/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UTIL_STRING_H
#define _SC_UTIL_STRING_H

// sc
#include "types.h"


namespace sc
{

// utf-8
class String
{
public:
  String();
  explicit String( const char* str );
  String( const String& src );
  String( const char* str, Size bytes );  // without 0 byte
  ~String();

  const char* getStr() const;
  Size getCharCnt() const;
  Size getByteCnt() const;
  bool isEmpty() const;

  operator const char*() const;

  void operator=( const String& in );
  void operator=( const char* in );

  String operator+( const String &in ) const;
  String operator+( const char* in ) const;

  String& operator+=( const String& in );
  String& operator+=( const char* in );

  bool operator<( const String& in ) const;
  bool operator==( const String& in ) const;
  bool operator==( const char* in ) const;
  bool operator!=( const String& in ) const;

  String left( Size chars ) const;
  String right( Size chars ) const;
  String mid( Size first, Size chars ) const;

  // convenience
  friend String operator+( const char *cin, const String& in );

private:
  int    _cmp( const char* src ) const;
  void   _copy( const char *szSrc );
  void   _ncopy( const char *szSrc, Size length );
  char*  _strcpy( char *szDest, const char *szSrc ) const;
  char*  _strncpy( char *szDest, const char *szSrc, Size length ) const;
  void   _append( const char *src );
  char*  _strcat( char *dest, const char* src ) const;
  void   _replace( const char *szSrc );
  Size   _strbytes( const char *szIn ) const;

  char*  _malloc( Size nbytes ) const;
  void   _free( char *ptr ) const;
  
private:
  char*  _str;
  Size   _chars; // without 0
  Size   _bytes; // without 0
};

const String NullString;

} // namespace

#endif // _SC_UTIL_STRING_H

