C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C
                        SUBROUTINE LECSY3
C                       *****************
C
C      -----------------------------------------
     * (NDIM,NDIELE,NPOINS,NELEMS,NDMATS,NBFACE,
     *  NODES,NREFS,NREFE,NREFAC,COORDS)
C      ------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             LECTURE DU MAILLAGE ELEMENTS FINIS                       *
C             STRUCTURE DE DONNEE ISSUE DE SYRTHES                     *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NODES    ! TE ! R  ! TABLE DES ELEMENTS DU MAILLAGE SOLIDE        !
C !  NREFS    ! TE ! R  ! REFERENCES DES NOEUDS DU MAILLAGE SOLIDE     !
C !  NREFAC   ! TE ! R  ! REFERENCES DES FACES                         !
C !  COORDS   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE SOLIDE          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /MOBIL/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NBFACE
      INTEGER NODES(NELEMS,NDMATS),NREFS(NPOINS),NREFE(NELEMS)
      INTEGER NREFAC(NELEMS,NBFACE)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM)
C
C.. Variables internes
      INTEGER N,I,J,N1,N2,NBNO,IERR
      CHARACTER CH1*10
      LOGICAL LF
C
C***********************************************************************
C
C
C     1- INITIALISATIONS
C     ==================
C
      DO 2 I=1,NPOINS
        NREFS(I) = 0
    2 CONTINUE
C
      IF (NDIELE.EQ.2) THEN
        NBNO = 6
      ELSE
        NBNO = 10
      ENDIF
C   
C
C     2- LECTURE DE LA TABLE DES NOEUDS
C     =================================
C
      IERR = 0
      CALL SECGRF(NFSGCT,'C$ RUBRIQUE = NOEUDS',20,IERR)
      IF (IERR.NE.0) THEN
         WRITE(NFECRA,2100)
         STOP
      ENDIF
C
      DO 220 N=1,NPOINS
       READ(NFSGCT,2200) CH1,NREFS(N),(COORDS(N,J),J=1,NDIM)
  220 CONTINUE
C
C
C     3- TABLE DES ELEMENTS
C     =====================
C
      IERR = 0
      CALL SECGRF(NFSGCT,'C$ RUBRIQUE = ELEMENTS',22,IERR)
      IF (IERR.NE.0) THEN
         WRITE(NFECRA,3100)
         STOP
      ENDIF
C
C
      IF (NDIELE.EQ.2) THEN
          DO 321 N=1,NELEMS
            READ(NFSGCT,3200) N1,NREFE(N),(NODES(N,I),I=1,NBNO)
  321     CONTINUE
C
      ELSE
          DO 323 N=1,NELEMS
            READ(NFSGCT,3201) N1,NREFE(N),(NODES(N,I),I=1,NBNO)
  323    CONTINUE
C
      ENDIF
C
C     4- REFERENCES DES FACES
C     =======================
C
      IF (LCFACE) THEN
C
        IERR = 0
        CALL SECGRF(NFSGCT,'C$ RUBRIQUE = REFERENCES DES FACES',34,IERR)
C
C
        LF = .FALSE.
C
        IF (IERR.EQ.0) THEN
          LF = .TRUE.
          DO 420 N=1,NELEMS
             READ(NFSGCT,4200) J,(NREFAC(N,I),I=1,NBFACE)
  420     CONTINUE
        ENDIF
C
      ENDIF
C
C
C     5- IMPRESSION SUR LISTING
C     =========================
C
      IF (NBLBLA.GT.0) THEN
        WRITE(NFECRA,5000)
        WRITE(NFECRA,5010) NDIM,NPOINS,NELEMS
        IF (LF) THEN
          WRITE(NFECRA,5020) 
        ELSE
          WRITE(NFECRA,5030) 
        ENDIF
      ENDIF
C
C
C     6- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLA.GE.2) THEN
C
      WRITE(NFECRA,6000) 
      WRITE(NFECRA,6010)
      DO 100 I=1,10
        WRITE(NFECRA,6011) I,(COORDS(I,J),J=1,NDIM)
  100 CONTINUE
C
      WRITE(NFECRA,6020)
      DO 110 I=1,10
        WRITE(NFECRA,6012) I,(NODES(I,J),J=1,NDMATS)
 110  CONTINUE
C
      WRITE(NFECRA,6030)
      DO 120 I=1,10
         WRITE(NFECRA,6013) I,NREFS(I)
 120  CONTINUE   
C
      IF (NDPROP.GT.1) THEN
        WRITE(NFECRA,6031)
        DO 121 I=1,10
           WRITE(NFECRA,6013) I,NREFE(I)
 121    CONTINUE   
      ENDIF
C
      IF (LCFACE .AND. LF) THEN
        WRITE(NFECRA,6040)
        DO 130 I=1,10
           WRITE(NFECRA,6014) I,(NREFAC(I,J),J=1,NDIELE+1)
 130    CONTINUE
      ENDIF   
C
      ENDIF  
C

C
C--------
C FORMATS
C--------
C
 2100 FORMAT(//,' *** LECSY3 : LE FICHIER SUITE NE CONTIENT PAS LA',
     &          ' TABLE DES NOEUDS')
 2200 FORMAT(A10,I3,1X,3(E14.7,1X))
 3100 FORMAT(//,' *** LECSY3 : LE FICHIER SUITE NE CONTIENT PAS LA',
     &          ' TABLE DES ELEMENTS')
 3200 FORMAT(I10,I3,6I10)
 3201 FORMAT(I10,I3,10I10)
 4200 FORMAT(I10,1X,4I5)
C
 5000 FORMAT(//,' *** LECSY3 : MAILLAGE ELEMENTS FINIS DU SOLIDE :')
 5010 FORMAT(8X,'- Dimension du maillage            : ',I6,/
     &       8X,'- Nombre total de noeuds           : ',I10,/
     &       8X,'- Nombre d''elements                : ',I10)
 5020 FORMAT(8X,'- Il y a des references sur les faces')
 5030 FORMAT(8X,'- Il n''y a pas de references sur les faces')
C
 6000 FORMAT(/,' *** LECSY3 : Verification du maillage solide',/)
 6010 FORMAT(/,14X,'Coordonnees des 10 premiers noeuds :',/)
 6020 FORMAT(/,14X,'Table des 10 premiers elements :',/)
 6030 FORMAT(/,14X,'References des 10 premiers noeuds :',/)
 6031 FORMAT(/,14X,'References des 10 premiers elements :',/)
 6040 FORMAT(/,14X,'References des faces des 10 premiers elements :',/)
 6011 FORMAT(14X,'N=',I2,'   COORDS : ',3E12.5) 
 6012 FORMAT(14X,'N=',I2,'   NOEUDS : ',10I10)
 6013 FORMAT(14X,'N=',I2,'   REFERENCE : ',I3)
 6014 FORMAT(14X,'N=',I2,'   REFERENCE DES FACES : ',4I3)
C
      END
