C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=PERMUT,SSI=0
                        SUBROUTINE PERMUT
C                       *****************
C
C      ------------------
     * (N1,N2,NTAB,MI,MJ)
C      ------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             PERMUTATION DES ELEMENTS N1 ET N2 DANS LA TABLE  NTAB    *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  N1,N2    !  E ! D  ! NUMERO DES 2 ELEMENTS A PERMUTER             !
C !  MI,MJ    !  E ! D  ! DIMENSIONS DU TABLEAU NTAB                   !
C !  NTAB     ! TE ! M  ! TABLEAU OU IL FAUT FAIRE LA PERMUTATION      !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
C
C***********************************************************************
C
      INTEGER IT
      PARAMETER (IT=10)
C
C.. Variables externes
      INTEGER N1,N2,MI,MJ,NTAB(MI,MJ)
C
C.. Variables internes
      INTEGER ITAB(IT),I
C
C***********************************************************************
C
C     1- CONSERVATION DES NOEUDS DE L'ELEMENT N1
C     ------------------------------------------
C
      DO 100 I=1,MJ
         ITAB(I) = NTAB(N1,I)
  100 CONTINUE
C
C
C     2- N2 EST MIS A LA PLACE DE N1
C     ------------------------------
C
      DO 200 I=1,MJ
         NTAB(N1,I) = NTAB(N2,I)
  200 CONTINUE
C

C     3- N2 REPREND LES NOEUDS DE N1
C     ------------------------------
C
      DO 300 I=1,MJ
         NTAB(N2,I) = ITAB(I)
  300 CONTINUE
C
C
      END
