## TFSA-2021-077: Division by zero in TFLite's implementation of `TransposeConv`

### CVE Number
CVE-2021-29588

### Impact
The optimized implementation of the `TransposeConv` TFLite operator is [vulnerable to
a division by zero
error](https://github.com/tensorflow/tensorflow/blob/0d45ea1ca641b21b73bcf9c00e0179cda284e7e7/tensorflow/lite/kernels/internal/optimized/optimized_ops.h#L5221-L5222):

```cc
int height_col = (height + pad_t + pad_b - filter_h) / stride_h + 1;
int width_col = (width + pad_l + pad_r - filter_w) / stride_w + 1;
```

An attacker can craft a model such that `stride_{h,w}` values are 0. Code
calling this function must validate these arguments.

### Patches
We have patched the issue in GitHub commit
[801c1c6be5324219689c98e1bd3e0ca365ee834d](https://github.com/tensorflow/tensorflow/commit/801c1c6be5324219689c98e1bd3e0ca365ee834d).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
