/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2014 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 4.1 - Feb 2014
 */

#include "twpskScope.h"

/*
 * Initialize drawing stuff for scope 
 */
void Scope::setup (Widget shell, Widget scopeWid)
{
   Colormap dcmap;
   XColor nill;

   scopeDA = scopeWid;
   /*
    * initialize these so the first time
    * wont't draw a line from 0,0 to center. 
    */
   x = (border_width + outer_circle_width) * 2;  /* this should keep it */
   y = (border_width + outer_circle_width) * 2;  /* inside of the circle */

   gc = XCreateGC(XtDisplay(shell),
                  RootWindowOfScreen (XtScreen(shell)),
                  GCForeground, &gcv);

   display = XtDisplay (scopeDA);
   window  = XtWindow (scopeDA);
   screen  = DefaultScreen (display);
   dcmap   = DefaultColormap (display, screen);

   XAllocNamedColor (display, dcmap, "red", &color[0], &nill);
   XAllocNamedColor (display, dcmap, "yellow", &color[1], &nill);
   XAllocNamedColor (display, dcmap, "green2", &color[2], &nill);
   XAllocNamedColor (display, dcmap, "light gray", &color[3], &nill); /*Outer*/
   XAllocNamedColor (display, dcmap, "slate gray", &color[4], &nill); /*Inner*/
}


/*
 * drawline - draws the phase lines in the scope
 */
void Scope::drawline (int phdelta, int strength, int icolor)
{
   float theta;
   float dx,dy;

   /* fudge factor - converts 0->256 thingies to radians */
   float fudge =  2.0 * M_PI / 256.0; 
   theta = phdelta * fudge;
   if ((x > 0) || (y > 0))
   {
      XSetForeground (display, gc, color[4].pixel); /* fg color to gray to */
      XDrawLine (display, window, gc,               /* undraw the last line */
         xo, yo,                                    /* Start of last line */
         x, y);                                     /* End of the last line */
   }

   XSetForeground (display, gc, color[icolor].pixel);  /* fg to requested */   

   dx = (float) strength * cos(theta+M_PI_2); // * scope_width;
   dy = (float) strength * sin(theta+M_PI_2); // * scope_width;
   //dx = (float) strength * cos(theta+M_PI_2) * scope_width/128;
   //dy = (float) strength * sin(theta+M_PI_2) * scope_width/128;

   x = (int) ((float)xo + dx);
   y = (int) ((float)yo - dy);
   XDrawLine (display, window, gc,
      xo, yo,                                     /* Start of new line */
      x, y);                                      /* End of new line */
   XSetForeground (display, gc, color[3].pixel);
}


/*
 * drawcirc - redraws the circle 
 */
void Scope::drawcirc()
{
   XtVaGetValues (scopeDA,
      XmNheight, &h,
      XmNwidth, &w,
      NULL);

   /* calculate some coordinates for the scope */
   if (h>w)                /* scope_width is 90% of the minor axis */
   {
      scope_width = w * .9;
   }
   else
   {
      scope_width = h * .9;
   }

   border_width = (w - scope_width) / 2;
   xc = border_width;
   yc = (h - scope_width) / 2;
   xo = w / 2;
   yo = h / 2;
   x = xo;                 /* set to origin of circle so the first */
   y = yo;                 /* time won't draw a line from 0.0 */

   /* Draw circles */
   /* outer white ring */
   XSetForeground (display, gc, color[3].pixel); /* fg = white */
   XSetLineAttributes (display, gc, outer_circle_width,
      LineSolid, CapRound, JoinRound);      

   XDrawArc (display, window, gc,
      xc, yc,                           /* upper left corner */
      scope_width, scope_width,         /* width and height */
      0, 23040);                        /* start/stop points */


   /* Change the gc for inner gray circle */
   gcv.foreground = color[4].pixel;     /* fg = gray */
   XChangeGC (display, gc, GCForeground, &gcv);
   XSetLineAttributes (display, gc, LINE_WIDTH,
      LineSolid, CapRound, JoinRound);      


   /* Draw filled inner circle */ 
   XFillArc (display, window, gc,
      xc, yc,                          /* upper left corner */
      scope_width, scope_width,        /* width and height */
      0, 23040);                       /* start/stop points */
}
