.TH "TXT2REGEX" 1 "September, 28th - 2004" ""

.SH NAME
.P
txt2regex \- a Regular Expression Wizard, written with bash2 builtins

.SH SYNOPSIS
.P
\fBtxt2regex\fR

.P
\fBtxt2regex\fR \-\-nocolor|\-\-whitebg

.P
\fBtxt2regex\fR \-\-all|\-\-prog <p1,p2,...,pN>

.P
\fBtxt2regex\fR \-\-showmeta|\-\-showinfo <program>

.P
\fBtxt2regex\fR \-\-make <target>

.P
\fBtxt2regex\fR \-\-history <value>

.SH DESCRIPTION
.P
\fBtxt2regex\fR is a Regular Expression "wizard", all written with bash2
builtins, that converts human sentences to regexes.

.P
With a simple interactive interface, you just answer to questions and
build your own regex for a large variety of programs, like awk, emacs,
grep, perl, php, procmail, python, sed and vim. There are more than 20
supported programs.

.P
It's bash so download and run, no compilation needed.

.P
Please visit the program homepage at
\fIhttp://txt2regex.sf.net\fR.

.SH OPTIONS
.TP
\fB\-\-all\fR
works with all registered programs

.TP
\fB\-\-help\fR
prints the help message and quit

.TP
\fB\-\-history <value>\fR
prints to STDOUT a regex from a history data

.TP
\fB\-\-make <target>\fR
prints a ready regex for a common pattern

.TP
\fB\-\-nocolor\fR
self\-explanatory

.TP
\fB\-\-prog <p1,p2,...>\fR
choose which programs to use (separated by commas)

.TP
\fB\-\-showinfo <program>\fR
prints regex info about the program

.TP
\fB\-\-showmeta\fR
prints a complete metachar table for all programs

.TP
\fB\-\-version\fR
prints the program version and quit

.TP
\fB\-\-whitebg\fR
colors adjusted to white background terminals

.P
By default, all options are turned OFF. Just call it with no options
to launch the default interactive interface.

.SH DETAILS
.P
\fB\-\-all\fR is cool but requires lots of lines (~35)

.P
\fB\-\-nocolor\fR is strong, so it kills \-\-whitebg

.P
\fB\-\-showmeta\fR rules, try it

.P
\fB\-\-showinfo\fR uses reverse video output, \-\-nocolor turns it off

.P
\fB\-\-history\fR is getting useful, stay tunned

.P
\fB\-\-make\fR is a remedy for headaches

.P
\fB\-\-prog\fR is nice to use your favorite programs, mix it with \-\-make and \-\-history

.SH EXAMPLES
.TP
Calling the program on the default interactive interface
.nf
  $ txt2regex
.fi


.TP
Calling the program on a white terminal
.nf
  $ xterm -fg black -bg white ; txt2regex --whitebg
.fi


.TP
Getting information
.nf
  $ txt2regex --showmeta
.fi


.TP
Getting specific information
.nf
  $ txt2regex --showinfo sed
.fi


.TP
Calling it for specific programs
.nf
  $ txt2regex --prog vim,sed,grep,python
.fi


.TP
Applying a history data
.nf
  $ txt2regex --history '16421:01:'
.fi


.TP
Getting ready regexes!
.nf
  $ txt2regex --make hour
  $ txt2regex --make number3 --prog perl
  $ txt2regex --make date2 --all
.fi


.SH INTERFACE
.P
The program interface is simple and easy to use. This is its contents:

.nf
         +---------------------------------------+
         | -> Top menu                           |
         | -> Group menu                         |
         |                                       |
         | -> Regexes of the programs selected   |
         |    ...                                |
         |    ...                                |
         |                                       |
         | -> History                            |
         | -> Your prompt                        |
         |                                       |
         | -> The question                       |
         | -> The answers                        |
         |    ...                                |
         |    ...                                |
         +---------------------------------------+
.fi


.P
All the basic commands can be used on the numeric pad on the keyboard,
but remember to turn ON the NumLock key.

.TS
center, tab(^); cl.
 \fBCommand\fR^\fBDescription\fR
 \fB.\fR^Quit the program (with confirmation)
 \fB0\fR^Reset the Regular Expression
 \fB1\-9\fR^Answers the questions
 \fB*\fR^Toggles color ON/OFF
 \fB/\fR^Add/remove programs on/from the list
 \fB|\fR^Insert an alternation (where allowed)
 \fB(\fR^Open a new group (where allowed)
 \fB)\fR^Close the opened group (if any)
.TE


.SH BUGS
.P
Bug reports and contributions are VERY welcome!
Please send them to the author.

.SH AUTHOR
.P
Written and maintained by Aurelio Marinho Jargas <verde@aurelio.net>

.SH COPYRIGHT
.P
Copyright  2000, 2001, 2002, 2003, 2004 Aurelio Marinho Jargas

.P
This is free software; see the source for copying conditions. There is
NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.


.\" man code generated by txt2tags 2.0 (http://txt2tags.sf.net)
.\" cmdline: txt2tags -t man manpage.t2t

