/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#include "upm_externalinterface.h"

UpmExternalInterface::UpmExternalInterface(QObject *parent) : QObject(parent)
{
    connect(UpmGsettings::self(), &UpmGsettings::batterySaveSwitchChanged,
            this, &UpmExternalInterface::dealBatterySaveSwitchChanged);
    connect(UpmUpowerDBus::self(), &UpmUpowerDBus::acOnlineStateChanged,
            this, &UpmExternalInterface::dealAcOnlineStateChanged);
}

void UpmExternalInterface::dealBatterySaveSwitchChanged(QVariant)
{
    QStringList batterySaver = {"batterySaver"};
    emit PowerConfigChanged(batterySaver);
}

void UpmExternalInterface::dealAcOnlineStateChanged(int index, bool value)
{
    Q_UNUSED(index)
    Q_UNUSED(value)
    QStringList batterySaver = {"batterySaver"};
    emit PowerConfigChanged(batterySaver);
}

void UpmExternalInterface::SetBatterySaver(const int value)
{
    if (1 == value) {
        UpmGsettings::self()->setGsettingsConfig(GSETTINGS_KEY_BATTERY_SAVE_SWITCH, true);
    } else {
        UpmGsettings::self()->setGsettingsConfig(GSETTINGS_KEY_BATTERY_SAVE_SWITCH, false);
    }
}

int UpmExternalInterface::GetBatterySaver()
{
    if (true == UpmUpowerDBus::self()->getAcOnlineState()) {
        return batterySaverUnavailable;
    }

    QVariant value;
    if (true == UpmGsettings::self()->getGsettingsConfig(GSETTINGS_KEY_BATTERY_SAVE_SWITCH, value)) {
        if (true == value.toBool()) {
            return batterySaverOn;
        }
    }
    return batterySaverOff;
}


