/* soapC.cpp
   Generated by gSOAP 2.7.9e from /root/Projects/UNS/SoapServer/gSoapGeneratedCode/SoapInterfaceTmp.h
   Copyright(C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.7.9e 2007-04-25 11:57:11 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_short:
		return soap_in_short(soap, NULL, NULL, "xsd:short");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_emi__AlertSubscriptionPolicyIDType:
		return soap_in_emi__AlertSubscriptionPolicyIDType(soap, NULL, NULL, "emi:AlertSubscriptionPolicyIDType");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedShort:
		return soap_in_unsignedShort(soap, NULL, NULL, "xsd:unsignedShort");
	case SOAP_TYPE_sai__CertificateHandleType:
		return soap_in_sai__CertificateHandleType(soap, NULL, NULL, "sai:CertificateHandleType");
	case SOAP_TYPE_sai__IPv4AddressType:
		return soap_in_sai__IPv4AddressType(soap, NULL, NULL, "sai:IPv4AddressType");
	case SOAP_TYPE_sai__UserAclEntryHandleType:
		return soap_in_sai__UserAclEntryHandleType(soap, NULL, NULL, "sai:UserAclEntryHandleType");
	case SOAP_TYPE_sai__PT_USCORESTATUS:
		return soap_in_sai__PT_USCORESTATUS(soap, NULL, NULL, "sai:PT_STATUS");
	case SOAP_TYPE_emi__SensorHandleType:
		return soap_in_emi__SensorHandleType(soap, NULL, NULL, "emi:SensorHandleType");
	case SOAP_TYPE_emi__IPv4AddressType:
		return soap_in_emi__IPv4AddressType(soap, NULL, NULL, "emi:IPv4AddressType");
	case SOAP_TYPE_emi__PT_USCORESTATUS:
		return soap_in_emi__PT_USCORESTATUS(soap, NULL, NULL, "emi:PT_STATUS");
	case SOAP_TYPE_emi__EventFilterHandleType:
		return soap_in_emi__EventFilterHandleType(soap, NULL, NULL, "emi:EventFilterHandleType");
	case SOAP_TYPE_emi__AlertSubscriptionHandleType:
		return soap_in_emi__AlertSubscriptionHandleType(soap, NULL, NULL, "emi:AlertSubscriptionHandleType");
	case SOAP_TYPE_emi__TimeType:
		return soap_in_emi__TimeType(soap, NULL, NULL, "emi:TimeType");
	case SOAP_TYPE_cmn__InterfaceHandleType:
		return soap_in_cmn__InterfaceHandleType(soap, NULL, NULL, "cmn:InterfaceHandleType");
	case SOAP_TYPE_cmn__IPv4AddressType:
		return soap_in_cmn__IPv4AddressType(soap, NULL, NULL, "cmn:IPv4AddressType");
	case SOAP_TYPE_cmn__PT_USCORESTATUS:
		return soap_in_cmn__PT_USCORESTATUS(soap, NULL, NULL, "cmn:PT_STATUS");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_sai__UNOptionsType:
		return soap_in_sai__UNOptionsType(soap, NULL, NULL, "sai:UNOptionsType");
	case SOAP_TYPE_sai__HashTypeType:
		return soap_in_sai__HashTypeType(soap, NULL, NULL, "sai:HashTypeType");
	case SOAP_TYPE_sai__ProvisioningTLSModeType:
		return soap_in_sai__ProvisioningTLSModeType(soap, NULL, NULL, "sai:ProvisioningTLSModeType");
	case SOAP_TYPE_sai__TlsAthenticationType:
		return soap_in_sai__TlsAthenticationType(soap, NULL, NULL, "sai:TlsAthenticationType");
	case SOAP_TYPE_sai__InterfaceType:
		return soap_in_sai__InterfaceType(soap, NULL, NULL, "sai:InterfaceType");
	case SOAP_TYPE_sai__EnabledInterfacesType:
		return soap_in_sai__EnabledInterfacesType(soap, NULL, NULL, "sai:EnabledInterfacesType");
	case SOAP_TYPE_sai__PowerStateType:
		return soap_in_sai__PowerStateType(soap, NULL, NULL, "sai:PowerStateType");
	case SOAP_TYPE_sai__KerberosEncryptionType:
		return soap_in_sai__KerberosEncryptionType(soap, NULL, NULL, "sai:KerberosEncryptionType");
	case SOAP_TYPE_sai__KerberosSpnProtocolType:
		return soap_in_sai__KerberosSpnProtocolType(soap, NULL, NULL, "sai:KerberosSpnProtocolType");
	case SOAP_TYPE_sai__AccessPermissionType:
		return soap_in_sai__AccessPermissionType(soap, NULL, NULL, "sai:AccessPermissionType");
	case SOAP_TYPE_sai__ProvisioningModeType:
		return soap_in_sai__ProvisioningModeType(soap, NULL, NULL, "sai:ProvisioningModeType");
	case SOAP_TYPE_sai__RngKeyEncodingType:
		return soap_in_sai__RngKeyEncodingType(soap, NULL, NULL, "sai:RngKeyEncodingType");
	case SOAP_TYPE_sai__RsaCertificateEncodingType:
		return soap_in_sai__RsaCertificateEncodingType(soap, NULL, NULL, "sai:RsaCertificateEncodingType");
	case SOAP_TYPE_sai__RsaKeyEncodingType:
		return soap_in_sai__RsaKeyEncodingType(soap, NULL, NULL, "sai:RsaKeyEncodingType");
	case SOAP_TYPE_sai__UserAclRealmType:
		return soap_in_sai__UserAclRealmType(soap, NULL, NULL, "sai:UserAclRealmType");
	case SOAP_TYPE_emi__AlertAuthOptionsType:
		return soap_in_emi__AlertAuthOptionsType(soap, NULL, NULL, "emi:AlertAuthOptionsType");
	case SOAP_TYPE_emi__EventSeverityType:
		return soap_in_emi__EventSeverityType(soap, NULL, NULL, "emi:EventSeverityType");
	case SOAP_TYPE_sai__FriendlyNameType:
		return soap_in_sai__FriendlyNameType(soap, NULL, NULL, "sai:FriendlyNameType");
	case SOAP_TYPE_sai__ProvisioningOTPType:
		return soap_in_sai__ProvisioningOTPType(soap, NULL, NULL, "sai:ProvisioningOTPType");
	case SOAP_TYPE_sai__MEBxPasswordType:
		return soap_in_sai__MEBxPasswordType(soap, NULL, NULL, "sai:MEBxPasswordType");
	case SOAP_TYPE_sai__AclPasswordStringType:
		return soap_in_sai__AclPasswordStringType(soap, NULL, NULL, "sai:AclPasswordStringType");
	case SOAP_TYPE_sai__AclStringType:
		return soap_in_sai__AclStringType(soap, NULL, NULL, "sai:AclStringType");
	case SOAP_TYPE_emi__CommunityStringType:
		return soap_in_emi__CommunityStringType(soap, NULL, NULL, "emi:CommunityStringType");
	case SOAP_TYPE_cmn__GuidBuf:
		return soap_in_cmn__GuidBuf(soap, NULL, NULL, "cmn:GuidBuf");
	case SOAP_TYPE_cmn__IPv6AddressStringType:
		return soap_in_cmn__IPv6AddressStringType(soap, NULL, NULL, "cmn:IPv6AddressStringType");
	case SOAP_TYPE_cmn__IPv4AddressStringType:
		return soap_in_cmn__IPv4AddressStringType(soap, NULL, NULL, "cmn:IPv4AddressStringType");
	case SOAP_TYPE_cmn__HostNameType:
		return soap_in_cmn__HostNameType(soap, NULL, NULL, "cmn:HostNameType");
	case SOAP_TYPE_sai__GlobalPowerPolicyType:
		return soap_in_sai__GlobalPowerPolicyType(soap, NULL, NULL, "sai:GlobalPowerPolicyType");
	case SOAP_TYPE_sai__EnvironmentDetectionType:
		return soap_in_sai__EnvironmentDetectionType(soap, NULL, NULL, "sai:EnvironmentDetectionType");
	case SOAP_TYPE_sai__EnvironmentDetectionDomainType:
		return soap_in_sai__EnvironmentDetectionDomainType(soap, NULL, NULL, "sai:EnvironmentDetectionDomainType");
	case SOAP_TYPE_sai__EnvironmentDetectionHTTPSType:
		return soap_in_sai__EnvironmentDetectionHTTPSType(soap, NULL, NULL, "sai:EnvironmentDetectionHTTPSType");
	case SOAP_TYPE_sai__ProvisioningAuditRecordType:
		return soap_in_sai__ProvisioningAuditRecordType(soap, NULL, NULL, "sai:ProvisioningAuditRecordType");
	case SOAP_TYPE_sai__CertHashEntryType:
		return soap_in_sai__CertHashEntryType(soap, NULL, NULL, "sai:CertHashEntryType");
	case SOAP_TYPE_sai__PkiCapsType:
		return soap_in_sai__PkiCapsType(soap, NULL, NULL, "sai:PkiCapsType");
	case SOAP_TYPE_sai__CrlType:
		return soap_in_sai__CrlType(soap, NULL, NULL, "sai:CrlType");
	case SOAP_TYPE_sai__CertificateType:
		return soap_in_sai__CertificateType(soap, NULL, NULL, "sai:CertificateType");
	case SOAP_TYPE_sai__TlsOptionsType:
		return soap_in_sai__TlsOptionsType(soap, NULL, NULL, "sai:TlsOptionsType");
	case SOAP_TYPE_sai__KerberosOptionsType:
		return soap_in_sai__KerberosOptionsType(soap, NULL, NULL, "sai:KerberosOptionsType");
	case SOAP_TYPE_sai__KerberosSpnType:
		return soap_in_sai__KerberosSpnType(soap, NULL, NULL, "sai:KerberosSpnType");
	case SOAP_TYPE_sai__AdminAclEntryExType:
		return soap_in_sai__AdminAclEntryExType(soap, NULL, NULL, "sai:AdminAclEntryExType");
	case SOAP_TYPE_sai__UserAclEntryExType:
		return soap_in_sai__UserAclEntryExType(soap, NULL, NULL, "sai:UserAclEntryExType");
	case SOAP_TYPE_sai__UserEntryKerberosType:
		return soap_in_sai__UserEntryKerberosType(soap, NULL, NULL, "sai:UserEntryKerberosType");
	case SOAP_TYPE_sai__UserEntryDigestType:
		return soap_in_sai__UserEntryDigestType(soap, NULL, NULL, "sai:UserEntryDigestType");
	case SOAP_TYPE_sai__AmtVersion:
		return soap_in_sai__AmtVersion(soap, NULL, NULL, "sai:AmtVersion");
	case SOAP_TYPE_sai__UpdateCoreUrlKeyType:
		return soap_in_sai__UpdateCoreUrlKeyType(soap, NULL, NULL, "sai:UpdateCoreUrlKeyType");
	case SOAP_TYPE_sai__CertificateChainType:
		return soap_in_sai__CertificateChainType(soap, NULL, NULL, "sai:CertificateChainType");
	case SOAP_TYPE_sai__RngKeyType:
		return soap_in_sai__RngKeyType(soap, NULL, NULL, "sai:RngKeyType");
	case SOAP_TYPE_sai__RsaKeyType:
		return soap_in_sai__RsaKeyType(soap, NULL, NULL, "sai:RsaKeyType");
	case SOAP_TYPE_sai__UserAclRealmListType:
		return soap_in_sai__UserAclRealmListType(soap, NULL, NULL, "sai:UserAclRealmListType");
	case SOAP_TYPE_sai__UserAclEntryHandleListType:
		return soap_in_sai__UserAclEntryHandleListType(soap, NULL, NULL, "sai:UserAclEntryHandleListType");
	case SOAP_TYPE_sai__AdminAclEntryType:
		return soap_in_sai__AdminAclEntryType(soap, NULL, NULL, "sai:AdminAclEntryType");
	case SOAP_TYPE_sai__UserAclEntryType:
		return soap_in_sai__UserAclEntryType(soap, NULL, NULL, "sai:UserAclEntryType");
	case SOAP_TYPE_emi__AlertSubscriptionGeneralType:
		return soap_in_emi__AlertSubscriptionGeneralType(soap, NULL, NULL, "emi:AlertSubscriptionGeneralType");
	case SOAP_TYPE_emi__AlertSubscriptionSoapType:
		return soap_in_emi__AlertSubscriptionSoapType(soap, NULL, NULL, "emi:AlertSubscriptionSoapType");
	case SOAP_TYPE_emi__AlertSubscriptionSNMPType:
		return soap_in_emi__AlertSubscriptionSNMPType(soap, NULL, NULL, "emi:AlertSubscriptionSNMPType");
	case SOAP_TYPE_emi__AlertCredentialsType:
		return soap_in_emi__AlertCredentialsType(soap, NULL, NULL, "emi:AlertCredentialsType");
	case SOAP_TYPE_emi__ByteStr:
		return soap_in_emi__ByteStr(soap, NULL, NULL, "emi:ByteStr");
	case SOAP_TYPE_emi__SensorAttributesType:
		return soap_in_emi__SensorAttributesType(soap, NULL, NULL, "emi:SensorAttributesType");
	case SOAP_TYPE_emi__SensorHandleArrayType:
		return soap_in_emi__SensorHandleArrayType(soap, NULL, NULL, "emi:SensorHandleArrayType");
	case SOAP_TYPE_emi__EventLogRecordArrayType:
		return soap_in_emi__EventLogRecordArrayType(soap, NULL, NULL, "emi:EventLogRecordArrayType");
	case SOAP_TYPE_emi__EventFilterHandleArrayType:
		return soap_in_emi__EventFilterHandleArrayType(soap, NULL, NULL, "emi:EventFilterHandleArrayType");
	case SOAP_TYPE_emi__AlertSubscriptionHandleArrayType:
		return soap_in_emi__AlertSubscriptionHandleArrayType(soap, NULL, NULL, "emi:AlertSubscriptionHandleArrayType");
	case SOAP_TYPE_emi__AlertSubscriptionType:
		return soap_in_emi__AlertSubscriptionType(soap, NULL, NULL, "emi:AlertSubscriptionType");
	case SOAP_TYPE_emi__EventFilterType:
		return soap_in_emi__EventFilterType(soap, NULL, NULL, "emi:EventFilterType");
	case SOAP_TYPE_emi__EventLogRecordType:
		return soap_in_emi__EventLogRecordType(soap, NULL, NULL, "emi:EventLogRecordType");
	case SOAP_TYPE_emi__ByteData:
		return soap_in_emi__ByteData(soap, NULL, NULL, "emi:ByteData");
	case SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType:
		return soap_in_emi__AlertSubscriptionPolicyIDArrayType(soap, NULL, NULL, "emi:AlertSubscriptionPolicyIDArrayType");
	case SOAP_TYPE_cmn__NodeAddressType:
		return soap_in_cmn__NodeAddressType(soap, NULL, NULL, "cmn:NodeAddressType");
	case SOAP_TYPE_cmn__URLType:
		return soap_in_cmn__URLType(soap, NULL, NULL, "cmn:URLType");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_xsd__anyURI:
		return soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTo_emc__SoapAlertResponse:
		return soap_in_PointerTo_emc__SoapAlertResponse(soap, NULL, NULL, "emc:SoapAlertResponse");
	case SOAP_TYPE_PointerTo_emc__SoapAlertRequest:
		return soap_in_PointerTo_emc__SoapAlertRequest(soap, NULL, NULL, "emc:SoapAlertRequest");
	case SOAP_TYPE_PointerTounsignedInt:
		return soap_in_PointerTounsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_PointerTosai__EnvironmentDetectionHTTPSType:
		return soap_in_PointerTosai__EnvironmentDetectionHTTPSType(soap, NULL, NULL, "sai:EnvironmentDetectionHTTPSType");
	case SOAP_TYPE_PointerTosai__EnvironmentDetectionDomainType:
		return soap_in_PointerTosai__EnvironmentDetectionDomainType(soap, NULL, NULL, "sai:EnvironmentDetectionDomainType");
	case SOAP_TYPE_PointerTobool:
		return soap_in_PointerTobool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_in_PointerToxsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTostd__string:
		return soap_in_PointerTostd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTosai__KerberosSpnType:
		return soap_in_PointerTosai__KerberosSpnType(soap, NULL, NULL, "sai:KerberosSpnType");
	case SOAP_TYPE_PointerTosai__UserEntryKerberosType:
		return soap_in_PointerTosai__UserEntryKerberosType(soap, NULL, NULL, "sai:UserEntryKerberosType");
	case SOAP_TYPE_PointerTosai__UserEntryDigestType:
		return soap_in_PointerTosai__UserEntryDigestType(soap, NULL, NULL, "sai:UserEntryDigestType");
	case SOAP_TYPE_PointerTosai__UserAclRealmListType:
		return soap_in_PointerTosai__UserAclRealmListType(soap, NULL, NULL, "sai:UserAclRealmListType");
	case SOAP_TYPE_PointerToemi__AlertSubscriptionPolicyIDType:
		return soap_in_PointerToemi__AlertSubscriptionPolicyIDType(soap, NULL, NULL, "emi:AlertSubscriptionPolicyIDType");
	case SOAP_TYPE_PointerToemi__AlertSubscriptionGeneralType:
		return soap_in_PointerToemi__AlertSubscriptionGeneralType(soap, NULL, NULL, "emi:AlertSubscriptionGeneralType");
	case SOAP_TYPE_PointerToemi__AlertSubscriptionSoapType:
		return soap_in_PointerToemi__AlertSubscriptionSoapType(soap, NULL, NULL, "emi:AlertSubscriptionSoapType");
	case SOAP_TYPE_PointerToemi__AlertSubscriptionSNMPType:
		return soap_in_PointerToemi__AlertSubscriptionSNMPType(soap, NULL, NULL, "emi:AlertSubscriptionSNMPType");
	case SOAP_TYPE_PointerToemi__AlertCredentialsType:
		return soap_in_PointerToemi__AlertCredentialsType(soap, NULL, NULL, "emi:AlertCredentialsType");
	case SOAP_TYPE_PointerTosai__CertificateHandleType:
		return soap_in_PointerTosai__CertificateHandleType(soap, NULL, NULL, "sai:CertificateHandleType");
	case SOAP_TYPE_PointerTocmn__URLType:
		return soap_in_PointerTocmn__URLType(soap, NULL, NULL, "cmn:URLType");
	case SOAP_TYPE_PointerToemi__CommunityStringType:
		return soap_in_PointerToemi__CommunityStringType(soap, NULL, NULL, "emi:CommunityStringType");
	case SOAP_TYPE_PointerTocmn__NodeAddressType:
		return soap_in_PointerTocmn__NodeAddressType(soap, NULL, NULL, "cmn:NodeAddressType");
	case SOAP_TYPE_PointerToemi__EventLogRecordType:
		return soap_in_PointerToemi__EventLogRecordType(soap, NULL, NULL, "emi:EventLogRecordType");
	case SOAP_TYPE_PointerToemi__ByteData:
		return soap_in_PointerToemi__ByteData(soap, NULL, NULL, "emi:ByteData");
	case SOAP_TYPE_PointerTocmn__IPv6AddressStringType:
		return soap_in_PointerTocmn__IPv6AddressStringType(soap, NULL, NULL, "cmn:IPv6AddressStringType");
	case SOAP_TYPE_PointerTocmn__IPv4AddressStringType:
		return soap_in_PointerTocmn__IPv4AddressStringType(soap, NULL, NULL, "cmn:IPv4AddressStringType");
	case SOAP_TYPE_PointerTocmn__HostNameType:
		return soap_in_PointerTocmn__HostNameType(soap, NULL, NULL, "cmn:HostNameType");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:short"))
		{	*type = SOAP_TYPE_short;
			return soap_in_short(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertSubscriptionPolicyIDType"))
		{	*type = SOAP_TYPE_emi__AlertSubscriptionPolicyIDType;
			return soap_in_emi__AlertSubscriptionPolicyIDType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedShort"))
		{	*type = SOAP_TYPE_unsignedShort;
			return soap_in_unsignedShort(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:CertificateHandleType"))
		{	*type = SOAP_TYPE_sai__CertificateHandleType;
			return soap_in_sai__CertificateHandleType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:IPv4AddressType"))
		{	*type = SOAP_TYPE_sai__IPv4AddressType;
			return soap_in_sai__IPv4AddressType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UserAclEntryHandleType"))
		{	*type = SOAP_TYPE_sai__UserAclEntryHandleType;
			return soap_in_sai__UserAclEntryHandleType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:PT_STATUS"))
		{	*type = SOAP_TYPE_sai__PT_USCORESTATUS;
			return soap_in_sai__PT_USCORESTATUS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:SensorHandleType"))
		{	*type = SOAP_TYPE_emi__SensorHandleType;
			return soap_in_emi__SensorHandleType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:IPv4AddressType"))
		{	*type = SOAP_TYPE_emi__IPv4AddressType;
			return soap_in_emi__IPv4AddressType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:PT_STATUS"))
		{	*type = SOAP_TYPE_emi__PT_USCORESTATUS;
			return soap_in_emi__PT_USCORESTATUS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:EventFilterHandleType"))
		{	*type = SOAP_TYPE_emi__EventFilterHandleType;
			return soap_in_emi__EventFilterHandleType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertSubscriptionHandleType"))
		{	*type = SOAP_TYPE_emi__AlertSubscriptionHandleType;
			return soap_in_emi__AlertSubscriptionHandleType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:TimeType"))
		{	*type = SOAP_TYPE_emi__TimeType;
			return soap_in_emi__TimeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:InterfaceHandleType"))
		{	*type = SOAP_TYPE_cmn__InterfaceHandleType;
			return soap_in_cmn__InterfaceHandleType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:IPv4AddressType"))
		{	*type = SOAP_TYPE_cmn__IPv4AddressType;
			return soap_in_cmn__IPv4AddressType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:PT_STATUS"))
		{	*type = SOAP_TYPE_cmn__PT_USCORESTATUS;
			return soap_in_cmn__PT_USCORESTATUS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UNOptionsType"))
		{	*type = SOAP_TYPE_sai__UNOptionsType;
			return soap_in_sai__UNOptionsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:HashTypeType"))
		{	*type = SOAP_TYPE_sai__HashTypeType;
			return soap_in_sai__HashTypeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:ProvisioningTLSModeType"))
		{	*type = SOAP_TYPE_sai__ProvisioningTLSModeType;
			return soap_in_sai__ProvisioningTLSModeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:TlsAthenticationType"))
		{	*type = SOAP_TYPE_sai__TlsAthenticationType;
			return soap_in_sai__TlsAthenticationType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:InterfaceType"))
		{	*type = SOAP_TYPE_sai__InterfaceType;
			return soap_in_sai__InterfaceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:EnabledInterfacesType"))
		{	*type = SOAP_TYPE_sai__EnabledInterfacesType;
			return soap_in_sai__EnabledInterfacesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:PowerStateType"))
		{	*type = SOAP_TYPE_sai__PowerStateType;
			return soap_in_sai__PowerStateType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:KerberosEncryptionType"))
		{	*type = SOAP_TYPE_sai__KerberosEncryptionType;
			return soap_in_sai__KerberosEncryptionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:KerberosSpnProtocolType"))
		{	*type = SOAP_TYPE_sai__KerberosSpnProtocolType;
			return soap_in_sai__KerberosSpnProtocolType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:AccessPermissionType"))
		{	*type = SOAP_TYPE_sai__AccessPermissionType;
			return soap_in_sai__AccessPermissionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:ProvisioningModeType"))
		{	*type = SOAP_TYPE_sai__ProvisioningModeType;
			return soap_in_sai__ProvisioningModeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:RngKeyEncodingType"))
		{	*type = SOAP_TYPE_sai__RngKeyEncodingType;
			return soap_in_sai__RngKeyEncodingType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:RsaCertificateEncodingType"))
		{	*type = SOAP_TYPE_sai__RsaCertificateEncodingType;
			return soap_in_sai__RsaCertificateEncodingType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:RsaKeyEncodingType"))
		{	*type = SOAP_TYPE_sai__RsaKeyEncodingType;
			return soap_in_sai__RsaKeyEncodingType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UserAclRealmType"))
		{	*type = SOAP_TYPE_sai__UserAclRealmType;
			return soap_in_sai__UserAclRealmType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertAuthOptionsType"))
		{	*type = SOAP_TYPE_emi__AlertAuthOptionsType;
			return soap_in_emi__AlertAuthOptionsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:EventSeverityType"))
		{	*type = SOAP_TYPE_emi__EventSeverityType;
			return soap_in_emi__EventSeverityType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:FriendlyNameType"))
		{	*type = SOAP_TYPE_sai__FriendlyNameType;
			return soap_in_sai__FriendlyNameType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:ProvisioningOTPType"))
		{	*type = SOAP_TYPE_sai__ProvisioningOTPType;
			return soap_in_sai__ProvisioningOTPType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:MEBxPasswordType"))
		{	*type = SOAP_TYPE_sai__MEBxPasswordType;
			return soap_in_sai__MEBxPasswordType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:AclPasswordStringType"))
		{	*type = SOAP_TYPE_sai__AclPasswordStringType;
			return soap_in_sai__AclPasswordStringType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:AclStringType"))
		{	*type = SOAP_TYPE_sai__AclStringType;
			return soap_in_sai__AclStringType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:CommunityStringType"))
		{	*type = SOAP_TYPE_emi__CommunityStringType;
			return soap_in_emi__CommunityStringType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:GuidBuf"))
		{	*type = SOAP_TYPE_cmn__GuidBuf;
			return soap_in_cmn__GuidBuf(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:IPv6AddressStringType"))
		{	*type = SOAP_TYPE_cmn__IPv6AddressStringType;
			return soap_in_cmn__IPv6AddressStringType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:IPv4AddressStringType"))
		{	*type = SOAP_TYPE_cmn__IPv4AddressStringType;
			return soap_in_cmn__IPv4AddressStringType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:HostNameType"))
		{	*type = SOAP_TYPE_cmn__HostNameType;
			return soap_in_cmn__HostNameType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:GlobalPowerPolicyType"))
		{	*type = SOAP_TYPE_sai__GlobalPowerPolicyType;
			return soap_in_sai__GlobalPowerPolicyType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:EnvironmentDetectionType"))
		{	*type = SOAP_TYPE_sai__EnvironmentDetectionType;
			return soap_in_sai__EnvironmentDetectionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:EnvironmentDetectionDomainType"))
		{	*type = SOAP_TYPE_sai__EnvironmentDetectionDomainType;
			return soap_in_sai__EnvironmentDetectionDomainType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:EnvironmentDetectionHTTPSType"))
		{	*type = SOAP_TYPE_sai__EnvironmentDetectionHTTPSType;
			return soap_in_sai__EnvironmentDetectionHTTPSType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:ProvisioningAuditRecordType"))
		{	*type = SOAP_TYPE_sai__ProvisioningAuditRecordType;
			return soap_in_sai__ProvisioningAuditRecordType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:CertHashEntryType"))
		{	*type = SOAP_TYPE_sai__CertHashEntryType;
			return soap_in_sai__CertHashEntryType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:PkiCapsType"))
		{	*type = SOAP_TYPE_sai__PkiCapsType;
			return soap_in_sai__PkiCapsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:CrlType"))
		{	*type = SOAP_TYPE_sai__CrlType;
			return soap_in_sai__CrlType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:CertificateType"))
		{	*type = SOAP_TYPE_sai__CertificateType;
			return soap_in_sai__CertificateType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:TlsOptionsType"))
		{	*type = SOAP_TYPE_sai__TlsOptionsType;
			return soap_in_sai__TlsOptionsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:KerberosOptionsType"))
		{	*type = SOAP_TYPE_sai__KerberosOptionsType;
			return soap_in_sai__KerberosOptionsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:KerberosSpnType"))
		{	*type = SOAP_TYPE_sai__KerberosSpnType;
			return soap_in_sai__KerberosSpnType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:AdminAclEntryExType"))
		{	*type = SOAP_TYPE_sai__AdminAclEntryExType;
			return soap_in_sai__AdminAclEntryExType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UserAclEntryExType"))
		{	*type = SOAP_TYPE_sai__UserAclEntryExType;
			return soap_in_sai__UserAclEntryExType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UserEntryKerberosType"))
		{	*type = SOAP_TYPE_sai__UserEntryKerberosType;
			return soap_in_sai__UserEntryKerberosType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UserEntryDigestType"))
		{	*type = SOAP_TYPE_sai__UserEntryDigestType;
			return soap_in_sai__UserEntryDigestType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:AmtVersion"))
		{	*type = SOAP_TYPE_sai__AmtVersion;
			return soap_in_sai__AmtVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UpdateCoreUrlKeyType"))
		{	*type = SOAP_TYPE_sai__UpdateCoreUrlKeyType;
			return soap_in_sai__UpdateCoreUrlKeyType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:CertificateChainType"))
		{	*type = SOAP_TYPE_sai__CertificateChainType;
			return soap_in_sai__CertificateChainType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:RngKeyType"))
		{	*type = SOAP_TYPE_sai__RngKeyType;
			return soap_in_sai__RngKeyType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:RsaKeyType"))
		{	*type = SOAP_TYPE_sai__RsaKeyType;
			return soap_in_sai__RsaKeyType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UserAclRealmListType"))
		{	*type = SOAP_TYPE_sai__UserAclRealmListType;
			return soap_in_sai__UserAclRealmListType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UserAclEntryHandleListType"))
		{	*type = SOAP_TYPE_sai__UserAclEntryHandleListType;
			return soap_in_sai__UserAclEntryHandleListType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:AdminAclEntryType"))
		{	*type = SOAP_TYPE_sai__AdminAclEntryType;
			return soap_in_sai__AdminAclEntryType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:UserAclEntryType"))
		{	*type = SOAP_TYPE_sai__UserAclEntryType;
			return soap_in_sai__UserAclEntryType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertSubscriptionGeneralType"))
		{	*type = SOAP_TYPE_emi__AlertSubscriptionGeneralType;
			return soap_in_emi__AlertSubscriptionGeneralType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertSubscriptionSoapType"))
		{	*type = SOAP_TYPE_emi__AlertSubscriptionSoapType;
			return soap_in_emi__AlertSubscriptionSoapType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertSubscriptionSNMPType"))
		{	*type = SOAP_TYPE_emi__AlertSubscriptionSNMPType;
			return soap_in_emi__AlertSubscriptionSNMPType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertCredentialsType"))
		{	*type = SOAP_TYPE_emi__AlertCredentialsType;
			return soap_in_emi__AlertCredentialsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:ByteStr"))
		{	*type = SOAP_TYPE_emi__ByteStr;
			return soap_in_emi__ByteStr(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:SensorAttributesType"))
		{	*type = SOAP_TYPE_emi__SensorAttributesType;
			return soap_in_emi__SensorAttributesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:SensorHandleArrayType"))
		{	*type = SOAP_TYPE_emi__SensorHandleArrayType;
			return soap_in_emi__SensorHandleArrayType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:EventLogRecordArrayType"))
		{	*type = SOAP_TYPE_emi__EventLogRecordArrayType;
			return soap_in_emi__EventLogRecordArrayType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:EventFilterHandleArrayType"))
		{	*type = SOAP_TYPE_emi__EventFilterHandleArrayType;
			return soap_in_emi__EventFilterHandleArrayType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertSubscriptionHandleArrayType"))
		{	*type = SOAP_TYPE_emi__AlertSubscriptionHandleArrayType;
			return soap_in_emi__AlertSubscriptionHandleArrayType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertSubscriptionType"))
		{	*type = SOAP_TYPE_emi__AlertSubscriptionType;
			return soap_in_emi__AlertSubscriptionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:EventFilterType"))
		{	*type = SOAP_TYPE_emi__EventFilterType;
			return soap_in_emi__EventFilterType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:EventLogRecordType"))
		{	*type = SOAP_TYPE_emi__EventLogRecordType;
			return soap_in_emi__EventLogRecordType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:ByteData"))
		{	*type = SOAP_TYPE_emi__ByteData;
			return soap_in_emi__ByteData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:AlertSubscriptionPolicyIDArrayType"))
		{	*type = SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType;
			return soap_in_emi__AlertSubscriptionPolicyIDArrayType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:NodeAddressType"))
		{	*type = SOAP_TYPE_cmn__NodeAddressType;
			return soap_in_cmn__NodeAddressType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "cmn:URLType"))
		{	*type = SOAP_TYPE_cmn__URLType;
			return soap_in_cmn__URLType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	*type = SOAP_TYPE_xsd__anyURI;
			return soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "sai:KerberosRealmName"))
		{	*type = SOAP_TYPE__sai__KerberosRealmName;
			return soap_in__sai__KerberosRealmName(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sai:SpnString"))
		{	*type = SOAP_TYPE__sai__SpnString;
			return soap_in__sai__SpnString(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emc:SoapAlertResponse"))
		{	*type = SOAP_TYPE__emc__SoapAlertResponse;
			return soap_in__emc__SoapAlertResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emc:SoapAlertRequest"))
		{	*type = SOAP_TYPE__emc__SoapAlertRequest;
			return soap_in__emc__SoapAlertRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:GetGeneralAlertSubscriptionResponse"))
		{	*type = SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse;
			return soap_in__emi__GetGeneralAlertSubscriptionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:GetGeneralAlertSubscription"))
		{	*type = SOAP_TYPE__emi__GetGeneralAlertSubscription;
			return soap_in__emi__GetGeneralAlertSubscription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:EnumerateGeneralAlertSubscriptionsResponse"))
		{	*type = SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse;
			return soap_in__emi__EnumerateGeneralAlertSubscriptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:EnumerateGeneralAlertSubscriptions"))
		{	*type = SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions;
			return soap_in__emi__EnumerateGeneralAlertSubscriptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:SubscribeForGeneralAlertResponse"))
		{	*type = SOAP_TYPE__emi__SubscribeForGeneralAlertResponse;
			return soap_in__emi__SubscribeForGeneralAlertResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:SubscribeForGeneralAlert"))
		{	*type = SOAP_TYPE__emi__SubscribeForGeneralAlert;
			return soap_in__emi__SubscribeForGeneralAlert(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:CancelAlertSubscriptionResponse"))
		{	*type = SOAP_TYPE__emi__CancelAlertSubscriptionResponse;
			return soap_in__emi__CancelAlertSubscriptionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "emi:CancelAlertSubscription"))
		{	*type = SOAP_TYPE__emi__CancelAlertSubscription;
			return soap_in__emi__CancelAlertSubscription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_short:
		return soap_out_short(soap, tag, id, (const short *)ptr, "xsd:short");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_emi__AlertSubscriptionPolicyIDType:
		return soap_out_emi__AlertSubscriptionPolicyIDType(soap, tag, id, (const unsigned char *)ptr, "emi:AlertSubscriptionPolicyIDType");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedShort:
		return soap_out_unsignedShort(soap, tag, id, (const unsigned short *)ptr, "xsd:unsignedShort");
	case SOAP_TYPE_sai__CertificateHandleType:
		return soap_out_sai__CertificateHandleType(soap, tag, id, (const unsigned int *)ptr, "sai:CertificateHandleType");
	case SOAP_TYPE_sai__IPv4AddressType:
		return soap_out_sai__IPv4AddressType(soap, tag, id, (const unsigned int *)ptr, "sai:IPv4AddressType");
	case SOAP_TYPE_sai__UserAclEntryHandleType:
		return soap_out_sai__UserAclEntryHandleType(soap, tag, id, (const unsigned int *)ptr, "sai:UserAclEntryHandleType");
	case SOAP_TYPE_sai__PT_USCORESTATUS:
		return soap_out_sai__PT_USCORESTATUS(soap, tag, id, (const unsigned int *)ptr, "sai:PT_STATUS");
	case SOAP_TYPE_emi__SensorHandleType:
		return soap_out_emi__SensorHandleType(soap, tag, id, (const unsigned int *)ptr, "emi:SensorHandleType");
	case SOAP_TYPE_emi__IPv4AddressType:
		return soap_out_emi__IPv4AddressType(soap, tag, id, (const unsigned int *)ptr, "emi:IPv4AddressType");
	case SOAP_TYPE_emi__PT_USCORESTATUS:
		return soap_out_emi__PT_USCORESTATUS(soap, tag, id, (const unsigned int *)ptr, "emi:PT_STATUS");
	case SOAP_TYPE_emi__EventFilterHandleType:
		return soap_out_emi__EventFilterHandleType(soap, tag, id, (const unsigned int *)ptr, "emi:EventFilterHandleType");
	case SOAP_TYPE_emi__AlertSubscriptionHandleType:
		return soap_out_emi__AlertSubscriptionHandleType(soap, tag, id, (const unsigned int *)ptr, "emi:AlertSubscriptionHandleType");
	case SOAP_TYPE_emi__TimeType:
		return soap_out_emi__TimeType(soap, tag, id, (const unsigned int *)ptr, "emi:TimeType");
	case SOAP_TYPE_cmn__InterfaceHandleType:
		return soap_out_cmn__InterfaceHandleType(soap, tag, id, (const unsigned int *)ptr, "cmn:InterfaceHandleType");
	case SOAP_TYPE_cmn__IPv4AddressType:
		return soap_out_cmn__IPv4AddressType(soap, tag, id, (const unsigned int *)ptr, "cmn:IPv4AddressType");
	case SOAP_TYPE_cmn__PT_USCORESTATUS:
		return soap_out_cmn__PT_USCORESTATUS(soap, tag, id, (const unsigned int *)ptr, "cmn:PT_STATUS");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_sai__UNOptionsType:
		return soap_out_sai__UNOptionsType(soap, tag, id, (const enum sai__UNOptionsType *)ptr, "sai:UNOptionsType");
	case SOAP_TYPE_sai__HashTypeType:
		return soap_out_sai__HashTypeType(soap, tag, id, (const enum sai__HashTypeType *)ptr, "sai:HashTypeType");
	case SOAP_TYPE_sai__ProvisioningTLSModeType:
		return soap_out_sai__ProvisioningTLSModeType(soap, tag, id, (const enum sai__ProvisioningTLSModeType *)ptr, "sai:ProvisioningTLSModeType");
	case SOAP_TYPE_sai__TlsAthenticationType:
		return soap_out_sai__TlsAthenticationType(soap, tag, id, (const enum sai__TlsAthenticationType *)ptr, "sai:TlsAthenticationType");
	case SOAP_TYPE_sai__InterfaceType:
		return soap_out_sai__InterfaceType(soap, tag, id, (const enum sai__InterfaceType *)ptr, "sai:InterfaceType");
	case SOAP_TYPE_sai__EnabledInterfacesType:
		return soap_out_sai__EnabledInterfacesType(soap, tag, id, (const enum sai__EnabledInterfacesType *)ptr, "sai:EnabledInterfacesType");
	case SOAP_TYPE_sai__PowerStateType:
		return soap_out_sai__PowerStateType(soap, tag, id, (const enum sai__PowerStateType *)ptr, "sai:PowerStateType");
	case SOAP_TYPE_sai__KerberosEncryptionType:
		return soap_out_sai__KerberosEncryptionType(soap, tag, id, (const enum sai__KerberosEncryptionType *)ptr, "sai:KerberosEncryptionType");
	case SOAP_TYPE_sai__KerberosSpnProtocolType:
		return soap_out_sai__KerberosSpnProtocolType(soap, tag, id, (const enum sai__KerberosSpnProtocolType *)ptr, "sai:KerberosSpnProtocolType");
	case SOAP_TYPE_sai__AccessPermissionType:
		return soap_out_sai__AccessPermissionType(soap, tag, id, (const enum sai__AccessPermissionType *)ptr, "sai:AccessPermissionType");
	case SOAP_TYPE_sai__ProvisioningModeType:
		return soap_out_sai__ProvisioningModeType(soap, tag, id, (const enum sai__ProvisioningModeType *)ptr, "sai:ProvisioningModeType");
	case SOAP_TYPE_sai__RngKeyEncodingType:
		return soap_out_sai__RngKeyEncodingType(soap, tag, id, (const enum sai__RngKeyEncodingType *)ptr, "sai:RngKeyEncodingType");
	case SOAP_TYPE_sai__RsaCertificateEncodingType:
		return soap_out_sai__RsaCertificateEncodingType(soap, tag, id, (const enum sai__RsaCertificateEncodingType *)ptr, "sai:RsaCertificateEncodingType");
	case SOAP_TYPE_sai__RsaKeyEncodingType:
		return soap_out_sai__RsaKeyEncodingType(soap, tag, id, (const enum sai__RsaKeyEncodingType *)ptr, "sai:RsaKeyEncodingType");
	case SOAP_TYPE_sai__UserAclRealmType:
		return soap_out_sai__UserAclRealmType(soap, tag, id, (const enum sai__UserAclRealmType *)ptr, "sai:UserAclRealmType");
	case SOAP_TYPE_emi__AlertAuthOptionsType:
		return soap_out_emi__AlertAuthOptionsType(soap, tag, id, (const enum emi__AlertAuthOptionsType *)ptr, "emi:AlertAuthOptionsType");
	case SOAP_TYPE_emi__EventSeverityType:
		return soap_out_emi__EventSeverityType(soap, tag, id, (const enum emi__EventSeverityType *)ptr, "emi:EventSeverityType");
	case SOAP_TYPE__sai__KerberosRealmName:
		return soap_out__sai__KerberosRealmName(soap, "sai:KerberosRealmName", id, (const std::string *)ptr, NULL);
	case SOAP_TYPE__sai__SpnString:
		return soap_out__sai__SpnString(soap, "sai:SpnString", id, (const std::string *)ptr, NULL);
	case SOAP_TYPE_sai__FriendlyNameType:
		return soap_out_sai__FriendlyNameType(soap, tag, id, (const std::string *)ptr, "sai:FriendlyNameType");
	case SOAP_TYPE_sai__ProvisioningOTPType:
		return soap_out_sai__ProvisioningOTPType(soap, tag, id, (const xsd__base64Binary *)ptr, "sai:ProvisioningOTPType");
	case SOAP_TYPE_sai__MEBxPasswordType:
		return soap_out_sai__MEBxPasswordType(soap, tag, id, (const std::string *)ptr, "sai:MEBxPasswordType");
	case SOAP_TYPE_sai__AclPasswordStringType:
		return soap_out_sai__AclPasswordStringType(soap, tag, id, (const std::string *)ptr, "sai:AclPasswordStringType");
	case SOAP_TYPE_sai__AclStringType:
		return soap_out_sai__AclStringType(soap, tag, id, (const std::string *)ptr, "sai:AclStringType");
	case SOAP_TYPE_emi__CommunityStringType:
		return soap_out_emi__CommunityStringType(soap, tag, id, (const std::string *)ptr, "emi:CommunityStringType");
	case SOAP_TYPE_cmn__GuidBuf:
		return soap_out_cmn__GuidBuf(soap, tag, id, (const xsd__base64Binary *)ptr, "cmn:GuidBuf");
	case SOAP_TYPE_cmn__IPv6AddressStringType:
		return soap_out_cmn__IPv6AddressStringType(soap, tag, id, (const std::string *)ptr, "cmn:IPv6AddressStringType");
	case SOAP_TYPE_cmn__IPv4AddressStringType:
		return soap_out_cmn__IPv4AddressStringType(soap, tag, id, (const std::string *)ptr, "cmn:IPv4AddressStringType");
	case SOAP_TYPE_cmn__HostNameType:
		return soap_out_cmn__HostNameType(soap, tag, id, (const std::string *)ptr, "cmn:HostNameType");
	case SOAP_TYPE_sai__GlobalPowerPolicyType:
		return ((sai__GlobalPowerPolicyType *)ptr)->soap_out(soap, tag, id, "sai:GlobalPowerPolicyType");
	case SOAP_TYPE_sai__EnvironmentDetectionType:
		return ((sai__EnvironmentDetectionType *)ptr)->soap_out(soap, tag, id, "sai:EnvironmentDetectionType");
	case SOAP_TYPE_sai__EnvironmentDetectionDomainType:
		return ((sai__EnvironmentDetectionDomainType *)ptr)->soap_out(soap, tag, id, "sai:EnvironmentDetectionDomainType");
	case SOAP_TYPE_sai__EnvironmentDetectionHTTPSType:
		return ((sai__EnvironmentDetectionHTTPSType *)ptr)->soap_out(soap, tag, id, "sai:EnvironmentDetectionHTTPSType");
	case SOAP_TYPE_sai__ProvisioningAuditRecordType:
		return ((sai__ProvisioningAuditRecordType *)ptr)->soap_out(soap, tag, id, "sai:ProvisioningAuditRecordType");
	case SOAP_TYPE_sai__CertHashEntryType:
		return ((sai__CertHashEntryType *)ptr)->soap_out(soap, tag, id, "sai:CertHashEntryType");
	case SOAP_TYPE_sai__PkiCapsType:
		return ((sai__PkiCapsType *)ptr)->soap_out(soap, tag, id, "sai:PkiCapsType");
	case SOAP_TYPE_sai__CrlType:
		return ((sai__CrlType *)ptr)->soap_out(soap, tag, id, "sai:CrlType");
	case SOAP_TYPE_sai__CertificateType:
		return ((sai__CertificateType *)ptr)->soap_out(soap, tag, id, "sai:CertificateType");
	case SOAP_TYPE_sai__TlsOptionsType:
		return ((sai__TlsOptionsType *)ptr)->soap_out(soap, tag, id, "sai:TlsOptionsType");
	case SOAP_TYPE_sai__KerberosOptionsType:
		return ((sai__KerberosOptionsType *)ptr)->soap_out(soap, tag, id, "sai:KerberosOptionsType");
	case SOAP_TYPE_sai__KerberosSpnType:
		return ((sai__KerberosSpnType *)ptr)->soap_out(soap, tag, id, "sai:KerberosSpnType");
	case SOAP_TYPE_sai__AdminAclEntryExType:
		return ((sai__AdminAclEntryExType *)ptr)->soap_out(soap, tag, id, "sai:AdminAclEntryExType");
	case SOAP_TYPE_sai__UserAclEntryExType:
		return ((sai__UserAclEntryExType *)ptr)->soap_out(soap, tag, id, "sai:UserAclEntryExType");
	case SOAP_TYPE_sai__UserEntryKerberosType:
		return ((sai__UserEntryKerberosType *)ptr)->soap_out(soap, tag, id, "sai:UserEntryKerberosType");
	case SOAP_TYPE_sai__UserEntryDigestType:
		return ((sai__UserEntryDigestType *)ptr)->soap_out(soap, tag, id, "sai:UserEntryDigestType");
	case SOAP_TYPE_sai__AmtVersion:
		return ((sai__AmtVersion *)ptr)->soap_out(soap, tag, id, "sai:AmtVersion");
	case SOAP_TYPE_sai__UpdateCoreUrlKeyType:
		return ((sai__UpdateCoreUrlKeyType *)ptr)->soap_out(soap, tag, id, "sai:UpdateCoreUrlKeyType");
	case SOAP_TYPE_sai__CertificateChainType:
		return ((sai__CertificateChainType *)ptr)->soap_out(soap, tag, id, "sai:CertificateChainType");
	case SOAP_TYPE_sai__RngKeyType:
		return ((sai__RngKeyType *)ptr)->soap_out(soap, tag, id, "sai:RngKeyType");
	case SOAP_TYPE_sai__RsaKeyType:
		return ((sai__RsaKeyType *)ptr)->soap_out(soap, tag, id, "sai:RsaKeyType");
	case SOAP_TYPE_sai__UserAclRealmListType:
		return ((sai__UserAclRealmListType *)ptr)->soap_out(soap, tag, id, "sai:UserAclRealmListType");
	case SOAP_TYPE_sai__UserAclEntryHandleListType:
		return ((sai__UserAclEntryHandleListType *)ptr)->soap_out(soap, tag, id, "sai:UserAclEntryHandleListType");
	case SOAP_TYPE_sai__AdminAclEntryType:
		return ((sai__AdminAclEntryType *)ptr)->soap_out(soap, tag, id, "sai:AdminAclEntryType");
	case SOAP_TYPE_sai__UserAclEntryType:
		return ((sai__UserAclEntryType *)ptr)->soap_out(soap, tag, id, "sai:UserAclEntryType");
	case SOAP_TYPE__emc__SoapAlertResponse:
		return ((_emc__SoapAlertResponse *)ptr)->soap_out(soap, "emc:SoapAlertResponse", id, NULL);
	case SOAP_TYPE__emc__SoapAlertRequest:
		return ((_emc__SoapAlertRequest *)ptr)->soap_out(soap, "emc:SoapAlertRequest", id, NULL);
	case SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse:
		return ((_emi__GetGeneralAlertSubscriptionResponse *)ptr)->soap_out(soap, "emi:GetGeneralAlertSubscriptionResponse", id, NULL);
	case SOAP_TYPE__emi__GetGeneralAlertSubscription:
		return ((_emi__GetGeneralAlertSubscription *)ptr)->soap_out(soap, "emi:GetGeneralAlertSubscription", id, NULL);
	case SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse:
		return ((_emi__EnumerateGeneralAlertSubscriptionsResponse *)ptr)->soap_out(soap, "emi:EnumerateGeneralAlertSubscriptionsResponse", id, NULL);
	case SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions:
		return ((_emi__EnumerateGeneralAlertSubscriptions *)ptr)->soap_out(soap, "emi:EnumerateGeneralAlertSubscriptions", id, NULL);
	case SOAP_TYPE__emi__SubscribeForGeneralAlertResponse:
		return ((_emi__SubscribeForGeneralAlertResponse *)ptr)->soap_out(soap, "emi:SubscribeForGeneralAlertResponse", id, NULL);
	case SOAP_TYPE__emi__SubscribeForGeneralAlert:
		return ((_emi__SubscribeForGeneralAlert *)ptr)->soap_out(soap, "emi:SubscribeForGeneralAlert", id, NULL);
	case SOAP_TYPE__emi__CancelAlertSubscriptionResponse:
		return ((_emi__CancelAlertSubscriptionResponse *)ptr)->soap_out(soap, "emi:CancelAlertSubscriptionResponse", id, NULL);
	case SOAP_TYPE__emi__CancelAlertSubscription:
		return ((_emi__CancelAlertSubscription *)ptr)->soap_out(soap, "emi:CancelAlertSubscription", id, NULL);
	case SOAP_TYPE_emi__AlertSubscriptionGeneralType:
		return ((emi__AlertSubscriptionGeneralType *)ptr)->soap_out(soap, tag, id, "emi:AlertSubscriptionGeneralType");
	case SOAP_TYPE_emi__AlertSubscriptionSoapType:
		return ((emi__AlertSubscriptionSoapType *)ptr)->soap_out(soap, tag, id, "emi:AlertSubscriptionSoapType");
	case SOAP_TYPE_emi__AlertSubscriptionSNMPType:
		return ((emi__AlertSubscriptionSNMPType *)ptr)->soap_out(soap, tag, id, "emi:AlertSubscriptionSNMPType");
	case SOAP_TYPE_emi__AlertCredentialsType:
		return ((emi__AlertCredentialsType *)ptr)->soap_out(soap, tag, id, "emi:AlertCredentialsType");
	case SOAP_TYPE_emi__ByteStr:
		return ((emi__ByteStr *)ptr)->soap_out(soap, tag, id, "emi:ByteStr");
	case SOAP_TYPE_emi__SensorAttributesType:
		return ((emi__SensorAttributesType *)ptr)->soap_out(soap, tag, id, "emi:SensorAttributesType");
	case SOAP_TYPE_emi__SensorHandleArrayType:
		return ((emi__SensorHandleArrayType *)ptr)->soap_out(soap, tag, id, "emi:SensorHandleArrayType");
	case SOAP_TYPE_emi__EventLogRecordArrayType:
		return ((emi__EventLogRecordArrayType *)ptr)->soap_out(soap, tag, id, "emi:EventLogRecordArrayType");
	case SOAP_TYPE_emi__EventFilterHandleArrayType:
		return ((emi__EventFilterHandleArrayType *)ptr)->soap_out(soap, tag, id, "emi:EventFilterHandleArrayType");
	case SOAP_TYPE_emi__AlertSubscriptionHandleArrayType:
		return ((emi__AlertSubscriptionHandleArrayType *)ptr)->soap_out(soap, tag, id, "emi:AlertSubscriptionHandleArrayType");
	case SOAP_TYPE_emi__AlertSubscriptionType:
		return ((emi__AlertSubscriptionType *)ptr)->soap_out(soap, tag, id, "emi:AlertSubscriptionType");
	case SOAP_TYPE_emi__EventFilterType:
		return ((emi__EventFilterType *)ptr)->soap_out(soap, tag, id, "emi:EventFilterType");
	case SOAP_TYPE_emi__EventLogRecordType:
		return ((emi__EventLogRecordType *)ptr)->soap_out(soap, tag, id, "emi:EventLogRecordType");
	case SOAP_TYPE_emi__ByteData:
		return ((emi__ByteData *)ptr)->soap_out(soap, tag, id, "emi:ByteData");
	case SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType:
		return ((emi__AlertSubscriptionPolicyIDArrayType *)ptr)->soap_out(soap, tag, id, "emi:AlertSubscriptionPolicyIDArrayType");
	case SOAP_TYPE_cmn__NodeAddressType:
		return ((cmn__NodeAddressType *)ptr)->soap_out(soap, tag, id, "cmn:NodeAddressType");
	case SOAP_TYPE_cmn__URLType:
		return ((cmn__URLType *)ptr)->soap_out(soap, tag, id, "cmn:URLType");
	case SOAP_TYPE_xsd__base64Binary:
		return ((xsd__base64Binary *)ptr)->soap_out(soap, tag, id, "xsd:base64Binary");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_xsd__anyURI(soap, tag, id, (const std::string *)ptr, "xsd:anyURI");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE_PointerTo_emc__SoapAlertResponse:
		return soap_out_PointerTo_emc__SoapAlertResponse(soap, tag, id, (_emc__SoapAlertResponse *const*)ptr, "emc:SoapAlertResponse");
	case SOAP_TYPE_PointerTo_emc__SoapAlertRequest:
		return soap_out_PointerTo_emc__SoapAlertRequest(soap, tag, id, (_emc__SoapAlertRequest *const*)ptr, "emc:SoapAlertRequest");
	case SOAP_TYPE_PointerTounsignedInt:
		return soap_out_PointerTounsignedInt(soap, tag, id, (unsigned int *const*)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_PointerTosai__EnvironmentDetectionHTTPSType:
		return soap_out_PointerTosai__EnvironmentDetectionHTTPSType(soap, tag, id, (sai__EnvironmentDetectionHTTPSType *const*)ptr, "sai:EnvironmentDetectionHTTPSType");
	case SOAP_TYPE_PointerTosai__EnvironmentDetectionDomainType:
		return soap_out_PointerTosai__EnvironmentDetectionDomainType(soap, tag, id, (sai__EnvironmentDetectionDomainType *const*)ptr, "sai:EnvironmentDetectionDomainType");
	case SOAP_TYPE_PointerTobool:
		return soap_out_PointerTobool(soap, tag, id, (bool *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_out_PointerToxsd__base64Binary(soap, tag, id, (xsd__base64Binary *const*)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTostd__string:
		return soap_out_PointerTostd__string(soap, tag, id, (std::string *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTosai__KerberosSpnType:
		return soap_out_PointerTosai__KerberosSpnType(soap, tag, id, (sai__KerberosSpnType *const*)ptr, "sai:KerberosSpnType");
	case SOAP_TYPE_PointerTosai__UserEntryKerberosType:
		return soap_out_PointerTosai__UserEntryKerberosType(soap, tag, id, (sai__UserEntryKerberosType *const*)ptr, "sai:UserEntryKerberosType");
	case SOAP_TYPE_PointerTosai__UserEntryDigestType:
		return soap_out_PointerTosai__UserEntryDigestType(soap, tag, id, (sai__UserEntryDigestType *const*)ptr, "sai:UserEntryDigestType");
	case SOAP_TYPE_PointerTosai__UserAclRealmListType:
		return soap_out_PointerTosai__UserAclRealmListType(soap, tag, id, (sai__UserAclRealmListType *const*)ptr, "sai:UserAclRealmListType");
	case SOAP_TYPE_PointerToemi__AlertSubscriptionPolicyIDType:
		return soap_out_PointerToemi__AlertSubscriptionPolicyIDType(soap, tag, id, (unsigned char *const*)ptr, "emi:AlertSubscriptionPolicyIDType");
	case SOAP_TYPE_PointerToemi__AlertSubscriptionGeneralType:
		return soap_out_PointerToemi__AlertSubscriptionGeneralType(soap, tag, id, (emi__AlertSubscriptionGeneralType *const*)ptr, "emi:AlertSubscriptionGeneralType");
	case SOAP_TYPE_PointerToemi__AlertSubscriptionSoapType:
		return soap_out_PointerToemi__AlertSubscriptionSoapType(soap, tag, id, (emi__AlertSubscriptionSoapType *const*)ptr, "emi:AlertSubscriptionSoapType");
	case SOAP_TYPE_PointerToemi__AlertSubscriptionSNMPType:
		return soap_out_PointerToemi__AlertSubscriptionSNMPType(soap, tag, id, (emi__AlertSubscriptionSNMPType *const*)ptr, "emi:AlertSubscriptionSNMPType");
	case SOAP_TYPE_PointerToemi__AlertCredentialsType:
		return soap_out_PointerToemi__AlertCredentialsType(soap, tag, id, (emi__AlertCredentialsType *const*)ptr, "emi:AlertCredentialsType");
	case SOAP_TYPE_PointerTosai__CertificateHandleType:
		return soap_out_PointerTosai__CertificateHandleType(soap, tag, id, (unsigned int *const*)ptr, "sai:CertificateHandleType");
	case SOAP_TYPE_PointerTocmn__URLType:
		return soap_out_PointerTocmn__URLType(soap, tag, id, (cmn__URLType *const*)ptr, "cmn:URLType");
	case SOAP_TYPE_PointerToemi__CommunityStringType:
		return soap_out_PointerToemi__CommunityStringType(soap, tag, id, (std::string *const*)ptr, "emi:CommunityStringType");
	case SOAP_TYPE_PointerTocmn__NodeAddressType:
		return soap_out_PointerTocmn__NodeAddressType(soap, tag, id, (cmn__NodeAddressType *const*)ptr, "cmn:NodeAddressType");
	case SOAP_TYPE_PointerToemi__EventLogRecordType:
		return soap_out_PointerToemi__EventLogRecordType(soap, tag, id, (emi__EventLogRecordType *const*)ptr, "emi:EventLogRecordType");
	case SOAP_TYPE_PointerToemi__ByteData:
		return soap_out_PointerToemi__ByteData(soap, tag, id, (emi__ByteData *const*)ptr, "emi:ByteData");
	case SOAP_TYPE_PointerTocmn__IPv6AddressStringType:
		return soap_out_PointerTocmn__IPv6AddressStringType(soap, tag, id, (std::string *const*)ptr, "cmn:IPv6AddressStringType");
	case SOAP_TYPE_PointerTocmn__IPv4AddressStringType:
		return soap_out_PointerTocmn__IPv4AddressStringType(soap, tag, id, (std::string *const*)ptr, "cmn:IPv4AddressStringType");
	case SOAP_TYPE_PointerTocmn__HostNameType:
		return soap_out_PointerTocmn__HostNameType(soap, tag, id, (std::string *const*)ptr, "cmn:HostNameType");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "xsd:QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE__sai__KerberosRealmName:
		soap_serialize__sai__KerberosRealmName(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE__sai__SpnString:
		soap_serialize__sai__SpnString(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_sai__FriendlyNameType:
		soap_serialize_sai__FriendlyNameType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_sai__ProvisioningOTPType:
		soap_serialize_sai__ProvisioningOTPType(soap, (const xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE_sai__MEBxPasswordType:
		soap_serialize_sai__MEBxPasswordType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_sai__AclPasswordStringType:
		soap_serialize_sai__AclPasswordStringType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_sai__AclStringType:
		soap_serialize_sai__AclStringType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_emi__CommunityStringType:
		soap_serialize_emi__CommunityStringType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_cmn__GuidBuf:
		soap_serialize_cmn__GuidBuf(soap, (const xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE_cmn__IPv6AddressStringType:
		soap_serialize_cmn__IPv6AddressStringType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_cmn__IPv4AddressStringType:
		soap_serialize_cmn__IPv4AddressStringType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_cmn__HostNameType:
		soap_serialize_cmn__HostNameType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_sai__GlobalPowerPolicyType:
		((sai__GlobalPowerPolicyType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__EnvironmentDetectionType:
		((sai__EnvironmentDetectionType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__EnvironmentDetectionDomainType:
		((sai__EnvironmentDetectionDomainType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__EnvironmentDetectionHTTPSType:
		((sai__EnvironmentDetectionHTTPSType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__ProvisioningAuditRecordType:
		((sai__ProvisioningAuditRecordType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__CertHashEntryType:
		((sai__CertHashEntryType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__PkiCapsType:
		((sai__PkiCapsType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__CrlType:
		((sai__CrlType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__CertificateType:
		((sai__CertificateType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__TlsOptionsType:
		((sai__TlsOptionsType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__KerberosOptionsType:
		((sai__KerberosOptionsType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__KerberosSpnType:
		((sai__KerberosSpnType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__AdminAclEntryExType:
		((sai__AdminAclEntryExType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__UserAclEntryExType:
		((sai__UserAclEntryExType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__UserEntryKerberosType:
		((sai__UserEntryKerberosType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__UserEntryDigestType:
		((sai__UserEntryDigestType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__AmtVersion:
		((sai__AmtVersion *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__UpdateCoreUrlKeyType:
		((sai__UpdateCoreUrlKeyType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__CertificateChainType:
		((sai__CertificateChainType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__RngKeyType:
		((sai__RngKeyType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__RsaKeyType:
		((sai__RsaKeyType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__UserAclRealmListType:
		((sai__UserAclRealmListType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__UserAclEntryHandleListType:
		((sai__UserAclEntryHandleListType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__AdminAclEntryType:
		((sai__AdminAclEntryType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sai__UserAclEntryType:
		((sai__UserAclEntryType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emc__SoapAlertResponse:
		((_emc__SoapAlertResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emc__SoapAlertRequest:
		((_emc__SoapAlertRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse:
		((_emi__GetGeneralAlertSubscriptionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emi__GetGeneralAlertSubscription:
		((_emi__GetGeneralAlertSubscription *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse:
		((_emi__EnumerateGeneralAlertSubscriptionsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions:
		((_emi__EnumerateGeneralAlertSubscriptions *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emi__SubscribeForGeneralAlertResponse:
		((_emi__SubscribeForGeneralAlertResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emi__SubscribeForGeneralAlert:
		((_emi__SubscribeForGeneralAlert *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emi__CancelAlertSubscriptionResponse:
		((_emi__CancelAlertSubscriptionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__emi__CancelAlertSubscription:
		((_emi__CancelAlertSubscription *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__AlertSubscriptionGeneralType:
		((emi__AlertSubscriptionGeneralType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__AlertSubscriptionSoapType:
		((emi__AlertSubscriptionSoapType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__AlertSubscriptionSNMPType:
		((emi__AlertSubscriptionSNMPType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__AlertCredentialsType:
		((emi__AlertCredentialsType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__ByteStr:
		((emi__ByteStr *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__SensorAttributesType:
		((emi__SensorAttributesType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__SensorHandleArrayType:
		((emi__SensorHandleArrayType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__EventLogRecordArrayType:
		((emi__EventLogRecordArrayType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__EventFilterHandleArrayType:
		((emi__EventFilterHandleArrayType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__AlertSubscriptionHandleArrayType:
		((emi__AlertSubscriptionHandleArrayType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__AlertSubscriptionType:
		((emi__AlertSubscriptionType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__EventFilterType:
		((emi__EventFilterType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__EventLogRecordType:
		((emi__EventLogRecordType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__ByteData:
		((emi__ByteData *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType:
		((emi__AlertSubscriptionPolicyIDArrayType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_cmn__NodeAddressType:
		((cmn__NodeAddressType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_cmn__URLType:
		((cmn__URLType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		((xsd__base64Binary *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_xsd__anyURI(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE___emc__SoapAlert:
		soap_serialize___emc__SoapAlert(soap, (const struct __emc__SoapAlert *)ptr);
		break;
	case SOAP_TYPE_PointerTo_emc__SoapAlertResponse:
		soap_serialize_PointerTo_emc__SoapAlertResponse(soap, (_emc__SoapAlertResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_emc__SoapAlertRequest:
		soap_serialize_PointerTo_emc__SoapAlertRequest(soap, (_emc__SoapAlertRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedInt:
		soap_serialize_PointerTounsignedInt(soap, (unsigned int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosai__EnvironmentDetectionHTTPSType:
		soap_serialize_PointerTosai__EnvironmentDetectionHTTPSType(soap, (sai__EnvironmentDetectionHTTPSType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosai__EnvironmentDetectionDomainType:
		soap_serialize_PointerTosai__EnvironmentDetectionDomainType(soap, (sai__EnvironmentDetectionDomainType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTobool:
		soap_serialize_PointerTobool(soap, (bool *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__base64Binary:
		soap_serialize_PointerToxsd__base64Binary(soap, (xsd__base64Binary *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostd__string:
		soap_serialize_PointerTostd__string(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosai__KerberosSpnType:
		soap_serialize_PointerTosai__KerberosSpnType(soap, (sai__KerberosSpnType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosai__UserEntryKerberosType:
		soap_serialize_PointerTosai__UserEntryKerberosType(soap, (sai__UserEntryKerberosType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosai__UserEntryDigestType:
		soap_serialize_PointerTosai__UserEntryDigestType(soap, (sai__UserEntryDigestType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosai__UserAclRealmListType:
		soap_serialize_PointerTosai__UserAclRealmListType(soap, (sai__UserAclRealmListType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToemi__AlertSubscriptionPolicyIDType:
		soap_serialize_PointerToemi__AlertSubscriptionPolicyIDType(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_PointerToemi__AlertSubscriptionGeneralType:
		soap_serialize_PointerToemi__AlertSubscriptionGeneralType(soap, (emi__AlertSubscriptionGeneralType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToemi__AlertSubscriptionSoapType:
		soap_serialize_PointerToemi__AlertSubscriptionSoapType(soap, (emi__AlertSubscriptionSoapType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToemi__AlertSubscriptionSNMPType:
		soap_serialize_PointerToemi__AlertSubscriptionSNMPType(soap, (emi__AlertSubscriptionSNMPType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToemi__AlertCredentialsType:
		soap_serialize_PointerToemi__AlertCredentialsType(soap, (emi__AlertCredentialsType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosai__CertificateHandleType:
		soap_serialize_PointerTosai__CertificateHandleType(soap, (unsigned int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTocmn__URLType:
		soap_serialize_PointerTocmn__URLType(soap, (cmn__URLType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToemi__CommunityStringType:
		soap_serialize_PointerToemi__CommunityStringType(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTocmn__NodeAddressType:
		soap_serialize_PointerTocmn__NodeAddressType(soap, (cmn__NodeAddressType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToemi__EventLogRecordType:
		soap_serialize_PointerToemi__EventLogRecordType(soap, (emi__EventLogRecordType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToemi__ByteData:
		soap_serialize_PointerToemi__ByteData(soap, (emi__ByteData *const*)ptr);
		break;
	case SOAP_TYPE_PointerTocmn__IPv6AddressStringType:
		soap_serialize_PointerTocmn__IPv6AddressStringType(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTocmn__IPv4AddressStringType:
		soap_serialize_PointerTocmn__IPv4AddressStringType(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTocmn__HostNameType:
		soap_serialize_PointerTocmn__HostNameType(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__base64Binary:
		return (void*)soap_instantiate_xsd__base64Binary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_cmn__NodeAddressType:
		return (void*)soap_instantiate_cmn__NodeAddressType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType:
		return (void*)soap_instantiate_emi__AlertSubscriptionPolicyIDArrayType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__ByteData:
		return (void*)soap_instantiate_emi__ByteData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__EventLogRecordType:
		return (void*)soap_instantiate_emi__EventLogRecordType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__EventFilterType:
		return (void*)soap_instantiate_emi__EventFilterType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__AlertSubscriptionType:
		return (void*)soap_instantiate_emi__AlertSubscriptionType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__AlertSubscriptionHandleArrayType:
		return (void*)soap_instantiate_emi__AlertSubscriptionHandleArrayType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__EventFilterHandleArrayType:
		return (void*)soap_instantiate_emi__EventFilterHandleArrayType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__EventLogRecordArrayType:
		return (void*)soap_instantiate_emi__EventLogRecordArrayType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__SensorHandleArrayType:
		return (void*)soap_instantiate_emi__SensorHandleArrayType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__SensorAttributesType:
		return (void*)soap_instantiate_emi__SensorAttributesType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__ByteStr:
		return (void*)soap_instantiate_emi__ByteStr(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__AlertCredentialsType:
		return (void*)soap_instantiate_emi__AlertCredentialsType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__AlertSubscriptionSNMPType:
		return (void*)soap_instantiate_emi__AlertSubscriptionSNMPType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__AlertSubscriptionSoapType:
		return (void*)soap_instantiate_emi__AlertSubscriptionSoapType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__AlertSubscriptionGeneralType:
		return (void*)soap_instantiate_emi__AlertSubscriptionGeneralType(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emi__CancelAlertSubscription:
		return (void*)soap_instantiate__emi__CancelAlertSubscription(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emi__CancelAlertSubscriptionResponse:
		return (void*)soap_instantiate__emi__CancelAlertSubscriptionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emi__SubscribeForGeneralAlert:
		return (void*)soap_instantiate__emi__SubscribeForGeneralAlert(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emi__SubscribeForGeneralAlertResponse:
		return (void*)soap_instantiate__emi__SubscribeForGeneralAlertResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions:
		return (void*)soap_instantiate__emi__EnumerateGeneralAlertSubscriptions(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse:
		return (void*)soap_instantiate__emi__EnumerateGeneralAlertSubscriptionsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emi__GetGeneralAlertSubscription:
		return (void*)soap_instantiate__emi__GetGeneralAlertSubscription(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse:
		return (void*)soap_instantiate__emi__GetGeneralAlertSubscriptionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emc__SoapAlertRequest:
		return (void*)soap_instantiate__emc__SoapAlertRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__emc__SoapAlertResponse:
		return (void*)soap_instantiate__emc__SoapAlertResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__UserAclEntryType:
		return (void*)soap_instantiate_sai__UserAclEntryType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__AdminAclEntryType:
		return (void*)soap_instantiate_sai__AdminAclEntryType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__UserAclEntryHandleListType:
		return (void*)soap_instantiate_sai__UserAclEntryHandleListType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__UserAclRealmListType:
		return (void*)soap_instantiate_sai__UserAclRealmListType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__RsaKeyType:
		return (void*)soap_instantiate_sai__RsaKeyType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__RngKeyType:
		return (void*)soap_instantiate_sai__RngKeyType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__CertificateChainType:
		return (void*)soap_instantiate_sai__CertificateChainType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__UpdateCoreUrlKeyType:
		return (void*)soap_instantiate_sai__UpdateCoreUrlKeyType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__AmtVersion:
		return (void*)soap_instantiate_sai__AmtVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__UserEntryDigestType:
		return (void*)soap_instantiate_sai__UserEntryDigestType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__UserEntryKerberosType:
		return (void*)soap_instantiate_sai__UserEntryKerberosType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__UserAclEntryExType:
		return (void*)soap_instantiate_sai__UserAclEntryExType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__AdminAclEntryExType:
		return (void*)soap_instantiate_sai__AdminAclEntryExType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__KerberosSpnType:
		return (void*)soap_instantiate_sai__KerberosSpnType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__KerberosOptionsType:
		return (void*)soap_instantiate_sai__KerberosOptionsType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__TlsOptionsType:
		return (void*)soap_instantiate_sai__TlsOptionsType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__CertificateType:
		return (void*)soap_instantiate_sai__CertificateType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__CrlType:
		return (void*)soap_instantiate_sai__CrlType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__PkiCapsType:
		return (void*)soap_instantiate_sai__PkiCapsType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__CertHashEntryType:
		return (void*)soap_instantiate_sai__CertHashEntryType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__ProvisioningAuditRecordType:
		return (void*)soap_instantiate_sai__ProvisioningAuditRecordType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__EnvironmentDetectionHTTPSType:
		return (void*)soap_instantiate_sai__EnvironmentDetectionHTTPSType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__EnvironmentDetectionDomainType:
		return (void*)soap_instantiate_sai__EnvironmentDetectionDomainType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__EnvironmentDetectionType:
		return (void*)soap_instantiate_sai__EnvironmentDetectionType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__GlobalPowerPolicyType:
		return (void*)soap_instantiate_sai__GlobalPowerPolicyType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_cmn__URLType:
		return (void*)soap_instantiate_cmn__URLType(soap, -1, type, arrayType, n);
	case SOAP_TYPE___emc__SoapAlert:
		return (void*)soap_instantiate___emc__SoapAlert(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	case SOAP_TYPE_xsd__anyURI:
		return (void*)soap_instantiate_xsd__anyURI(soap, -1, type, arrayType, n);
	case SOAP_TYPE_cmn__HostNameType:
		return (void*)soap_instantiate_cmn__HostNameType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_cmn__IPv4AddressStringType:
		return (void*)soap_instantiate_cmn__IPv4AddressStringType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_cmn__IPv6AddressStringType:
		return (void*)soap_instantiate_cmn__IPv6AddressStringType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_cmn__GuidBuf:
		return (void*)soap_instantiate_cmn__GuidBuf(soap, -1, type, arrayType, n);
	case SOAP_TYPE_emi__CommunityStringType:
		return (void*)soap_instantiate_emi__CommunityStringType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__AclStringType:
		return (void*)soap_instantiate_sai__AclStringType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__AclPasswordStringType:
		return (void*)soap_instantiate_sai__AclPasswordStringType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__MEBxPasswordType:
		return (void*)soap_instantiate_sai__MEBxPasswordType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__ProvisioningOTPType:
		return (void*)soap_instantiate_sai__ProvisioningOTPType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sai__FriendlyNameType:
		return (void*)soap_instantiate_sai__FriendlyNameType(soap, -1, type, arrayType, n);
	case SOAP_TYPE__sai__SpnString:
		return (void*)soap_instantiate__sai__SpnString(soap, -1, type, arrayType, n);
	case SOAP_TYPE__sai__KerberosRealmName:
		return (void*)soap_instantiate__sai__KerberosRealmName(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		return (void*)soap_instantiate_std__vectorTemplateOfstd__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxsd__anyURI:
		return (void*)soap_instantiate_std__vectorTemplateOfxsd__anyURI(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfunsignedInt:
		return (void*)soap_instantiate_std__vectorTemplateOfunsignedInt(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxsd__base64Binary:
		return (void*)soap_instantiate_std__vectorTemplateOfxsd__base64Binary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTosai__KerberosSpnType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTosai__KerberosSpnType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfsai__UserAclRealmType:
		return (void*)soap_instantiate_std__vectorTemplateOfsai__UserAclRealmType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfsai__UserAclEntryHandleType:
		return (void*)soap_instantiate_std__vectorTemplateOfsai__UserAclEntryHandleType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertAuthOptionsType:
		return (void*)soap_instantiate_std__vectorTemplateOfemi__AlertAuthOptionsType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfemi__SensorHandleType:
		return (void*)soap_instantiate_std__vectorTemplateOfemi__SensorHandleType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerToemi__EventLogRecordType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfemi__EventFilterHandleType:
		return (void*)soap_instantiate_std__vectorTemplateOfemi__EventFilterHandleType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionHandleType:
		return (void*)soap_instantiate_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfunsignedByte:
		return (void*)soap_instantiate_std__vectorTemplateOfunsignedByte(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType:
		return (void*)soap_instantiate_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_xsd__base64Binary:
		if (p->size < 0)
			delete (xsd__base64Binary*)p->ptr;
		else
			delete[] (xsd__base64Binary*)p->ptr;
		break;
	case SOAP_TYPE_cmn__NodeAddressType:
		if (p->size < 0)
			delete (cmn__NodeAddressType*)p->ptr;
		else
			delete[] (cmn__NodeAddressType*)p->ptr;
		break;
	case SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType:
		if (p->size < 0)
			delete (emi__AlertSubscriptionPolicyIDArrayType*)p->ptr;
		else
			delete[] (emi__AlertSubscriptionPolicyIDArrayType*)p->ptr;
		break;
	case SOAP_TYPE_emi__ByteData:
		if (p->size < 0)
			delete (emi__ByteData*)p->ptr;
		else
			delete[] (emi__ByteData*)p->ptr;
		break;
	case SOAP_TYPE_emi__EventLogRecordType:
		if (p->size < 0)
			delete (emi__EventLogRecordType*)p->ptr;
		else
			delete[] (emi__EventLogRecordType*)p->ptr;
		break;
	case SOAP_TYPE_emi__EventFilterType:
		if (p->size < 0)
			delete (emi__EventFilterType*)p->ptr;
		else
			delete[] (emi__EventFilterType*)p->ptr;
		break;
	case SOAP_TYPE_emi__AlertSubscriptionType:
		if (p->size < 0)
			delete (emi__AlertSubscriptionType*)p->ptr;
		else
			delete[] (emi__AlertSubscriptionType*)p->ptr;
		break;
	case SOAP_TYPE_emi__AlertSubscriptionHandleArrayType:
		if (p->size < 0)
			delete (emi__AlertSubscriptionHandleArrayType*)p->ptr;
		else
			delete[] (emi__AlertSubscriptionHandleArrayType*)p->ptr;
		break;
	case SOAP_TYPE_emi__EventFilterHandleArrayType:
		if (p->size < 0)
			delete (emi__EventFilterHandleArrayType*)p->ptr;
		else
			delete[] (emi__EventFilterHandleArrayType*)p->ptr;
		break;
	case SOAP_TYPE_emi__EventLogRecordArrayType:
		if (p->size < 0)
			delete (emi__EventLogRecordArrayType*)p->ptr;
		else
			delete[] (emi__EventLogRecordArrayType*)p->ptr;
		break;
	case SOAP_TYPE_emi__SensorHandleArrayType:
		if (p->size < 0)
			delete (emi__SensorHandleArrayType*)p->ptr;
		else
			delete[] (emi__SensorHandleArrayType*)p->ptr;
		break;
	case SOAP_TYPE_emi__SensorAttributesType:
		if (p->size < 0)
			delete (emi__SensorAttributesType*)p->ptr;
		else
			delete[] (emi__SensorAttributesType*)p->ptr;
		break;
	case SOAP_TYPE_emi__ByteStr:
		if (p->size < 0)
			delete (emi__ByteStr*)p->ptr;
		else
			delete[] (emi__ByteStr*)p->ptr;
		break;
	case SOAP_TYPE_emi__AlertCredentialsType:
		if (p->size < 0)
			delete (emi__AlertCredentialsType*)p->ptr;
		else
			delete[] (emi__AlertCredentialsType*)p->ptr;
		break;
	case SOAP_TYPE_emi__AlertSubscriptionSNMPType:
		if (p->size < 0)
			delete (emi__AlertSubscriptionSNMPType*)p->ptr;
		else
			delete[] (emi__AlertSubscriptionSNMPType*)p->ptr;
		break;
	case SOAP_TYPE_emi__AlertSubscriptionSoapType:
		if (p->size < 0)
			delete (emi__AlertSubscriptionSoapType*)p->ptr;
		else
			delete[] (emi__AlertSubscriptionSoapType*)p->ptr;
		break;
	case SOAP_TYPE_emi__AlertSubscriptionGeneralType:
		if (p->size < 0)
			delete (emi__AlertSubscriptionGeneralType*)p->ptr;
		else
			delete[] (emi__AlertSubscriptionGeneralType*)p->ptr;
		break;
	case SOAP_TYPE__emi__CancelAlertSubscription:
		if (p->size < 0)
			delete (_emi__CancelAlertSubscription*)p->ptr;
		else
			delete[] (_emi__CancelAlertSubscription*)p->ptr;
		break;
	case SOAP_TYPE__emi__CancelAlertSubscriptionResponse:
		if (p->size < 0)
			delete (_emi__CancelAlertSubscriptionResponse*)p->ptr;
		else
			delete[] (_emi__CancelAlertSubscriptionResponse*)p->ptr;
		break;
	case SOAP_TYPE__emi__SubscribeForGeneralAlert:
		if (p->size < 0)
			delete (_emi__SubscribeForGeneralAlert*)p->ptr;
		else
			delete[] (_emi__SubscribeForGeneralAlert*)p->ptr;
		break;
	case SOAP_TYPE__emi__SubscribeForGeneralAlertResponse:
		if (p->size < 0)
			delete (_emi__SubscribeForGeneralAlertResponse*)p->ptr;
		else
			delete[] (_emi__SubscribeForGeneralAlertResponse*)p->ptr;
		break;
	case SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions:
		if (p->size < 0)
			delete (_emi__EnumerateGeneralAlertSubscriptions*)p->ptr;
		else
			delete[] (_emi__EnumerateGeneralAlertSubscriptions*)p->ptr;
		break;
	case SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse:
		if (p->size < 0)
			delete (_emi__EnumerateGeneralAlertSubscriptionsResponse*)p->ptr;
		else
			delete[] (_emi__EnumerateGeneralAlertSubscriptionsResponse*)p->ptr;
		break;
	case SOAP_TYPE__emi__GetGeneralAlertSubscription:
		if (p->size < 0)
			delete (_emi__GetGeneralAlertSubscription*)p->ptr;
		else
			delete[] (_emi__GetGeneralAlertSubscription*)p->ptr;
		break;
	case SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse:
		if (p->size < 0)
			delete (_emi__GetGeneralAlertSubscriptionResponse*)p->ptr;
		else
			delete[] (_emi__GetGeneralAlertSubscriptionResponse*)p->ptr;
		break;
	case SOAP_TYPE__emc__SoapAlertRequest:
		if (p->size < 0)
			delete (_emc__SoapAlertRequest*)p->ptr;
		else
			delete[] (_emc__SoapAlertRequest*)p->ptr;
		break;
	case SOAP_TYPE__emc__SoapAlertResponse:
		if (p->size < 0)
			delete (_emc__SoapAlertResponse*)p->ptr;
		else
			delete[] (_emc__SoapAlertResponse*)p->ptr;
		break;
	case SOAP_TYPE_sai__UserAclEntryType:
		if (p->size < 0)
			delete (sai__UserAclEntryType*)p->ptr;
		else
			delete[] (sai__UserAclEntryType*)p->ptr;
		break;
	case SOAP_TYPE_sai__AdminAclEntryType:
		if (p->size < 0)
			delete (sai__AdminAclEntryType*)p->ptr;
		else
			delete[] (sai__AdminAclEntryType*)p->ptr;
		break;
	case SOAP_TYPE_sai__UserAclEntryHandleListType:
		if (p->size < 0)
			delete (sai__UserAclEntryHandleListType*)p->ptr;
		else
			delete[] (sai__UserAclEntryHandleListType*)p->ptr;
		break;
	case SOAP_TYPE_sai__UserAclRealmListType:
		if (p->size < 0)
			delete (sai__UserAclRealmListType*)p->ptr;
		else
			delete[] (sai__UserAclRealmListType*)p->ptr;
		break;
	case SOAP_TYPE_sai__RsaKeyType:
		if (p->size < 0)
			delete (sai__RsaKeyType*)p->ptr;
		else
			delete[] (sai__RsaKeyType*)p->ptr;
		break;
	case SOAP_TYPE_sai__RngKeyType:
		if (p->size < 0)
			delete (sai__RngKeyType*)p->ptr;
		else
			delete[] (sai__RngKeyType*)p->ptr;
		break;
	case SOAP_TYPE_sai__CertificateChainType:
		if (p->size < 0)
			delete (sai__CertificateChainType*)p->ptr;
		else
			delete[] (sai__CertificateChainType*)p->ptr;
		break;
	case SOAP_TYPE_sai__UpdateCoreUrlKeyType:
		if (p->size < 0)
			delete (sai__UpdateCoreUrlKeyType*)p->ptr;
		else
			delete[] (sai__UpdateCoreUrlKeyType*)p->ptr;
		break;
	case SOAP_TYPE_sai__AmtVersion:
		if (p->size < 0)
			delete (sai__AmtVersion*)p->ptr;
		else
			delete[] (sai__AmtVersion*)p->ptr;
		break;
	case SOAP_TYPE_sai__UserEntryDigestType:
		if (p->size < 0)
			delete (sai__UserEntryDigestType*)p->ptr;
		else
			delete[] (sai__UserEntryDigestType*)p->ptr;
		break;
	case SOAP_TYPE_sai__UserEntryKerberosType:
		if (p->size < 0)
			delete (sai__UserEntryKerberosType*)p->ptr;
		else
			delete[] (sai__UserEntryKerberosType*)p->ptr;
		break;
	case SOAP_TYPE_sai__UserAclEntryExType:
		if (p->size < 0)
			delete (sai__UserAclEntryExType*)p->ptr;
		else
			delete[] (sai__UserAclEntryExType*)p->ptr;
		break;
	case SOAP_TYPE_sai__AdminAclEntryExType:
		if (p->size < 0)
			delete (sai__AdminAclEntryExType*)p->ptr;
		else
			delete[] (sai__AdminAclEntryExType*)p->ptr;
		break;
	case SOAP_TYPE_sai__KerberosSpnType:
		if (p->size < 0)
			delete (sai__KerberosSpnType*)p->ptr;
		else
			delete[] (sai__KerberosSpnType*)p->ptr;
		break;
	case SOAP_TYPE_sai__KerberosOptionsType:
		if (p->size < 0)
			delete (sai__KerberosOptionsType*)p->ptr;
		else
			delete[] (sai__KerberosOptionsType*)p->ptr;
		break;
	case SOAP_TYPE_sai__TlsOptionsType:
		if (p->size < 0)
			delete (sai__TlsOptionsType*)p->ptr;
		else
			delete[] (sai__TlsOptionsType*)p->ptr;
		break;
	case SOAP_TYPE_sai__CertificateType:
		if (p->size < 0)
			delete (sai__CertificateType*)p->ptr;
		else
			delete[] (sai__CertificateType*)p->ptr;
		break;
	case SOAP_TYPE_sai__CrlType:
		if (p->size < 0)
			delete (sai__CrlType*)p->ptr;
		else
			delete[] (sai__CrlType*)p->ptr;
		break;
	case SOAP_TYPE_sai__PkiCapsType:
		if (p->size < 0)
			delete (sai__PkiCapsType*)p->ptr;
		else
			delete[] (sai__PkiCapsType*)p->ptr;
		break;
	case SOAP_TYPE_sai__CertHashEntryType:
		if (p->size < 0)
			delete (sai__CertHashEntryType*)p->ptr;
		else
			delete[] (sai__CertHashEntryType*)p->ptr;
		break;
	case SOAP_TYPE_sai__ProvisioningAuditRecordType:
		if (p->size < 0)
			delete (sai__ProvisioningAuditRecordType*)p->ptr;
		else
			delete[] (sai__ProvisioningAuditRecordType*)p->ptr;
		break;
	case SOAP_TYPE_sai__EnvironmentDetectionHTTPSType:
		if (p->size < 0)
			delete (sai__EnvironmentDetectionHTTPSType*)p->ptr;
		else
			delete[] (sai__EnvironmentDetectionHTTPSType*)p->ptr;
		break;
	case SOAP_TYPE_sai__EnvironmentDetectionDomainType:
		if (p->size < 0)
			delete (sai__EnvironmentDetectionDomainType*)p->ptr;
		else
			delete[] (sai__EnvironmentDetectionDomainType*)p->ptr;
		break;
	case SOAP_TYPE_sai__EnvironmentDetectionType:
		if (p->size < 0)
			delete (sai__EnvironmentDetectionType*)p->ptr;
		else
			delete[] (sai__EnvironmentDetectionType*)p->ptr;
		break;
	case SOAP_TYPE_sai__GlobalPowerPolicyType:
		if (p->size < 0)
			delete (sai__GlobalPowerPolicyType*)p->ptr;
		else
			delete[] (sai__GlobalPowerPolicyType*)p->ptr;
		break;
	case SOAP_TYPE_cmn__URLType:
		if (p->size < 0)
			delete (cmn__URLType*)p->ptr;
		else
			delete[] (cmn__URLType*)p->ptr;
		break;
	case SOAP_TYPE___emc__SoapAlert:
		if (p->size < 0)
			delete (struct __emc__SoapAlert*)p->ptr;
		else
			delete[] (struct __emc__SoapAlert*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	case SOAP_TYPE_xsd__anyURI:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_cmn__HostNameType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_cmn__IPv4AddressStringType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_cmn__IPv6AddressStringType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_cmn__GuidBuf:
		if (p->size < 0)
			delete (xsd__base64Binary*)p->ptr;
		else
			delete[] (xsd__base64Binary*)p->ptr;
		break;
	case SOAP_TYPE_emi__CommunityStringType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_sai__AclStringType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_sai__AclPasswordStringType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_sai__MEBxPasswordType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_sai__ProvisioningOTPType:
		if (p->size < 0)
			delete (xsd__base64Binary*)p->ptr;
		else
			delete[] (xsd__base64Binary*)p->ptr;
		break;
	case SOAP_TYPE_sai__FriendlyNameType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE__sai__SpnString:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE__sai__KerberosRealmName:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		if (p->size < 0)
			delete (std::vector<std::string >*)p->ptr;
		else
			delete[] (std::vector<std::string >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxsd__anyURI:
		if (p->size < 0)
			delete (std::vector<std::string >*)p->ptr;
		else
			delete[] (std::vector<std::string >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfunsignedInt:
		if (p->size < 0)
			delete (std::vector<unsigned int >*)p->ptr;
		else
			delete[] (std::vector<unsigned int >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxsd__base64Binary:
		if (p->size < 0)
			delete (std::vector<xsd__base64Binary >*)p->ptr;
		else
			delete[] (std::vector<xsd__base64Binary >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTosai__KerberosSpnType:
		if (p->size < 0)
			delete (std::vector<sai__KerberosSpnType * >*)p->ptr;
		else
			delete[] (std::vector<sai__KerberosSpnType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsai__UserAclRealmType:
		if (p->size < 0)
			delete (std::vector<enum sai__UserAclRealmType >*)p->ptr;
		else
			delete[] (std::vector<enum sai__UserAclRealmType >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsai__UserAclEntryHandleType:
		if (p->size < 0)
			delete (std::vector<unsigned int >*)p->ptr;
		else
			delete[] (std::vector<unsigned int >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertAuthOptionsType:
		if (p->size < 0)
			delete (std::vector<enum emi__AlertAuthOptionsType >*)p->ptr;
		else
			delete[] (std::vector<enum emi__AlertAuthOptionsType >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__SensorHandleType:
		if (p->size < 0)
			delete (std::vector<unsigned int >*)p->ptr;
		else
			delete[] (std::vector<unsigned int >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToemi__EventLogRecordType:
		if (p->size < 0)
			delete (std::vector<emi__EventLogRecordType * >*)p->ptr;
		else
			delete[] (std::vector<emi__EventLogRecordType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__EventFilterHandleType:
		if (p->size < 0)
			delete (std::vector<unsigned int >*)p->ptr;
		else
			delete[] (std::vector<unsigned int >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionHandleType:
		if (p->size < 0)
			delete (std::vector<unsigned int >*)p->ptr;
		else
			delete[] (std::vector<unsigned int >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfunsignedByte:
		if (p->size < 0)
			delete (std::vector<unsigned char >*)p->ptr;
		else
			delete[] (std::vector<unsigned char >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType:
		if (p->size < 0)
			delete (std::vector<unsigned char >*)p->ptr;
		else
			delete[] (std::vector<unsigned char >*)p->ptr;
		break;
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{	switch (tt)
	{
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<std::string >*)p)[len] = *(std::string *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxsd__anyURI:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<std::string >*)p)[len] = *(std::string *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfunsignedInt:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<unsigned int >*)p)[len] = *(unsigned int *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxsd__base64Binary:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xsd__base64Binary >*)p)[len] = *(xsd__base64Binary *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTosai__KerberosSpnType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<sai__KerberosSpnType * >*)p)[len] = *(sai__KerberosSpnType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsai__UserAclRealmType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<enum sai__UserAclRealmType >*)p)[len] = *(enum sai__UserAclRealmType *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsai__UserAclEntryHandleType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<unsigned int >*)p)[len] = *(unsigned int *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertAuthOptionsType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<enum emi__AlertAuthOptionsType >*)p)[len] = *(enum emi__AlertAuthOptionsType *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__SensorHandleType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<unsigned int >*)p)[len] = *(unsigned int *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToemi__EventLogRecordType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<emi__EventLogRecordType * >*)p)[len] = *(emi__EventLogRecordType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__EventFilterHandleType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<unsigned int >*)p)[len] = *(unsigned int *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionHandleType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<unsigned int >*)p)[len] = *(unsigned int *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfunsignedByte:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<unsigned char >*)p)[len] = *(unsigned char *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<unsigned char >*)p)[len] = *(unsigned char *)q;
		break;
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_short(struct soap *soap, short *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_short
	*a = SOAP_DEFAULT_short;
#else
	*a = (short)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_short(struct soap *soap, const short *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_short);
	if (soap_out_short(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_short(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{
	return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_short);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_short(struct soap *soap, short *p, const char *tag, const char *type)
{
	if ((p = soap_in_short(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_short(struct soap *soap, const char *tag, short *a, const char *type)
{
	return soap_inshort(soap, tag, a, type, SOAP_TYPE_short);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__AlertSubscriptionPolicyIDType(struct soap *soap, unsigned char *a)
{	soap_default_unsignedByte(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__AlertSubscriptionPolicyIDType(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType);
	if (soap_out_emi__AlertSubscriptionPolicyIDType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertSubscriptionPolicyIDType(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_emi__AlertSubscriptionPolicyIDType(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertSubscriptionPolicyIDType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_emi__AlertSubscriptionPolicyIDType(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedShort(struct soap *soap, unsigned short *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedShort
	*a = SOAP_DEFAULT_unsignedShort;
#else
	*a = (unsigned short)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedShort(struct soap *soap, const unsigned short *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedShort);
	if (soap_out_unsignedShort(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedShort(struct soap *soap, const char *tag, int id, const unsigned short *a, const char *type)
{
	return soap_outunsignedShort(soap, tag, id, a, type, SOAP_TYPE_unsignedShort);
}

SOAP_FMAC3 unsigned short * SOAP_FMAC4 soap_get_unsignedShort(struct soap *soap, unsigned short *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedShort(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned short * SOAP_FMAC4 soap_in_unsignedShort(struct soap *soap, const char *tag, unsigned short *a, const char *type)
{
	return soap_inunsignedShort(soap, tag, a, type, SOAP_TYPE_unsignedShort);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__CertificateHandleType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__CertificateHandleType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__CertificateHandleType);
	if (soap_out_sai__CertificateHandleType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__CertificateHandleType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_sai__CertificateHandleType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_sai__CertificateHandleType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__CertificateHandleType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_sai__CertificateHandleType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_sai__CertificateHandleType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__IPv4AddressType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__IPv4AddressType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__IPv4AddressType);
	if (soap_out_sai__IPv4AddressType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__IPv4AddressType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_sai__IPv4AddressType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_sai__IPv4AddressType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__IPv4AddressType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_sai__IPv4AddressType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_sai__IPv4AddressType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__UserAclEntryHandleType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__UserAclEntryHandleType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__UserAclEntryHandleType);
	if (soap_out_sai__UserAclEntryHandleType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UserAclEntryHandleType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_sai__UserAclEntryHandleType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_sai__UserAclEntryHandleType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UserAclEntryHandleType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_sai__UserAclEntryHandleType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_sai__UserAclEntryHandleType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__PT_USCORESTATUS(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__PT_USCORESTATUS(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__PT_USCORESTATUS);
	if (soap_out_sai__PT_USCORESTATUS(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__PT_USCORESTATUS(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_sai__PT_USCORESTATUS);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_sai__PT_USCORESTATUS(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__PT_USCORESTATUS(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_sai__PT_USCORESTATUS(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_sai__PT_USCORESTATUS);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__SensorHandleType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__SensorHandleType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__SensorHandleType);
	if (soap_out_emi__SensorHandleType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__SensorHandleType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_emi__SensorHandleType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_emi__SensorHandleType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__SensorHandleType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_emi__SensorHandleType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_emi__SensorHandleType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__IPv4AddressType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__IPv4AddressType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__IPv4AddressType);
	if (soap_out_emi__IPv4AddressType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__IPv4AddressType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_emi__IPv4AddressType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_emi__IPv4AddressType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__IPv4AddressType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_emi__IPv4AddressType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_emi__IPv4AddressType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__PT_USCORESTATUS(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__PT_USCORESTATUS(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__PT_USCORESTATUS);
	if (soap_out_emi__PT_USCORESTATUS(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__PT_USCORESTATUS(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_emi__PT_USCORESTATUS);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_emi__PT_USCORESTATUS(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__PT_USCORESTATUS(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_emi__PT_USCORESTATUS(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_emi__PT_USCORESTATUS);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__EventFilterHandleType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__EventFilterHandleType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__EventFilterHandleType);
	if (soap_out_emi__EventFilterHandleType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__EventFilterHandleType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_emi__EventFilterHandleType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_emi__EventFilterHandleType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__EventFilterHandleType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_emi__EventFilterHandleType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_emi__EventFilterHandleType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__AlertSubscriptionHandleType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__AlertSubscriptionHandleType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__AlertSubscriptionHandleType);
	if (soap_out_emi__AlertSubscriptionHandleType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertSubscriptionHandleType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_emi__AlertSubscriptionHandleType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_emi__AlertSubscriptionHandleType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertSubscriptionHandleType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_emi__AlertSubscriptionHandleType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_emi__AlertSubscriptionHandleType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__TimeType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__TimeType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__TimeType);
	if (soap_out_emi__TimeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__TimeType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_emi__TimeType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_emi__TimeType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__TimeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_emi__TimeType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_emi__TimeType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_cmn__InterfaceHandleType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_cmn__InterfaceHandleType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_cmn__InterfaceHandleType);
	if (soap_out_cmn__InterfaceHandleType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__InterfaceHandleType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_cmn__InterfaceHandleType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_cmn__InterfaceHandleType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__InterfaceHandleType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_cmn__InterfaceHandleType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_cmn__InterfaceHandleType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_cmn__IPv4AddressType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_cmn__IPv4AddressType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_cmn__IPv4AddressType);
	if (soap_out_cmn__IPv4AddressType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__IPv4AddressType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_cmn__IPv4AddressType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_cmn__IPv4AddressType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__IPv4AddressType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_cmn__IPv4AddressType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_cmn__IPv4AddressType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_cmn__PT_USCORESTATUS(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_cmn__PT_USCORESTATUS(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_cmn__PT_USCORESTATUS);
	if (soap_out_cmn__PT_USCORESTATUS(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__PT_USCORESTATUS(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_cmn__PT_USCORESTATUS);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_cmn__PT_USCORESTATUS(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__PT_USCORESTATUS(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_cmn__PT_USCORESTATUS(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_cmn__PT_USCORESTATUS);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	return soap_code_str(soap_codes_bool, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__UNOptionsType(struct soap *soap, enum sai__UNOptionsType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__UNOptionsType
	*a = SOAP_DEFAULT_sai__UNOptionsType;
#else
	*a = (enum sai__UNOptionsType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__UNOptionsType(struct soap *soap, const enum sai__UNOptionsType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__UNOptionsType);
	if (soap_out_sai__UNOptionsType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__UNOptionsType[] =
{	{ (long)sai__UNOptionsType__NoAuth, "NoAuth" },
	{ (long)sai__UNOptionsType__Auth, "Auth" },
	{ (long)sai__UNOptionsType__Disable, "Disable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__UNOptionsType2s(struct soap *soap, enum sai__UNOptionsType n)
{	const char *s = soap_code_str(soap_codes_sai__UNOptionsType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UNOptionsType(struct soap *soap, const char *tag, int id, const enum sai__UNOptionsType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UNOptionsType), type);
	soap_send(soap, soap_sai__UNOptionsType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__UNOptionsType * SOAP_FMAC4 soap_get_sai__UNOptionsType(struct soap *soap, enum sai__UNOptionsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UNOptionsType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__UNOptionsType(struct soap *soap, const char *s, enum sai__UNOptionsType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__UNOptionsType, s);
	if (map)
		*a = (enum sai__UNOptionsType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__UNOptionsType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__UNOptionsType * SOAP_FMAC4 soap_in_sai__UNOptionsType(struct soap *soap, const char *tag, enum sai__UNOptionsType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__UNOptionsType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UNOptionsType, sizeof(enum sai__UNOptionsType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__UNOptionsType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__UNOptionsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UNOptionsType, 0, sizeof(enum sai__UNOptionsType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__HashTypeType(struct soap *soap, enum sai__HashTypeType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__HashTypeType
	*a = SOAP_DEFAULT_sai__HashTypeType;
#else
	*a = (enum sai__HashTypeType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__HashTypeType(struct soap *soap, const enum sai__HashTypeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__HashTypeType);
	if (soap_out_sai__HashTypeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__HashTypeType[] =
{	{ (long)sai__HashTypeType__1, "1" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__HashTypeType2s(struct soap *soap, enum sai__HashTypeType n)
{	const char *s = soap_code_str(soap_codes_sai__HashTypeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__HashTypeType(struct soap *soap, const char *tag, int id, const enum sai__HashTypeType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__HashTypeType), type);
	soap_send(soap, soap_sai__HashTypeType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__HashTypeType * SOAP_FMAC4 soap_get_sai__HashTypeType(struct soap *soap, enum sai__HashTypeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__HashTypeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__HashTypeType(struct soap *soap, const char *s, enum sai__HashTypeType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__HashTypeType, s);
	if (map)
		*a = (enum sai__HashTypeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__HashTypeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__HashTypeType * SOAP_FMAC4 soap_in_sai__HashTypeType(struct soap *soap, const char *tag, enum sai__HashTypeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__HashTypeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__HashTypeType, sizeof(enum sai__HashTypeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__HashTypeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__HashTypeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__HashTypeType, 0, sizeof(enum sai__HashTypeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__ProvisioningTLSModeType(struct soap *soap, enum sai__ProvisioningTLSModeType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__ProvisioningTLSModeType
	*a = SOAP_DEFAULT_sai__ProvisioningTLSModeType;
#else
	*a = (enum sai__ProvisioningTLSModeType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__ProvisioningTLSModeType(struct soap *soap, const enum sai__ProvisioningTLSModeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__ProvisioningTLSModeType);
	if (soap_out_sai__ProvisioningTLSModeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__ProvisioningTLSModeType[] =
{	{ (long)sai__ProvisioningTLSModeType__0, "0" },
	{ (long)sai__ProvisioningTLSModeType__1, "1" },
	{ (long)sai__ProvisioningTLSModeType__2, "2" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__ProvisioningTLSModeType2s(struct soap *soap, enum sai__ProvisioningTLSModeType n)
{	const char *s = soap_code_str(soap_codes_sai__ProvisioningTLSModeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__ProvisioningTLSModeType(struct soap *soap, const char *tag, int id, const enum sai__ProvisioningTLSModeType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__ProvisioningTLSModeType), type);
	soap_send(soap, soap_sai__ProvisioningTLSModeType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__ProvisioningTLSModeType * SOAP_FMAC4 soap_get_sai__ProvisioningTLSModeType(struct soap *soap, enum sai__ProvisioningTLSModeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__ProvisioningTLSModeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__ProvisioningTLSModeType(struct soap *soap, const char *s, enum sai__ProvisioningTLSModeType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__ProvisioningTLSModeType, s);
	if (map)
		*a = (enum sai__ProvisioningTLSModeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__ProvisioningTLSModeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__ProvisioningTLSModeType * SOAP_FMAC4 soap_in_sai__ProvisioningTLSModeType(struct soap *soap, const char *tag, enum sai__ProvisioningTLSModeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__ProvisioningTLSModeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__ProvisioningTLSModeType, sizeof(enum sai__ProvisioningTLSModeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__ProvisioningTLSModeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__ProvisioningTLSModeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__ProvisioningTLSModeType, 0, sizeof(enum sai__ProvisioningTLSModeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__TlsAthenticationType(struct soap *soap, enum sai__TlsAthenticationType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__TlsAthenticationType
	*a = SOAP_DEFAULT_sai__TlsAthenticationType;
#else
	*a = (enum sai__TlsAthenticationType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__TlsAthenticationType(struct soap *soap, const enum sai__TlsAthenticationType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__TlsAthenticationType);
	if (soap_out_sai__TlsAthenticationType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__TlsAthenticationType[] =
{	{ (long)sai__TlsAthenticationType__NoAuth, "NoAuth" },
	{ (long)sai__TlsAthenticationType__ServerAuth, "ServerAuth" },
	{ (long)sai__TlsAthenticationType__MutualAuth, "MutualAuth" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__TlsAthenticationType2s(struct soap *soap, enum sai__TlsAthenticationType n)
{	const char *s = soap_code_str(soap_codes_sai__TlsAthenticationType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__TlsAthenticationType(struct soap *soap, const char *tag, int id, const enum sai__TlsAthenticationType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__TlsAthenticationType), type);
	soap_send(soap, soap_sai__TlsAthenticationType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__TlsAthenticationType * SOAP_FMAC4 soap_get_sai__TlsAthenticationType(struct soap *soap, enum sai__TlsAthenticationType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__TlsAthenticationType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__TlsAthenticationType(struct soap *soap, const char *s, enum sai__TlsAthenticationType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__TlsAthenticationType, s);
	if (map)
		*a = (enum sai__TlsAthenticationType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__TlsAthenticationType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__TlsAthenticationType * SOAP_FMAC4 soap_in_sai__TlsAthenticationType(struct soap *soap, const char *tag, enum sai__TlsAthenticationType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__TlsAthenticationType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__TlsAthenticationType, sizeof(enum sai__TlsAthenticationType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__TlsAthenticationType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__TlsAthenticationType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__TlsAthenticationType, 0, sizeof(enum sai__TlsAthenticationType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__InterfaceType(struct soap *soap, enum sai__InterfaceType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__InterfaceType
	*a = SOAP_DEFAULT_sai__InterfaceType;
#else
	*a = (enum sai__InterfaceType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__InterfaceType(struct soap *soap, const enum sai__InterfaceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__InterfaceType);
	if (soap_out_sai__InterfaceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__InterfaceType[] =
{	{ (long)sai__InterfaceType__NetworkInterface, "NetworkInterface" },
	{ (long)sai__InterfaceType__LocalHostInterface, "LocalHostInterface" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__InterfaceType2s(struct soap *soap, enum sai__InterfaceType n)
{	const char *s = soap_code_str(soap_codes_sai__InterfaceType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__InterfaceType(struct soap *soap, const char *tag, int id, const enum sai__InterfaceType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__InterfaceType), type);
	soap_send(soap, soap_sai__InterfaceType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__InterfaceType * SOAP_FMAC4 soap_get_sai__InterfaceType(struct soap *soap, enum sai__InterfaceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__InterfaceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__InterfaceType(struct soap *soap, const char *s, enum sai__InterfaceType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__InterfaceType, s);
	if (map)
		*a = (enum sai__InterfaceType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__InterfaceType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__InterfaceType * SOAP_FMAC4 soap_in_sai__InterfaceType(struct soap *soap, const char *tag, enum sai__InterfaceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__InterfaceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__InterfaceType, sizeof(enum sai__InterfaceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__InterfaceType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__InterfaceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__InterfaceType, 0, sizeof(enum sai__InterfaceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__EnabledInterfacesType(struct soap *soap, enum sai__EnabledInterfacesType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__EnabledInterfacesType
	*a = SOAP_DEFAULT_sai__EnabledInterfacesType;
#else
	*a = (enum sai__EnabledInterfacesType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__EnabledInterfacesType(struct soap *soap, const enum sai__EnabledInterfacesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__EnabledInterfacesType);
	if (soap_out_sai__EnabledInterfacesType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__EnabledInterfacesType[] =
{	{ (long)sai__EnabledInterfacesType__WebUI, "WebUI" },
	{ (long)sai__EnabledInterfacesType__SerialOverLAN, "SerialOverLAN" },
	{ (long)sai__EnabledInterfacesType__IdeRedirection, "IdeRedirection" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__EnabledInterfacesType2s(struct soap *soap, enum sai__EnabledInterfacesType n)
{	const char *s = soap_code_str(soap_codes_sai__EnabledInterfacesType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__EnabledInterfacesType(struct soap *soap, const char *tag, int id, const enum sai__EnabledInterfacesType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__EnabledInterfacesType), type);
	soap_send(soap, soap_sai__EnabledInterfacesType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__EnabledInterfacesType * SOAP_FMAC4 soap_get_sai__EnabledInterfacesType(struct soap *soap, enum sai__EnabledInterfacesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__EnabledInterfacesType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__EnabledInterfacesType(struct soap *soap, const char *s, enum sai__EnabledInterfacesType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__EnabledInterfacesType, s);
	if (map)
		*a = (enum sai__EnabledInterfacesType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__EnabledInterfacesType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__EnabledInterfacesType * SOAP_FMAC4 soap_in_sai__EnabledInterfacesType(struct soap *soap, const char *tag, enum sai__EnabledInterfacesType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__EnabledInterfacesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__EnabledInterfacesType, sizeof(enum sai__EnabledInterfacesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__EnabledInterfacesType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__EnabledInterfacesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__EnabledInterfacesType, 0, sizeof(enum sai__EnabledInterfacesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__PowerStateType(struct soap *soap, enum sai__PowerStateType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__PowerStateType
	*a = SOAP_DEFAULT_sai__PowerStateType;
#else
	*a = (enum sai__PowerStateType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__PowerStateType(struct soap *soap, const enum sai__PowerStateType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__PowerStateType);
	if (soap_out_sai__PowerStateType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__PowerStateType[] =
{	{ (long)sai__PowerStateType__PowerStateS0, "PowerStateS0" },
	{ (long)sai__PowerStateType__PowerStateS1, "PowerStateS1" },
	{ (long)sai__PowerStateType__PowerStateS2, "PowerStateS2" },
	{ (long)sai__PowerStateType__PowerStateS3, "PowerStateS3" },
	{ (long)sai__PowerStateType__PowerStateS4, "PowerStateS4" },
	{ (long)sai__PowerStateType__PowerStateS5, "PowerStateS5" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__PowerStateType2s(struct soap *soap, enum sai__PowerStateType n)
{	const char *s = soap_code_str(soap_codes_sai__PowerStateType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__PowerStateType(struct soap *soap, const char *tag, int id, const enum sai__PowerStateType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__PowerStateType), type);
	soap_send(soap, soap_sai__PowerStateType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__PowerStateType * SOAP_FMAC4 soap_get_sai__PowerStateType(struct soap *soap, enum sai__PowerStateType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__PowerStateType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__PowerStateType(struct soap *soap, const char *s, enum sai__PowerStateType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__PowerStateType, s);
	if (map)
		*a = (enum sai__PowerStateType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 5)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__PowerStateType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__PowerStateType * SOAP_FMAC4 soap_in_sai__PowerStateType(struct soap *soap, const char *tag, enum sai__PowerStateType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__PowerStateType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__PowerStateType, sizeof(enum sai__PowerStateType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__PowerStateType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__PowerStateType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__PowerStateType, 0, sizeof(enum sai__PowerStateType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__KerberosEncryptionType(struct soap *soap, enum sai__KerberosEncryptionType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__KerberosEncryptionType
	*a = SOAP_DEFAULT_sai__KerberosEncryptionType;
#else
	*a = (enum sai__KerberosEncryptionType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__KerberosEncryptionType(struct soap *soap, const enum sai__KerberosEncryptionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__KerberosEncryptionType);
	if (soap_out_sai__KerberosEncryptionType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__KerberosEncryptionType[] =
{	{ (long)sai__KerberosEncryptionType__HMAC_USCORERC4, "HMAC_RC4" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__KerberosEncryptionType2s(struct soap *soap, enum sai__KerberosEncryptionType n)
{	const char *s = soap_code_str(soap_codes_sai__KerberosEncryptionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__KerberosEncryptionType(struct soap *soap, const char *tag, int id, const enum sai__KerberosEncryptionType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__KerberosEncryptionType), type);
	soap_send(soap, soap_sai__KerberosEncryptionType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__KerberosEncryptionType * SOAP_FMAC4 soap_get_sai__KerberosEncryptionType(struct soap *soap, enum sai__KerberosEncryptionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__KerberosEncryptionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__KerberosEncryptionType(struct soap *soap, const char *s, enum sai__KerberosEncryptionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__KerberosEncryptionType, s);
	if (map)
		*a = (enum sai__KerberosEncryptionType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__KerberosEncryptionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__KerberosEncryptionType * SOAP_FMAC4 soap_in_sai__KerberosEncryptionType(struct soap *soap, const char *tag, enum sai__KerberosEncryptionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__KerberosEncryptionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__KerberosEncryptionType, sizeof(enum sai__KerberosEncryptionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__KerberosEncryptionType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__KerberosEncryptionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__KerberosEncryptionType, 0, sizeof(enum sai__KerberosEncryptionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__KerberosSpnProtocolType(struct soap *soap, enum sai__KerberosSpnProtocolType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__KerberosSpnProtocolType
	*a = SOAP_DEFAULT_sai__KerberosSpnProtocolType;
#else
	*a = (enum sai__KerberosSpnProtocolType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__KerberosSpnProtocolType(struct soap *soap, const enum sai__KerberosSpnProtocolType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__KerberosSpnProtocolType);
	if (soap_out_sai__KerberosSpnProtocolType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__KerberosSpnProtocolType[] =
{	{ (long)sai__KerberosSpnProtocolType__HTTP, "HTTP" },
	{ (long)sai__KerberosSpnProtocolType__HTTPS, "HTTPS" },
	{ (long)sai__KerberosSpnProtocolType__SOL_USCOREIDER, "SOL_IDER" },
	{ (long)sai__KerberosSpnProtocolType__SOL_USCOREIDER_USCORESSL, "SOL_IDER_SSL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__KerberosSpnProtocolType2s(struct soap *soap, enum sai__KerberosSpnProtocolType n)
{	const char *s = soap_code_str(soap_codes_sai__KerberosSpnProtocolType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__KerberosSpnProtocolType(struct soap *soap, const char *tag, int id, const enum sai__KerberosSpnProtocolType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__KerberosSpnProtocolType), type);
	soap_send(soap, soap_sai__KerberosSpnProtocolType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__KerberosSpnProtocolType * SOAP_FMAC4 soap_get_sai__KerberosSpnProtocolType(struct soap *soap, enum sai__KerberosSpnProtocolType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__KerberosSpnProtocolType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__KerberosSpnProtocolType(struct soap *soap, const char *s, enum sai__KerberosSpnProtocolType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__KerberosSpnProtocolType, s);
	if (map)
		*a = (enum sai__KerberosSpnProtocolType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__KerberosSpnProtocolType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__KerberosSpnProtocolType * SOAP_FMAC4 soap_in_sai__KerberosSpnProtocolType(struct soap *soap, const char *tag, enum sai__KerberosSpnProtocolType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__KerberosSpnProtocolType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__KerberosSpnProtocolType, sizeof(enum sai__KerberosSpnProtocolType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__KerberosSpnProtocolType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__KerberosSpnProtocolType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__KerberosSpnProtocolType, 0, sizeof(enum sai__KerberosSpnProtocolType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__AccessPermissionType(struct soap *soap, enum sai__AccessPermissionType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__AccessPermissionType
	*a = SOAP_DEFAULT_sai__AccessPermissionType;
#else
	*a = (enum sai__AccessPermissionType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__AccessPermissionType(struct soap *soap, const enum sai__AccessPermissionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__AccessPermissionType);
	if (soap_out_sai__AccessPermissionType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__AccessPermissionType[] =
{	{ (long)sai__AccessPermissionType__LocalAccessPermission, "LocalAccessPermission" },
	{ (long)sai__AccessPermissionType__NetworkAccessPermission, "NetworkAccessPermission" },
	{ (long)sai__AccessPermissionType__AnyAccessPermission, "AnyAccessPermission" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__AccessPermissionType2s(struct soap *soap, enum sai__AccessPermissionType n)
{	const char *s = soap_code_str(soap_codes_sai__AccessPermissionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__AccessPermissionType(struct soap *soap, const char *tag, int id, const enum sai__AccessPermissionType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__AccessPermissionType), type);
	soap_send(soap, soap_sai__AccessPermissionType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__AccessPermissionType * SOAP_FMAC4 soap_get_sai__AccessPermissionType(struct soap *soap, enum sai__AccessPermissionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__AccessPermissionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__AccessPermissionType(struct soap *soap, const char *s, enum sai__AccessPermissionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__AccessPermissionType, s);
	if (map)
		*a = (enum sai__AccessPermissionType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__AccessPermissionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__AccessPermissionType * SOAP_FMAC4 soap_in_sai__AccessPermissionType(struct soap *soap, const char *tag, enum sai__AccessPermissionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__AccessPermissionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__AccessPermissionType, sizeof(enum sai__AccessPermissionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__AccessPermissionType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__AccessPermissionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__AccessPermissionType, 0, sizeof(enum sai__AccessPermissionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__ProvisioningModeType(struct soap *soap, enum sai__ProvisioningModeType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__ProvisioningModeType
	*a = SOAP_DEFAULT_sai__ProvisioningModeType;
#else
	*a = (enum sai__ProvisioningModeType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__ProvisioningModeType(struct soap *soap, const enum sai__ProvisioningModeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__ProvisioningModeType);
	if (soap_out_sai__ProvisioningModeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__ProvisioningModeType[] =
{	{ (long)sai__ProvisioningModeType__0, "0" },
	{ (long)sai__ProvisioningModeType__1, "1" },
	{ (long)sai__ProvisioningModeType__2, "2" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__ProvisioningModeType2s(struct soap *soap, enum sai__ProvisioningModeType n)
{	const char *s = soap_code_str(soap_codes_sai__ProvisioningModeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__ProvisioningModeType(struct soap *soap, const char *tag, int id, const enum sai__ProvisioningModeType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__ProvisioningModeType), type);
	soap_send(soap, soap_sai__ProvisioningModeType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__ProvisioningModeType * SOAP_FMAC4 soap_get_sai__ProvisioningModeType(struct soap *soap, enum sai__ProvisioningModeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__ProvisioningModeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__ProvisioningModeType(struct soap *soap, const char *s, enum sai__ProvisioningModeType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__ProvisioningModeType, s);
	if (map)
		*a = (enum sai__ProvisioningModeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__ProvisioningModeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__ProvisioningModeType * SOAP_FMAC4 soap_in_sai__ProvisioningModeType(struct soap *soap, const char *tag, enum sai__ProvisioningModeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__ProvisioningModeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__ProvisioningModeType, sizeof(enum sai__ProvisioningModeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__ProvisioningModeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__ProvisioningModeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__ProvisioningModeType, 0, sizeof(enum sai__ProvisioningModeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__RngKeyEncodingType(struct soap *soap, enum sai__RngKeyEncodingType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__RngKeyEncodingType
	*a = SOAP_DEFAULT_sai__RngKeyEncodingType;
#else
	*a = (enum sai__RngKeyEncodingType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__RngKeyEncodingType(struct soap *soap, const enum sai__RngKeyEncodingType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__RngKeyEncodingType);
	if (soap_out_sai__RngKeyEncodingType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__RngKeyEncodingType[] =
{	{ (long)sai__RngKeyEncodingType__20, "20" },
	{ (long)sai__RngKeyEncodingType__21, "21" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__RngKeyEncodingType2s(struct soap *soap, enum sai__RngKeyEncodingType n)
{	const char *s = soap_code_str(soap_codes_sai__RngKeyEncodingType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__RngKeyEncodingType(struct soap *soap, const char *tag, int id, const enum sai__RngKeyEncodingType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__RngKeyEncodingType), type);
	soap_send(soap, soap_sai__RngKeyEncodingType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__RngKeyEncodingType * SOAP_FMAC4 soap_get_sai__RngKeyEncodingType(struct soap *soap, enum sai__RngKeyEncodingType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__RngKeyEncodingType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__RngKeyEncodingType(struct soap *soap, const char *s, enum sai__RngKeyEncodingType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__RngKeyEncodingType, s);
	if (map)
		*a = (enum sai__RngKeyEncodingType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 21)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__RngKeyEncodingType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__RngKeyEncodingType * SOAP_FMAC4 soap_in_sai__RngKeyEncodingType(struct soap *soap, const char *tag, enum sai__RngKeyEncodingType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__RngKeyEncodingType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__RngKeyEncodingType, sizeof(enum sai__RngKeyEncodingType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__RngKeyEncodingType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__RngKeyEncodingType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__RngKeyEncodingType, 0, sizeof(enum sai__RngKeyEncodingType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__RsaCertificateEncodingType(struct soap *soap, enum sai__RsaCertificateEncodingType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__RsaCertificateEncodingType
	*a = SOAP_DEFAULT_sai__RsaCertificateEncodingType;
#else
	*a = (enum sai__RsaCertificateEncodingType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__RsaCertificateEncodingType(struct soap *soap, const enum sai__RsaCertificateEncodingType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__RsaCertificateEncodingType);
	if (soap_out_sai__RsaCertificateEncodingType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__RsaCertificateEncodingType[] =
{	{ (long)sai__RsaCertificateEncodingType__10, "10" },
	{ (long)sai__RsaCertificateEncodingType__11, "11" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__RsaCertificateEncodingType2s(struct soap *soap, enum sai__RsaCertificateEncodingType n)
{	const char *s = soap_code_str(soap_codes_sai__RsaCertificateEncodingType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__RsaCertificateEncodingType(struct soap *soap, const char *tag, int id, const enum sai__RsaCertificateEncodingType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__RsaCertificateEncodingType), type);
	soap_send(soap, soap_sai__RsaCertificateEncodingType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__RsaCertificateEncodingType * SOAP_FMAC4 soap_get_sai__RsaCertificateEncodingType(struct soap *soap, enum sai__RsaCertificateEncodingType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__RsaCertificateEncodingType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__RsaCertificateEncodingType(struct soap *soap, const char *s, enum sai__RsaCertificateEncodingType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__RsaCertificateEncodingType, s);
	if (map)
		*a = (enum sai__RsaCertificateEncodingType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 11)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__RsaCertificateEncodingType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__RsaCertificateEncodingType * SOAP_FMAC4 soap_in_sai__RsaCertificateEncodingType(struct soap *soap, const char *tag, enum sai__RsaCertificateEncodingType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__RsaCertificateEncodingType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__RsaCertificateEncodingType, sizeof(enum sai__RsaCertificateEncodingType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__RsaCertificateEncodingType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__RsaCertificateEncodingType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__RsaCertificateEncodingType, 0, sizeof(enum sai__RsaCertificateEncodingType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__RsaKeyEncodingType(struct soap *soap, enum sai__RsaKeyEncodingType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__RsaKeyEncodingType
	*a = SOAP_DEFAULT_sai__RsaKeyEncodingType;
#else
	*a = (enum sai__RsaKeyEncodingType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__RsaKeyEncodingType(struct soap *soap, const enum sai__RsaKeyEncodingType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__RsaKeyEncodingType);
	if (soap_out_sai__RsaKeyEncodingType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__RsaKeyEncodingType[] =
{	{ (long)sai__RsaKeyEncodingType__30, "30" },
	{ (long)sai__RsaKeyEncodingType__31, "31" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__RsaKeyEncodingType2s(struct soap *soap, enum sai__RsaKeyEncodingType n)
{	const char *s = soap_code_str(soap_codes_sai__RsaKeyEncodingType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__RsaKeyEncodingType(struct soap *soap, const char *tag, int id, const enum sai__RsaKeyEncodingType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__RsaKeyEncodingType), type);
	soap_send(soap, soap_sai__RsaKeyEncodingType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__RsaKeyEncodingType * SOAP_FMAC4 soap_get_sai__RsaKeyEncodingType(struct soap *soap, enum sai__RsaKeyEncodingType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__RsaKeyEncodingType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__RsaKeyEncodingType(struct soap *soap, const char *s, enum sai__RsaKeyEncodingType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__RsaKeyEncodingType, s);
	if (map)
		*a = (enum sai__RsaKeyEncodingType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 31)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__RsaKeyEncodingType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__RsaKeyEncodingType * SOAP_FMAC4 soap_in_sai__RsaKeyEncodingType(struct soap *soap, const char *tag, enum sai__RsaKeyEncodingType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__RsaKeyEncodingType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__RsaKeyEncodingType, sizeof(enum sai__RsaKeyEncodingType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__RsaKeyEncodingType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__RsaKeyEncodingType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__RsaKeyEncodingType, 0, sizeof(enum sai__RsaKeyEncodingType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__UserAclRealmType(struct soap *soap, enum sai__UserAclRealmType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sai__UserAclRealmType
	*a = SOAP_DEFAULT_sai__UserAclRealmType;
#else
	*a = (enum sai__UserAclRealmType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__UserAclRealmType(struct soap *soap, const enum sai__UserAclRealmType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__UserAclRealmType);
	if (soap_out_sai__UserAclRealmType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_sai__UserAclRealmType[] =
{	{ (long)sai__UserAclRealmType__0, "0" },
	{ (long)sai__UserAclRealmType__1, "1" },
	{ (long)sai__UserAclRealmType__2, "2" },
	{ (long)sai__UserAclRealmType__3, "3" },
	{ (long)sai__UserAclRealmType__4, "4" },
	{ (long)sai__UserAclRealmType__5, "5" },
	{ (long)sai__UserAclRealmType__6, "6" },
	{ (long)sai__UserAclRealmType__7, "7" },
	{ (long)sai__UserAclRealmType__8, "8" },
	{ (long)sai__UserAclRealmType__9, "9" },
	{ (long)sai__UserAclRealmType__10, "10" },
	{ (long)sai__UserAclRealmType__11, "11" },
	{ (long)sai__UserAclRealmType__12, "12" },
	{ (long)sai__UserAclRealmType__13, "13" },
	{ (long)sai__UserAclRealmType__14, "14" },
	{ (long)sai__UserAclRealmType__16, "16" },
	{ (long)sai__UserAclRealmType__17, "17" },
	{ (long)sai__UserAclRealmType__18, "18" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sai__UserAclRealmType2s(struct soap *soap, enum sai__UserAclRealmType n)
{	const char *s = soap_code_str(soap_codes_sai__UserAclRealmType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UserAclRealmType(struct soap *soap, const char *tag, int id, const enum sai__UserAclRealmType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UserAclRealmType), type);
	soap_send(soap, soap_sai__UserAclRealmType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum sai__UserAclRealmType * SOAP_FMAC4 soap_get_sai__UserAclRealmType(struct soap *soap, enum sai__UserAclRealmType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UserAclRealmType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sai__UserAclRealmType(struct soap *soap, const char *s, enum sai__UserAclRealmType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_sai__UserAclRealmType, s);
	if (map)
		*a = (enum sai__UserAclRealmType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 18)))
			return soap->error = SOAP_TYPE;
		*a = (enum sai__UserAclRealmType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sai__UserAclRealmType * SOAP_FMAC4 soap_in_sai__UserAclRealmType(struct soap *soap, const char *tag, enum sai__UserAclRealmType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sai__UserAclRealmType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UserAclRealmType, sizeof(enum sai__UserAclRealmType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sai__UserAclRealmType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sai__UserAclRealmType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UserAclRealmType, 0, sizeof(enum sai__UserAclRealmType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__AlertAuthOptionsType(struct soap *soap, enum emi__AlertAuthOptionsType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_emi__AlertAuthOptionsType
	*a = SOAP_DEFAULT_emi__AlertAuthOptionsType;
#else
	*a = (enum emi__AlertAuthOptionsType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__AlertAuthOptionsType(struct soap *soap, const enum emi__AlertAuthOptionsType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__AlertAuthOptionsType);
	if (soap_out_emi__AlertAuthOptionsType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_emi__AlertAuthOptionsType[] =
{	{ (long)emi__AlertAuthOptionsType__Kerberos, "Kerberos" },
	{ (long)emi__AlertAuthOptionsType__Digest, "Digest" },
	{ (long)emi__AlertAuthOptionsType__Basic, "Basic" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_emi__AlertAuthOptionsType2s(struct soap *soap, enum emi__AlertAuthOptionsType n)
{	const char *s = soap_code_str(soap_codes_emi__AlertAuthOptionsType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertAuthOptionsType(struct soap *soap, const char *tag, int id, const enum emi__AlertAuthOptionsType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__AlertAuthOptionsType), type);
	soap_send(soap, soap_emi__AlertAuthOptionsType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum emi__AlertAuthOptionsType * SOAP_FMAC4 soap_get_emi__AlertAuthOptionsType(struct soap *soap, enum emi__AlertAuthOptionsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertAuthOptionsType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2emi__AlertAuthOptionsType(struct soap *soap, const char *s, enum emi__AlertAuthOptionsType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_emi__AlertAuthOptionsType, s);
	if (map)
		*a = (enum emi__AlertAuthOptionsType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum emi__AlertAuthOptionsType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum emi__AlertAuthOptionsType * SOAP_FMAC4 soap_in_emi__AlertAuthOptionsType(struct soap *soap, const char *tag, enum emi__AlertAuthOptionsType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum emi__AlertAuthOptionsType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_emi__AlertAuthOptionsType, sizeof(enum emi__AlertAuthOptionsType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2emi__AlertAuthOptionsType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum emi__AlertAuthOptionsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__AlertAuthOptionsType, 0, sizeof(enum emi__AlertAuthOptionsType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__EventSeverityType(struct soap *soap, enum emi__EventSeverityType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_emi__EventSeverityType
	*a = SOAP_DEFAULT_emi__EventSeverityType;
#else
	*a = (enum emi__EventSeverityType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__EventSeverityType(struct soap *soap, const enum emi__EventSeverityType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__EventSeverityType);
	if (soap_out_emi__EventSeverityType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_emi__EventSeverityType[] =
{	{ (long)emi__EventSeverityType__0, "0" },
	{ (long)emi__EventSeverityType__1, "1" },
	{ (long)emi__EventSeverityType__2, "2" },
	{ (long)emi__EventSeverityType__4, "4" },
	{ (long)emi__EventSeverityType__8, "8" },
	{ (long)emi__EventSeverityType__16, "16" },
	{ (long)emi__EventSeverityType__32, "32" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_emi__EventSeverityType2s(struct soap *soap, enum emi__EventSeverityType n)
{	const char *s = soap_code_str(soap_codes_emi__EventSeverityType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__EventSeverityType(struct soap *soap, const char *tag, int id, const enum emi__EventSeverityType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__EventSeverityType), type);
	soap_send(soap, soap_emi__EventSeverityType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum emi__EventSeverityType * SOAP_FMAC4 soap_get_emi__EventSeverityType(struct soap *soap, enum emi__EventSeverityType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__EventSeverityType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2emi__EventSeverityType(struct soap *soap, const char *s, enum emi__EventSeverityType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_emi__EventSeverityType, s);
	if (map)
		*a = (enum emi__EventSeverityType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 32)))
			return soap->error = SOAP_TYPE;
		*a = (enum emi__EventSeverityType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum emi__EventSeverityType * SOAP_FMAC4 soap_in_emi__EventSeverityType(struct soap *soap, const char *tag, enum emi__EventSeverityType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum emi__EventSeverityType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_emi__EventSeverityType, sizeof(enum emi__EventSeverityType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2emi__EventSeverityType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum emi__EventSeverityType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__EventSeverityType, 0, sizeof(enum emi__EventSeverityType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__sai__KerberosRealmName(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__sai__KerberosRealmName(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__sai__KerberosRealmName(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__sai__KerberosRealmName);
	if (soap_out__sai__KerberosRealmName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out__sai__KerberosRealmName(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE__sai__KerberosRealmName), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get__sai__KerberosRealmName(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in__sai__KerberosRealmName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in__sai__KerberosRealmName(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE__sai__KerberosRealmName, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 1, 63)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE__sai__KerberosRealmName, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE__sai__KerberosRealmName, 0, sizeof(std::string), 0, soap_copy__sai__KerberosRealmName);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new__sai__KerberosRealmName(struct soap *soap, int n)
{	return soap_instantiate__sai__KerberosRealmName(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__sai__KerberosRealmName(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate__sai__KerberosRealmName(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__sai__KerberosRealmName(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__sai__KerberosRealmName, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__sai__KerberosRealmName(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__sai__SpnString(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__sai__SpnString(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__sai__SpnString(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__sai__SpnString);
	if (soap_out__sai__SpnString(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out__sai__SpnString(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE__sai__SpnString), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get__sai__SpnString(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in__sai__SpnString(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in__sai__SpnString(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE__sai__SpnString, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 0, 266)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE__sai__SpnString, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE__sai__SpnString, 0, sizeof(std::string), 0, soap_copy__sai__SpnString);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new__sai__SpnString(struct soap *soap, int n)
{	return soap_instantiate__sai__SpnString(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__sai__SpnString(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate__sai__SpnString(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__sai__SpnString(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__sai__SpnString, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__sai__SpnString(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__FriendlyNameType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_sai__FriendlyNameType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__FriendlyNameType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__FriendlyNameType);
	if (soap_out_sai__FriendlyNameType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__FriendlyNameType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_sai__FriendlyNameType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_sai__FriendlyNameType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__FriendlyNameType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_sai__FriendlyNameType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_sai__FriendlyNameType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 1, 32)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_sai__FriendlyNameType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_sai__FriendlyNameType, 0, sizeof(std::string), 0, soap_copy_sai__FriendlyNameType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_sai__FriendlyNameType(struct soap *soap, int n)
{	return soap_instantiate_sai__FriendlyNameType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__FriendlyNameType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_sai__FriendlyNameType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__FriendlyNameType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__FriendlyNameType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__FriendlyNameType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__ProvisioningOTPType(struct soap *soap, xsd__base64Binary *a)
{	a->xsd__base64Binary::soap_default(soap);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_sai__ProvisioningOTPType(struct soap *soap, xsd__base64Binary const*a)
{	a->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__ProvisioningOTPType(struct soap *soap, const xsd__base64Binary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_sai__ProvisioningOTPType);
	if (soap_out_sai__ProvisioningOTPType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__ProvisioningOTPType(struct soap *soap, const char *tag, int id, const xsd__base64Binary *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE_sai__ProvisioningOTPType);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_sai__ProvisioningOTPType);
#endif
	if (id < 0)
		return soap->error;
	soap_element_begin_out(soap, tag, id, type);
	soap_putbase64(soap, a->__ptr, a->__size);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_get_sai__ProvisioningOTPType(struct soap *soap, xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__ProvisioningOTPType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_in_sai__ProvisioningOTPType(struct soap *soap, const char *tag, xsd__base64Binary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (xsd__base64Binary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__ProvisioningOTPType, sizeof(xsd__base64Binary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__ProvisioningOTPType, 0, sizeof(xsd__base64Binary), 0, soap_copy_sai__ProvisioningOTPType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 xsd__base64Binary * SOAP_FMAC6 soap_new_sai__ProvisioningOTPType(struct soap *soap, int n)
{	return soap_instantiate_sai__ProvisioningOTPType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__ProvisioningOTPType(struct soap *soap, xsd__base64Binary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_instantiate_sai__ProvisioningOTPType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__ProvisioningOTPType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__ProvisioningOTPType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new xsd__base64Binary;
		if (size)
			*size = sizeof(xsd__base64Binary);
		((xsd__base64Binary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new xsd__base64Binary[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xsd__base64Binary);
		for (int i = 0; i < n; i++)
			((xsd__base64Binary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xsd__base64Binary*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__ProvisioningOTPType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__base64Binary %p -> %p\n", q, p));
	*(xsd__base64Binary*)p = *(xsd__base64Binary*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__MEBxPasswordType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_sai__MEBxPasswordType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__MEBxPasswordType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__MEBxPasswordType);
	if (soap_out_sai__MEBxPasswordType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__MEBxPasswordType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_sai__MEBxPasswordType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_sai__MEBxPasswordType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__MEBxPasswordType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_sai__MEBxPasswordType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_sai__MEBxPasswordType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 0, 32)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_sai__MEBxPasswordType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_sai__MEBxPasswordType, 0, sizeof(std::string), 0, soap_copy_sai__MEBxPasswordType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_sai__MEBxPasswordType(struct soap *soap, int n)
{	return soap_instantiate_sai__MEBxPasswordType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__MEBxPasswordType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_sai__MEBxPasswordType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__MEBxPasswordType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__MEBxPasswordType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__MEBxPasswordType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__AclPasswordStringType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_sai__AclPasswordStringType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__AclPasswordStringType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__AclPasswordStringType);
	if (soap_out_sai__AclPasswordStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__AclPasswordStringType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_sai__AclPasswordStringType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_sai__AclPasswordStringType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__AclPasswordStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_sai__AclPasswordStringType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_sai__AclPasswordStringType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, 32)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_sai__AclPasswordStringType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_sai__AclPasswordStringType, 0, sizeof(std::string), 0, soap_copy_sai__AclPasswordStringType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_sai__AclPasswordStringType(struct soap *soap, int n)
{	return soap_instantiate_sai__AclPasswordStringType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__AclPasswordStringType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_sai__AclPasswordStringType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__AclPasswordStringType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__AclPasswordStringType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__AclPasswordStringType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sai__AclStringType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_sai__AclStringType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sai__AclStringType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sai__AclStringType);
	if (soap_out_sai__AclStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__AclStringType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_sai__AclStringType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_sai__AclStringType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__AclStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_sai__AclStringType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_sai__AclStringType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, 16)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_sai__AclStringType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_sai__AclStringType, 0, sizeof(std::string), 0, soap_copy_sai__AclStringType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_sai__AclStringType(struct soap *soap, int n)
{	return soap_instantiate_sai__AclStringType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__AclStringType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_sai__AclStringType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__AclStringType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__AclStringType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__AclStringType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_emi__CommunityStringType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_emi__CommunityStringType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_emi__CommunityStringType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_emi__CommunityStringType);
	if (soap_out_emi__CommunityStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__CommunityStringType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_emi__CommunityStringType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_emi__CommunityStringType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__CommunityStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_emi__CommunityStringType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_emi__CommunityStringType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 1, 16)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_emi__CommunityStringType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_emi__CommunityStringType, 0, sizeof(std::string), 0, soap_copy_emi__CommunityStringType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_emi__CommunityStringType(struct soap *soap, int n)
{	return soap_instantiate_emi__CommunityStringType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__CommunityStringType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_emi__CommunityStringType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__CommunityStringType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__CommunityStringType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__CommunityStringType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_cmn__GuidBuf(struct soap *soap, xsd__base64Binary *a)
{	a->xsd__base64Binary::soap_default(soap);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_cmn__GuidBuf(struct soap *soap, xsd__base64Binary const*a)
{	a->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_cmn__GuidBuf(struct soap *soap, const xsd__base64Binary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_cmn__GuidBuf);
	if (soap_out_cmn__GuidBuf(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__GuidBuf(struct soap *soap, const char *tag, int id, const xsd__base64Binary *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE_cmn__GuidBuf);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_cmn__GuidBuf);
#endif
	if (id < 0)
		return soap->error;
	soap_element_begin_out(soap, tag, id, type);
	soap_putbase64(soap, a->__ptr, a->__size);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_get_cmn__GuidBuf(struct soap *soap, xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__GuidBuf(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_in_cmn__GuidBuf(struct soap *soap, const char *tag, xsd__base64Binary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (xsd__base64Binary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_cmn__GuidBuf, sizeof(xsd__base64Binary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_cmn__GuidBuf, 0, sizeof(xsd__base64Binary), 0, soap_copy_cmn__GuidBuf);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 xsd__base64Binary * SOAP_FMAC6 soap_new_cmn__GuidBuf(struct soap *soap, int n)
{	return soap_instantiate_cmn__GuidBuf(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_cmn__GuidBuf(struct soap *soap, xsd__base64Binary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_instantiate_cmn__GuidBuf(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_cmn__GuidBuf(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_cmn__GuidBuf, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new xsd__base64Binary;
		if (size)
			*size = sizeof(xsd__base64Binary);
		((xsd__base64Binary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new xsd__base64Binary[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xsd__base64Binary);
		for (int i = 0; i < n; i++)
			((xsd__base64Binary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xsd__base64Binary*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_cmn__GuidBuf(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__base64Binary %p -> %p\n", q, p));
	*(xsd__base64Binary*)p = *(xsd__base64Binary*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_cmn__IPv6AddressStringType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_cmn__IPv6AddressStringType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_cmn__IPv6AddressStringType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_cmn__IPv6AddressStringType);
	if (soap_out_cmn__IPv6AddressStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__IPv6AddressStringType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_cmn__IPv6AddressStringType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_cmn__IPv6AddressStringType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__IPv6AddressStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_cmn__IPv6AddressStringType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_cmn__IPv6AddressStringType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_cmn__IPv6AddressStringType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_cmn__IPv6AddressStringType, 0, sizeof(std::string), 0, soap_copy_cmn__IPv6AddressStringType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_cmn__IPv6AddressStringType(struct soap *soap, int n)
{	return soap_instantiate_cmn__IPv6AddressStringType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_cmn__IPv6AddressStringType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_cmn__IPv6AddressStringType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_cmn__IPv6AddressStringType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_cmn__IPv6AddressStringType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_cmn__IPv6AddressStringType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_cmn__IPv4AddressStringType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_cmn__IPv4AddressStringType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_cmn__IPv4AddressStringType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_cmn__IPv4AddressStringType);
	if (soap_out_cmn__IPv4AddressStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__IPv4AddressStringType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_cmn__IPv4AddressStringType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_cmn__IPv4AddressStringType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__IPv4AddressStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_cmn__IPv4AddressStringType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_cmn__IPv4AddressStringType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_cmn__IPv4AddressStringType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_cmn__IPv4AddressStringType, 0, sizeof(std::string), 0, soap_copy_cmn__IPv4AddressStringType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_cmn__IPv4AddressStringType(struct soap *soap, int n)
{	return soap_instantiate_cmn__IPv4AddressStringType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_cmn__IPv4AddressStringType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_cmn__IPv4AddressStringType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_cmn__IPv4AddressStringType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_cmn__IPv4AddressStringType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_cmn__IPv4AddressStringType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_cmn__HostNameType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_cmn__HostNameType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_cmn__HostNameType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_cmn__HostNameType);
	if (soap_out_cmn__HostNameType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__HostNameType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_cmn__HostNameType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_cmn__HostNameType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__HostNameType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_cmn__HostNameType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_cmn__HostNameType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 0, 64)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_cmn__HostNameType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_cmn__HostNameType, 0, sizeof(std::string), 0, soap_copy_cmn__HostNameType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_cmn__HostNameType(struct soap *soap, int n)
{	return soap_instantiate_cmn__HostNameType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_cmn__HostNameType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_cmn__HostNameType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_cmn__HostNameType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_cmn__HostNameType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_cmn__HostNameType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void sai__GlobalPowerPolicyType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_unsignedInt(soap, &this->sai__GlobalPowerPolicyType::IdleWakeTimeout);
	/* transient soap skipped */
}

void sai__GlobalPowerPolicyType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__GlobalPowerPolicyType::IdleWakeTimeout, SOAP_TYPE_unsignedInt);
	/* transient soap skipped */
}

int sai__GlobalPowerPolicyType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__GlobalPowerPolicyType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__GlobalPowerPolicyType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__GlobalPowerPolicyType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__GlobalPowerPolicyType(struct soap *soap, const char *tag, int id, const sai__GlobalPowerPolicyType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__GlobalPowerPolicyType), type);
	soap_out_unsignedInt(soap, "sai:IdleWakeTimeout", -1, &(a->sai__GlobalPowerPolicyType::IdleWakeTimeout), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__GlobalPowerPolicyType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__GlobalPowerPolicyType(soap, this, tag, type);
}

SOAP_FMAC3 sai__GlobalPowerPolicyType * SOAP_FMAC4 soap_get_sai__GlobalPowerPolicyType(struct soap *soap, sai__GlobalPowerPolicyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__GlobalPowerPolicyType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__GlobalPowerPolicyType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__GlobalPowerPolicyType(soap, tag, this, type);
}

SOAP_FMAC3 sai__GlobalPowerPolicyType * SOAP_FMAC4 soap_in_sai__GlobalPowerPolicyType(struct soap *soap, const char *tag, sai__GlobalPowerPolicyType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__GlobalPowerPolicyType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__GlobalPowerPolicyType, sizeof(sai__GlobalPowerPolicyType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__GlobalPowerPolicyType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__GlobalPowerPolicyType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_IdleWakeTimeout1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_IdleWakeTimeout1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:IdleWakeTimeout", &(a->sai__GlobalPowerPolicyType::IdleWakeTimeout), "xsd:unsignedInt"))
				{	soap_flag_IdleWakeTimeout1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__GlobalPowerPolicyType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__GlobalPowerPolicyType, 0, sizeof(sai__GlobalPowerPolicyType), 0, soap_copy_sai__GlobalPowerPolicyType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_IdleWakeTimeout1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__GlobalPowerPolicyType * SOAP_FMAC6 soap_new_sai__GlobalPowerPolicyType(struct soap *soap, int n)
{	return soap_instantiate_sai__GlobalPowerPolicyType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__GlobalPowerPolicyType(struct soap *soap, sai__GlobalPowerPolicyType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__GlobalPowerPolicyType * SOAP_FMAC4 soap_instantiate_sai__GlobalPowerPolicyType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__GlobalPowerPolicyType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__GlobalPowerPolicyType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__GlobalPowerPolicyType;
		if (size)
			*size = sizeof(sai__GlobalPowerPolicyType);
		((sai__GlobalPowerPolicyType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__GlobalPowerPolicyType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__GlobalPowerPolicyType);
		for (int i = 0; i < n; i++)
			((sai__GlobalPowerPolicyType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__GlobalPowerPolicyType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__GlobalPowerPolicyType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__GlobalPowerPolicyType %p -> %p\n", q, p));
	*(sai__GlobalPowerPolicyType*)p = *(sai__GlobalPowerPolicyType*)q;
}

void sai__EnvironmentDetectionType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->sai__EnvironmentDetectionType::__union_EnvironmentDetectionType = 0;
	this->sai__EnvironmentDetectionType::ExternalCircuitBreakerPolicy = NULL;
	/* transient soap skipped */
}

void sai__EnvironmentDetectionType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize__sai__union_EnvironmentDetectionType(soap, this->sai__EnvironmentDetectionType::__union_EnvironmentDetectionType, &this->sai__EnvironmentDetectionType::union_EnvironmentDetectionType);
	soap_serialize_PointerTounsignedInt(soap, &this->sai__EnvironmentDetectionType::ExternalCircuitBreakerPolicy);
	/* transient soap skipped */
}

int sai__EnvironmentDetectionType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__EnvironmentDetectionType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__EnvironmentDetectionType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__EnvironmentDetectionType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__EnvironmentDetectionType(struct soap *soap, const char *tag, int id, const sai__EnvironmentDetectionType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__EnvironmentDetectionType), type);
	soap_out__sai__union_EnvironmentDetectionType(soap, a->sai__EnvironmentDetectionType::__union_EnvironmentDetectionType, &a->sai__EnvironmentDetectionType::union_EnvironmentDetectionType);
	soap_out_PointerTounsignedInt(soap, "sai:ExternalCircuitBreakerPolicy", -1, &(a->sai__EnvironmentDetectionType::ExternalCircuitBreakerPolicy), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__EnvironmentDetectionType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__EnvironmentDetectionType(soap, this, tag, type);
}

SOAP_FMAC3 sai__EnvironmentDetectionType * SOAP_FMAC4 soap_get_sai__EnvironmentDetectionType(struct soap *soap, sai__EnvironmentDetectionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__EnvironmentDetectionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__EnvironmentDetectionType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__EnvironmentDetectionType(soap, tag, this, type);
}

SOAP_FMAC3 sai__EnvironmentDetectionType * SOAP_FMAC4 soap_in_sai__EnvironmentDetectionType(struct soap *soap, const char *tag, sai__EnvironmentDetectionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__EnvironmentDetectionType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__EnvironmentDetectionType, sizeof(sai__EnvironmentDetectionType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__EnvironmentDetectionType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__EnvironmentDetectionType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_union_EnvironmentDetectionType1 = 1, soap_flag_ExternalCircuitBreakerPolicy1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_union_EnvironmentDetectionType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__sai__union_EnvironmentDetectionType(soap, &a->sai__EnvironmentDetectionType::__union_EnvironmentDetectionType, &a->sai__EnvironmentDetectionType::union_EnvironmentDetectionType))
				{	soap_flag_union_EnvironmentDetectionType1 = 0;
					continue;
				}
			if (soap_flag_ExternalCircuitBreakerPolicy1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedInt(soap, "sai:ExternalCircuitBreakerPolicy", &(a->sai__EnvironmentDetectionType::ExternalCircuitBreakerPolicy), "xsd:unsignedInt"))
				{	soap_flag_ExternalCircuitBreakerPolicy1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__EnvironmentDetectionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__EnvironmentDetectionType, 0, sizeof(sai__EnvironmentDetectionType), 0, soap_copy_sai__EnvironmentDetectionType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_union_EnvironmentDetectionType1))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__EnvironmentDetectionType * SOAP_FMAC6 soap_new_sai__EnvironmentDetectionType(struct soap *soap, int n)
{	return soap_instantiate_sai__EnvironmentDetectionType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__EnvironmentDetectionType(struct soap *soap, sai__EnvironmentDetectionType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__EnvironmentDetectionType * SOAP_FMAC4 soap_instantiate_sai__EnvironmentDetectionType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__EnvironmentDetectionType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__EnvironmentDetectionType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__EnvironmentDetectionType;
		if (size)
			*size = sizeof(sai__EnvironmentDetectionType);
		((sai__EnvironmentDetectionType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__EnvironmentDetectionType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__EnvironmentDetectionType);
		for (int i = 0; i < n; i++)
			((sai__EnvironmentDetectionType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__EnvironmentDetectionType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__EnvironmentDetectionType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__EnvironmentDetectionType %p -> %p\n", q, p));
	*(sai__EnvironmentDetectionType*)p = *(sai__EnvironmentDetectionType*)q;
}

void sai__EnvironmentDetectionDomainType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfstd__string(soap, &this->sai__EnvironmentDetectionDomainType::values);
	/* transient soap skipped */
}

void sai__EnvironmentDetectionDomainType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfstd__string(soap, &this->sai__EnvironmentDetectionDomainType::values);
	/* transient soap skipped */
}

int sai__EnvironmentDetectionDomainType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__EnvironmentDetectionDomainType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__EnvironmentDetectionDomainType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__EnvironmentDetectionDomainType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__EnvironmentDetectionDomainType(struct soap *soap, const char *tag, int id, const sai__EnvironmentDetectionDomainType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__EnvironmentDetectionDomainType), type);
	soap_out_std__vectorTemplateOfstd__string(soap, "sai:values", -1, &(a->sai__EnvironmentDetectionDomainType::values), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__EnvironmentDetectionDomainType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__EnvironmentDetectionDomainType(soap, this, tag, type);
}

SOAP_FMAC3 sai__EnvironmentDetectionDomainType * SOAP_FMAC4 soap_get_sai__EnvironmentDetectionDomainType(struct soap *soap, sai__EnvironmentDetectionDomainType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__EnvironmentDetectionDomainType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__EnvironmentDetectionDomainType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__EnvironmentDetectionDomainType(soap, tag, this, type);
}

SOAP_FMAC3 sai__EnvironmentDetectionDomainType * SOAP_FMAC4 soap_in_sai__EnvironmentDetectionDomainType(struct soap *soap, const char *tag, sai__EnvironmentDetectionDomainType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__EnvironmentDetectionDomainType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__EnvironmentDetectionDomainType, sizeof(sai__EnvironmentDetectionDomainType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__EnvironmentDetectionDomainType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__EnvironmentDetectionDomainType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "sai:values", &(a->sai__EnvironmentDetectionDomainType::values), "xsd:string"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__EnvironmentDetectionDomainType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__EnvironmentDetectionDomainType, 0, sizeof(sai__EnvironmentDetectionDomainType), 0, soap_copy_sai__EnvironmentDetectionDomainType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->sai__EnvironmentDetectionDomainType::values.size() > 5))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__EnvironmentDetectionDomainType * SOAP_FMAC6 soap_new_sai__EnvironmentDetectionDomainType(struct soap *soap, int n)
{	return soap_instantiate_sai__EnvironmentDetectionDomainType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__EnvironmentDetectionDomainType(struct soap *soap, sai__EnvironmentDetectionDomainType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__EnvironmentDetectionDomainType * SOAP_FMAC4 soap_instantiate_sai__EnvironmentDetectionDomainType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__EnvironmentDetectionDomainType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__EnvironmentDetectionDomainType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__EnvironmentDetectionDomainType;
		if (size)
			*size = sizeof(sai__EnvironmentDetectionDomainType);
		((sai__EnvironmentDetectionDomainType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__EnvironmentDetectionDomainType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__EnvironmentDetectionDomainType);
		for (int i = 0; i < n; i++)
			((sai__EnvironmentDetectionDomainType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__EnvironmentDetectionDomainType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__EnvironmentDetectionDomainType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__EnvironmentDetectionDomainType %p -> %p\n", q, p));
	*(sai__EnvironmentDetectionDomainType*)p = *(sai__EnvironmentDetectionDomainType*)q;
}

void sai__EnvironmentDetectionHTTPSType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfxsd__anyURI(soap, &this->sai__EnvironmentDetectionHTTPSType::values);
	/* transient soap skipped */
}

void sai__EnvironmentDetectionHTTPSType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfxsd__anyURI(soap, &this->sai__EnvironmentDetectionHTTPSType::values);
	/* transient soap skipped */
}

int sai__EnvironmentDetectionHTTPSType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__EnvironmentDetectionHTTPSType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__EnvironmentDetectionHTTPSType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__EnvironmentDetectionHTTPSType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__EnvironmentDetectionHTTPSType(struct soap *soap, const char *tag, int id, const sai__EnvironmentDetectionHTTPSType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__EnvironmentDetectionHTTPSType), type);
	soap_out_std__vectorTemplateOfxsd__anyURI(soap, "sai:values", -1, &(a->sai__EnvironmentDetectionHTTPSType::values), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__EnvironmentDetectionHTTPSType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__EnvironmentDetectionHTTPSType(soap, this, tag, type);
}

SOAP_FMAC3 sai__EnvironmentDetectionHTTPSType * SOAP_FMAC4 soap_get_sai__EnvironmentDetectionHTTPSType(struct soap *soap, sai__EnvironmentDetectionHTTPSType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__EnvironmentDetectionHTTPSType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__EnvironmentDetectionHTTPSType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__EnvironmentDetectionHTTPSType(soap, tag, this, type);
}

SOAP_FMAC3 sai__EnvironmentDetectionHTTPSType * SOAP_FMAC4 soap_in_sai__EnvironmentDetectionHTTPSType(struct soap *soap, const char *tag, sai__EnvironmentDetectionHTTPSType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__EnvironmentDetectionHTTPSType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__EnvironmentDetectionHTTPSType, sizeof(sai__EnvironmentDetectionHTTPSType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__EnvironmentDetectionHTTPSType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__EnvironmentDetectionHTTPSType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxsd__anyURI(soap, "sai:values", &(a->sai__EnvironmentDetectionHTTPSType::values), "xsd:anyURI"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__EnvironmentDetectionHTTPSType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__EnvironmentDetectionHTTPSType, 0, sizeof(sai__EnvironmentDetectionHTTPSType), 0, soap_copy_sai__EnvironmentDetectionHTTPSType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->sai__EnvironmentDetectionHTTPSType::values.size() > 5))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__EnvironmentDetectionHTTPSType * SOAP_FMAC6 soap_new_sai__EnvironmentDetectionHTTPSType(struct soap *soap, int n)
{	return soap_instantiate_sai__EnvironmentDetectionHTTPSType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__EnvironmentDetectionHTTPSType(struct soap *soap, sai__EnvironmentDetectionHTTPSType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__EnvironmentDetectionHTTPSType * SOAP_FMAC4 soap_instantiate_sai__EnvironmentDetectionHTTPSType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__EnvironmentDetectionHTTPSType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__EnvironmentDetectionHTTPSType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__EnvironmentDetectionHTTPSType;
		if (size)
			*size = sizeof(sai__EnvironmentDetectionHTTPSType);
		((sai__EnvironmentDetectionHTTPSType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__EnvironmentDetectionHTTPSType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__EnvironmentDetectionHTTPSType);
		for (int i = 0; i < n; i++)
			((sai__EnvironmentDetectionHTTPSType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__EnvironmentDetectionHTTPSType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__EnvironmentDetectionHTTPSType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__EnvironmentDetectionHTTPSType %p -> %p\n", q, p));
	*(sai__EnvironmentDetectionHTTPSType*)p = *(sai__EnvironmentDetectionHTTPSType*)q;
}

void sai__ProvisioningAuditRecordType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__ProvisioningTLSModeType(soap, &this->sai__ProvisioningAuditRecordType::ProvisioningTLSMode);
	soap_default_bool(soap, &this->sai__ProvisioningAuditRecordType::SecureDNS);
	soap_default_bool(soap, &this->sai__ProvisioningAuditRecordType::HostInitiated);
	this->sai__ProvisioningAuditRecordType::ProvServerFQDN = NULL;
	soap_default_sai__HashTypeType(soap, &this->sai__ProvisioningAuditRecordType::SelectedHashType);
	this->sai__ProvisioningAuditRecordType::SelectedHashData.xsd__base64Binary::soap_default(soap);
	this->sai__ProvisioningAuditRecordType::CaCertSerials = NULL;
	this->sai__ProvisioningAuditRecordType::AdditionalCaSerialNums = NULL;
	soap_default_bool(soap, &this->sai__ProvisioningAuditRecordType::IsOemDefault);
	soap_default_bool(soap, &this->sai__ProvisioningAuditRecordType::IsTimeValid);
	soap_default_sai__IPv4AddressType(soap, &this->sai__ProvisioningAuditRecordType::ProvServerIP);
	soap_default_unsignedInt(soap, &this->sai__ProvisioningAuditRecordType::TlsStartTime);
	/* transient soap skipped */
}

void sai__ProvisioningAuditRecordType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__ProvisioningAuditRecordType::SecureDNS, SOAP_TYPE_bool);
	soap_embedded(soap, &this->sai__ProvisioningAuditRecordType::HostInitiated, SOAP_TYPE_bool);
	soap_serialize_PointerTostd__string(soap, &this->sai__ProvisioningAuditRecordType::ProvServerFQDN);
	soap_embedded(soap, &this->sai__ProvisioningAuditRecordType::SelectedHashData, SOAP_TYPE_xsd__base64Binary);
	this->sai__ProvisioningAuditRecordType::SelectedHashData.soap_serialize(soap);
	soap_serialize_PointerToxsd__base64Binary(soap, &this->sai__ProvisioningAuditRecordType::CaCertSerials);
	soap_serialize_PointerTobool(soap, &this->sai__ProvisioningAuditRecordType::AdditionalCaSerialNums);
	soap_embedded(soap, &this->sai__ProvisioningAuditRecordType::IsOemDefault, SOAP_TYPE_bool);
	soap_embedded(soap, &this->sai__ProvisioningAuditRecordType::IsTimeValid, SOAP_TYPE_bool);
	soap_embedded(soap, &this->sai__ProvisioningAuditRecordType::TlsStartTime, SOAP_TYPE_unsignedInt);
	/* transient soap skipped */
}

int sai__ProvisioningAuditRecordType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__ProvisioningAuditRecordType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__ProvisioningAuditRecordType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__ProvisioningAuditRecordType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__ProvisioningAuditRecordType(struct soap *soap, const char *tag, int id, const sai__ProvisioningAuditRecordType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__ProvisioningAuditRecordType), type);
	soap_out_sai__ProvisioningTLSModeType(soap, "sai:ProvisioningTLSMode", -1, &(a->sai__ProvisioningAuditRecordType::ProvisioningTLSMode), "");
	soap_out_bool(soap, "sai:SecureDNS", -1, &(a->sai__ProvisioningAuditRecordType::SecureDNS), "");
	soap_out_bool(soap, "sai:HostInitiated", -1, &(a->sai__ProvisioningAuditRecordType::HostInitiated), "");
	soap_out_PointerTostd__string(soap, "sai:ProvServerFQDN", -1, &(a->sai__ProvisioningAuditRecordType::ProvServerFQDN), "");
	soap_out_sai__HashTypeType(soap, "sai:SelectedHashType", -1, &(a->sai__ProvisioningAuditRecordType::SelectedHashType), "");
	(a->sai__ProvisioningAuditRecordType::SelectedHashData).soap_out(soap, "sai:SelectedHashData", -1, "");
	soap_out_PointerToxsd__base64Binary(soap, "sai:CaCertSerials", -1, &(a->sai__ProvisioningAuditRecordType::CaCertSerials), "");
	soap_out_PointerTobool(soap, "sai:AdditionalCaSerialNums", -1, &(a->sai__ProvisioningAuditRecordType::AdditionalCaSerialNums), "");
	soap_out_bool(soap, "sai:IsOemDefault", -1, &(a->sai__ProvisioningAuditRecordType::IsOemDefault), "");
	soap_out_bool(soap, "sai:IsTimeValid", -1, &(a->sai__ProvisioningAuditRecordType::IsTimeValid), "");
	soap_out_sai__IPv4AddressType(soap, "sai:ProvServerIP", -1, &(a->sai__ProvisioningAuditRecordType::ProvServerIP), "");
	soap_out_unsignedInt(soap, "sai:TlsStartTime", -1, &(a->sai__ProvisioningAuditRecordType::TlsStartTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__ProvisioningAuditRecordType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__ProvisioningAuditRecordType(soap, this, tag, type);
}

SOAP_FMAC3 sai__ProvisioningAuditRecordType * SOAP_FMAC4 soap_get_sai__ProvisioningAuditRecordType(struct soap *soap, sai__ProvisioningAuditRecordType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__ProvisioningAuditRecordType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__ProvisioningAuditRecordType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__ProvisioningAuditRecordType(soap, tag, this, type);
}

SOAP_FMAC3 sai__ProvisioningAuditRecordType * SOAP_FMAC4 soap_in_sai__ProvisioningAuditRecordType(struct soap *soap, const char *tag, sai__ProvisioningAuditRecordType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__ProvisioningAuditRecordType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__ProvisioningAuditRecordType, sizeof(sai__ProvisioningAuditRecordType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__ProvisioningAuditRecordType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__ProvisioningAuditRecordType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_ProvisioningTLSMode1 = 1, soap_flag_SecureDNS1 = 1, soap_flag_HostInitiated1 = 1, soap_flag_ProvServerFQDN1 = 1, soap_flag_SelectedHashType1 = 1, soap_flag_SelectedHashData1 = 1, soap_flag_CaCertSerials1 = 1, soap_flag_AdditionalCaSerialNums1 = 1, soap_flag_IsOemDefault1 = 1, soap_flag_IsTimeValid1 = 1, soap_flag_ProvServerIP1 = 1, soap_flag_TlsStartTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProvisioningTLSMode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__ProvisioningTLSModeType(soap, "sai:ProvisioningTLSMode", &(a->sai__ProvisioningAuditRecordType::ProvisioningTLSMode), "sai:ProvisioningTLSModeType"))
				{	soap_flag_ProvisioningTLSMode1--;
					continue;
				}
			if (soap_flag_SecureDNS1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "sai:SecureDNS", &(a->sai__ProvisioningAuditRecordType::SecureDNS), "xsd:boolean"))
				{	soap_flag_SecureDNS1--;
					continue;
				}
			if (soap_flag_HostInitiated1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "sai:HostInitiated", &(a->sai__ProvisioningAuditRecordType::HostInitiated), "xsd:boolean"))
				{	soap_flag_HostInitiated1--;
					continue;
				}
			if (soap_flag_ProvServerFQDN1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "sai:ProvServerFQDN", &(a->sai__ProvisioningAuditRecordType::ProvServerFQDN), "xsd:string"))
				{	soap_flag_ProvServerFQDN1--;
					continue;
				}
			if (soap_flag_SelectedHashType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__HashTypeType(soap, "sai:SelectedHashType", &(a->sai__ProvisioningAuditRecordType::SelectedHashType), "sai:HashTypeType"))
				{	soap_flag_SelectedHashType1--;
					continue;
				}
			if (soap_flag_SelectedHashData1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__ProvisioningAuditRecordType::SelectedHashData).soap_in(soap, "sai:SelectedHashData", "xsd:base64Binary"))
				{	soap_flag_SelectedHashData1--;
					continue;
				}
			if (soap_flag_CaCertSerials1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "sai:CaCertSerials", &(a->sai__ProvisioningAuditRecordType::CaCertSerials), "xsd:base64Binary"))
				{	soap_flag_CaCertSerials1--;
					continue;
				}
			if (soap_flag_AdditionalCaSerialNums1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "sai:AdditionalCaSerialNums", &(a->sai__ProvisioningAuditRecordType::AdditionalCaSerialNums), "xsd:boolean"))
				{	soap_flag_AdditionalCaSerialNums1--;
					continue;
				}
			if (soap_flag_IsOemDefault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "sai:IsOemDefault", &(a->sai__ProvisioningAuditRecordType::IsOemDefault), "xsd:boolean"))
				{	soap_flag_IsOemDefault1--;
					continue;
				}
			if (soap_flag_IsTimeValid1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "sai:IsTimeValid", &(a->sai__ProvisioningAuditRecordType::IsTimeValid), "xsd:boolean"))
				{	soap_flag_IsTimeValid1--;
					continue;
				}
			if (soap_flag_ProvServerIP1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__IPv4AddressType(soap, "sai:ProvServerIP", &(a->sai__ProvisioningAuditRecordType::ProvServerIP), "sai:IPv4AddressType"))
				{	soap_flag_ProvServerIP1--;
					continue;
				}
			if (soap_flag_TlsStartTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:TlsStartTime", &(a->sai__ProvisioningAuditRecordType::TlsStartTime), "xsd:unsignedInt"))
				{	soap_flag_TlsStartTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__ProvisioningAuditRecordType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__ProvisioningAuditRecordType, 0, sizeof(sai__ProvisioningAuditRecordType), 0, soap_copy_sai__ProvisioningAuditRecordType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ProvisioningTLSMode1 > 0 || soap_flag_SecureDNS1 > 0 || soap_flag_HostInitiated1 > 0 || soap_flag_SelectedHashType1 > 0 || soap_flag_SelectedHashData1 > 0 || soap_flag_IsOemDefault1 > 0 || soap_flag_IsTimeValid1 > 0 || soap_flag_ProvServerIP1 > 0 || soap_flag_TlsStartTime1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__ProvisioningAuditRecordType * SOAP_FMAC6 soap_new_sai__ProvisioningAuditRecordType(struct soap *soap, int n)
{	return soap_instantiate_sai__ProvisioningAuditRecordType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__ProvisioningAuditRecordType(struct soap *soap, sai__ProvisioningAuditRecordType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__ProvisioningAuditRecordType * SOAP_FMAC4 soap_instantiate_sai__ProvisioningAuditRecordType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__ProvisioningAuditRecordType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__ProvisioningAuditRecordType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__ProvisioningAuditRecordType;
		if (size)
			*size = sizeof(sai__ProvisioningAuditRecordType);
		((sai__ProvisioningAuditRecordType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__ProvisioningAuditRecordType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__ProvisioningAuditRecordType);
		for (int i = 0; i < n; i++)
			((sai__ProvisioningAuditRecordType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__ProvisioningAuditRecordType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__ProvisioningAuditRecordType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__ProvisioningAuditRecordType %p -> %p\n", q, p));
	*(sai__ProvisioningAuditRecordType*)p = *(sai__ProvisioningAuditRecordType*)q;
}

void sai__CertHashEntryType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->sai__CertHashEntryType::Default);
	soap_default_bool(soap, &this->sai__CertHashEntryType::Active);
	soap_default_sai__HashTypeType(soap, &this->sai__CertHashEntryType::HashType);
	this->sai__CertHashEntryType::Hash.xsd__base64Binary::soap_default(soap);
	soap_default_sai__FriendlyNameType(soap, &this->sai__CertHashEntryType::FriendlyName);
	/* transient soap skipped */
}

void sai__CertHashEntryType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__CertHashEntryType::Default, SOAP_TYPE_bool);
	soap_embedded(soap, &this->sai__CertHashEntryType::Active, SOAP_TYPE_bool);
	soap_embedded(soap, &this->sai__CertHashEntryType::Hash, SOAP_TYPE_xsd__base64Binary);
	this->sai__CertHashEntryType::Hash.soap_serialize(soap);
	soap_serialize_sai__FriendlyNameType(soap, &this->sai__CertHashEntryType::FriendlyName);
	/* transient soap skipped */
}

int sai__CertHashEntryType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__CertHashEntryType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__CertHashEntryType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__CertHashEntryType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__CertHashEntryType(struct soap *soap, const char *tag, int id, const sai__CertHashEntryType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__CertHashEntryType), type);
	soap_out_bool(soap, "sai:Default", -1, &(a->sai__CertHashEntryType::Default), "");
	soap_out_bool(soap, "sai:Active", -1, &(a->sai__CertHashEntryType::Active), "");
	soap_out_sai__HashTypeType(soap, "sai:HashType", -1, &(a->sai__CertHashEntryType::HashType), "");
	(a->sai__CertHashEntryType::Hash).soap_out(soap, "sai:Hash", -1, "");
	soap_out_sai__FriendlyNameType(soap, "sai:FriendlyName", -1, &(a->sai__CertHashEntryType::FriendlyName), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__CertHashEntryType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__CertHashEntryType(soap, this, tag, type);
}

SOAP_FMAC3 sai__CertHashEntryType * SOAP_FMAC4 soap_get_sai__CertHashEntryType(struct soap *soap, sai__CertHashEntryType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__CertHashEntryType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__CertHashEntryType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__CertHashEntryType(soap, tag, this, type);
}

SOAP_FMAC3 sai__CertHashEntryType * SOAP_FMAC4 soap_in_sai__CertHashEntryType(struct soap *soap, const char *tag, sai__CertHashEntryType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__CertHashEntryType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__CertHashEntryType, sizeof(sai__CertHashEntryType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__CertHashEntryType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__CertHashEntryType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Default1 = 1, soap_flag_Active1 = 1, soap_flag_HashType1 = 1, soap_flag_Hash1 = 1, soap_flag_FriendlyName1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Default1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "sai:Default", &(a->sai__CertHashEntryType::Default), "xsd:boolean"))
				{	soap_flag_Default1--;
					continue;
				}
			if (soap_flag_Active1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "sai:Active", &(a->sai__CertHashEntryType::Active), "xsd:boolean"))
				{	soap_flag_Active1--;
					continue;
				}
			if (soap_flag_HashType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__HashTypeType(soap, "sai:HashType", &(a->sai__CertHashEntryType::HashType), "sai:HashTypeType"))
				{	soap_flag_HashType1--;
					continue;
				}
			if (soap_flag_Hash1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__CertHashEntryType::Hash).soap_in(soap, "sai:Hash", "xsd:base64Binary"))
				{	soap_flag_Hash1--;
					continue;
				}
			if (soap_flag_FriendlyName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_sai__FriendlyNameType(soap, "sai:FriendlyName", &(a->sai__CertHashEntryType::FriendlyName), "sai:FriendlyNameType"))
				{	soap_flag_FriendlyName1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__CertHashEntryType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__CertHashEntryType, 0, sizeof(sai__CertHashEntryType), 0, soap_copy_sai__CertHashEntryType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Default1 > 0 || soap_flag_Active1 > 0 || soap_flag_HashType1 > 0 || soap_flag_Hash1 > 0 || soap_flag_FriendlyName1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__CertHashEntryType * SOAP_FMAC6 soap_new_sai__CertHashEntryType(struct soap *soap, int n)
{	return soap_instantiate_sai__CertHashEntryType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__CertHashEntryType(struct soap *soap, sai__CertHashEntryType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__CertHashEntryType * SOAP_FMAC4 soap_instantiate_sai__CertHashEntryType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__CertHashEntryType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__CertHashEntryType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__CertHashEntryType;
		if (size)
			*size = sizeof(sai__CertHashEntryType);
		((sai__CertHashEntryType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__CertHashEntryType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__CertHashEntryType);
		for (int i = 0; i < n; i++)
			((sai__CertHashEntryType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__CertHashEntryType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__CertHashEntryType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__CertHashEntryType %p -> %p\n", q, p));
	*(sai__CertHashEntryType*)p = *(sai__CertHashEntryType*)q;
}

void sai__PkiCapsType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_unsignedInt(soap, &this->sai__PkiCapsType::CrlStoreSize);
	soap_default_unsignedInt(soap, &this->sai__PkiCapsType::RootCertMaxSize);
	soap_default_unsignedInt(soap, &this->sai__PkiCapsType::RootCertMaxInstances);
	soap_default_unsignedInt(soap, &this->sai__PkiCapsType::FqdnSuffixMaxEntries);
	soap_default_unsignedInt(soap, &this->sai__PkiCapsType::FqdnSuffixMaxEntryLength);
	soap_default_unsignedInt(soap, &this->sai__PkiCapsType::CertChainMaxSize);
	soap_default_std__vectorTemplateOfunsignedInt(soap, &this->sai__PkiCapsType::SupportedKeyLengths);
	/* transient soap skipped */
}

void sai__PkiCapsType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__PkiCapsType::CrlStoreSize, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__PkiCapsType::RootCertMaxSize, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__PkiCapsType::RootCertMaxInstances, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__PkiCapsType::FqdnSuffixMaxEntries, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__PkiCapsType::FqdnSuffixMaxEntryLength, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__PkiCapsType::CertChainMaxSize, SOAP_TYPE_unsignedInt);
	soap_serialize_std__vectorTemplateOfunsignedInt(soap, &this->sai__PkiCapsType::SupportedKeyLengths);
	/* transient soap skipped */
}

int sai__PkiCapsType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__PkiCapsType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__PkiCapsType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__PkiCapsType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__PkiCapsType(struct soap *soap, const char *tag, int id, const sai__PkiCapsType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__PkiCapsType), type);
	soap_out_unsignedInt(soap, "sai:CrlStoreSize", -1, &(a->sai__PkiCapsType::CrlStoreSize), "");
	soap_out_unsignedInt(soap, "sai:RootCertMaxSize", -1, &(a->sai__PkiCapsType::RootCertMaxSize), "");
	soap_out_unsignedInt(soap, "sai:RootCertMaxInstances", -1, &(a->sai__PkiCapsType::RootCertMaxInstances), "");
	soap_out_unsignedInt(soap, "sai:FqdnSuffixMaxEntries", -1, &(a->sai__PkiCapsType::FqdnSuffixMaxEntries), "");
	soap_out_unsignedInt(soap, "sai:FqdnSuffixMaxEntryLength", -1, &(a->sai__PkiCapsType::FqdnSuffixMaxEntryLength), "");
	soap_out_unsignedInt(soap, "sai:CertChainMaxSize", -1, &(a->sai__PkiCapsType::CertChainMaxSize), "");
	soap_out_std__vectorTemplateOfunsignedInt(soap, "sai:SupportedKeyLengths", -1, &(a->sai__PkiCapsType::SupportedKeyLengths), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__PkiCapsType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__PkiCapsType(soap, this, tag, type);
}

SOAP_FMAC3 sai__PkiCapsType * SOAP_FMAC4 soap_get_sai__PkiCapsType(struct soap *soap, sai__PkiCapsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__PkiCapsType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__PkiCapsType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__PkiCapsType(soap, tag, this, type);
}

SOAP_FMAC3 sai__PkiCapsType * SOAP_FMAC4 soap_in_sai__PkiCapsType(struct soap *soap, const char *tag, sai__PkiCapsType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__PkiCapsType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__PkiCapsType, sizeof(sai__PkiCapsType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__PkiCapsType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__PkiCapsType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_CrlStoreSize1 = 1, soap_flag_RootCertMaxSize1 = 1, soap_flag_RootCertMaxInstances1 = 1, soap_flag_FqdnSuffixMaxEntries1 = 1, soap_flag_FqdnSuffixMaxEntryLength1 = 1, soap_flag_CertChainMaxSize1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CrlStoreSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:CrlStoreSize", &(a->sai__PkiCapsType::CrlStoreSize), "xsd:unsignedInt"))
				{	soap_flag_CrlStoreSize1--;
					continue;
				}
			if (soap_flag_RootCertMaxSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:RootCertMaxSize", &(a->sai__PkiCapsType::RootCertMaxSize), "xsd:unsignedInt"))
				{	soap_flag_RootCertMaxSize1--;
					continue;
				}
			if (soap_flag_RootCertMaxInstances1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:RootCertMaxInstances", &(a->sai__PkiCapsType::RootCertMaxInstances), "xsd:unsignedInt"))
				{	soap_flag_RootCertMaxInstances1--;
					continue;
				}
			if (soap_flag_FqdnSuffixMaxEntries1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:FqdnSuffixMaxEntries", &(a->sai__PkiCapsType::FqdnSuffixMaxEntries), "xsd:unsignedInt"))
				{	soap_flag_FqdnSuffixMaxEntries1--;
					continue;
				}
			if (soap_flag_FqdnSuffixMaxEntryLength1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:FqdnSuffixMaxEntryLength", &(a->sai__PkiCapsType::FqdnSuffixMaxEntryLength), "xsd:unsignedInt"))
				{	soap_flag_FqdnSuffixMaxEntryLength1--;
					continue;
				}
			if (soap_flag_CertChainMaxSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:CertChainMaxSize", &(a->sai__PkiCapsType::CertChainMaxSize), "xsd:unsignedInt"))
				{	soap_flag_CertChainMaxSize1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfunsignedInt(soap, "sai:SupportedKeyLengths", &(a->sai__PkiCapsType::SupportedKeyLengths), "xsd:unsignedInt"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__PkiCapsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__PkiCapsType, 0, sizeof(sai__PkiCapsType), 0, soap_copy_sai__PkiCapsType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CrlStoreSize1 > 0 || soap_flag_RootCertMaxSize1 > 0 || soap_flag_RootCertMaxInstances1 > 0 || soap_flag_FqdnSuffixMaxEntries1 > 0 || soap_flag_FqdnSuffixMaxEntryLength1 > 0 || soap_flag_CertChainMaxSize1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__PkiCapsType * SOAP_FMAC6 soap_new_sai__PkiCapsType(struct soap *soap, int n)
{	return soap_instantiate_sai__PkiCapsType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__PkiCapsType(struct soap *soap, sai__PkiCapsType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__PkiCapsType * SOAP_FMAC4 soap_instantiate_sai__PkiCapsType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__PkiCapsType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__PkiCapsType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__PkiCapsType;
		if (size)
			*size = sizeof(sai__PkiCapsType);
		((sai__PkiCapsType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__PkiCapsType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__PkiCapsType);
		for (int i = 0; i < n; i++)
			((sai__PkiCapsType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__PkiCapsType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__PkiCapsType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__PkiCapsType %p -> %p\n", q, p));
	*(sai__PkiCapsType*)p = *(sai__PkiCapsType*)q;
}

void sai__CrlType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->sai__CrlType::CrlUrl);
	soap_default_std__vectorTemplateOfxsd__base64Binary(soap, &this->sai__CrlType::SerialNumber);
	/* transient soap skipped */
}

void sai__CrlType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__CrlType::CrlUrl, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->sai__CrlType::CrlUrl);
	soap_serialize_std__vectorTemplateOfxsd__base64Binary(soap, &this->sai__CrlType::SerialNumber);
	/* transient soap skipped */
}

int sai__CrlType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__CrlType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__CrlType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__CrlType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__CrlType(struct soap *soap, const char *tag, int id, const sai__CrlType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__CrlType), type);
	soap_out_std__string(soap, "sai:CrlUrl", -1, &(a->sai__CrlType::CrlUrl), "");
	soap_out_std__vectorTemplateOfxsd__base64Binary(soap, "sai:SerialNumber", -1, &(a->sai__CrlType::SerialNumber), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__CrlType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__CrlType(soap, this, tag, type);
}

SOAP_FMAC3 sai__CrlType * SOAP_FMAC4 soap_get_sai__CrlType(struct soap *soap, sai__CrlType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__CrlType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__CrlType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__CrlType(soap, tag, this, type);
}

SOAP_FMAC3 sai__CrlType * SOAP_FMAC4 soap_in_sai__CrlType(struct soap *soap, const char *tag, sai__CrlType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__CrlType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__CrlType, sizeof(sai__CrlType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__CrlType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__CrlType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_CrlUrl1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CrlUrl1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "sai:CrlUrl", &(a->sai__CrlType::CrlUrl), "xsd:string"))
				{	soap_flag_CrlUrl1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxsd__base64Binary(soap, "sai:SerialNumber", &(a->sai__CrlType::SerialNumber), "xsd:base64Binary"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__CrlType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__CrlType, 0, sizeof(sai__CrlType), 0, soap_copy_sai__CrlType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CrlUrl1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__CrlType * SOAP_FMAC6 soap_new_sai__CrlType(struct soap *soap, int n)
{	return soap_instantiate_sai__CrlType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__CrlType(struct soap *soap, sai__CrlType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__CrlType * SOAP_FMAC4 soap_instantiate_sai__CrlType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__CrlType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__CrlType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__CrlType;
		if (size)
			*size = sizeof(sai__CrlType);
		((sai__CrlType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__CrlType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__CrlType);
		for (int i = 0; i < n; i++)
			((sai__CrlType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__CrlType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__CrlType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__CrlType %p -> %p\n", q, p));
	*(sai__CrlType*)p = *(sai__CrlType*)q;
}

void sai__CertificateType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->sai__CertificateType::X509cert.xsd__base64Binary::soap_default(soap);
	/* transient soap skipped */
}

void sai__CertificateType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__CertificateType::X509cert, SOAP_TYPE_xsd__base64Binary);
	this->sai__CertificateType::X509cert.soap_serialize(soap);
	/* transient soap skipped */
}

int sai__CertificateType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__CertificateType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__CertificateType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__CertificateType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__CertificateType(struct soap *soap, const char *tag, int id, const sai__CertificateType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__CertificateType), type);
	(a->sai__CertificateType::X509cert).soap_out(soap, "sai:X509cert", -1, "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__CertificateType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__CertificateType(soap, this, tag, type);
}

SOAP_FMAC3 sai__CertificateType * SOAP_FMAC4 soap_get_sai__CertificateType(struct soap *soap, sai__CertificateType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__CertificateType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__CertificateType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__CertificateType(soap, tag, this, type);
}

SOAP_FMAC3 sai__CertificateType * SOAP_FMAC4 soap_in_sai__CertificateType(struct soap *soap, const char *tag, sai__CertificateType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__CertificateType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__CertificateType, sizeof(sai__CertificateType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__CertificateType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__CertificateType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_X509cert1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_X509cert1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__CertificateType::X509cert).soap_in(soap, "sai:X509cert", "xsd:base64Binary"))
				{	soap_flag_X509cert1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__CertificateType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__CertificateType, 0, sizeof(sai__CertificateType), 0, soap_copy_sai__CertificateType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_X509cert1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__CertificateType * SOAP_FMAC6 soap_new_sai__CertificateType(struct soap *soap, int n)
{	return soap_instantiate_sai__CertificateType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__CertificateType(struct soap *soap, sai__CertificateType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__CertificateType * SOAP_FMAC4 soap_instantiate_sai__CertificateType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__CertificateType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__CertificateType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__CertificateType;
		if (size)
			*size = sizeof(sai__CertificateType);
		((sai__CertificateType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__CertificateType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__CertificateType);
		for (int i = 0; i < n; i++)
			((sai__CertificateType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__CertificateType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__CertificateType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__CertificateType %p -> %p\n", q, p));
	*(sai__CertificateType*)p = *(sai__CertificateType*)q;
}

void sai__TlsOptionsType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__InterfaceType(soap, &this->sai__TlsOptionsType::Interface);
	soap_default_sai__TlsAthenticationType(soap, &this->sai__TlsOptionsType::TlsAuthentication);
	/* transient soap skipped */
}

void sai__TlsOptionsType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int sai__TlsOptionsType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__TlsOptionsType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__TlsOptionsType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__TlsOptionsType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__TlsOptionsType(struct soap *soap, const char *tag, int id, const sai__TlsOptionsType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__TlsOptionsType), type);
	soap_out_sai__InterfaceType(soap, "sai:Interface", -1, &(a->sai__TlsOptionsType::Interface), "");
	soap_out_sai__TlsAthenticationType(soap, "sai:TlsAuthentication", -1, &(a->sai__TlsOptionsType::TlsAuthentication), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__TlsOptionsType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__TlsOptionsType(soap, this, tag, type);
}

SOAP_FMAC3 sai__TlsOptionsType * SOAP_FMAC4 soap_get_sai__TlsOptionsType(struct soap *soap, sai__TlsOptionsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__TlsOptionsType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__TlsOptionsType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__TlsOptionsType(soap, tag, this, type);
}

SOAP_FMAC3 sai__TlsOptionsType * SOAP_FMAC4 soap_in_sai__TlsOptionsType(struct soap *soap, const char *tag, sai__TlsOptionsType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__TlsOptionsType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__TlsOptionsType, sizeof(sai__TlsOptionsType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__TlsOptionsType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__TlsOptionsType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Interface1 = 1, soap_flag_TlsAuthentication1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Interface1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__InterfaceType(soap, "sai:Interface", &(a->sai__TlsOptionsType::Interface), "sai:InterfaceType"))
				{	soap_flag_Interface1--;
					continue;
				}
			if (soap_flag_TlsAuthentication1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__TlsAthenticationType(soap, "sai:TlsAuthentication", &(a->sai__TlsOptionsType::TlsAuthentication), "sai:TlsAthenticationType"))
				{	soap_flag_TlsAuthentication1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__TlsOptionsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__TlsOptionsType, 0, sizeof(sai__TlsOptionsType), 0, soap_copy_sai__TlsOptionsType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Interface1 > 0 || soap_flag_TlsAuthentication1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__TlsOptionsType * SOAP_FMAC6 soap_new_sai__TlsOptionsType(struct soap *soap, int n)
{	return soap_instantiate_sai__TlsOptionsType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__TlsOptionsType(struct soap *soap, sai__TlsOptionsType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__TlsOptionsType * SOAP_FMAC4 soap_instantiate_sai__TlsOptionsType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__TlsOptionsType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__TlsOptionsType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__TlsOptionsType;
		if (size)
			*size = sizeof(sai__TlsOptionsType);
		((sai__TlsOptionsType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__TlsOptionsType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__TlsOptionsType);
		for (int i = 0; i < n; i++)
			((sai__TlsOptionsType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__TlsOptionsType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__TlsOptionsType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__TlsOptionsType %p -> %p\n", q, p));
	*(sai__TlsOptionsType*)p = *(sai__TlsOptionsType*)q;
}

void sai__KerberosOptionsType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default__sai__KerberosRealmName(soap, &this->sai__KerberosOptionsType::KerberosRealmName);
	soap_default_std__vectorTemplateOfPointerTosai__KerberosSpnType(soap, &this->sai__KerberosOptionsType::KerberosSpn);
	soap_default_unsignedInt(soap, &this->sai__KerberosOptionsType::KerberosKeyVersion);
	soap_default_sai__KerberosEncryptionType(soap, &this->sai__KerberosOptionsType::KerberosEncryption);
	this->sai__KerberosOptionsType::KerberosMasterKey.xsd__base64Binary::soap_default(soap);
	soap_default_unsignedInt(soap, &this->sai__KerberosOptionsType::KerberosMaximumClockTolerance);
	/* transient soap skipped */
}

void sai__KerberosOptionsType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize__sai__KerberosRealmName(soap, &this->sai__KerberosOptionsType::KerberosRealmName);
	soap_serialize_std__vectorTemplateOfPointerTosai__KerberosSpnType(soap, &this->sai__KerberosOptionsType::KerberosSpn);
	soap_embedded(soap, &this->sai__KerberosOptionsType::KerberosKeyVersion, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__KerberosOptionsType::KerberosMasterKey, SOAP_TYPE_xsd__base64Binary);
	this->sai__KerberosOptionsType::KerberosMasterKey.soap_serialize(soap);
	soap_embedded(soap, &this->sai__KerberosOptionsType::KerberosMaximumClockTolerance, SOAP_TYPE_unsignedInt);
	/* transient soap skipped */
}

int sai__KerberosOptionsType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__KerberosOptionsType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__KerberosOptionsType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__KerberosOptionsType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__KerberosOptionsType(struct soap *soap, const char *tag, int id, const sai__KerberosOptionsType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__KerberosOptionsType), type);
	soap_out__sai__KerberosRealmName(soap, "sai:KerberosRealmName", -1, &(a->sai__KerberosOptionsType::KerberosRealmName), "");
	soap_out_std__vectorTemplateOfPointerTosai__KerberosSpnType(soap, "sai:KerberosSpn", -1, &(a->sai__KerberosOptionsType::KerberosSpn), "");
	soap_out_unsignedInt(soap, "sai:KerberosKeyVersion", -1, &(a->sai__KerberosOptionsType::KerberosKeyVersion), "");
	soap_out_sai__KerberosEncryptionType(soap, "sai:KerberosEncryption", -1, &(a->sai__KerberosOptionsType::KerberosEncryption), "");
	(a->sai__KerberosOptionsType::KerberosMasterKey).soap_out(soap, "sai:KerberosMasterKey", -1, "");
	soap_out_unsignedInt(soap, "sai:KerberosMaximumClockTolerance", -1, &(a->sai__KerberosOptionsType::KerberosMaximumClockTolerance), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__KerberosOptionsType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__KerberosOptionsType(soap, this, tag, type);
}

SOAP_FMAC3 sai__KerberosOptionsType * SOAP_FMAC4 soap_get_sai__KerberosOptionsType(struct soap *soap, sai__KerberosOptionsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__KerberosOptionsType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__KerberosOptionsType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__KerberosOptionsType(soap, tag, this, type);
}

SOAP_FMAC3 sai__KerberosOptionsType * SOAP_FMAC4 soap_in_sai__KerberosOptionsType(struct soap *soap, const char *tag, sai__KerberosOptionsType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__KerberosOptionsType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__KerberosOptionsType, sizeof(sai__KerberosOptionsType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__KerberosOptionsType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__KerberosOptionsType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_KerberosRealmName1 = 1, soap_flag_KerberosKeyVersion1 = 1, soap_flag_KerberosEncryption1 = 1, soap_flag_KerberosMasterKey1 = 1, soap_flag_KerberosMaximumClockTolerance1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_KerberosRealmName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__sai__KerberosRealmName(soap, "sai:KerberosRealmName", &(a->sai__KerberosOptionsType::KerberosRealmName), ""))
				{	soap_flag_KerberosRealmName1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTosai__KerberosSpnType(soap, "sai:KerberosSpn", &(a->sai__KerberosOptionsType::KerberosSpn), "sai:KerberosSpnType"))
					continue;
			if (soap_flag_KerberosKeyVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:KerberosKeyVersion", &(a->sai__KerberosOptionsType::KerberosKeyVersion), "xsd:unsignedInt"))
				{	soap_flag_KerberosKeyVersion1--;
					continue;
				}
			if (soap_flag_KerberosEncryption1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__KerberosEncryptionType(soap, "sai:KerberosEncryption", &(a->sai__KerberosOptionsType::KerberosEncryption), "sai:KerberosEncryptionType"))
				{	soap_flag_KerberosEncryption1--;
					continue;
				}
			if (soap_flag_KerberosMasterKey1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__KerberosOptionsType::KerberosMasterKey).soap_in(soap, "sai:KerberosMasterKey", "xsd:base64Binary"))
				{	soap_flag_KerberosMasterKey1--;
					continue;
				}
			if (soap_flag_KerberosMaximumClockTolerance1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:KerberosMaximumClockTolerance", &(a->sai__KerberosOptionsType::KerberosMaximumClockTolerance), "xsd:unsignedInt"))
				{	soap_flag_KerberosMaximumClockTolerance1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__KerberosOptionsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__KerberosOptionsType, 0, sizeof(sai__KerberosOptionsType), 0, soap_copy_sai__KerberosOptionsType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_KerberosRealmName1 > 0 || a->sai__KerberosOptionsType::KerberosSpn.size() > 4 || soap_flag_KerberosKeyVersion1 > 0 || soap_flag_KerberosEncryption1 > 0 || soap_flag_KerberosMasterKey1 > 0 || soap_flag_KerberosMaximumClockTolerance1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__KerberosOptionsType * SOAP_FMAC6 soap_new_sai__KerberosOptionsType(struct soap *soap, int n)
{	return soap_instantiate_sai__KerberosOptionsType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__KerberosOptionsType(struct soap *soap, sai__KerberosOptionsType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__KerberosOptionsType * SOAP_FMAC4 soap_instantiate_sai__KerberosOptionsType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__KerberosOptionsType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__KerberosOptionsType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__KerberosOptionsType;
		if (size)
			*size = sizeof(sai__KerberosOptionsType);
		((sai__KerberosOptionsType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__KerberosOptionsType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__KerberosOptionsType);
		for (int i = 0; i < n; i++)
			((sai__KerberosOptionsType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__KerberosOptionsType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__KerberosOptionsType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__KerberosOptionsType %p -> %p\n", q, p));
	*(sai__KerberosOptionsType*)p = *(sai__KerberosOptionsType*)q;
}

void sai__KerberosSpnType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__KerberosSpnProtocolType(soap, &this->sai__KerberosSpnType::SpnProtocolIndex);
	soap_default__sai__SpnString(soap, &this->sai__KerberosSpnType::SpnString);
	/* transient soap skipped */
}

void sai__KerberosSpnType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize__sai__SpnString(soap, &this->sai__KerberosSpnType::SpnString);
	/* transient soap skipped */
}

int sai__KerberosSpnType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__KerberosSpnType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__KerberosSpnType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__KerberosSpnType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__KerberosSpnType(struct soap *soap, const char *tag, int id, const sai__KerberosSpnType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__KerberosSpnType), type);
	soap_out_sai__KerberosSpnProtocolType(soap, "sai:SpnProtocolIndex", -1, &(a->sai__KerberosSpnType::SpnProtocolIndex), "");
	soap_out__sai__SpnString(soap, "sai:SpnString", -1, &(a->sai__KerberosSpnType::SpnString), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__KerberosSpnType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__KerberosSpnType(soap, this, tag, type);
}

SOAP_FMAC3 sai__KerberosSpnType * SOAP_FMAC4 soap_get_sai__KerberosSpnType(struct soap *soap, sai__KerberosSpnType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__KerberosSpnType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__KerberosSpnType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__KerberosSpnType(soap, tag, this, type);
}

SOAP_FMAC3 sai__KerberosSpnType * SOAP_FMAC4 soap_in_sai__KerberosSpnType(struct soap *soap, const char *tag, sai__KerberosSpnType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__KerberosSpnType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__KerberosSpnType, sizeof(sai__KerberosSpnType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__KerberosSpnType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__KerberosSpnType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_SpnProtocolIndex1 = 1, soap_flag_SpnString1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SpnProtocolIndex1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__KerberosSpnProtocolType(soap, "sai:SpnProtocolIndex", &(a->sai__KerberosSpnType::SpnProtocolIndex), "sai:KerberosSpnProtocolType"))
				{	soap_flag_SpnProtocolIndex1--;
					continue;
				}
			if (soap_flag_SpnString1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__sai__SpnString(soap, "sai:SpnString", &(a->sai__KerberosSpnType::SpnString), ""))
				{	soap_flag_SpnString1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__KerberosSpnType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__KerberosSpnType, 0, sizeof(sai__KerberosSpnType), 0, soap_copy_sai__KerberosSpnType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_SpnProtocolIndex1 > 0 || soap_flag_SpnString1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__KerberosSpnType * SOAP_FMAC6 soap_new_sai__KerberosSpnType(struct soap *soap, int n)
{	return soap_instantiate_sai__KerberosSpnType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__KerberosSpnType(struct soap *soap, sai__KerberosSpnType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__KerberosSpnType * SOAP_FMAC4 soap_instantiate_sai__KerberosSpnType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__KerberosSpnType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__KerberosSpnType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__KerberosSpnType;
		if (size)
			*size = sizeof(sai__KerberosSpnType);
		((sai__KerberosSpnType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__KerberosSpnType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__KerberosSpnType);
		for (int i = 0; i < n; i++)
			((sai__KerberosSpnType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__KerberosSpnType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__KerberosSpnType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__KerberosSpnType %p -> %p\n", q, p));
	*(sai__KerberosSpnType*)p = *(sai__KerberosSpnType*)q;
}

void sai__AdminAclEntryExType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__AclStringType(soap, &this->sai__AdminAclEntryExType::Username);
	this->sai__AdminAclEntryExType::DigestPassword.xsd__base64Binary::soap_default(soap);
	/* transient soap skipped */
}

void sai__AdminAclEntryExType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_sai__AclStringType(soap, &this->sai__AdminAclEntryExType::Username);
	soap_embedded(soap, &this->sai__AdminAclEntryExType::DigestPassword, SOAP_TYPE_xsd__base64Binary);
	this->sai__AdminAclEntryExType::DigestPassword.soap_serialize(soap);
	/* transient soap skipped */
}

int sai__AdminAclEntryExType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__AdminAclEntryExType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__AdminAclEntryExType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__AdminAclEntryExType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__AdminAclEntryExType(struct soap *soap, const char *tag, int id, const sai__AdminAclEntryExType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__AdminAclEntryExType), type);
	soap_out_sai__AclStringType(soap, "sai:Username", -1, &(a->sai__AdminAclEntryExType::Username), "");
	(a->sai__AdminAclEntryExType::DigestPassword).soap_out(soap, "sai:DigestPassword", -1, "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__AdminAclEntryExType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__AdminAclEntryExType(soap, this, tag, type);
}

SOAP_FMAC3 sai__AdminAclEntryExType * SOAP_FMAC4 soap_get_sai__AdminAclEntryExType(struct soap *soap, sai__AdminAclEntryExType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__AdminAclEntryExType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__AdminAclEntryExType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__AdminAclEntryExType(soap, tag, this, type);
}

SOAP_FMAC3 sai__AdminAclEntryExType * SOAP_FMAC4 soap_in_sai__AdminAclEntryExType(struct soap *soap, const char *tag, sai__AdminAclEntryExType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__AdminAclEntryExType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__AdminAclEntryExType, sizeof(sai__AdminAclEntryExType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__AdminAclEntryExType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__AdminAclEntryExType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Username1 = 1, soap_flag_DigestPassword1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Username1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_sai__AclStringType(soap, "sai:Username", &(a->sai__AdminAclEntryExType::Username), "sai:AclStringType"))
				{	soap_flag_Username1--;
					continue;
				}
			if (soap_flag_DigestPassword1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__AdminAclEntryExType::DigestPassword).soap_in(soap, "sai:DigestPassword", "xsd:base64Binary"))
				{	soap_flag_DigestPassword1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__AdminAclEntryExType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__AdminAclEntryExType, 0, sizeof(sai__AdminAclEntryExType), 0, soap_copy_sai__AdminAclEntryExType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Username1 > 0 || soap_flag_DigestPassword1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__AdminAclEntryExType * SOAP_FMAC6 soap_new_sai__AdminAclEntryExType(struct soap *soap, int n)
{	return soap_instantiate_sai__AdminAclEntryExType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__AdminAclEntryExType(struct soap *soap, sai__AdminAclEntryExType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__AdminAclEntryExType * SOAP_FMAC4 soap_instantiate_sai__AdminAclEntryExType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__AdminAclEntryExType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__AdminAclEntryExType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__AdminAclEntryExType;
		if (size)
			*size = sizeof(sai__AdminAclEntryExType);
		((sai__AdminAclEntryExType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__AdminAclEntryExType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__AdminAclEntryExType);
		for (int i = 0; i < n; i++)
			((sai__AdminAclEntryExType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__AdminAclEntryExType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__AdminAclEntryExType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__AdminAclEntryExType %p -> %p\n", q, p));
	*(sai__AdminAclEntryExType*)p = *(sai__AdminAclEntryExType*)q;
}

void sai__UserAclEntryExType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->sai__UserAclEntryExType::__union_UserAclEntryExType = 0;
	soap_default_sai__AccessPermissionType(soap, &this->sai__UserAclEntryExType::AccessPermission);
	this->sai__UserAclEntryExType::Realms = NULL;
	/* transient soap skipped */
}

void sai__UserAclEntryExType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize__sai__union_UserAclEntryExType(soap, this->sai__UserAclEntryExType::__union_UserAclEntryExType, &this->sai__UserAclEntryExType::union_UserAclEntryExType);
	soap_serialize_PointerTosai__UserAclRealmListType(soap, &this->sai__UserAclEntryExType::Realms);
	/* transient soap skipped */
}

int sai__UserAclEntryExType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__UserAclEntryExType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__UserAclEntryExType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__UserAclEntryExType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UserAclEntryExType(struct soap *soap, const char *tag, int id, const sai__UserAclEntryExType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UserAclEntryExType), type);
	soap_out__sai__union_UserAclEntryExType(soap, a->sai__UserAclEntryExType::__union_UserAclEntryExType, &a->sai__UserAclEntryExType::union_UserAclEntryExType);
	soap_out_sai__AccessPermissionType(soap, "sai:AccessPermission", -1, &(a->sai__UserAclEntryExType::AccessPermission), "");
	soap_out_PointerTosai__UserAclRealmListType(soap, "sai:Realms", -1, &(a->sai__UserAclEntryExType::Realms), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__UserAclEntryExType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__UserAclEntryExType(soap, this, tag, type);
}

SOAP_FMAC3 sai__UserAclEntryExType * SOAP_FMAC4 soap_get_sai__UserAclEntryExType(struct soap *soap, sai__UserAclEntryExType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UserAclEntryExType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__UserAclEntryExType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__UserAclEntryExType(soap, tag, this, type);
}

SOAP_FMAC3 sai__UserAclEntryExType * SOAP_FMAC4 soap_in_sai__UserAclEntryExType(struct soap *soap, const char *tag, sai__UserAclEntryExType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__UserAclEntryExType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UserAclEntryExType, sizeof(sai__UserAclEntryExType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__UserAclEntryExType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__UserAclEntryExType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_union_UserAclEntryExType1 = 1, soap_flag_AccessPermission1 = 1, soap_flag_Realms1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_union_UserAclEntryExType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__sai__union_UserAclEntryExType(soap, &a->sai__UserAclEntryExType::__union_UserAclEntryExType, &a->sai__UserAclEntryExType::union_UserAclEntryExType))
				{	soap_flag_union_UserAclEntryExType1 = 0;
					continue;
				}
			if (soap_flag_AccessPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__AccessPermissionType(soap, "sai:AccessPermission", &(a->sai__UserAclEntryExType::AccessPermission), "sai:AccessPermissionType"))
				{	soap_flag_AccessPermission1--;
					continue;
				}
			if (soap_flag_Realms1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosai__UserAclRealmListType(soap, "sai:Realms", &(a->sai__UserAclEntryExType::Realms), "sai:UserAclRealmListType"))
				{	soap_flag_Realms1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__UserAclEntryExType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UserAclEntryExType, 0, sizeof(sai__UserAclEntryExType), 0, soap_copy_sai__UserAclEntryExType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_union_UserAclEntryExType1 || soap_flag_AccessPermission1 > 0 || soap_flag_Realms1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__UserAclEntryExType * SOAP_FMAC6 soap_new_sai__UserAclEntryExType(struct soap *soap, int n)
{	return soap_instantiate_sai__UserAclEntryExType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__UserAclEntryExType(struct soap *soap, sai__UserAclEntryExType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__UserAclEntryExType * SOAP_FMAC4 soap_instantiate_sai__UserAclEntryExType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__UserAclEntryExType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__UserAclEntryExType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__UserAclEntryExType;
		if (size)
			*size = sizeof(sai__UserAclEntryExType);
		((sai__UserAclEntryExType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__UserAclEntryExType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__UserAclEntryExType);
		for (int i = 0; i < n; i++)
			((sai__UserAclEntryExType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__UserAclEntryExType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__UserAclEntryExType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__UserAclEntryExType %p -> %p\n", q, p));
	*(sai__UserAclEntryExType*)p = *(sai__UserAclEntryExType*)q;
}

void sai__UserEntryKerberosType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->sai__UserEntryKerberosType::Sid.xsd__base64Binary::soap_default(soap);
	/* transient soap skipped */
}

void sai__UserEntryKerberosType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__UserEntryKerberosType::Sid, SOAP_TYPE_xsd__base64Binary);
	this->sai__UserEntryKerberosType::Sid.soap_serialize(soap);
	/* transient soap skipped */
}

int sai__UserEntryKerberosType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__UserEntryKerberosType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__UserEntryKerberosType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__UserEntryKerberosType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UserEntryKerberosType(struct soap *soap, const char *tag, int id, const sai__UserEntryKerberosType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UserEntryKerberosType), type);
	(a->sai__UserEntryKerberosType::Sid).soap_out(soap, "sai:Sid", -1, "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__UserEntryKerberosType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__UserEntryKerberosType(soap, this, tag, type);
}

SOAP_FMAC3 sai__UserEntryKerberosType * SOAP_FMAC4 soap_get_sai__UserEntryKerberosType(struct soap *soap, sai__UserEntryKerberosType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UserEntryKerberosType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__UserEntryKerberosType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__UserEntryKerberosType(soap, tag, this, type);
}

SOAP_FMAC3 sai__UserEntryKerberosType * SOAP_FMAC4 soap_in_sai__UserEntryKerberosType(struct soap *soap, const char *tag, sai__UserEntryKerberosType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__UserEntryKerberosType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UserEntryKerberosType, sizeof(sai__UserEntryKerberosType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__UserEntryKerberosType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__UserEntryKerberosType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Sid1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sid1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__UserEntryKerberosType::Sid).soap_in(soap, "sai:Sid", "xsd:base64Binary"))
				{	soap_flag_Sid1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__UserEntryKerberosType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UserEntryKerberosType, 0, sizeof(sai__UserEntryKerberosType), 0, soap_copy_sai__UserEntryKerberosType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Sid1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__UserEntryKerberosType * SOAP_FMAC6 soap_new_sai__UserEntryKerberosType(struct soap *soap, int n)
{	return soap_instantiate_sai__UserEntryKerberosType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__UserEntryKerberosType(struct soap *soap, sai__UserEntryKerberosType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__UserEntryKerberosType * SOAP_FMAC4 soap_instantiate_sai__UserEntryKerberosType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__UserEntryKerberosType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__UserEntryKerberosType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__UserEntryKerberosType;
		if (size)
			*size = sizeof(sai__UserEntryKerberosType);
		((sai__UserEntryKerberosType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__UserEntryKerberosType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__UserEntryKerberosType);
		for (int i = 0; i < n; i++)
			((sai__UserEntryKerberosType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__UserEntryKerberosType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__UserEntryKerberosType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__UserEntryKerberosType %p -> %p\n", q, p));
	*(sai__UserEntryKerberosType*)p = *(sai__UserEntryKerberosType*)q;
}

void sai__UserEntryDigestType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__AclStringType(soap, &this->sai__UserEntryDigestType::Username);
	this->sai__UserEntryDigestType::DigestPassword.xsd__base64Binary::soap_default(soap);
	/* transient soap skipped */
}

void sai__UserEntryDigestType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_sai__AclStringType(soap, &this->sai__UserEntryDigestType::Username);
	soap_embedded(soap, &this->sai__UserEntryDigestType::DigestPassword, SOAP_TYPE_xsd__base64Binary);
	this->sai__UserEntryDigestType::DigestPassword.soap_serialize(soap);
	/* transient soap skipped */
}

int sai__UserEntryDigestType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__UserEntryDigestType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__UserEntryDigestType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__UserEntryDigestType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UserEntryDigestType(struct soap *soap, const char *tag, int id, const sai__UserEntryDigestType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UserEntryDigestType), type);
	soap_out_sai__AclStringType(soap, "sai:Username", -1, &(a->sai__UserEntryDigestType::Username), "");
	(a->sai__UserEntryDigestType::DigestPassword).soap_out(soap, "sai:DigestPassword", -1, "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__UserEntryDigestType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__UserEntryDigestType(soap, this, tag, type);
}

SOAP_FMAC3 sai__UserEntryDigestType * SOAP_FMAC4 soap_get_sai__UserEntryDigestType(struct soap *soap, sai__UserEntryDigestType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UserEntryDigestType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__UserEntryDigestType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__UserEntryDigestType(soap, tag, this, type);
}

SOAP_FMAC3 sai__UserEntryDigestType * SOAP_FMAC4 soap_in_sai__UserEntryDigestType(struct soap *soap, const char *tag, sai__UserEntryDigestType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__UserEntryDigestType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UserEntryDigestType, sizeof(sai__UserEntryDigestType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__UserEntryDigestType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__UserEntryDigestType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Username1 = 1, soap_flag_DigestPassword1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Username1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_sai__AclStringType(soap, "sai:Username", &(a->sai__UserEntryDigestType::Username), "sai:AclStringType"))
				{	soap_flag_Username1--;
					continue;
				}
			if (soap_flag_DigestPassword1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__UserEntryDigestType::DigestPassword).soap_in(soap, "sai:DigestPassword", "xsd:base64Binary"))
				{	soap_flag_DigestPassword1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__UserEntryDigestType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UserEntryDigestType, 0, sizeof(sai__UserEntryDigestType), 0, soap_copy_sai__UserEntryDigestType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Username1 > 0 || soap_flag_DigestPassword1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__UserEntryDigestType * SOAP_FMAC6 soap_new_sai__UserEntryDigestType(struct soap *soap, int n)
{	return soap_instantiate_sai__UserEntryDigestType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__UserEntryDigestType(struct soap *soap, sai__UserEntryDigestType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__UserEntryDigestType * SOAP_FMAC4 soap_instantiate_sai__UserEntryDigestType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__UserEntryDigestType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__UserEntryDigestType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__UserEntryDigestType;
		if (size)
			*size = sizeof(sai__UserEntryDigestType);
		((sai__UserEntryDigestType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__UserEntryDigestType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__UserEntryDigestType);
		for (int i = 0; i < n; i++)
			((sai__UserEntryDigestType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__UserEntryDigestType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__UserEntryDigestType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__UserEntryDigestType %p -> %p\n", q, p));
	*(sai__UserEntryDigestType*)p = *(sai__UserEntryDigestType*)q;
}

void sai__AmtVersion::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_unsignedByte(soap, &this->sai__AmtVersion::major);
	soap_default_unsignedByte(soap, &this->sai__AmtVersion::minor);
	soap_default_unsignedShort(soap, &this->sai__AmtVersion::micro);
	/* transient soap skipped */
}

void sai__AmtVersion::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__AmtVersion::major, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->sai__AmtVersion::minor, SOAP_TYPE_unsignedByte);
	/* transient soap skipped */
}

int sai__AmtVersion::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__AmtVersion);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__AmtVersion::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__AmtVersion(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__AmtVersion(struct soap *soap, const char *tag, int id, const sai__AmtVersion *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__AmtVersion), type);
	soap_out_unsignedByte(soap, "sai:major", -1, &(a->sai__AmtVersion::major), "");
	soap_out_unsignedByte(soap, "sai:minor", -1, &(a->sai__AmtVersion::minor), "");
	soap_out_unsignedShort(soap, "sai:micro", -1, &(a->sai__AmtVersion::micro), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__AmtVersion::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__AmtVersion(soap, this, tag, type);
}

SOAP_FMAC3 sai__AmtVersion * SOAP_FMAC4 soap_get_sai__AmtVersion(struct soap *soap, sai__AmtVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__AmtVersion(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__AmtVersion::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__AmtVersion(soap, tag, this, type);
}

SOAP_FMAC3 sai__AmtVersion * SOAP_FMAC4 soap_in_sai__AmtVersion(struct soap *soap, const char *tag, sai__AmtVersion *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__AmtVersion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__AmtVersion, sizeof(sai__AmtVersion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__AmtVersion)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__AmtVersion *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_major1 = 1, soap_flag_minor1 = 1, soap_flag_micro1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_major1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "sai:major", &(a->sai__AmtVersion::major), "xsd:unsignedByte"))
				{	soap_flag_major1--;
					continue;
				}
			if (soap_flag_minor1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "sai:minor", &(a->sai__AmtVersion::minor), "xsd:unsignedByte"))
				{	soap_flag_minor1--;
					continue;
				}
			if (soap_flag_micro1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedShort(soap, "sai:micro", &(a->sai__AmtVersion::micro), "xsd:unsignedShort"))
				{	soap_flag_micro1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__AmtVersion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__AmtVersion, 0, sizeof(sai__AmtVersion), 0, soap_copy_sai__AmtVersion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_major1 > 0 || soap_flag_minor1 > 0 || soap_flag_micro1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__AmtVersion * SOAP_FMAC6 soap_new_sai__AmtVersion(struct soap *soap, int n)
{	return soap_instantiate_sai__AmtVersion(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__AmtVersion(struct soap *soap, sai__AmtVersion *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__AmtVersion * SOAP_FMAC4 soap_instantiate_sai__AmtVersion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__AmtVersion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__AmtVersion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__AmtVersion;
		if (size)
			*size = sizeof(sai__AmtVersion);
		((sai__AmtVersion*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__AmtVersion[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__AmtVersion);
		for (int i = 0; i < n; i++)
			((sai__AmtVersion*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__AmtVersion*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__AmtVersion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__AmtVersion %p -> %p\n", q, p));
	*(sai__AmtVersion*)p = *(sai__AmtVersion*)q;
}

void sai__UpdateCoreUrlKeyType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_unsignedInt(soap, &this->sai__UpdateCoreUrlKeyType::KeyLength);
	soap_default_unsignedInt(soap, &this->sai__UpdateCoreUrlKeyType::KeyAlgorithm);
	this->sai__UpdateCoreUrlKeyType::KeyData.xsd__base64Binary::soap_default(soap);
	/* transient soap skipped */
}

void sai__UpdateCoreUrlKeyType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__UpdateCoreUrlKeyType::KeyLength, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__UpdateCoreUrlKeyType::KeyAlgorithm, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__UpdateCoreUrlKeyType::KeyData, SOAP_TYPE_xsd__base64Binary);
	this->sai__UpdateCoreUrlKeyType::KeyData.soap_serialize(soap);
	/* transient soap skipped */
}

int sai__UpdateCoreUrlKeyType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__UpdateCoreUrlKeyType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__UpdateCoreUrlKeyType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__UpdateCoreUrlKeyType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UpdateCoreUrlKeyType(struct soap *soap, const char *tag, int id, const sai__UpdateCoreUrlKeyType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UpdateCoreUrlKeyType), type);
	soap_out_unsignedInt(soap, "sai:KeyLength", -1, &(a->sai__UpdateCoreUrlKeyType::KeyLength), "");
	soap_out_unsignedInt(soap, "sai:KeyAlgorithm", -1, &(a->sai__UpdateCoreUrlKeyType::KeyAlgorithm), "");
	(a->sai__UpdateCoreUrlKeyType::KeyData).soap_out(soap, "sai:KeyData", -1, "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__UpdateCoreUrlKeyType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__UpdateCoreUrlKeyType(soap, this, tag, type);
}

SOAP_FMAC3 sai__UpdateCoreUrlKeyType * SOAP_FMAC4 soap_get_sai__UpdateCoreUrlKeyType(struct soap *soap, sai__UpdateCoreUrlKeyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UpdateCoreUrlKeyType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__UpdateCoreUrlKeyType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__UpdateCoreUrlKeyType(soap, tag, this, type);
}

SOAP_FMAC3 sai__UpdateCoreUrlKeyType * SOAP_FMAC4 soap_in_sai__UpdateCoreUrlKeyType(struct soap *soap, const char *tag, sai__UpdateCoreUrlKeyType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__UpdateCoreUrlKeyType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UpdateCoreUrlKeyType, sizeof(sai__UpdateCoreUrlKeyType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__UpdateCoreUrlKeyType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__UpdateCoreUrlKeyType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_KeyLength1 = 1, soap_flag_KeyAlgorithm1 = 1, soap_flag_KeyData1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_KeyLength1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:KeyLength", &(a->sai__UpdateCoreUrlKeyType::KeyLength), "xsd:unsignedInt"))
				{	soap_flag_KeyLength1--;
					continue;
				}
			if (soap_flag_KeyAlgorithm1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:KeyAlgorithm", &(a->sai__UpdateCoreUrlKeyType::KeyAlgorithm), "xsd:unsignedInt"))
				{	soap_flag_KeyAlgorithm1--;
					continue;
				}
			if (soap_flag_KeyData1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__UpdateCoreUrlKeyType::KeyData).soap_in(soap, "sai:KeyData", "xsd:base64Binary"))
				{	soap_flag_KeyData1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__UpdateCoreUrlKeyType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UpdateCoreUrlKeyType, 0, sizeof(sai__UpdateCoreUrlKeyType), 0, soap_copy_sai__UpdateCoreUrlKeyType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_KeyLength1 > 0 || soap_flag_KeyAlgorithm1 > 0 || soap_flag_KeyData1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__UpdateCoreUrlKeyType * SOAP_FMAC6 soap_new_sai__UpdateCoreUrlKeyType(struct soap *soap, int n)
{	return soap_instantiate_sai__UpdateCoreUrlKeyType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__UpdateCoreUrlKeyType(struct soap *soap, sai__UpdateCoreUrlKeyType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__UpdateCoreUrlKeyType * SOAP_FMAC4 soap_instantiate_sai__UpdateCoreUrlKeyType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__UpdateCoreUrlKeyType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__UpdateCoreUrlKeyType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__UpdateCoreUrlKeyType;
		if (size)
			*size = sizeof(sai__UpdateCoreUrlKeyType);
		((sai__UpdateCoreUrlKeyType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__UpdateCoreUrlKeyType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__UpdateCoreUrlKeyType);
		for (int i = 0; i < n; i++)
			((sai__UpdateCoreUrlKeyType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__UpdateCoreUrlKeyType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__UpdateCoreUrlKeyType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__UpdateCoreUrlKeyType %p -> %p\n", q, p));
	*(sai__UpdateCoreUrlKeyType*)p = *(sai__UpdateCoreUrlKeyType*)q;
}

void sai__CertificateChainType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__RsaCertificateEncodingType(soap, &this->sai__CertificateChainType::Encoding);
	soap_default_unsignedInt(soap, &this->sai__CertificateChainType::Length);
	this->sai__CertificateChainType::Value.xsd__base64Binary::soap_default(soap);
	/* transient soap skipped */
}

void sai__CertificateChainType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__CertificateChainType::Length, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__CertificateChainType::Value, SOAP_TYPE_xsd__base64Binary);
	this->sai__CertificateChainType::Value.soap_serialize(soap);
	/* transient soap skipped */
}

int sai__CertificateChainType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__CertificateChainType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__CertificateChainType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__CertificateChainType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__CertificateChainType(struct soap *soap, const char *tag, int id, const sai__CertificateChainType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__CertificateChainType), type);
	soap_out_sai__RsaCertificateEncodingType(soap, "sai:Encoding", -1, &(a->sai__CertificateChainType::Encoding), "");
	soap_out_unsignedInt(soap, "sai:Length", -1, &(a->sai__CertificateChainType::Length), "");
	(a->sai__CertificateChainType::Value).soap_out(soap, "sai:Value", -1, "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__CertificateChainType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__CertificateChainType(soap, this, tag, type);
}

SOAP_FMAC3 sai__CertificateChainType * SOAP_FMAC4 soap_get_sai__CertificateChainType(struct soap *soap, sai__CertificateChainType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__CertificateChainType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__CertificateChainType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__CertificateChainType(soap, tag, this, type);
}

SOAP_FMAC3 sai__CertificateChainType * SOAP_FMAC4 soap_in_sai__CertificateChainType(struct soap *soap, const char *tag, sai__CertificateChainType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__CertificateChainType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__CertificateChainType, sizeof(sai__CertificateChainType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__CertificateChainType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__CertificateChainType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Encoding1 = 1, soap_flag_Length1 = 1, soap_flag_Value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Encoding1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__RsaCertificateEncodingType(soap, "sai:Encoding", &(a->sai__CertificateChainType::Encoding), "sai:RsaCertificateEncodingType"))
				{	soap_flag_Encoding1--;
					continue;
				}
			if (soap_flag_Length1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:Length", &(a->sai__CertificateChainType::Length), "xsd:unsignedInt"))
				{	soap_flag_Length1--;
					continue;
				}
			if (soap_flag_Value1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__CertificateChainType::Value).soap_in(soap, "sai:Value", "xsd:base64Binary"))
				{	soap_flag_Value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__CertificateChainType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__CertificateChainType, 0, sizeof(sai__CertificateChainType), 0, soap_copy_sai__CertificateChainType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Encoding1 > 0 || soap_flag_Length1 > 0 || soap_flag_Value1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__CertificateChainType * SOAP_FMAC6 soap_new_sai__CertificateChainType(struct soap *soap, int n)
{	return soap_instantiate_sai__CertificateChainType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__CertificateChainType(struct soap *soap, sai__CertificateChainType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__CertificateChainType * SOAP_FMAC4 soap_instantiate_sai__CertificateChainType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__CertificateChainType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__CertificateChainType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__CertificateChainType;
		if (size)
			*size = sizeof(sai__CertificateChainType);
		((sai__CertificateChainType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__CertificateChainType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__CertificateChainType);
		for (int i = 0; i < n; i++)
			((sai__CertificateChainType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__CertificateChainType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__CertificateChainType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__CertificateChainType %p -> %p\n", q, p));
	*(sai__CertificateChainType*)p = *(sai__CertificateChainType*)q;
}

void sai__RngKeyType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__RngKeyEncodingType(soap, &this->sai__RngKeyType::Type);
	soap_default_unsignedInt(soap, &this->sai__RngKeyType::Length);
	this->sai__RngKeyType::Data.xsd__base64Binary::soap_default(soap);
	/* transient soap skipped */
}

void sai__RngKeyType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__RngKeyType::Length, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__RngKeyType::Data, SOAP_TYPE_xsd__base64Binary);
	this->sai__RngKeyType::Data.soap_serialize(soap);
	/* transient soap skipped */
}

int sai__RngKeyType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__RngKeyType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__RngKeyType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__RngKeyType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__RngKeyType(struct soap *soap, const char *tag, int id, const sai__RngKeyType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__RngKeyType), type);
	soap_out_sai__RngKeyEncodingType(soap, "sai:Type", -1, &(a->sai__RngKeyType::Type), "");
	soap_out_unsignedInt(soap, "sai:Length", -1, &(a->sai__RngKeyType::Length), "");
	(a->sai__RngKeyType::Data).soap_out(soap, "sai:Data", -1, "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__RngKeyType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__RngKeyType(soap, this, tag, type);
}

SOAP_FMAC3 sai__RngKeyType * SOAP_FMAC4 soap_get_sai__RngKeyType(struct soap *soap, sai__RngKeyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__RngKeyType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__RngKeyType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__RngKeyType(soap, tag, this, type);
}

SOAP_FMAC3 sai__RngKeyType * SOAP_FMAC4 soap_in_sai__RngKeyType(struct soap *soap, const char *tag, sai__RngKeyType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__RngKeyType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__RngKeyType, sizeof(sai__RngKeyType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__RngKeyType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__RngKeyType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Type1 = 1, soap_flag_Length1 = 1, soap_flag_Data1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Type1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__RngKeyEncodingType(soap, "sai:Type", &(a->sai__RngKeyType::Type), "sai:RngKeyEncodingType"))
				{	soap_flag_Type1--;
					continue;
				}
			if (soap_flag_Length1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:Length", &(a->sai__RngKeyType::Length), "xsd:unsignedInt"))
				{	soap_flag_Length1--;
					continue;
				}
			if (soap_flag_Data1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__RngKeyType::Data).soap_in(soap, "sai:Data", "xsd:base64Binary"))
				{	soap_flag_Data1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__RngKeyType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__RngKeyType, 0, sizeof(sai__RngKeyType), 0, soap_copy_sai__RngKeyType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Type1 > 0 || soap_flag_Length1 > 0 || soap_flag_Data1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__RngKeyType * SOAP_FMAC6 soap_new_sai__RngKeyType(struct soap *soap, int n)
{	return soap_instantiate_sai__RngKeyType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__RngKeyType(struct soap *soap, sai__RngKeyType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__RngKeyType * SOAP_FMAC4 soap_instantiate_sai__RngKeyType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__RngKeyType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__RngKeyType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__RngKeyType;
		if (size)
			*size = sizeof(sai__RngKeyType);
		((sai__RngKeyType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__RngKeyType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__RngKeyType);
		for (int i = 0; i < n; i++)
			((sai__RngKeyType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__RngKeyType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__RngKeyType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__RngKeyType %p -> %p\n", q, p));
	*(sai__RngKeyType*)p = *(sai__RngKeyType*)q;
}

void sai__RsaKeyType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__RsaKeyEncodingType(soap, &this->sai__RsaKeyType::Encoding);
	soap_default_unsignedInt(soap, &this->sai__RsaKeyType::Length);
	this->sai__RsaKeyType::Value.xsd__base64Binary::soap_default(soap);
	/* transient soap skipped */
}

void sai__RsaKeyType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->sai__RsaKeyType::Length, SOAP_TYPE_unsignedInt);
	soap_embedded(soap, &this->sai__RsaKeyType::Value, SOAP_TYPE_xsd__base64Binary);
	this->sai__RsaKeyType::Value.soap_serialize(soap);
	/* transient soap skipped */
}

int sai__RsaKeyType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__RsaKeyType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__RsaKeyType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__RsaKeyType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__RsaKeyType(struct soap *soap, const char *tag, int id, const sai__RsaKeyType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__RsaKeyType), type);
	soap_out_sai__RsaKeyEncodingType(soap, "sai:Encoding", -1, &(a->sai__RsaKeyType::Encoding), "");
	soap_out_unsignedInt(soap, "sai:Length", -1, &(a->sai__RsaKeyType::Length), "");
	(a->sai__RsaKeyType::Value).soap_out(soap, "sai:Value", -1, "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__RsaKeyType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__RsaKeyType(soap, this, tag, type);
}

SOAP_FMAC3 sai__RsaKeyType * SOAP_FMAC4 soap_get_sai__RsaKeyType(struct soap *soap, sai__RsaKeyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__RsaKeyType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__RsaKeyType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__RsaKeyType(soap, tag, this, type);
}

SOAP_FMAC3 sai__RsaKeyType * SOAP_FMAC4 soap_in_sai__RsaKeyType(struct soap *soap, const char *tag, sai__RsaKeyType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__RsaKeyType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__RsaKeyType, sizeof(sai__RsaKeyType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__RsaKeyType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__RsaKeyType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Encoding1 = 1, soap_flag_Length1 = 1, soap_flag_Value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Encoding1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_sai__RsaKeyEncodingType(soap, "sai:Encoding", &(a->sai__RsaKeyType::Encoding), "sai:RsaKeyEncodingType"))
				{	soap_flag_Encoding1--;
					continue;
				}
			if (soap_flag_Length1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "sai:Length", &(a->sai__RsaKeyType::Length), "xsd:unsignedInt"))
				{	soap_flag_Length1--;
					continue;
				}
			if (soap_flag_Value1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sai__RsaKeyType::Value).soap_in(soap, "sai:Value", "xsd:base64Binary"))
				{	soap_flag_Value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__RsaKeyType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__RsaKeyType, 0, sizeof(sai__RsaKeyType), 0, soap_copy_sai__RsaKeyType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Encoding1 > 0 || soap_flag_Length1 > 0 || soap_flag_Value1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__RsaKeyType * SOAP_FMAC6 soap_new_sai__RsaKeyType(struct soap *soap, int n)
{	return soap_instantiate_sai__RsaKeyType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__RsaKeyType(struct soap *soap, sai__RsaKeyType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__RsaKeyType * SOAP_FMAC4 soap_instantiate_sai__RsaKeyType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__RsaKeyType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__RsaKeyType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__RsaKeyType;
		if (size)
			*size = sizeof(sai__RsaKeyType);
		((sai__RsaKeyType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__RsaKeyType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__RsaKeyType);
		for (int i = 0; i < n; i++)
			((sai__RsaKeyType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__RsaKeyType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__RsaKeyType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__RsaKeyType %p -> %p\n", q, p));
	*(sai__RsaKeyType*)p = *(sai__RsaKeyType*)q;
}

void sai__UserAclRealmListType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfsai__UserAclRealmType(soap, &this->sai__UserAclRealmListType::Realm);
	/* transient soap skipped */
}

void sai__UserAclRealmListType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfsai__UserAclRealmType(soap, &this->sai__UserAclRealmListType::Realm);
	/* transient soap skipped */
}

int sai__UserAclRealmListType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__UserAclRealmListType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__UserAclRealmListType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__UserAclRealmListType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UserAclRealmListType(struct soap *soap, const char *tag, int id, const sai__UserAclRealmListType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UserAclRealmListType), type);
	soap_out_std__vectorTemplateOfsai__UserAclRealmType(soap, "sai:Realm", -1, &(a->sai__UserAclRealmListType::Realm), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__UserAclRealmListType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__UserAclRealmListType(soap, this, tag, type);
}

SOAP_FMAC3 sai__UserAclRealmListType * SOAP_FMAC4 soap_get_sai__UserAclRealmListType(struct soap *soap, sai__UserAclRealmListType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UserAclRealmListType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__UserAclRealmListType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__UserAclRealmListType(soap, tag, this, type);
}

SOAP_FMAC3 sai__UserAclRealmListType * SOAP_FMAC4 soap_in_sai__UserAclRealmListType(struct soap *soap, const char *tag, sai__UserAclRealmListType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__UserAclRealmListType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UserAclRealmListType, sizeof(sai__UserAclRealmListType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__UserAclRealmListType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__UserAclRealmListType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsai__UserAclRealmType(soap, "sai:Realm", &(a->sai__UserAclRealmListType::Realm), "sai:UserAclRealmType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__UserAclRealmListType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UserAclRealmListType, 0, sizeof(sai__UserAclRealmListType), 0, soap_copy_sai__UserAclRealmListType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->sai__UserAclRealmListType::Realm.size() > 14))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__UserAclRealmListType * SOAP_FMAC6 soap_new_sai__UserAclRealmListType(struct soap *soap, int n)
{	return soap_instantiate_sai__UserAclRealmListType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__UserAclRealmListType(struct soap *soap, sai__UserAclRealmListType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__UserAclRealmListType * SOAP_FMAC4 soap_instantiate_sai__UserAclRealmListType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__UserAclRealmListType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__UserAclRealmListType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__UserAclRealmListType;
		if (size)
			*size = sizeof(sai__UserAclRealmListType);
		((sai__UserAclRealmListType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__UserAclRealmListType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__UserAclRealmListType);
		for (int i = 0; i < n; i++)
			((sai__UserAclRealmListType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__UserAclRealmListType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__UserAclRealmListType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__UserAclRealmListType %p -> %p\n", q, p));
	*(sai__UserAclRealmListType*)p = *(sai__UserAclRealmListType*)q;
}

void sai__UserAclEntryHandleListType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfsai__UserAclEntryHandleType(soap, &this->sai__UserAclEntryHandleListType::Handle);
	/* transient soap skipped */
}

void sai__UserAclEntryHandleListType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfsai__UserAclEntryHandleType(soap, &this->sai__UserAclEntryHandleListType::Handle);
	/* transient soap skipped */
}

int sai__UserAclEntryHandleListType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__UserAclEntryHandleListType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__UserAclEntryHandleListType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__UserAclEntryHandleListType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UserAclEntryHandleListType(struct soap *soap, const char *tag, int id, const sai__UserAclEntryHandleListType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UserAclEntryHandleListType), type);
	soap_out_std__vectorTemplateOfsai__UserAclEntryHandleType(soap, "sai:Handle", -1, &(a->sai__UserAclEntryHandleListType::Handle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__UserAclEntryHandleListType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__UserAclEntryHandleListType(soap, this, tag, type);
}

SOAP_FMAC3 sai__UserAclEntryHandleListType * SOAP_FMAC4 soap_get_sai__UserAclEntryHandleListType(struct soap *soap, sai__UserAclEntryHandleListType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UserAclEntryHandleListType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__UserAclEntryHandleListType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__UserAclEntryHandleListType(soap, tag, this, type);
}

SOAP_FMAC3 sai__UserAclEntryHandleListType * SOAP_FMAC4 soap_in_sai__UserAclEntryHandleListType(struct soap *soap, const char *tag, sai__UserAclEntryHandleListType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__UserAclEntryHandleListType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UserAclEntryHandleListType, sizeof(sai__UserAclEntryHandleListType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__UserAclEntryHandleListType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__UserAclEntryHandleListType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsai__UserAclEntryHandleType(soap, "sai:Handle", &(a->sai__UserAclEntryHandleListType::Handle), "sai:UserAclEntryHandleType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__UserAclEntryHandleListType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UserAclEntryHandleListType, 0, sizeof(sai__UserAclEntryHandleListType), 0, soap_copy_sai__UserAclEntryHandleListType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->sai__UserAclEntryHandleListType::Handle.size() > 7))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__UserAclEntryHandleListType * SOAP_FMAC6 soap_new_sai__UserAclEntryHandleListType(struct soap *soap, int n)
{	return soap_instantiate_sai__UserAclEntryHandleListType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__UserAclEntryHandleListType(struct soap *soap, sai__UserAclEntryHandleListType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__UserAclEntryHandleListType * SOAP_FMAC4 soap_instantiate_sai__UserAclEntryHandleListType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__UserAclEntryHandleListType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__UserAclEntryHandleListType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__UserAclEntryHandleListType;
		if (size)
			*size = sizeof(sai__UserAclEntryHandleListType);
		((sai__UserAclEntryHandleListType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__UserAclEntryHandleListType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__UserAclEntryHandleListType);
		for (int i = 0; i < n; i++)
			((sai__UserAclEntryHandleListType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__UserAclEntryHandleListType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__UserAclEntryHandleListType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__UserAclEntryHandleListType %p -> %p\n", q, p));
	*(sai__UserAclEntryHandleListType*)p = *(sai__UserAclEntryHandleListType*)q;
}

void sai__AdminAclEntryType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__AclStringType(soap, &this->sai__AdminAclEntryType::Username);
	soap_default_sai__AclPasswordStringType(soap, &this->sai__AdminAclEntryType::Password);
	/* transient soap skipped */
}

void sai__AdminAclEntryType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_sai__AclStringType(soap, &this->sai__AdminAclEntryType::Username);
	soap_serialize_sai__AclPasswordStringType(soap, &this->sai__AdminAclEntryType::Password);
	/* transient soap skipped */
}

int sai__AdminAclEntryType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__AdminAclEntryType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__AdminAclEntryType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__AdminAclEntryType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__AdminAclEntryType(struct soap *soap, const char *tag, int id, const sai__AdminAclEntryType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__AdminAclEntryType), type);
	soap_out_sai__AclStringType(soap, "sai:Username", -1, &(a->sai__AdminAclEntryType::Username), "");
	soap_out_sai__AclPasswordStringType(soap, "sai:Password", -1, &(a->sai__AdminAclEntryType::Password), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__AdminAclEntryType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__AdminAclEntryType(soap, this, tag, type);
}

SOAP_FMAC3 sai__AdminAclEntryType * SOAP_FMAC4 soap_get_sai__AdminAclEntryType(struct soap *soap, sai__AdminAclEntryType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__AdminAclEntryType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__AdminAclEntryType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__AdminAclEntryType(soap, tag, this, type);
}

SOAP_FMAC3 sai__AdminAclEntryType * SOAP_FMAC4 soap_in_sai__AdminAclEntryType(struct soap *soap, const char *tag, sai__AdminAclEntryType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__AdminAclEntryType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__AdminAclEntryType, sizeof(sai__AdminAclEntryType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__AdminAclEntryType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__AdminAclEntryType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Username1 = 1, soap_flag_Password1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Username1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_sai__AclStringType(soap, "sai:Username", &(a->sai__AdminAclEntryType::Username), "sai:AclStringType"))
				{	soap_flag_Username1--;
					continue;
				}
			if (soap_flag_Password1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_sai__AclPasswordStringType(soap, "sai:Password", &(a->sai__AdminAclEntryType::Password), "sai:AclPasswordStringType"))
				{	soap_flag_Password1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__AdminAclEntryType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__AdminAclEntryType, 0, sizeof(sai__AdminAclEntryType), 0, soap_copy_sai__AdminAclEntryType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Username1 > 0 || soap_flag_Password1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__AdminAclEntryType * SOAP_FMAC6 soap_new_sai__AdminAclEntryType(struct soap *soap, int n)
{	return soap_instantiate_sai__AdminAclEntryType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__AdminAclEntryType(struct soap *soap, sai__AdminAclEntryType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__AdminAclEntryType * SOAP_FMAC4 soap_instantiate_sai__AdminAclEntryType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__AdminAclEntryType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__AdminAclEntryType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__AdminAclEntryType;
		if (size)
			*size = sizeof(sai__AdminAclEntryType);
		((sai__AdminAclEntryType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__AdminAclEntryType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__AdminAclEntryType);
		for (int i = 0; i < n; i++)
			((sai__AdminAclEntryType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__AdminAclEntryType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__AdminAclEntryType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__AdminAclEntryType %p -> %p\n", q, p));
	*(sai__AdminAclEntryType*)p = *(sai__AdminAclEntryType*)q;
}

void sai__UserAclEntryType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_sai__AclStringType(soap, &this->sai__UserAclEntryType::Username);
	soap_default_sai__AclPasswordStringType(soap, &this->sai__UserAclEntryType::Password);
	this->sai__UserAclEntryType::Realms = NULL;
	/* transient soap skipped */
}

void sai__UserAclEntryType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_sai__AclStringType(soap, &this->sai__UserAclEntryType::Username);
	soap_serialize_sai__AclPasswordStringType(soap, &this->sai__UserAclEntryType::Password);
	soap_serialize_PointerTosai__UserAclRealmListType(soap, &this->sai__UserAclEntryType::Realms);
	/* transient soap skipped */
}

int sai__UserAclEntryType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sai__UserAclEntryType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int sai__UserAclEntryType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sai__UserAclEntryType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sai__UserAclEntryType(struct soap *soap, const char *tag, int id, const sai__UserAclEntryType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sai__UserAclEntryType), type);
	soap_out_sai__AclStringType(soap, "sai:Username", -1, &(a->sai__UserAclEntryType::Username), "");
	soap_out_sai__AclPasswordStringType(soap, "sai:Password", -1, &(a->sai__UserAclEntryType::Password), "");
	soap_out_PointerTosai__UserAclRealmListType(soap, "sai:Realms", -1, &(a->sai__UserAclEntryType::Realms), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *sai__UserAclEntryType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sai__UserAclEntryType(soap, this, tag, type);
}

SOAP_FMAC3 sai__UserAclEntryType * SOAP_FMAC4 soap_get_sai__UserAclEntryType(struct soap *soap, sai__UserAclEntryType *p, const char *tag, const char *type)
{
	if ((p = soap_in_sai__UserAclEntryType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *sai__UserAclEntryType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sai__UserAclEntryType(soap, tag, this, type);
}

SOAP_FMAC3 sai__UserAclEntryType * SOAP_FMAC4 soap_in_sai__UserAclEntryType(struct soap *soap, const char *tag, sai__UserAclEntryType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sai__UserAclEntryType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sai__UserAclEntryType, sizeof(sai__UserAclEntryType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sai__UserAclEntryType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sai__UserAclEntryType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Username1 = 1, soap_flag_Password1 = 1, soap_flag_Realms1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Username1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_sai__AclStringType(soap, "sai:Username", &(a->sai__UserAclEntryType::Username), "sai:AclStringType"))
				{	soap_flag_Username1--;
					continue;
				}
			if (soap_flag_Password1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_sai__AclPasswordStringType(soap, "sai:Password", &(a->sai__UserAclEntryType::Password), "sai:AclPasswordStringType"))
				{	soap_flag_Password1--;
					continue;
				}
			if (soap_flag_Realms1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosai__UserAclRealmListType(soap, "sai:Realms", &(a->sai__UserAclEntryType::Realms), "sai:UserAclRealmListType"))
				{	soap_flag_Realms1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sai__UserAclEntryType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sai__UserAclEntryType, 0, sizeof(sai__UserAclEntryType), 0, soap_copy_sai__UserAclEntryType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Username1 > 0 || soap_flag_Password1 > 0 || soap_flag_Realms1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 sai__UserAclEntryType * SOAP_FMAC6 soap_new_sai__UserAclEntryType(struct soap *soap, int n)
{	return soap_instantiate_sai__UserAclEntryType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_sai__UserAclEntryType(struct soap *soap, sai__UserAclEntryType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 sai__UserAclEntryType * SOAP_FMAC4 soap_instantiate_sai__UserAclEntryType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sai__UserAclEntryType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sai__UserAclEntryType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new sai__UserAclEntryType;
		if (size)
			*size = sizeof(sai__UserAclEntryType);
		((sai__UserAclEntryType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new sai__UserAclEntryType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sai__UserAclEntryType);
		for (int i = 0; i < n; i++)
			((sai__UserAclEntryType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sai__UserAclEntryType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sai__UserAclEntryType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sai__UserAclEntryType %p -> %p\n", q, p));
	*(sai__UserAclEntryType*)p = *(sai__UserAclEntryType*)q;
}

void _emc__SoapAlertResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_cmn__PT_USCORESTATUS(soap, &this->_emc__SoapAlertResponse::Status);
	/* transient soap skipped */
}

void _emc__SoapAlertResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _emc__SoapAlertResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emc__SoapAlertResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emc__SoapAlertResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emc__SoapAlertResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emc__SoapAlertResponse(struct soap *soap, const char *tag, int id, const _emc__SoapAlertResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emc__SoapAlertResponse), type);
	soap_element_result(soap, "emc:Status");
	soap_out_cmn__PT_USCORESTATUS(soap, "emc:Status", -1, &(a->_emc__SoapAlertResponse::Status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emc__SoapAlertResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emc__SoapAlertResponse(soap, this, tag, type);
}

SOAP_FMAC3 _emc__SoapAlertResponse * SOAP_FMAC4 soap_get__emc__SoapAlertResponse(struct soap *soap, _emc__SoapAlertResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__emc__SoapAlertResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emc__SoapAlertResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emc__SoapAlertResponse(soap, tag, this, type);
}

SOAP_FMAC3 _emc__SoapAlertResponse * SOAP_FMAC4 soap_in__emc__SoapAlertResponse(struct soap *soap, const char *tag, _emc__SoapAlertResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emc__SoapAlertResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emc__SoapAlertResponse, sizeof(_emc__SoapAlertResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emc__SoapAlertResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emc__SoapAlertResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_cmn__PT_USCORESTATUS(soap, "emc:Status", &(a->_emc__SoapAlertResponse::Status), "cmn:PT_STATUS"))
				{	soap_flag_Status1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "emc:Status");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emc__SoapAlertResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emc__SoapAlertResponse, 0, sizeof(_emc__SoapAlertResponse), 0, soap_copy__emc__SoapAlertResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Status1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emc__SoapAlertResponse * SOAP_FMAC6 soap_new__emc__SoapAlertResponse(struct soap *soap, int n)
{	return soap_instantiate__emc__SoapAlertResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emc__SoapAlertResponse(struct soap *soap, _emc__SoapAlertResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emc__SoapAlertResponse * SOAP_FMAC4 soap_instantiate__emc__SoapAlertResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emc__SoapAlertResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emc__SoapAlertResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emc__SoapAlertResponse;
		if (size)
			*size = sizeof(_emc__SoapAlertResponse);
		((_emc__SoapAlertResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emc__SoapAlertResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emc__SoapAlertResponse);
		for (int i = 0; i < n; i++)
			((_emc__SoapAlertResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emc__SoapAlertResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emc__SoapAlertResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emc__SoapAlertResponse %p -> %p\n", q, p));
	*(_emc__SoapAlertResponse*)p = *(_emc__SoapAlertResponse*)q;
}

void _emc__SoapAlertRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, &this->_emc__SoapAlertRequest::SoapAlertRecords);
	/* transient soap skipped */
}

void _emc__SoapAlertRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, &this->_emc__SoapAlertRequest::SoapAlertRecords);
	/* transient soap skipped */
}

int _emc__SoapAlertRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emc__SoapAlertRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emc__SoapAlertRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emc__SoapAlertRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emc__SoapAlertRequest(struct soap *soap, const char *tag, int id, const _emc__SoapAlertRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emc__SoapAlertRequest), type);
	soap_out_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, "emc:SoapAlertRecords", -1, &(a->_emc__SoapAlertRequest::SoapAlertRecords), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emc__SoapAlertRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emc__SoapAlertRequest(soap, this, tag, type);
}

SOAP_FMAC3 _emc__SoapAlertRequest * SOAP_FMAC4 soap_get__emc__SoapAlertRequest(struct soap *soap, _emc__SoapAlertRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__emc__SoapAlertRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emc__SoapAlertRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emc__SoapAlertRequest(soap, tag, this, type);
}

SOAP_FMAC3 _emc__SoapAlertRequest * SOAP_FMAC4 soap_in__emc__SoapAlertRequest(struct soap *soap, const char *tag, _emc__SoapAlertRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emc__SoapAlertRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emc__SoapAlertRequest, sizeof(_emc__SoapAlertRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emc__SoapAlertRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emc__SoapAlertRequest *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, "emc:SoapAlertRecords", &(a->_emc__SoapAlertRequest::SoapAlertRecords), "emi:EventLogRecordType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emc__SoapAlertRequest *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emc__SoapAlertRequest, 0, sizeof(_emc__SoapAlertRequest), 0, soap_copy__emc__SoapAlertRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->_emc__SoapAlertRequest::SoapAlertRecords.size() > 64))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emc__SoapAlertRequest * SOAP_FMAC6 soap_new__emc__SoapAlertRequest(struct soap *soap, int n)
{	return soap_instantiate__emc__SoapAlertRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emc__SoapAlertRequest(struct soap *soap, _emc__SoapAlertRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emc__SoapAlertRequest * SOAP_FMAC4 soap_instantiate__emc__SoapAlertRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emc__SoapAlertRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emc__SoapAlertRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emc__SoapAlertRequest;
		if (size)
			*size = sizeof(_emc__SoapAlertRequest);
		((_emc__SoapAlertRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emc__SoapAlertRequest[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emc__SoapAlertRequest);
		for (int i = 0; i < n; i++)
			((_emc__SoapAlertRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emc__SoapAlertRequest*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emc__SoapAlertRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emc__SoapAlertRequest %p -> %p\n", q, p));
	*(_emc__SoapAlertRequest*)p = *(_emc__SoapAlertRequest*)q;
}

void _emi__GetGeneralAlertSubscriptionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_emi__PT_USCORESTATUS(soap, &this->_emi__GetGeneralAlertSubscriptionResponse::Status);
	this->_emi__GetGeneralAlertSubscriptionResponse::SubscriptionInfo = NULL;
	/* transient soap skipped */
}

void _emi__GetGeneralAlertSubscriptionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToemi__AlertSubscriptionGeneralType(soap, &this->_emi__GetGeneralAlertSubscriptionResponse::SubscriptionInfo);
	/* transient soap skipped */
}

int _emi__GetGeneralAlertSubscriptionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emi__GetGeneralAlertSubscriptionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emi__GetGeneralAlertSubscriptionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__GetGeneralAlertSubscriptionResponse(struct soap *soap, const char *tag, int id, const _emi__GetGeneralAlertSubscriptionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse), type);
	soap_out_emi__PT_USCORESTATUS(soap, "emi:Status", -1, &(a->_emi__GetGeneralAlertSubscriptionResponse::Status), "");
	soap_out_PointerToemi__AlertSubscriptionGeneralType(soap, "emi:SubscriptionInfo", -1, &(a->_emi__GetGeneralAlertSubscriptionResponse::SubscriptionInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emi__GetGeneralAlertSubscriptionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emi__GetGeneralAlertSubscriptionResponse(soap, this, tag, type);
}

SOAP_FMAC3 _emi__GetGeneralAlertSubscriptionResponse * SOAP_FMAC4 soap_get__emi__GetGeneralAlertSubscriptionResponse(struct soap *soap, _emi__GetGeneralAlertSubscriptionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__emi__GetGeneralAlertSubscriptionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emi__GetGeneralAlertSubscriptionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emi__GetGeneralAlertSubscriptionResponse(soap, tag, this, type);
}

SOAP_FMAC3 _emi__GetGeneralAlertSubscriptionResponse * SOAP_FMAC4 soap_in__emi__GetGeneralAlertSubscriptionResponse(struct soap *soap, const char *tag, _emi__GetGeneralAlertSubscriptionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emi__GetGeneralAlertSubscriptionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse, sizeof(_emi__GetGeneralAlertSubscriptionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emi__GetGeneralAlertSubscriptionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Status1 = 1, soap_flag_SubscriptionInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__PT_USCORESTATUS(soap, "emi:Status", &(a->_emi__GetGeneralAlertSubscriptionResponse::Status), "emi:PT_STATUS"))
				{	soap_flag_Status1--;
					continue;
				}
			if (soap_flag_SubscriptionInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToemi__AlertSubscriptionGeneralType(soap, "emi:SubscriptionInfo", &(a->_emi__GetGeneralAlertSubscriptionResponse::SubscriptionInfo), "emi:AlertSubscriptionGeneralType"))
				{	soap_flag_SubscriptionInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emi__GetGeneralAlertSubscriptionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse, 0, sizeof(_emi__GetGeneralAlertSubscriptionResponse), 0, soap_copy__emi__GetGeneralAlertSubscriptionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Status1 > 0 || soap_flag_SubscriptionInfo1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emi__GetGeneralAlertSubscriptionResponse * SOAP_FMAC6 soap_new__emi__GetGeneralAlertSubscriptionResponse(struct soap *soap, int n)
{	return soap_instantiate__emi__GetGeneralAlertSubscriptionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emi__GetGeneralAlertSubscriptionResponse(struct soap *soap, _emi__GetGeneralAlertSubscriptionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emi__GetGeneralAlertSubscriptionResponse * SOAP_FMAC4 soap_instantiate__emi__GetGeneralAlertSubscriptionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emi__GetGeneralAlertSubscriptionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emi__GetGeneralAlertSubscriptionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emi__GetGeneralAlertSubscriptionResponse;
		if (size)
			*size = sizeof(_emi__GetGeneralAlertSubscriptionResponse);
		((_emi__GetGeneralAlertSubscriptionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emi__GetGeneralAlertSubscriptionResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emi__GetGeneralAlertSubscriptionResponse);
		for (int i = 0; i < n; i++)
			((_emi__GetGeneralAlertSubscriptionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emi__GetGeneralAlertSubscriptionResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emi__GetGeneralAlertSubscriptionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emi__GetGeneralAlertSubscriptionResponse %p -> %p\n", q, p));
	*(_emi__GetGeneralAlertSubscriptionResponse*)p = *(_emi__GetGeneralAlertSubscriptionResponse*)q;
}

void _emi__GetGeneralAlertSubscription::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_emi__AlertSubscriptionHandleType(soap, &this->_emi__GetGeneralAlertSubscription::SubscriptionHandle);
	/* transient soap skipped */
}

void _emi__GetGeneralAlertSubscription::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _emi__GetGeneralAlertSubscription::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emi__GetGeneralAlertSubscription);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emi__GetGeneralAlertSubscription::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emi__GetGeneralAlertSubscription(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__GetGeneralAlertSubscription(struct soap *soap, const char *tag, int id, const _emi__GetGeneralAlertSubscription *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emi__GetGeneralAlertSubscription), type);
	soap_out_emi__AlertSubscriptionHandleType(soap, "emi:SubscriptionHandle", -1, &(a->_emi__GetGeneralAlertSubscription::SubscriptionHandle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emi__GetGeneralAlertSubscription::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emi__GetGeneralAlertSubscription(soap, this, tag, type);
}

SOAP_FMAC3 _emi__GetGeneralAlertSubscription * SOAP_FMAC4 soap_get__emi__GetGeneralAlertSubscription(struct soap *soap, _emi__GetGeneralAlertSubscription *p, const char *tag, const char *type)
{
	if ((p = soap_in__emi__GetGeneralAlertSubscription(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emi__GetGeneralAlertSubscription::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emi__GetGeneralAlertSubscription(soap, tag, this, type);
}

SOAP_FMAC3 _emi__GetGeneralAlertSubscription * SOAP_FMAC4 soap_in__emi__GetGeneralAlertSubscription(struct soap *soap, const char *tag, _emi__GetGeneralAlertSubscription *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emi__GetGeneralAlertSubscription *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emi__GetGeneralAlertSubscription, sizeof(_emi__GetGeneralAlertSubscription), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emi__GetGeneralAlertSubscription)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emi__GetGeneralAlertSubscription *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_SubscriptionHandle1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SubscriptionHandle1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__AlertSubscriptionHandleType(soap, "emi:SubscriptionHandle", &(a->_emi__GetGeneralAlertSubscription::SubscriptionHandle), "emi:AlertSubscriptionHandleType"))
				{	soap_flag_SubscriptionHandle1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emi__GetGeneralAlertSubscription *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emi__GetGeneralAlertSubscription, 0, sizeof(_emi__GetGeneralAlertSubscription), 0, soap_copy__emi__GetGeneralAlertSubscription);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_SubscriptionHandle1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emi__GetGeneralAlertSubscription * SOAP_FMAC6 soap_new__emi__GetGeneralAlertSubscription(struct soap *soap, int n)
{	return soap_instantiate__emi__GetGeneralAlertSubscription(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emi__GetGeneralAlertSubscription(struct soap *soap, _emi__GetGeneralAlertSubscription *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emi__GetGeneralAlertSubscription * SOAP_FMAC4 soap_instantiate__emi__GetGeneralAlertSubscription(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emi__GetGeneralAlertSubscription(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emi__GetGeneralAlertSubscription, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emi__GetGeneralAlertSubscription;
		if (size)
			*size = sizeof(_emi__GetGeneralAlertSubscription);
		((_emi__GetGeneralAlertSubscription*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emi__GetGeneralAlertSubscription[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emi__GetGeneralAlertSubscription);
		for (int i = 0; i < n; i++)
			((_emi__GetGeneralAlertSubscription*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emi__GetGeneralAlertSubscription*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emi__GetGeneralAlertSubscription(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emi__GetGeneralAlertSubscription %p -> %p\n", q, p));
	*(_emi__GetGeneralAlertSubscription*)p = *(_emi__GetGeneralAlertSubscription*)q;
}

void _emi__EnumerateGeneralAlertSubscriptionsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_emi__PT_USCORESTATUS(soap, &this->_emi__EnumerateGeneralAlertSubscriptionsResponse::Status);
	soap_default_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, &this->_emi__EnumerateGeneralAlertSubscriptionsResponse::SubscriptionHandle);
	/* transient soap skipped */
}

void _emi__EnumerateGeneralAlertSubscriptionsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, &this->_emi__EnumerateGeneralAlertSubscriptionsResponse::SubscriptionHandle);
	/* transient soap skipped */
}

int _emi__EnumerateGeneralAlertSubscriptionsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emi__EnumerateGeneralAlertSubscriptionsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emi__EnumerateGeneralAlertSubscriptionsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__EnumerateGeneralAlertSubscriptionsResponse(struct soap *soap, const char *tag, int id, const _emi__EnumerateGeneralAlertSubscriptionsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse), type);
	soap_out_emi__PT_USCORESTATUS(soap, "emi:Status", -1, &(a->_emi__EnumerateGeneralAlertSubscriptionsResponse::Status), "");
	soap_out_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, "emi:SubscriptionHandle", -1, &(a->_emi__EnumerateGeneralAlertSubscriptionsResponse::SubscriptionHandle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emi__EnumerateGeneralAlertSubscriptionsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emi__EnumerateGeneralAlertSubscriptionsResponse(soap, this, tag, type);
}

SOAP_FMAC3 _emi__EnumerateGeneralAlertSubscriptionsResponse * SOAP_FMAC4 soap_get__emi__EnumerateGeneralAlertSubscriptionsResponse(struct soap *soap, _emi__EnumerateGeneralAlertSubscriptionsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__emi__EnumerateGeneralAlertSubscriptionsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emi__EnumerateGeneralAlertSubscriptionsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emi__EnumerateGeneralAlertSubscriptionsResponse(soap, tag, this, type);
}

SOAP_FMAC3 _emi__EnumerateGeneralAlertSubscriptionsResponse * SOAP_FMAC4 soap_in__emi__EnumerateGeneralAlertSubscriptionsResponse(struct soap *soap, const char *tag, _emi__EnumerateGeneralAlertSubscriptionsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emi__EnumerateGeneralAlertSubscriptionsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse, sizeof(_emi__EnumerateGeneralAlertSubscriptionsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emi__EnumerateGeneralAlertSubscriptionsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__PT_USCORESTATUS(soap, "emi:Status", &(a->_emi__EnumerateGeneralAlertSubscriptionsResponse::Status), "emi:PT_STATUS"))
				{	soap_flag_Status1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, "emi:SubscriptionHandle", &(a->_emi__EnumerateGeneralAlertSubscriptionsResponse::SubscriptionHandle), "emi:AlertSubscriptionHandleType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emi__EnumerateGeneralAlertSubscriptionsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse, 0, sizeof(_emi__EnumerateGeneralAlertSubscriptionsResponse), 0, soap_copy__emi__EnumerateGeneralAlertSubscriptionsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Status1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emi__EnumerateGeneralAlertSubscriptionsResponse * SOAP_FMAC6 soap_new__emi__EnumerateGeneralAlertSubscriptionsResponse(struct soap *soap, int n)
{	return soap_instantiate__emi__EnumerateGeneralAlertSubscriptionsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emi__EnumerateGeneralAlertSubscriptionsResponse(struct soap *soap, _emi__EnumerateGeneralAlertSubscriptionsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emi__EnumerateGeneralAlertSubscriptionsResponse * SOAP_FMAC4 soap_instantiate__emi__EnumerateGeneralAlertSubscriptionsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emi__EnumerateGeneralAlertSubscriptionsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptionsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emi__EnumerateGeneralAlertSubscriptionsResponse;
		if (size)
			*size = sizeof(_emi__EnumerateGeneralAlertSubscriptionsResponse);
		((_emi__EnumerateGeneralAlertSubscriptionsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emi__EnumerateGeneralAlertSubscriptionsResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emi__EnumerateGeneralAlertSubscriptionsResponse);
		for (int i = 0; i < n; i++)
			((_emi__EnumerateGeneralAlertSubscriptionsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emi__EnumerateGeneralAlertSubscriptionsResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emi__EnumerateGeneralAlertSubscriptionsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emi__EnumerateGeneralAlertSubscriptionsResponse %p -> %p\n", q, p));
	*(_emi__EnumerateGeneralAlertSubscriptionsResponse*)p = *(_emi__EnumerateGeneralAlertSubscriptionsResponse*)q;
}

void _emi__EnumerateGeneralAlertSubscriptions::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_emi__EnumerateGeneralAlertSubscriptions::PolicyID = NULL;
	/* transient soap skipped */
}

void _emi__EnumerateGeneralAlertSubscriptions::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToemi__AlertSubscriptionPolicyIDType(soap, &this->_emi__EnumerateGeneralAlertSubscriptions::PolicyID);
	/* transient soap skipped */
}

int _emi__EnumerateGeneralAlertSubscriptions::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emi__EnumerateGeneralAlertSubscriptions::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emi__EnumerateGeneralAlertSubscriptions(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__EnumerateGeneralAlertSubscriptions(struct soap *soap, const char *tag, int id, const _emi__EnumerateGeneralAlertSubscriptions *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions), type);
	soap_out_PointerToemi__AlertSubscriptionPolicyIDType(soap, "emi:PolicyID", -1, &(a->_emi__EnumerateGeneralAlertSubscriptions::PolicyID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emi__EnumerateGeneralAlertSubscriptions::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emi__EnumerateGeneralAlertSubscriptions(soap, this, tag, type);
}

SOAP_FMAC3 _emi__EnumerateGeneralAlertSubscriptions * SOAP_FMAC4 soap_get__emi__EnumerateGeneralAlertSubscriptions(struct soap *soap, _emi__EnumerateGeneralAlertSubscriptions *p, const char *tag, const char *type)
{
	if ((p = soap_in__emi__EnumerateGeneralAlertSubscriptions(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emi__EnumerateGeneralAlertSubscriptions::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emi__EnumerateGeneralAlertSubscriptions(soap, tag, this, type);
}

SOAP_FMAC3 _emi__EnumerateGeneralAlertSubscriptions * SOAP_FMAC4 soap_in__emi__EnumerateGeneralAlertSubscriptions(struct soap *soap, const char *tag, _emi__EnumerateGeneralAlertSubscriptions *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emi__EnumerateGeneralAlertSubscriptions *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions, sizeof(_emi__EnumerateGeneralAlertSubscriptions), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emi__EnumerateGeneralAlertSubscriptions *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_PolicyID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_PolicyID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToemi__AlertSubscriptionPolicyIDType(soap, "emi:PolicyID", &(a->_emi__EnumerateGeneralAlertSubscriptions::PolicyID), "emi:AlertSubscriptionPolicyIDType"))
				{	soap_flag_PolicyID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emi__EnumerateGeneralAlertSubscriptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions, 0, sizeof(_emi__EnumerateGeneralAlertSubscriptions), 0, soap_copy__emi__EnumerateGeneralAlertSubscriptions);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _emi__EnumerateGeneralAlertSubscriptions * SOAP_FMAC6 soap_new__emi__EnumerateGeneralAlertSubscriptions(struct soap *soap, int n)
{	return soap_instantiate__emi__EnumerateGeneralAlertSubscriptions(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emi__EnumerateGeneralAlertSubscriptions(struct soap *soap, _emi__EnumerateGeneralAlertSubscriptions *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emi__EnumerateGeneralAlertSubscriptions * SOAP_FMAC4 soap_instantiate__emi__EnumerateGeneralAlertSubscriptions(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emi__EnumerateGeneralAlertSubscriptions(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emi__EnumerateGeneralAlertSubscriptions, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emi__EnumerateGeneralAlertSubscriptions;
		if (size)
			*size = sizeof(_emi__EnumerateGeneralAlertSubscriptions);
		((_emi__EnumerateGeneralAlertSubscriptions*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emi__EnumerateGeneralAlertSubscriptions[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emi__EnumerateGeneralAlertSubscriptions);
		for (int i = 0; i < n; i++)
			((_emi__EnumerateGeneralAlertSubscriptions*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emi__EnumerateGeneralAlertSubscriptions*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emi__EnumerateGeneralAlertSubscriptions(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emi__EnumerateGeneralAlertSubscriptions %p -> %p\n", q, p));
	*(_emi__EnumerateGeneralAlertSubscriptions*)p = *(_emi__EnumerateGeneralAlertSubscriptions*)q;
}

void _emi__SubscribeForGeneralAlertResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_emi__PT_USCORESTATUS(soap, &this->_emi__SubscribeForGeneralAlertResponse::Status);
	soap_default_emi__AlertSubscriptionHandleType(soap, &this->_emi__SubscribeForGeneralAlertResponse::SubscriptionHandle);
	/* transient soap skipped */
}

void _emi__SubscribeForGeneralAlertResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _emi__SubscribeForGeneralAlertResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emi__SubscribeForGeneralAlertResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emi__SubscribeForGeneralAlertResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emi__SubscribeForGeneralAlertResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__SubscribeForGeneralAlertResponse(struct soap *soap, const char *tag, int id, const _emi__SubscribeForGeneralAlertResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emi__SubscribeForGeneralAlertResponse), type);
	soap_out_emi__PT_USCORESTATUS(soap, "emi:Status", -1, &(a->_emi__SubscribeForGeneralAlertResponse::Status), "");
	soap_out_emi__AlertSubscriptionHandleType(soap, "emi:SubscriptionHandle", -1, &(a->_emi__SubscribeForGeneralAlertResponse::SubscriptionHandle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emi__SubscribeForGeneralAlertResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emi__SubscribeForGeneralAlertResponse(soap, this, tag, type);
}

SOAP_FMAC3 _emi__SubscribeForGeneralAlertResponse * SOAP_FMAC4 soap_get__emi__SubscribeForGeneralAlertResponse(struct soap *soap, _emi__SubscribeForGeneralAlertResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__emi__SubscribeForGeneralAlertResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emi__SubscribeForGeneralAlertResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emi__SubscribeForGeneralAlertResponse(soap, tag, this, type);
}

SOAP_FMAC3 _emi__SubscribeForGeneralAlertResponse * SOAP_FMAC4 soap_in__emi__SubscribeForGeneralAlertResponse(struct soap *soap, const char *tag, _emi__SubscribeForGeneralAlertResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emi__SubscribeForGeneralAlertResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emi__SubscribeForGeneralAlertResponse, sizeof(_emi__SubscribeForGeneralAlertResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emi__SubscribeForGeneralAlertResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emi__SubscribeForGeneralAlertResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Status1 = 1, soap_flag_SubscriptionHandle1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__PT_USCORESTATUS(soap, "emi:Status", &(a->_emi__SubscribeForGeneralAlertResponse::Status), "emi:PT_STATUS"))
				{	soap_flag_Status1--;
					continue;
				}
			if (soap_flag_SubscriptionHandle1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__AlertSubscriptionHandleType(soap, "emi:SubscriptionHandle", &(a->_emi__SubscribeForGeneralAlertResponse::SubscriptionHandle), "emi:AlertSubscriptionHandleType"))
				{	soap_flag_SubscriptionHandle1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emi__SubscribeForGeneralAlertResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emi__SubscribeForGeneralAlertResponse, 0, sizeof(_emi__SubscribeForGeneralAlertResponse), 0, soap_copy__emi__SubscribeForGeneralAlertResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Status1 > 0 || soap_flag_SubscriptionHandle1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emi__SubscribeForGeneralAlertResponse * SOAP_FMAC6 soap_new__emi__SubscribeForGeneralAlertResponse(struct soap *soap, int n)
{	return soap_instantiate__emi__SubscribeForGeneralAlertResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emi__SubscribeForGeneralAlertResponse(struct soap *soap, _emi__SubscribeForGeneralAlertResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emi__SubscribeForGeneralAlertResponse * SOAP_FMAC4 soap_instantiate__emi__SubscribeForGeneralAlertResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emi__SubscribeForGeneralAlertResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emi__SubscribeForGeneralAlertResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emi__SubscribeForGeneralAlertResponse;
		if (size)
			*size = sizeof(_emi__SubscribeForGeneralAlertResponse);
		((_emi__SubscribeForGeneralAlertResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emi__SubscribeForGeneralAlertResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emi__SubscribeForGeneralAlertResponse);
		for (int i = 0; i < n; i++)
			((_emi__SubscribeForGeneralAlertResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emi__SubscribeForGeneralAlertResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emi__SubscribeForGeneralAlertResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emi__SubscribeForGeneralAlertResponse %p -> %p\n", q, p));
	*(_emi__SubscribeForGeneralAlertResponse*)p = *(_emi__SubscribeForGeneralAlertResponse*)q;
}

void _emi__SubscribeForGeneralAlert::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_emi__SubscribeForGeneralAlert::SubscriptionInfo = NULL;
	/* transient soap skipped */
}

void _emi__SubscribeForGeneralAlert::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToemi__AlertSubscriptionGeneralType(soap, &this->_emi__SubscribeForGeneralAlert::SubscriptionInfo);
	/* transient soap skipped */
}

int _emi__SubscribeForGeneralAlert::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emi__SubscribeForGeneralAlert);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emi__SubscribeForGeneralAlert::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emi__SubscribeForGeneralAlert(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__SubscribeForGeneralAlert(struct soap *soap, const char *tag, int id, const _emi__SubscribeForGeneralAlert *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emi__SubscribeForGeneralAlert), type);
	soap_out_PointerToemi__AlertSubscriptionGeneralType(soap, "emi:SubscriptionInfo", -1, &(a->_emi__SubscribeForGeneralAlert::SubscriptionInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emi__SubscribeForGeneralAlert::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emi__SubscribeForGeneralAlert(soap, this, tag, type);
}

SOAP_FMAC3 _emi__SubscribeForGeneralAlert * SOAP_FMAC4 soap_get__emi__SubscribeForGeneralAlert(struct soap *soap, _emi__SubscribeForGeneralAlert *p, const char *tag, const char *type)
{
	if ((p = soap_in__emi__SubscribeForGeneralAlert(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emi__SubscribeForGeneralAlert::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emi__SubscribeForGeneralAlert(soap, tag, this, type);
}

SOAP_FMAC3 _emi__SubscribeForGeneralAlert * SOAP_FMAC4 soap_in__emi__SubscribeForGeneralAlert(struct soap *soap, const char *tag, _emi__SubscribeForGeneralAlert *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emi__SubscribeForGeneralAlert *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emi__SubscribeForGeneralAlert, sizeof(_emi__SubscribeForGeneralAlert), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emi__SubscribeForGeneralAlert)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emi__SubscribeForGeneralAlert *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_SubscriptionInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SubscriptionInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToemi__AlertSubscriptionGeneralType(soap, "emi:SubscriptionInfo", &(a->_emi__SubscribeForGeneralAlert::SubscriptionInfo), "emi:AlertSubscriptionGeneralType"))
				{	soap_flag_SubscriptionInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emi__SubscribeForGeneralAlert *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emi__SubscribeForGeneralAlert, 0, sizeof(_emi__SubscribeForGeneralAlert), 0, soap_copy__emi__SubscribeForGeneralAlert);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_SubscriptionInfo1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emi__SubscribeForGeneralAlert * SOAP_FMAC6 soap_new__emi__SubscribeForGeneralAlert(struct soap *soap, int n)
{	return soap_instantiate__emi__SubscribeForGeneralAlert(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emi__SubscribeForGeneralAlert(struct soap *soap, _emi__SubscribeForGeneralAlert *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emi__SubscribeForGeneralAlert * SOAP_FMAC4 soap_instantiate__emi__SubscribeForGeneralAlert(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emi__SubscribeForGeneralAlert(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emi__SubscribeForGeneralAlert, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emi__SubscribeForGeneralAlert;
		if (size)
			*size = sizeof(_emi__SubscribeForGeneralAlert);
		((_emi__SubscribeForGeneralAlert*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emi__SubscribeForGeneralAlert[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emi__SubscribeForGeneralAlert);
		for (int i = 0; i < n; i++)
			((_emi__SubscribeForGeneralAlert*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emi__SubscribeForGeneralAlert*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emi__SubscribeForGeneralAlert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emi__SubscribeForGeneralAlert %p -> %p\n", q, p));
	*(_emi__SubscribeForGeneralAlert*)p = *(_emi__SubscribeForGeneralAlert*)q;
}

void _emi__CancelAlertSubscriptionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_emi__PT_USCORESTATUS(soap, &this->_emi__CancelAlertSubscriptionResponse::Status);
	/* transient soap skipped */
}

void _emi__CancelAlertSubscriptionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _emi__CancelAlertSubscriptionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emi__CancelAlertSubscriptionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emi__CancelAlertSubscriptionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emi__CancelAlertSubscriptionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__CancelAlertSubscriptionResponse(struct soap *soap, const char *tag, int id, const _emi__CancelAlertSubscriptionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emi__CancelAlertSubscriptionResponse), type);
	soap_out_emi__PT_USCORESTATUS(soap, "emi:Status", -1, &(a->_emi__CancelAlertSubscriptionResponse::Status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emi__CancelAlertSubscriptionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emi__CancelAlertSubscriptionResponse(soap, this, tag, type);
}

SOAP_FMAC3 _emi__CancelAlertSubscriptionResponse * SOAP_FMAC4 soap_get__emi__CancelAlertSubscriptionResponse(struct soap *soap, _emi__CancelAlertSubscriptionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__emi__CancelAlertSubscriptionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emi__CancelAlertSubscriptionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emi__CancelAlertSubscriptionResponse(soap, tag, this, type);
}

SOAP_FMAC3 _emi__CancelAlertSubscriptionResponse * SOAP_FMAC4 soap_in__emi__CancelAlertSubscriptionResponse(struct soap *soap, const char *tag, _emi__CancelAlertSubscriptionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emi__CancelAlertSubscriptionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emi__CancelAlertSubscriptionResponse, sizeof(_emi__CancelAlertSubscriptionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emi__CancelAlertSubscriptionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emi__CancelAlertSubscriptionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__PT_USCORESTATUS(soap, "emi:Status", &(a->_emi__CancelAlertSubscriptionResponse::Status), "emi:PT_STATUS"))
				{	soap_flag_Status1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emi__CancelAlertSubscriptionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emi__CancelAlertSubscriptionResponse, 0, sizeof(_emi__CancelAlertSubscriptionResponse), 0, soap_copy__emi__CancelAlertSubscriptionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Status1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emi__CancelAlertSubscriptionResponse * SOAP_FMAC6 soap_new__emi__CancelAlertSubscriptionResponse(struct soap *soap, int n)
{	return soap_instantiate__emi__CancelAlertSubscriptionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emi__CancelAlertSubscriptionResponse(struct soap *soap, _emi__CancelAlertSubscriptionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emi__CancelAlertSubscriptionResponse * SOAP_FMAC4 soap_instantiate__emi__CancelAlertSubscriptionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emi__CancelAlertSubscriptionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emi__CancelAlertSubscriptionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emi__CancelAlertSubscriptionResponse;
		if (size)
			*size = sizeof(_emi__CancelAlertSubscriptionResponse);
		((_emi__CancelAlertSubscriptionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emi__CancelAlertSubscriptionResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emi__CancelAlertSubscriptionResponse);
		for (int i = 0; i < n; i++)
			((_emi__CancelAlertSubscriptionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emi__CancelAlertSubscriptionResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emi__CancelAlertSubscriptionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emi__CancelAlertSubscriptionResponse %p -> %p\n", q, p));
	*(_emi__CancelAlertSubscriptionResponse*)p = *(_emi__CancelAlertSubscriptionResponse*)q;
}

void _emi__CancelAlertSubscription::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_emi__AlertSubscriptionHandleType(soap, &this->_emi__CancelAlertSubscription::SubscriptionHandle);
	/* transient soap skipped */
}

void _emi__CancelAlertSubscription::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _emi__CancelAlertSubscription::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__emi__CancelAlertSubscription);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _emi__CancelAlertSubscription::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__emi__CancelAlertSubscription(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__CancelAlertSubscription(struct soap *soap, const char *tag, int id, const _emi__CancelAlertSubscription *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__emi__CancelAlertSubscription), type);
	soap_out_emi__AlertSubscriptionHandleType(soap, "emi:SubscriptionHandle", -1, &(a->_emi__CancelAlertSubscription::SubscriptionHandle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_emi__CancelAlertSubscription::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__emi__CancelAlertSubscription(soap, this, tag, type);
}

SOAP_FMAC3 _emi__CancelAlertSubscription * SOAP_FMAC4 soap_get__emi__CancelAlertSubscription(struct soap *soap, _emi__CancelAlertSubscription *p, const char *tag, const char *type)
{
	if ((p = soap_in__emi__CancelAlertSubscription(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_emi__CancelAlertSubscription::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__emi__CancelAlertSubscription(soap, tag, this, type);
}

SOAP_FMAC3 _emi__CancelAlertSubscription * SOAP_FMAC4 soap_in__emi__CancelAlertSubscription(struct soap *soap, const char *tag, _emi__CancelAlertSubscription *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_emi__CancelAlertSubscription *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__emi__CancelAlertSubscription, sizeof(_emi__CancelAlertSubscription), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__emi__CancelAlertSubscription)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_emi__CancelAlertSubscription *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_SubscriptionHandle1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SubscriptionHandle1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__AlertSubscriptionHandleType(soap, "emi:SubscriptionHandle", &(a->_emi__CancelAlertSubscription::SubscriptionHandle), "emi:AlertSubscriptionHandleType"))
				{	soap_flag_SubscriptionHandle1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_emi__CancelAlertSubscription *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__emi__CancelAlertSubscription, 0, sizeof(_emi__CancelAlertSubscription), 0, soap_copy__emi__CancelAlertSubscription);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_SubscriptionHandle1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 _emi__CancelAlertSubscription * SOAP_FMAC6 soap_new__emi__CancelAlertSubscription(struct soap *soap, int n)
{	return soap_instantiate__emi__CancelAlertSubscription(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__emi__CancelAlertSubscription(struct soap *soap, _emi__CancelAlertSubscription *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _emi__CancelAlertSubscription * SOAP_FMAC4 soap_instantiate__emi__CancelAlertSubscription(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__emi__CancelAlertSubscription(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__emi__CancelAlertSubscription, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _emi__CancelAlertSubscription;
		if (size)
			*size = sizeof(_emi__CancelAlertSubscription);
		((_emi__CancelAlertSubscription*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _emi__CancelAlertSubscription[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_emi__CancelAlertSubscription);
		for (int i = 0; i < n; i++)
			((_emi__CancelAlertSubscription*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_emi__CancelAlertSubscription*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy__emi__CancelAlertSubscription(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _emi__CancelAlertSubscription %p -> %p\n", q, p));
	*(_emi__CancelAlertSubscription*)p = *(_emi__CancelAlertSubscription*)q;
}

void emi__AlertSubscriptionGeneralType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->emi__AlertSubscriptionGeneralType::__union_AlertSubscriptionGeneralType = 0;
	soap_default_emi__AlertSubscriptionPolicyIDType(soap, &this->emi__AlertSubscriptionGeneralType::PolicyID);
	/* transient soap skipped */
}

void emi__AlertSubscriptionGeneralType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize__emi__union_AlertSubscriptionGeneralType(soap, this->emi__AlertSubscriptionGeneralType::__union_AlertSubscriptionGeneralType, &this->emi__AlertSubscriptionGeneralType::union_AlertSubscriptionGeneralType);
	soap_embedded(soap, &this->emi__AlertSubscriptionGeneralType::PolicyID, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType);
	/* transient soap skipped */
}

int emi__AlertSubscriptionGeneralType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__AlertSubscriptionGeneralType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__AlertSubscriptionGeneralType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__AlertSubscriptionGeneralType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertSubscriptionGeneralType(struct soap *soap, const char *tag, int id, const emi__AlertSubscriptionGeneralType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__AlertSubscriptionGeneralType), type);
	soap_out__emi__union_AlertSubscriptionGeneralType(soap, a->emi__AlertSubscriptionGeneralType::__union_AlertSubscriptionGeneralType, &a->emi__AlertSubscriptionGeneralType::union_AlertSubscriptionGeneralType);
	soap_out_emi__AlertSubscriptionPolicyIDType(soap, "emi:PolicyID", -1, &(a->emi__AlertSubscriptionGeneralType::PolicyID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__AlertSubscriptionGeneralType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__AlertSubscriptionGeneralType(soap, this, tag, type);
}

SOAP_FMAC3 emi__AlertSubscriptionGeneralType * SOAP_FMAC4 soap_get_emi__AlertSubscriptionGeneralType(struct soap *soap, emi__AlertSubscriptionGeneralType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertSubscriptionGeneralType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__AlertSubscriptionGeneralType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__AlertSubscriptionGeneralType(soap, tag, this, type);
}

SOAP_FMAC3 emi__AlertSubscriptionGeneralType * SOAP_FMAC4 soap_in_emi__AlertSubscriptionGeneralType(struct soap *soap, const char *tag, emi__AlertSubscriptionGeneralType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__AlertSubscriptionGeneralType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__AlertSubscriptionGeneralType, sizeof(emi__AlertSubscriptionGeneralType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__AlertSubscriptionGeneralType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__AlertSubscriptionGeneralType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_union_AlertSubscriptionGeneralType1 = 1, soap_flag_PolicyID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_union_AlertSubscriptionGeneralType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__emi__union_AlertSubscriptionGeneralType(soap, &a->emi__AlertSubscriptionGeneralType::__union_AlertSubscriptionGeneralType, &a->emi__AlertSubscriptionGeneralType::union_AlertSubscriptionGeneralType))
				{	soap_flag_union_AlertSubscriptionGeneralType1 = 0;
					continue;
				}
			if (soap_flag_PolicyID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__AlertSubscriptionPolicyIDType(soap, "emi:PolicyID", &(a->emi__AlertSubscriptionGeneralType::PolicyID), "emi:AlertSubscriptionPolicyIDType"))
				{	soap_flag_PolicyID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionGeneralType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__AlertSubscriptionGeneralType, 0, sizeof(emi__AlertSubscriptionGeneralType), 0, soap_copy_emi__AlertSubscriptionGeneralType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_union_AlertSubscriptionGeneralType1 || soap_flag_PolicyID1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__AlertSubscriptionGeneralType * SOAP_FMAC6 soap_new_emi__AlertSubscriptionGeneralType(struct soap *soap, int n)
{	return soap_instantiate_emi__AlertSubscriptionGeneralType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__AlertSubscriptionGeneralType(struct soap *soap, emi__AlertSubscriptionGeneralType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__AlertSubscriptionGeneralType * SOAP_FMAC4 soap_instantiate_emi__AlertSubscriptionGeneralType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__AlertSubscriptionGeneralType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__AlertSubscriptionGeneralType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__AlertSubscriptionGeneralType;
		if (size)
			*size = sizeof(emi__AlertSubscriptionGeneralType);
		((emi__AlertSubscriptionGeneralType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__AlertSubscriptionGeneralType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__AlertSubscriptionGeneralType);
		for (int i = 0; i < n; i++)
			((emi__AlertSubscriptionGeneralType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__AlertSubscriptionGeneralType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__AlertSubscriptionGeneralType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__AlertSubscriptionGeneralType %p -> %p\n", q, p));
	*(emi__AlertSubscriptionGeneralType*)p = *(emi__AlertSubscriptionGeneralType*)q;
}

void emi__AlertSubscriptionSoapType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->emi__AlertSubscriptionSoapType::Address = NULL;
	this->emi__AlertSubscriptionSoapType::ClientCredentials = NULL;
	this->emi__AlertSubscriptionSoapType::UserCredentials = NULL;
	soap_default_std__vectorTemplateOfemi__AlertAuthOptionsType(soap, &this->emi__AlertSubscriptionSoapType::AlertAuthOptions);
	/* transient soap skipped */
}

void emi__AlertSubscriptionSoapType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTocmn__URLType(soap, &this->emi__AlertSubscriptionSoapType::Address);
	soap_serialize_PointerTosai__CertificateHandleType(soap, &this->emi__AlertSubscriptionSoapType::ClientCredentials);
	soap_serialize_PointerToemi__AlertCredentialsType(soap, &this->emi__AlertSubscriptionSoapType::UserCredentials);
	soap_serialize_std__vectorTemplateOfemi__AlertAuthOptionsType(soap, &this->emi__AlertSubscriptionSoapType::AlertAuthOptions);
	/* transient soap skipped */
}

int emi__AlertSubscriptionSoapType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__AlertSubscriptionSoapType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__AlertSubscriptionSoapType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__AlertSubscriptionSoapType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertSubscriptionSoapType(struct soap *soap, const char *tag, int id, const emi__AlertSubscriptionSoapType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__AlertSubscriptionSoapType), type);
	soap_out_PointerTocmn__URLType(soap, "emi:Address", -1, &(a->emi__AlertSubscriptionSoapType::Address), "");
	soap_out_PointerTosai__CertificateHandleType(soap, "emi:ClientCredentials", -1, &(a->emi__AlertSubscriptionSoapType::ClientCredentials), "");
	soap_out_PointerToemi__AlertCredentialsType(soap, "emi:UserCredentials", -1, &(a->emi__AlertSubscriptionSoapType::UserCredentials), "");
	soap_out_std__vectorTemplateOfemi__AlertAuthOptionsType(soap, "emi:AlertAuthOptions", -1, &(a->emi__AlertSubscriptionSoapType::AlertAuthOptions), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__AlertSubscriptionSoapType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__AlertSubscriptionSoapType(soap, this, tag, type);
}

SOAP_FMAC3 emi__AlertSubscriptionSoapType * SOAP_FMAC4 soap_get_emi__AlertSubscriptionSoapType(struct soap *soap, emi__AlertSubscriptionSoapType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertSubscriptionSoapType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__AlertSubscriptionSoapType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__AlertSubscriptionSoapType(soap, tag, this, type);
}

SOAP_FMAC3 emi__AlertSubscriptionSoapType * SOAP_FMAC4 soap_in_emi__AlertSubscriptionSoapType(struct soap *soap, const char *tag, emi__AlertSubscriptionSoapType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__AlertSubscriptionSoapType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__AlertSubscriptionSoapType, sizeof(emi__AlertSubscriptionSoapType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__AlertSubscriptionSoapType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__AlertSubscriptionSoapType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Address1 = 1, soap_flag_ClientCredentials1 = 1, soap_flag_UserCredentials1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Address1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTocmn__URLType(soap, "emi:Address", &(a->emi__AlertSubscriptionSoapType::Address), "cmn:URLType"))
				{	soap_flag_Address1--;
					continue;
				}
			if (soap_flag_ClientCredentials1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosai__CertificateHandleType(soap, "emi:ClientCredentials", &(a->emi__AlertSubscriptionSoapType::ClientCredentials), "sai:CertificateHandleType"))
				{	soap_flag_ClientCredentials1--;
					continue;
				}
			if (soap_flag_UserCredentials1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToemi__AlertCredentialsType(soap, "emi:UserCredentials", &(a->emi__AlertSubscriptionSoapType::UserCredentials), "emi:AlertCredentialsType"))
				{	soap_flag_UserCredentials1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfemi__AlertAuthOptionsType(soap, "emi:AlertAuthOptions", &(a->emi__AlertSubscriptionSoapType::AlertAuthOptions), "emi:AlertAuthOptionsType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionSoapType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__AlertSubscriptionSoapType, 0, sizeof(emi__AlertSubscriptionSoapType), 0, soap_copy_emi__AlertSubscriptionSoapType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Address1 > 0 || a->emi__AlertSubscriptionSoapType::AlertAuthOptions.size() > 3))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__AlertSubscriptionSoapType * SOAP_FMAC6 soap_new_emi__AlertSubscriptionSoapType(struct soap *soap, int n)
{	return soap_instantiate_emi__AlertSubscriptionSoapType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__AlertSubscriptionSoapType(struct soap *soap, emi__AlertSubscriptionSoapType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__AlertSubscriptionSoapType * SOAP_FMAC4 soap_instantiate_emi__AlertSubscriptionSoapType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__AlertSubscriptionSoapType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__AlertSubscriptionSoapType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__AlertSubscriptionSoapType;
		if (size)
			*size = sizeof(emi__AlertSubscriptionSoapType);
		((emi__AlertSubscriptionSoapType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__AlertSubscriptionSoapType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__AlertSubscriptionSoapType);
		for (int i = 0; i < n; i++)
			((emi__AlertSubscriptionSoapType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__AlertSubscriptionSoapType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__AlertSubscriptionSoapType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__AlertSubscriptionSoapType %p -> %p\n", q, p));
	*(emi__AlertSubscriptionSoapType*)p = *(emi__AlertSubscriptionSoapType*)q;
}

void emi__AlertSubscriptionSNMPType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->emi__AlertSubscriptionSNMPType::Address = NULL;
	this->emi__AlertSubscriptionSNMPType::CommunityString = NULL;
	/* transient soap skipped */
}

void emi__AlertSubscriptionSNMPType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTocmn__NodeAddressType(soap, &this->emi__AlertSubscriptionSNMPType::Address);
	soap_serialize_PointerToemi__CommunityStringType(soap, &this->emi__AlertSubscriptionSNMPType::CommunityString);
	/* transient soap skipped */
}

int emi__AlertSubscriptionSNMPType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__AlertSubscriptionSNMPType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__AlertSubscriptionSNMPType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__AlertSubscriptionSNMPType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertSubscriptionSNMPType(struct soap *soap, const char *tag, int id, const emi__AlertSubscriptionSNMPType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__AlertSubscriptionSNMPType), type);
	soap_out_PointerTocmn__NodeAddressType(soap, "emi:Address", -1, &(a->emi__AlertSubscriptionSNMPType::Address), "");
	soap_out_PointerToemi__CommunityStringType(soap, "emi:CommunityString", -1, &(a->emi__AlertSubscriptionSNMPType::CommunityString), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__AlertSubscriptionSNMPType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__AlertSubscriptionSNMPType(soap, this, tag, type);
}

SOAP_FMAC3 emi__AlertSubscriptionSNMPType * SOAP_FMAC4 soap_get_emi__AlertSubscriptionSNMPType(struct soap *soap, emi__AlertSubscriptionSNMPType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertSubscriptionSNMPType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__AlertSubscriptionSNMPType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__AlertSubscriptionSNMPType(soap, tag, this, type);
}

SOAP_FMAC3 emi__AlertSubscriptionSNMPType * SOAP_FMAC4 soap_in_emi__AlertSubscriptionSNMPType(struct soap *soap, const char *tag, emi__AlertSubscriptionSNMPType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__AlertSubscriptionSNMPType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__AlertSubscriptionSNMPType, sizeof(emi__AlertSubscriptionSNMPType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__AlertSubscriptionSNMPType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__AlertSubscriptionSNMPType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Address1 = 1, soap_flag_CommunityString1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Address1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTocmn__NodeAddressType(soap, "emi:Address", &(a->emi__AlertSubscriptionSNMPType::Address), "cmn:NodeAddressType"))
				{	soap_flag_Address1--;
					continue;
				}
			if (soap_flag_CommunityString1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerToemi__CommunityStringType(soap, "emi:CommunityString", &(a->emi__AlertSubscriptionSNMPType::CommunityString), "emi:CommunityStringType"))
				{	soap_flag_CommunityString1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionSNMPType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__AlertSubscriptionSNMPType, 0, sizeof(emi__AlertSubscriptionSNMPType), 0, soap_copy_emi__AlertSubscriptionSNMPType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Address1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__AlertSubscriptionSNMPType * SOAP_FMAC6 soap_new_emi__AlertSubscriptionSNMPType(struct soap *soap, int n)
{	return soap_instantiate_emi__AlertSubscriptionSNMPType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__AlertSubscriptionSNMPType(struct soap *soap, emi__AlertSubscriptionSNMPType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__AlertSubscriptionSNMPType * SOAP_FMAC4 soap_instantiate_emi__AlertSubscriptionSNMPType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__AlertSubscriptionSNMPType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__AlertSubscriptionSNMPType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__AlertSubscriptionSNMPType;
		if (size)
			*size = sizeof(emi__AlertSubscriptionSNMPType);
		((emi__AlertSubscriptionSNMPType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__AlertSubscriptionSNMPType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__AlertSubscriptionSNMPType);
		for (int i = 0; i < n; i++)
			((emi__AlertSubscriptionSNMPType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__AlertSubscriptionSNMPType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__AlertSubscriptionSNMPType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__AlertSubscriptionSNMPType %p -> %p\n", q, p));
	*(emi__AlertSubscriptionSNMPType*)p = *(emi__AlertSubscriptionSNMPType*)q;
}

void emi__AlertCredentialsType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->emi__AlertCredentialsType::Username);
	soap_default_std__string(soap, &this->emi__AlertCredentialsType::Password);
	/* transient soap skipped */
}

void emi__AlertCredentialsType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->emi__AlertCredentialsType::Username, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->emi__AlertCredentialsType::Username);
	soap_embedded(soap, &this->emi__AlertCredentialsType::Password, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &this->emi__AlertCredentialsType::Password);
	/* transient soap skipped */
}

int emi__AlertCredentialsType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__AlertCredentialsType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__AlertCredentialsType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__AlertCredentialsType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertCredentialsType(struct soap *soap, const char *tag, int id, const emi__AlertCredentialsType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__AlertCredentialsType), type);
	soap_out_std__string(soap, "emi:Username", -1, &(a->emi__AlertCredentialsType::Username), "");
	soap_out_std__string(soap, "emi:Password", -1, &(a->emi__AlertCredentialsType::Password), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__AlertCredentialsType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__AlertCredentialsType(soap, this, tag, type);
}

SOAP_FMAC3 emi__AlertCredentialsType * SOAP_FMAC4 soap_get_emi__AlertCredentialsType(struct soap *soap, emi__AlertCredentialsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertCredentialsType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__AlertCredentialsType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__AlertCredentialsType(soap, tag, this, type);
}

SOAP_FMAC3 emi__AlertCredentialsType * SOAP_FMAC4 soap_in_emi__AlertCredentialsType(struct soap *soap, const char *tag, emi__AlertCredentialsType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__AlertCredentialsType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__AlertCredentialsType, sizeof(emi__AlertCredentialsType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__AlertCredentialsType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__AlertCredentialsType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Username1 = 1, soap_flag_Password1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Username1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "emi:Username", &(a->emi__AlertCredentialsType::Username), "xsd:string"))
				{	soap_flag_Username1--;
					continue;
				}
			if (soap_flag_Password1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "emi:Password", &(a->emi__AlertCredentialsType::Password), "xsd:string"))
				{	soap_flag_Password1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__AlertCredentialsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__AlertCredentialsType, 0, sizeof(emi__AlertCredentialsType), 0, soap_copy_emi__AlertCredentialsType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Username1 > 0 || soap_flag_Password1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__AlertCredentialsType * SOAP_FMAC6 soap_new_emi__AlertCredentialsType(struct soap *soap, int n)
{	return soap_instantiate_emi__AlertCredentialsType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__AlertCredentialsType(struct soap *soap, emi__AlertCredentialsType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__AlertCredentialsType * SOAP_FMAC4 soap_instantiate_emi__AlertCredentialsType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__AlertCredentialsType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__AlertCredentialsType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__AlertCredentialsType;
		if (size)
			*size = sizeof(emi__AlertCredentialsType);
		((emi__AlertCredentialsType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__AlertCredentialsType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__AlertCredentialsType);
		for (int i = 0; i < n; i++)
			((emi__AlertCredentialsType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__AlertCredentialsType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__AlertCredentialsType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__AlertCredentialsType %p -> %p\n", q, p));
	*(emi__AlertCredentialsType*)p = *(emi__AlertCredentialsType*)q;
}

void emi__ByteStr::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfunsignedByte(soap, &this->emi__ByteStr::Byte);
	/* transient soap skipped */
}

void emi__ByteStr::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfunsignedByte(soap, &this->emi__ByteStr::Byte);
	/* transient soap skipped */
}

int emi__ByteStr::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__ByteStr);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__ByteStr::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__ByteStr(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__ByteStr(struct soap *soap, const char *tag, int id, const emi__ByteStr *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__ByteStr), type);
	soap_out_std__vectorTemplateOfunsignedByte(soap, "emi:Byte", -1, &(a->emi__ByteStr::Byte), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__ByteStr::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__ByteStr(soap, this, tag, type);
}

SOAP_FMAC3 emi__ByteStr * SOAP_FMAC4 soap_get_emi__ByteStr(struct soap *soap, emi__ByteStr *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__ByteStr(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__ByteStr::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__ByteStr(soap, tag, this, type);
}

SOAP_FMAC3 emi__ByteStr * SOAP_FMAC4 soap_in_emi__ByteStr(struct soap *soap, const char *tag, emi__ByteStr *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__ByteStr *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__ByteStr, sizeof(emi__ByteStr), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__ByteStr)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__ByteStr *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfunsignedByte(soap, "emi:Byte", &(a->emi__ByteStr::Byte), "xsd:unsignedByte"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__ByteStr *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__ByteStr, 0, sizeof(emi__ByteStr), 0, soap_copy_emi__ByteStr);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->emi__ByteStr::Byte.size() > 16))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__ByteStr * SOAP_FMAC6 soap_new_emi__ByteStr(struct soap *soap, int n)
{	return soap_instantiate_emi__ByteStr(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__ByteStr(struct soap *soap, emi__ByteStr *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__ByteStr * SOAP_FMAC4 soap_instantiate_emi__ByteStr(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__ByteStr(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__ByteStr, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__ByteStr;
		if (size)
			*size = sizeof(emi__ByteStr);
		((emi__ByteStr*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__ByteStr[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__ByteStr);
		for (int i = 0; i < n; i++)
			((emi__ByteStr*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__ByteStr*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__ByteStr(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__ByteStr %p -> %p\n", q, p));
	*(emi__ByteStr*)p = *(emi__ByteStr*)q;
}

void emi__SensorAttributesType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->emi__SensorAttributesType::IsLegacySensor);
	soap_default_bool(soap, &this->emi__SensorAttributesType::AssertionEvent);
	soap_default_bool(soap, &this->emi__SensorAttributesType::DeassertionEvent);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::Index);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::DeviceAddress);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::EventSensorType);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::EventType);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::EventOffset);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::EventSourceType);
	soap_default_emi__EventSeverityType(soap, &this->emi__SensorAttributesType::EventSeverity);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::SensorNumber);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::Entity);
	soap_default_unsignedByte(soap, &this->emi__SensorAttributesType::EntityInstance);
	/* transient soap skipped */
}

void emi__SensorAttributesType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->emi__SensorAttributesType::IsLegacySensor, SOAP_TYPE_bool);
	soap_embedded(soap, &this->emi__SensorAttributesType::AssertionEvent, SOAP_TYPE_bool);
	soap_embedded(soap, &this->emi__SensorAttributesType::DeassertionEvent, SOAP_TYPE_bool);
	soap_embedded(soap, &this->emi__SensorAttributesType::Index, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__SensorAttributesType::DeviceAddress, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__SensorAttributesType::EventSensorType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__SensorAttributesType::EventType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__SensorAttributesType::EventOffset, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__SensorAttributesType::EventSourceType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__SensorAttributesType::SensorNumber, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__SensorAttributesType::Entity, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__SensorAttributesType::EntityInstance, SOAP_TYPE_unsignedByte);
	/* transient soap skipped */
}

int emi__SensorAttributesType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__SensorAttributesType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__SensorAttributesType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__SensorAttributesType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__SensorAttributesType(struct soap *soap, const char *tag, int id, const emi__SensorAttributesType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__SensorAttributesType), type);
	soap_out_bool(soap, "emi:IsLegacySensor", -1, &(a->emi__SensorAttributesType::IsLegacySensor), "");
	soap_out_bool(soap, "emi:AssertionEvent", -1, &(a->emi__SensorAttributesType::AssertionEvent), "");
	soap_out_bool(soap, "emi:DeassertionEvent", -1, &(a->emi__SensorAttributesType::DeassertionEvent), "");
	soap_out_unsignedByte(soap, "emi:Index", -1, &(a->emi__SensorAttributesType::Index), "");
	soap_out_unsignedByte(soap, "emi:DeviceAddress", -1, &(a->emi__SensorAttributesType::DeviceAddress), "");
	soap_out_unsignedByte(soap, "emi:EventSensorType", -1, &(a->emi__SensorAttributesType::EventSensorType), "");
	soap_out_unsignedByte(soap, "emi:EventType", -1, &(a->emi__SensorAttributesType::EventType), "");
	soap_out_unsignedByte(soap, "emi:EventOffset", -1, &(a->emi__SensorAttributesType::EventOffset), "");
	soap_out_unsignedByte(soap, "emi:EventSourceType", -1, &(a->emi__SensorAttributesType::EventSourceType), "");
	soap_out_emi__EventSeverityType(soap, "emi:EventSeverity", -1, &(a->emi__SensorAttributesType::EventSeverity), "");
	soap_out_unsignedByte(soap, "emi:SensorNumber", -1, &(a->emi__SensorAttributesType::SensorNumber), "");
	soap_out_unsignedByte(soap, "emi:Entity", -1, &(a->emi__SensorAttributesType::Entity), "");
	soap_out_unsignedByte(soap, "emi:EntityInstance", -1, &(a->emi__SensorAttributesType::EntityInstance), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__SensorAttributesType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__SensorAttributesType(soap, this, tag, type);
}

SOAP_FMAC3 emi__SensorAttributesType * SOAP_FMAC4 soap_get_emi__SensorAttributesType(struct soap *soap, emi__SensorAttributesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__SensorAttributesType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__SensorAttributesType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__SensorAttributesType(soap, tag, this, type);
}

SOAP_FMAC3 emi__SensorAttributesType * SOAP_FMAC4 soap_in_emi__SensorAttributesType(struct soap *soap, const char *tag, emi__SensorAttributesType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__SensorAttributesType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__SensorAttributesType, sizeof(emi__SensorAttributesType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__SensorAttributesType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__SensorAttributesType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_IsLegacySensor1 = 1, soap_flag_AssertionEvent1 = 1, soap_flag_DeassertionEvent1 = 1, soap_flag_Index1 = 1, soap_flag_DeviceAddress1 = 1, soap_flag_EventSensorType1 = 1, soap_flag_EventType1 = 1, soap_flag_EventOffset1 = 1, soap_flag_EventSourceType1 = 1, soap_flag_EventSeverity1 = 1, soap_flag_SensorNumber1 = 1, soap_flag_Entity1 = 1, soap_flag_EntityInstance1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_IsLegacySensor1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "emi:IsLegacySensor", &(a->emi__SensorAttributesType::IsLegacySensor), "xsd:boolean"))
				{	soap_flag_IsLegacySensor1--;
					continue;
				}
			if (soap_flag_AssertionEvent1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "emi:AssertionEvent", &(a->emi__SensorAttributesType::AssertionEvent), "xsd:boolean"))
				{	soap_flag_AssertionEvent1--;
					continue;
				}
			if (soap_flag_DeassertionEvent1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "emi:DeassertionEvent", &(a->emi__SensorAttributesType::DeassertionEvent), "xsd:boolean"))
				{	soap_flag_DeassertionEvent1--;
					continue;
				}
			if (soap_flag_Index1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:Index", &(a->emi__SensorAttributesType::Index), "xsd:unsignedByte"))
				{	soap_flag_Index1--;
					continue;
				}
			if (soap_flag_DeviceAddress1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:DeviceAddress", &(a->emi__SensorAttributesType::DeviceAddress), "xsd:unsignedByte"))
				{	soap_flag_DeviceAddress1--;
					continue;
				}
			if (soap_flag_EventSensorType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventSensorType", &(a->emi__SensorAttributesType::EventSensorType), "xsd:unsignedByte"))
				{	soap_flag_EventSensorType1--;
					continue;
				}
			if (soap_flag_EventType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventType", &(a->emi__SensorAttributesType::EventType), "xsd:unsignedByte"))
				{	soap_flag_EventType1--;
					continue;
				}
			if (soap_flag_EventOffset1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventOffset", &(a->emi__SensorAttributesType::EventOffset), "xsd:unsignedByte"))
				{	soap_flag_EventOffset1--;
					continue;
				}
			if (soap_flag_EventSourceType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventSourceType", &(a->emi__SensorAttributesType::EventSourceType), "xsd:unsignedByte"))
				{	soap_flag_EventSourceType1--;
					continue;
				}
			if (soap_flag_EventSeverity1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__EventSeverityType(soap, "emi:EventSeverity", &(a->emi__SensorAttributesType::EventSeverity), "emi:EventSeverityType"))
				{	soap_flag_EventSeverity1--;
					continue;
				}
			if (soap_flag_SensorNumber1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:SensorNumber", &(a->emi__SensorAttributesType::SensorNumber), "xsd:unsignedByte"))
				{	soap_flag_SensorNumber1--;
					continue;
				}
			if (soap_flag_Entity1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:Entity", &(a->emi__SensorAttributesType::Entity), "xsd:unsignedByte"))
				{	soap_flag_Entity1--;
					continue;
				}
			if (soap_flag_EntityInstance1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EntityInstance", &(a->emi__SensorAttributesType::EntityInstance), "xsd:unsignedByte"))
				{	soap_flag_EntityInstance1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__SensorAttributesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__SensorAttributesType, 0, sizeof(emi__SensorAttributesType), 0, soap_copy_emi__SensorAttributesType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_IsLegacySensor1 > 0 || soap_flag_AssertionEvent1 > 0 || soap_flag_DeassertionEvent1 > 0 || soap_flag_Index1 > 0 || soap_flag_DeviceAddress1 > 0 || soap_flag_EventSensorType1 > 0 || soap_flag_EventType1 > 0 || soap_flag_EventOffset1 > 0 || soap_flag_EventSourceType1 > 0 || soap_flag_EventSeverity1 > 0 || soap_flag_SensorNumber1 > 0 || soap_flag_Entity1 > 0 || soap_flag_EntityInstance1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__SensorAttributesType * SOAP_FMAC6 soap_new_emi__SensorAttributesType(struct soap *soap, int n)
{	return soap_instantiate_emi__SensorAttributesType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__SensorAttributesType(struct soap *soap, emi__SensorAttributesType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__SensorAttributesType * SOAP_FMAC4 soap_instantiate_emi__SensorAttributesType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__SensorAttributesType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__SensorAttributesType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__SensorAttributesType;
		if (size)
			*size = sizeof(emi__SensorAttributesType);
		((emi__SensorAttributesType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__SensorAttributesType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__SensorAttributesType);
		for (int i = 0; i < n; i++)
			((emi__SensorAttributesType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__SensorAttributesType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__SensorAttributesType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__SensorAttributesType %p -> %p\n", q, p));
	*(emi__SensorAttributesType*)p = *(emi__SensorAttributesType*)q;
}

void emi__SensorHandleArrayType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfemi__SensorHandleType(soap, &this->emi__SensorHandleArrayType::SensorHandle);
	/* transient soap skipped */
}

void emi__SensorHandleArrayType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfemi__SensorHandleType(soap, &this->emi__SensorHandleArrayType::SensorHandle);
	/* transient soap skipped */
}

int emi__SensorHandleArrayType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__SensorHandleArrayType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__SensorHandleArrayType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__SensorHandleArrayType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__SensorHandleArrayType(struct soap *soap, const char *tag, int id, const emi__SensorHandleArrayType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__SensorHandleArrayType), type);
	soap_out_std__vectorTemplateOfemi__SensorHandleType(soap, "emi:SensorHandle", -1, &(a->emi__SensorHandleArrayType::SensorHandle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__SensorHandleArrayType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__SensorHandleArrayType(soap, this, tag, type);
}

SOAP_FMAC3 emi__SensorHandleArrayType * SOAP_FMAC4 soap_get_emi__SensorHandleArrayType(struct soap *soap, emi__SensorHandleArrayType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__SensorHandleArrayType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__SensorHandleArrayType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__SensorHandleArrayType(soap, tag, this, type);
}

SOAP_FMAC3 emi__SensorHandleArrayType * SOAP_FMAC4 soap_in_emi__SensorHandleArrayType(struct soap *soap, const char *tag, emi__SensorHandleArrayType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__SensorHandleArrayType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__SensorHandleArrayType, sizeof(emi__SensorHandleArrayType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__SensorHandleArrayType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__SensorHandleArrayType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfemi__SensorHandleType(soap, "emi:SensorHandle", &(a->emi__SensorHandleArrayType::SensorHandle), "emi:SensorHandleType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__SensorHandleArrayType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__SensorHandleArrayType, 0, sizeof(emi__SensorHandleArrayType), 0, soap_copy_emi__SensorHandleArrayType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__SensorHandleArrayType * SOAP_FMAC6 soap_new_emi__SensorHandleArrayType(struct soap *soap, int n)
{	return soap_instantiate_emi__SensorHandleArrayType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__SensorHandleArrayType(struct soap *soap, emi__SensorHandleArrayType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__SensorHandleArrayType * SOAP_FMAC4 soap_instantiate_emi__SensorHandleArrayType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__SensorHandleArrayType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__SensorHandleArrayType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__SensorHandleArrayType;
		if (size)
			*size = sizeof(emi__SensorHandleArrayType);
		((emi__SensorHandleArrayType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__SensorHandleArrayType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__SensorHandleArrayType);
		for (int i = 0; i < n; i++)
			((emi__SensorHandleArrayType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__SensorHandleArrayType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__SensorHandleArrayType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__SensorHandleArrayType %p -> %p\n", q, p));
	*(emi__SensorHandleArrayType*)p = *(emi__SensorHandleArrayType*)q;
}

void emi__EventLogRecordArrayType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, &this->emi__EventLogRecordArrayType::EventLogRecord);
	/* transient soap skipped */
}

void emi__EventLogRecordArrayType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, &this->emi__EventLogRecordArrayType::EventLogRecord);
	/* transient soap skipped */
}

int emi__EventLogRecordArrayType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__EventLogRecordArrayType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__EventLogRecordArrayType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__EventLogRecordArrayType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__EventLogRecordArrayType(struct soap *soap, const char *tag, int id, const emi__EventLogRecordArrayType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__EventLogRecordArrayType), type);
	soap_out_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, "emi:EventLogRecord", -1, &(a->emi__EventLogRecordArrayType::EventLogRecord), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__EventLogRecordArrayType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__EventLogRecordArrayType(soap, this, tag, type);
}

SOAP_FMAC3 emi__EventLogRecordArrayType * SOAP_FMAC4 soap_get_emi__EventLogRecordArrayType(struct soap *soap, emi__EventLogRecordArrayType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__EventLogRecordArrayType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__EventLogRecordArrayType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__EventLogRecordArrayType(soap, tag, this, type);
}

SOAP_FMAC3 emi__EventLogRecordArrayType * SOAP_FMAC4 soap_in_emi__EventLogRecordArrayType(struct soap *soap, const char *tag, emi__EventLogRecordArrayType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__EventLogRecordArrayType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__EventLogRecordArrayType, sizeof(emi__EventLogRecordArrayType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__EventLogRecordArrayType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__EventLogRecordArrayType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, "emi:EventLogRecord", &(a->emi__EventLogRecordArrayType::EventLogRecord), "emi:EventLogRecordType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__EventLogRecordArrayType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__EventLogRecordArrayType, 0, sizeof(emi__EventLogRecordArrayType), 0, soap_copy_emi__EventLogRecordArrayType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__EventLogRecordArrayType * SOAP_FMAC6 soap_new_emi__EventLogRecordArrayType(struct soap *soap, int n)
{	return soap_instantiate_emi__EventLogRecordArrayType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__EventLogRecordArrayType(struct soap *soap, emi__EventLogRecordArrayType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__EventLogRecordArrayType * SOAP_FMAC4 soap_instantiate_emi__EventLogRecordArrayType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__EventLogRecordArrayType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__EventLogRecordArrayType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__EventLogRecordArrayType;
		if (size)
			*size = sizeof(emi__EventLogRecordArrayType);
		((emi__EventLogRecordArrayType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__EventLogRecordArrayType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__EventLogRecordArrayType);
		for (int i = 0; i < n; i++)
			((emi__EventLogRecordArrayType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__EventLogRecordArrayType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__EventLogRecordArrayType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__EventLogRecordArrayType %p -> %p\n", q, p));
	*(emi__EventLogRecordArrayType*)p = *(emi__EventLogRecordArrayType*)q;
}

void emi__EventFilterHandleArrayType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfemi__EventFilterHandleType(soap, &this->emi__EventFilterHandleArrayType::EventFilterHandle);
	/* transient soap skipped */
}

void emi__EventFilterHandleArrayType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfemi__EventFilterHandleType(soap, &this->emi__EventFilterHandleArrayType::EventFilterHandle);
	/* transient soap skipped */
}

int emi__EventFilterHandleArrayType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__EventFilterHandleArrayType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__EventFilterHandleArrayType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__EventFilterHandleArrayType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__EventFilterHandleArrayType(struct soap *soap, const char *tag, int id, const emi__EventFilterHandleArrayType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__EventFilterHandleArrayType), type);
	soap_out_std__vectorTemplateOfemi__EventFilterHandleType(soap, "emi:EventFilterHandle", -1, &(a->emi__EventFilterHandleArrayType::EventFilterHandle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__EventFilterHandleArrayType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__EventFilterHandleArrayType(soap, this, tag, type);
}

SOAP_FMAC3 emi__EventFilterHandleArrayType * SOAP_FMAC4 soap_get_emi__EventFilterHandleArrayType(struct soap *soap, emi__EventFilterHandleArrayType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__EventFilterHandleArrayType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__EventFilterHandleArrayType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__EventFilterHandleArrayType(soap, tag, this, type);
}

SOAP_FMAC3 emi__EventFilterHandleArrayType * SOAP_FMAC4 soap_in_emi__EventFilterHandleArrayType(struct soap *soap, const char *tag, emi__EventFilterHandleArrayType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__EventFilterHandleArrayType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__EventFilterHandleArrayType, sizeof(emi__EventFilterHandleArrayType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__EventFilterHandleArrayType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__EventFilterHandleArrayType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfemi__EventFilterHandleType(soap, "emi:EventFilterHandle", &(a->emi__EventFilterHandleArrayType::EventFilterHandle), "emi:EventFilterHandleType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__EventFilterHandleArrayType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__EventFilterHandleArrayType, 0, sizeof(emi__EventFilterHandleArrayType), 0, soap_copy_emi__EventFilterHandleArrayType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__EventFilterHandleArrayType * SOAP_FMAC6 soap_new_emi__EventFilterHandleArrayType(struct soap *soap, int n)
{	return soap_instantiate_emi__EventFilterHandleArrayType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__EventFilterHandleArrayType(struct soap *soap, emi__EventFilterHandleArrayType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__EventFilterHandleArrayType * SOAP_FMAC4 soap_instantiate_emi__EventFilterHandleArrayType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__EventFilterHandleArrayType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__EventFilterHandleArrayType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__EventFilterHandleArrayType;
		if (size)
			*size = sizeof(emi__EventFilterHandleArrayType);
		((emi__EventFilterHandleArrayType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__EventFilterHandleArrayType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__EventFilterHandleArrayType);
		for (int i = 0; i < n; i++)
			((emi__EventFilterHandleArrayType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__EventFilterHandleArrayType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__EventFilterHandleArrayType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__EventFilterHandleArrayType %p -> %p\n", q, p));
	*(emi__EventFilterHandleArrayType*)p = *(emi__EventFilterHandleArrayType*)q;
}

void emi__AlertSubscriptionHandleArrayType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, &this->emi__AlertSubscriptionHandleArrayType::AlertSubscriptionHandle);
	/* transient soap skipped */
}

void emi__AlertSubscriptionHandleArrayType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, &this->emi__AlertSubscriptionHandleArrayType::AlertSubscriptionHandle);
	/* transient soap skipped */
}

int emi__AlertSubscriptionHandleArrayType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__AlertSubscriptionHandleArrayType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__AlertSubscriptionHandleArrayType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__AlertSubscriptionHandleArrayType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertSubscriptionHandleArrayType(struct soap *soap, const char *tag, int id, const emi__AlertSubscriptionHandleArrayType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__AlertSubscriptionHandleArrayType), type);
	soap_out_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, "emi:AlertSubscriptionHandle", -1, &(a->emi__AlertSubscriptionHandleArrayType::AlertSubscriptionHandle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__AlertSubscriptionHandleArrayType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__AlertSubscriptionHandleArrayType(soap, this, tag, type);
}

SOAP_FMAC3 emi__AlertSubscriptionHandleArrayType * SOAP_FMAC4 soap_get_emi__AlertSubscriptionHandleArrayType(struct soap *soap, emi__AlertSubscriptionHandleArrayType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertSubscriptionHandleArrayType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__AlertSubscriptionHandleArrayType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__AlertSubscriptionHandleArrayType(soap, tag, this, type);
}

SOAP_FMAC3 emi__AlertSubscriptionHandleArrayType * SOAP_FMAC4 soap_in_emi__AlertSubscriptionHandleArrayType(struct soap *soap, const char *tag, emi__AlertSubscriptionHandleArrayType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__AlertSubscriptionHandleArrayType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__AlertSubscriptionHandleArrayType, sizeof(emi__AlertSubscriptionHandleArrayType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__AlertSubscriptionHandleArrayType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__AlertSubscriptionHandleArrayType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, "emi:AlertSubscriptionHandle", &(a->emi__AlertSubscriptionHandleArrayType::AlertSubscriptionHandle), "emi:AlertSubscriptionHandleType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionHandleArrayType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__AlertSubscriptionHandleArrayType, 0, sizeof(emi__AlertSubscriptionHandleArrayType), 0, soap_copy_emi__AlertSubscriptionHandleArrayType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__AlertSubscriptionHandleArrayType * SOAP_FMAC6 soap_new_emi__AlertSubscriptionHandleArrayType(struct soap *soap, int n)
{	return soap_instantiate_emi__AlertSubscriptionHandleArrayType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__AlertSubscriptionHandleArrayType(struct soap *soap, emi__AlertSubscriptionHandleArrayType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__AlertSubscriptionHandleArrayType * SOAP_FMAC4 soap_instantiate_emi__AlertSubscriptionHandleArrayType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__AlertSubscriptionHandleArrayType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__AlertSubscriptionHandleArrayType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__AlertSubscriptionHandleArrayType;
		if (size)
			*size = sizeof(emi__AlertSubscriptionHandleArrayType);
		((emi__AlertSubscriptionHandleArrayType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__AlertSubscriptionHandleArrayType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__AlertSubscriptionHandleArrayType);
		for (int i = 0; i < n; i++)
			((emi__AlertSubscriptionHandleArrayType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__AlertSubscriptionHandleArrayType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__AlertSubscriptionHandleArrayType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__AlertSubscriptionHandleArrayType %p -> %p\n", q, p));
	*(emi__AlertSubscriptionHandleArrayType*)p = *(emi__AlertSubscriptionHandleArrayType*)q;
}

void emi__AlertSubscriptionType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_emi__AlertSubscriptionPolicyIDType(soap, &this->emi__AlertSubscriptionType::AlertSubscriptionPolicyID);
	soap_default_emi__IPv4AddressType(soap, &this->emi__AlertSubscriptionType::DestinationAddress);
	/* transient soap skipped */
}

void emi__AlertSubscriptionType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->emi__AlertSubscriptionType::AlertSubscriptionPolicyID, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType);
	/* transient soap skipped */
}

int emi__AlertSubscriptionType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__AlertSubscriptionType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__AlertSubscriptionType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__AlertSubscriptionType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertSubscriptionType(struct soap *soap, const char *tag, int id, const emi__AlertSubscriptionType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__AlertSubscriptionType), type);
	soap_out_emi__AlertSubscriptionPolicyIDType(soap, "emi:AlertSubscriptionPolicyID", -1, &(a->emi__AlertSubscriptionType::AlertSubscriptionPolicyID), "");
	soap_out_emi__IPv4AddressType(soap, "emi:DestinationAddress", -1, &(a->emi__AlertSubscriptionType::DestinationAddress), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__AlertSubscriptionType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__AlertSubscriptionType(soap, this, tag, type);
}

SOAP_FMAC3 emi__AlertSubscriptionType * SOAP_FMAC4 soap_get_emi__AlertSubscriptionType(struct soap *soap, emi__AlertSubscriptionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertSubscriptionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__AlertSubscriptionType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__AlertSubscriptionType(soap, tag, this, type);
}

SOAP_FMAC3 emi__AlertSubscriptionType * SOAP_FMAC4 soap_in_emi__AlertSubscriptionType(struct soap *soap, const char *tag, emi__AlertSubscriptionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__AlertSubscriptionType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__AlertSubscriptionType, sizeof(emi__AlertSubscriptionType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__AlertSubscriptionType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__AlertSubscriptionType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_AlertSubscriptionPolicyID1 = 1, soap_flag_DestinationAddress1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AlertSubscriptionPolicyID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__AlertSubscriptionPolicyIDType(soap, "emi:AlertSubscriptionPolicyID", &(a->emi__AlertSubscriptionType::AlertSubscriptionPolicyID), "emi:AlertSubscriptionPolicyIDType"))
				{	soap_flag_AlertSubscriptionPolicyID1--;
					continue;
				}
			if (soap_flag_DestinationAddress1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__IPv4AddressType(soap, "emi:DestinationAddress", &(a->emi__AlertSubscriptionType::DestinationAddress), "emi:IPv4AddressType"))
				{	soap_flag_DestinationAddress1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__AlertSubscriptionType, 0, sizeof(emi__AlertSubscriptionType), 0, soap_copy_emi__AlertSubscriptionType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_AlertSubscriptionPolicyID1 > 0 || soap_flag_DestinationAddress1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__AlertSubscriptionType * SOAP_FMAC6 soap_new_emi__AlertSubscriptionType(struct soap *soap, int n)
{	return soap_instantiate_emi__AlertSubscriptionType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__AlertSubscriptionType(struct soap *soap, emi__AlertSubscriptionType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__AlertSubscriptionType * SOAP_FMAC4 soap_instantiate_emi__AlertSubscriptionType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__AlertSubscriptionType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__AlertSubscriptionType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__AlertSubscriptionType;
		if (size)
			*size = sizeof(emi__AlertSubscriptionType);
		((emi__AlertSubscriptionType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__AlertSubscriptionType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__AlertSubscriptionType);
		for (int i = 0; i < n; i++)
			((emi__AlertSubscriptionType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__AlertSubscriptionType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__AlertSubscriptionType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__AlertSubscriptionType %p -> %p\n", q, p));
	*(emi__AlertSubscriptionType*)p = *(emi__AlertSubscriptionType*)q;
}

void emi__EventFilterType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::FilterConfiguration);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::FilterAction);
	soap_default_emi__AlertSubscriptionPolicyIDType(soap, &this->emi__EventFilterType::AlertSubscriptionPolicyID);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::DeviceAddress);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::EventSensorType);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::EventType);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::EventOffset);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::EventSourceType);
	soap_default_emi__EventSeverityType(soap, &this->emi__EventFilterType::EventSeverity);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::SensorNumber);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::Entity);
	soap_default_unsignedByte(soap, &this->emi__EventFilterType::EntityInstance);
	/* transient soap skipped */
}

void emi__EventFilterType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->emi__EventFilterType::FilterConfiguration, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::FilterAction, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::AlertSubscriptionPolicyID, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType);
	soap_embedded(soap, &this->emi__EventFilterType::DeviceAddress, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::EventSensorType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::EventType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::EventOffset, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::EventSourceType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::SensorNumber, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::Entity, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventFilterType::EntityInstance, SOAP_TYPE_unsignedByte);
	/* transient soap skipped */
}

int emi__EventFilterType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__EventFilterType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__EventFilterType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__EventFilterType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__EventFilterType(struct soap *soap, const char *tag, int id, const emi__EventFilterType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__EventFilterType), type);
	soap_out_unsignedByte(soap, "emi:FilterConfiguration", -1, &(a->emi__EventFilterType::FilterConfiguration), "");
	soap_out_unsignedByte(soap, "emi:FilterAction", -1, &(a->emi__EventFilterType::FilterAction), "");
	soap_out_emi__AlertSubscriptionPolicyIDType(soap, "emi:AlertSubscriptionPolicyID", -1, &(a->emi__EventFilterType::AlertSubscriptionPolicyID), "");
	soap_out_unsignedByte(soap, "emi:DeviceAddress", -1, &(a->emi__EventFilterType::DeviceAddress), "");
	soap_out_unsignedByte(soap, "emi:EventSensorType", -1, &(a->emi__EventFilterType::EventSensorType), "");
	soap_out_unsignedByte(soap, "emi:EventType", -1, &(a->emi__EventFilterType::EventType), "");
	soap_out_unsignedByte(soap, "emi:EventOffset", -1, &(a->emi__EventFilterType::EventOffset), "");
	soap_out_unsignedByte(soap, "emi:EventSourceType", -1, &(a->emi__EventFilterType::EventSourceType), "");
	soap_out_emi__EventSeverityType(soap, "emi:EventSeverity", -1, &(a->emi__EventFilterType::EventSeverity), "");
	soap_out_unsignedByte(soap, "emi:SensorNumber", -1, &(a->emi__EventFilterType::SensorNumber), "");
	soap_out_unsignedByte(soap, "emi:Entity", -1, &(a->emi__EventFilterType::Entity), "");
	soap_out_unsignedByte(soap, "emi:EntityInstance", -1, &(a->emi__EventFilterType::EntityInstance), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__EventFilterType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__EventFilterType(soap, this, tag, type);
}

SOAP_FMAC3 emi__EventFilterType * SOAP_FMAC4 soap_get_emi__EventFilterType(struct soap *soap, emi__EventFilterType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__EventFilterType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__EventFilterType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__EventFilterType(soap, tag, this, type);
}

SOAP_FMAC3 emi__EventFilterType * SOAP_FMAC4 soap_in_emi__EventFilterType(struct soap *soap, const char *tag, emi__EventFilterType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__EventFilterType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__EventFilterType, sizeof(emi__EventFilterType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__EventFilterType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__EventFilterType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_FilterConfiguration1 = 1, soap_flag_FilterAction1 = 1, soap_flag_AlertSubscriptionPolicyID1 = 1, soap_flag_DeviceAddress1 = 1, soap_flag_EventSensorType1 = 1, soap_flag_EventType1 = 1, soap_flag_EventOffset1 = 1, soap_flag_EventSourceType1 = 1, soap_flag_EventSeverity1 = 1, soap_flag_SensorNumber1 = 1, soap_flag_Entity1 = 1, soap_flag_EntityInstance1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_FilterConfiguration1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:FilterConfiguration", &(a->emi__EventFilterType::FilterConfiguration), "xsd:unsignedByte"))
				{	soap_flag_FilterConfiguration1--;
					continue;
				}
			if (soap_flag_FilterAction1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:FilterAction", &(a->emi__EventFilterType::FilterAction), "xsd:unsignedByte"))
				{	soap_flag_FilterAction1--;
					continue;
				}
			if (soap_flag_AlertSubscriptionPolicyID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__AlertSubscriptionPolicyIDType(soap, "emi:AlertSubscriptionPolicyID", &(a->emi__EventFilterType::AlertSubscriptionPolicyID), "emi:AlertSubscriptionPolicyIDType"))
				{	soap_flag_AlertSubscriptionPolicyID1--;
					continue;
				}
			if (soap_flag_DeviceAddress1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:DeviceAddress", &(a->emi__EventFilterType::DeviceAddress), "xsd:unsignedByte"))
				{	soap_flag_DeviceAddress1--;
					continue;
				}
			if (soap_flag_EventSensorType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventSensorType", &(a->emi__EventFilterType::EventSensorType), "xsd:unsignedByte"))
				{	soap_flag_EventSensorType1--;
					continue;
				}
			if (soap_flag_EventType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventType", &(a->emi__EventFilterType::EventType), "xsd:unsignedByte"))
				{	soap_flag_EventType1--;
					continue;
				}
			if (soap_flag_EventOffset1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventOffset", &(a->emi__EventFilterType::EventOffset), "xsd:unsignedByte"))
				{	soap_flag_EventOffset1--;
					continue;
				}
			if (soap_flag_EventSourceType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventSourceType", &(a->emi__EventFilterType::EventSourceType), "xsd:unsignedByte"))
				{	soap_flag_EventSourceType1--;
					continue;
				}
			if (soap_flag_EventSeverity1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__EventSeverityType(soap, "emi:EventSeverity", &(a->emi__EventFilterType::EventSeverity), "emi:EventSeverityType"))
				{	soap_flag_EventSeverity1--;
					continue;
				}
			if (soap_flag_SensorNumber1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:SensorNumber", &(a->emi__EventFilterType::SensorNumber), "xsd:unsignedByte"))
				{	soap_flag_SensorNumber1--;
					continue;
				}
			if (soap_flag_Entity1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:Entity", &(a->emi__EventFilterType::Entity), "xsd:unsignedByte"))
				{	soap_flag_Entity1--;
					continue;
				}
			if (soap_flag_EntityInstance1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EntityInstance", &(a->emi__EventFilterType::EntityInstance), "xsd:unsignedByte"))
				{	soap_flag_EntityInstance1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__EventFilterType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__EventFilterType, 0, sizeof(emi__EventFilterType), 0, soap_copy_emi__EventFilterType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_FilterConfiguration1 > 0 || soap_flag_FilterAction1 > 0 || soap_flag_AlertSubscriptionPolicyID1 > 0 || soap_flag_DeviceAddress1 > 0 || soap_flag_EventSensorType1 > 0 || soap_flag_EventType1 > 0 || soap_flag_EventOffset1 > 0 || soap_flag_EventSourceType1 > 0 || soap_flag_EventSeverity1 > 0 || soap_flag_SensorNumber1 > 0 || soap_flag_Entity1 > 0 || soap_flag_EntityInstance1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__EventFilterType * SOAP_FMAC6 soap_new_emi__EventFilterType(struct soap *soap, int n)
{	return soap_instantiate_emi__EventFilterType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__EventFilterType(struct soap *soap, emi__EventFilterType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__EventFilterType * SOAP_FMAC4 soap_instantiate_emi__EventFilterType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__EventFilterType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__EventFilterType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__EventFilterType;
		if (size)
			*size = sizeof(emi__EventFilterType);
		((emi__EventFilterType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__EventFilterType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__EventFilterType);
		for (int i = 0; i < n; i++)
			((emi__EventFilterType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__EventFilterType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__EventFilterType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__EventFilterType %p -> %p\n", q, p));
	*(emi__EventFilterType*)p = *(emi__EventFilterType*)q;
}

void emi__EventLogRecordType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_emi__TimeType(soap, &this->emi__EventLogRecordType::TimeStamp);
	soap_default_unsignedByte(soap, &this->emi__EventLogRecordType::DeviceAddress);
	soap_default_unsignedByte(soap, &this->emi__EventLogRecordType::EventSensorType);
	soap_default_unsignedByte(soap, &this->emi__EventLogRecordType::EventType);
	soap_default_unsignedByte(soap, &this->emi__EventLogRecordType::EventOffset);
	soap_default_unsignedByte(soap, &this->emi__EventLogRecordType::EventSourceType);
	soap_default_emi__EventSeverityType(soap, &this->emi__EventLogRecordType::EventSeverity);
	soap_default_unsignedByte(soap, &this->emi__EventLogRecordType::SensorNumber);
	soap_default_unsignedByte(soap, &this->emi__EventLogRecordType::Entity);
	soap_default_unsignedByte(soap, &this->emi__EventLogRecordType::EntityInstance);
	this->emi__EventLogRecordType::EventData = NULL;
	/* transient soap skipped */
}

void emi__EventLogRecordType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &this->emi__EventLogRecordType::DeviceAddress, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventLogRecordType::EventSensorType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventLogRecordType::EventType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventLogRecordType::EventOffset, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventLogRecordType::EventSourceType, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventLogRecordType::SensorNumber, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventLogRecordType::Entity, SOAP_TYPE_unsignedByte);
	soap_embedded(soap, &this->emi__EventLogRecordType::EntityInstance, SOAP_TYPE_unsignedByte);
	soap_serialize_PointerToemi__ByteData(soap, &this->emi__EventLogRecordType::EventData);
	/* transient soap skipped */
}

int emi__EventLogRecordType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__EventLogRecordType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__EventLogRecordType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__EventLogRecordType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__EventLogRecordType(struct soap *soap, const char *tag, int id, const emi__EventLogRecordType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__EventLogRecordType), type);
	soap_out_emi__TimeType(soap, "emi:TimeStamp", -1, &(a->emi__EventLogRecordType::TimeStamp), "");
	soap_out_unsignedByte(soap, "emi:DeviceAddress", -1, &(a->emi__EventLogRecordType::DeviceAddress), "");
	soap_out_unsignedByte(soap, "emi:EventSensorType", -1, &(a->emi__EventLogRecordType::EventSensorType), "");
	soap_out_unsignedByte(soap, "emi:EventType", -1, &(a->emi__EventLogRecordType::EventType), "");
	soap_out_unsignedByte(soap, "emi:EventOffset", -1, &(a->emi__EventLogRecordType::EventOffset), "");
	soap_out_unsignedByte(soap, "emi:EventSourceType", -1, &(a->emi__EventLogRecordType::EventSourceType), "");
	soap_out_emi__EventSeverityType(soap, "emi:EventSeverity", -1, &(a->emi__EventLogRecordType::EventSeverity), "");
	soap_out_unsignedByte(soap, "emi:SensorNumber", -1, &(a->emi__EventLogRecordType::SensorNumber), "");
	soap_out_unsignedByte(soap, "emi:Entity", -1, &(a->emi__EventLogRecordType::Entity), "");
	soap_out_unsignedByte(soap, "emi:EntityInstance", -1, &(a->emi__EventLogRecordType::EntityInstance), "");
	soap_out_PointerToemi__ByteData(soap, "emi:EventData", -1, &(a->emi__EventLogRecordType::EventData), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__EventLogRecordType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__EventLogRecordType(soap, this, tag, type);
}

SOAP_FMAC3 emi__EventLogRecordType * SOAP_FMAC4 soap_get_emi__EventLogRecordType(struct soap *soap, emi__EventLogRecordType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__EventLogRecordType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__EventLogRecordType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__EventLogRecordType(soap, tag, this, type);
}

SOAP_FMAC3 emi__EventLogRecordType * SOAP_FMAC4 soap_in_emi__EventLogRecordType(struct soap *soap, const char *tag, emi__EventLogRecordType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__EventLogRecordType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__EventLogRecordType, sizeof(emi__EventLogRecordType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__EventLogRecordType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__EventLogRecordType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_TimeStamp1 = 1, soap_flag_DeviceAddress1 = 1, soap_flag_EventSensorType1 = 1, soap_flag_EventType1 = 1, soap_flag_EventOffset1 = 1, soap_flag_EventSourceType1 = 1, soap_flag_EventSeverity1 = 1, soap_flag_SensorNumber1 = 1, soap_flag_Entity1 = 1, soap_flag_EntityInstance1 = 1, soap_flag_EventData1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_TimeStamp1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__TimeType(soap, "emi:TimeStamp", &(a->emi__EventLogRecordType::TimeStamp), "emi:TimeType"))
				{	soap_flag_TimeStamp1--;
					continue;
				}
			if (soap_flag_DeviceAddress1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:DeviceAddress", &(a->emi__EventLogRecordType::DeviceAddress), "xsd:unsignedByte"))
				{	soap_flag_DeviceAddress1--;
					continue;
				}
			if (soap_flag_EventSensorType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventSensorType", &(a->emi__EventLogRecordType::EventSensorType), "xsd:unsignedByte"))
				{	soap_flag_EventSensorType1--;
					continue;
				}
			if (soap_flag_EventType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventType", &(a->emi__EventLogRecordType::EventType), "xsd:unsignedByte"))
				{	soap_flag_EventType1--;
					continue;
				}
			if (soap_flag_EventOffset1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventOffset", &(a->emi__EventLogRecordType::EventOffset), "xsd:unsignedByte"))
				{	soap_flag_EventOffset1--;
					continue;
				}
			if (soap_flag_EventSourceType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EventSourceType", &(a->emi__EventLogRecordType::EventSourceType), "xsd:unsignedByte"))
				{	soap_flag_EventSourceType1--;
					continue;
				}
			if (soap_flag_EventSeverity1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_emi__EventSeverityType(soap, "emi:EventSeverity", &(a->emi__EventLogRecordType::EventSeverity), "emi:EventSeverityType"))
				{	soap_flag_EventSeverity1--;
					continue;
				}
			if (soap_flag_SensorNumber1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:SensorNumber", &(a->emi__EventLogRecordType::SensorNumber), "xsd:unsignedByte"))
				{	soap_flag_SensorNumber1--;
					continue;
				}
			if (soap_flag_Entity1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:Entity", &(a->emi__EventLogRecordType::Entity), "xsd:unsignedByte"))
				{	soap_flag_Entity1--;
					continue;
				}
			if (soap_flag_EntityInstance1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "emi:EntityInstance", &(a->emi__EventLogRecordType::EntityInstance), "xsd:unsignedByte"))
				{	soap_flag_EntityInstance1--;
					continue;
				}
			if (soap_flag_EventData1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToemi__ByteData(soap, "emi:EventData", &(a->emi__EventLogRecordType::EventData), "emi:ByteData"))
				{	soap_flag_EventData1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__EventLogRecordType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__EventLogRecordType, 0, sizeof(emi__EventLogRecordType), 0, soap_copy_emi__EventLogRecordType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_TimeStamp1 > 0 || soap_flag_DeviceAddress1 > 0 || soap_flag_EventSensorType1 > 0 || soap_flag_EventType1 > 0 || soap_flag_EventOffset1 > 0 || soap_flag_EventSourceType1 > 0 || soap_flag_EventSeverity1 > 0 || soap_flag_SensorNumber1 > 0 || soap_flag_Entity1 > 0 || soap_flag_EntityInstance1 > 0 || soap_flag_EventData1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__EventLogRecordType * SOAP_FMAC6 soap_new_emi__EventLogRecordType(struct soap *soap, int n)
{	return soap_instantiate_emi__EventLogRecordType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__EventLogRecordType(struct soap *soap, emi__EventLogRecordType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__EventLogRecordType * SOAP_FMAC4 soap_instantiate_emi__EventLogRecordType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__EventLogRecordType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__EventLogRecordType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__EventLogRecordType;
		if (size)
			*size = sizeof(emi__EventLogRecordType);
		((emi__EventLogRecordType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__EventLogRecordType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__EventLogRecordType);
		for (int i = 0; i < n; i++)
			((emi__EventLogRecordType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__EventLogRecordType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__EventLogRecordType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__EventLogRecordType %p -> %p\n", q, p));
	*(emi__EventLogRecordType*)p = *(emi__EventLogRecordType*)q;
}

void emi__ByteData::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfunsignedByte(soap, &this->emi__ByteData::Byte);
	/* transient soap skipped */
}

void emi__ByteData::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfunsignedByte(soap, &this->emi__ByteData::Byte);
	/* transient soap skipped */
}

int emi__ByteData::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__ByteData);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__ByteData::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__ByteData(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__ByteData(struct soap *soap, const char *tag, int id, const emi__ByteData *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__ByteData), type);
	soap_out_std__vectorTemplateOfunsignedByte(soap, "emi:Byte", -1, &(a->emi__ByteData::Byte), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__ByteData::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__ByteData(soap, this, tag, type);
}

SOAP_FMAC3 emi__ByteData * SOAP_FMAC4 soap_get_emi__ByteData(struct soap *soap, emi__ByteData *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__ByteData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__ByteData::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__ByteData(soap, tag, this, type);
}

SOAP_FMAC3 emi__ByteData * SOAP_FMAC4 soap_in_emi__ByteData(struct soap *soap, const char *tag, emi__ByteData *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__ByteData *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__ByteData, sizeof(emi__ByteData), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__ByteData)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__ByteData *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfunsignedByte(soap, "emi:Byte", &(a->emi__ByteData::Byte), "xsd:unsignedByte"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__ByteData *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__ByteData, 0, sizeof(emi__ByteData), 0, soap_copy_emi__ByteData);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->emi__ByteData::Byte.size() < 8 || a->emi__ByteData::Byte.size() > 8))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__ByteData * SOAP_FMAC6 soap_new_emi__ByteData(struct soap *soap, int n)
{	return soap_instantiate_emi__ByteData(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__ByteData(struct soap *soap, emi__ByteData *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__ByteData * SOAP_FMAC4 soap_instantiate_emi__ByteData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__ByteData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__ByteData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__ByteData;
		if (size)
			*size = sizeof(emi__ByteData);
		((emi__ByteData*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__ByteData[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__ByteData);
		for (int i = 0; i < n; i++)
			((emi__ByteData*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__ByteData*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__ByteData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__ByteData %p -> %p\n", q, p));
	*(emi__ByteData*)p = *(emi__ByteData*)q;
}

void emi__AlertSubscriptionPolicyIDArrayType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(soap, &this->emi__AlertSubscriptionPolicyIDArrayType::AlertSubscriptionPolicyID);
	/* transient soap skipped */
}

void emi__AlertSubscriptionPolicyIDArrayType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(soap, &this->emi__AlertSubscriptionPolicyIDArrayType::AlertSubscriptionPolicyID);
	/* transient soap skipped */
}

int emi__AlertSubscriptionPolicyIDArrayType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int emi__AlertSubscriptionPolicyIDArrayType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_emi__AlertSubscriptionPolicyIDArrayType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_emi__AlertSubscriptionPolicyIDArrayType(struct soap *soap, const char *tag, int id, const emi__AlertSubscriptionPolicyIDArrayType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType), type);
	soap_out_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(soap, "emi:AlertSubscriptionPolicyID", -1, &(a->emi__AlertSubscriptionPolicyIDArrayType::AlertSubscriptionPolicyID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *emi__AlertSubscriptionPolicyIDArrayType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_emi__AlertSubscriptionPolicyIDArrayType(soap, this, tag, type);
}

SOAP_FMAC3 emi__AlertSubscriptionPolicyIDArrayType * SOAP_FMAC4 soap_get_emi__AlertSubscriptionPolicyIDArrayType(struct soap *soap, emi__AlertSubscriptionPolicyIDArrayType *p, const char *tag, const char *type)
{
	if ((p = soap_in_emi__AlertSubscriptionPolicyIDArrayType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *emi__AlertSubscriptionPolicyIDArrayType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_emi__AlertSubscriptionPolicyIDArrayType(soap, tag, this, type);
}

SOAP_FMAC3 emi__AlertSubscriptionPolicyIDArrayType * SOAP_FMAC4 soap_in_emi__AlertSubscriptionPolicyIDArrayType(struct soap *soap, const char *tag, emi__AlertSubscriptionPolicyIDArrayType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (emi__AlertSubscriptionPolicyIDArrayType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType, sizeof(emi__AlertSubscriptionPolicyIDArrayType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (emi__AlertSubscriptionPolicyIDArrayType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(soap, "emi:AlertSubscriptionPolicyID", &(a->emi__AlertSubscriptionPolicyIDArrayType::AlertSubscriptionPolicyID), "emi:AlertSubscriptionPolicyIDType"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionPolicyIDArrayType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType, 0, sizeof(emi__AlertSubscriptionPolicyIDArrayType), 0, soap_copy_emi__AlertSubscriptionPolicyIDArrayType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 emi__AlertSubscriptionPolicyIDArrayType * SOAP_FMAC6 soap_new_emi__AlertSubscriptionPolicyIDArrayType(struct soap *soap, int n)
{	return soap_instantiate_emi__AlertSubscriptionPolicyIDArrayType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_emi__AlertSubscriptionPolicyIDArrayType(struct soap *soap, emi__AlertSubscriptionPolicyIDArrayType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 emi__AlertSubscriptionPolicyIDArrayType * SOAP_FMAC4 soap_instantiate_emi__AlertSubscriptionPolicyIDArrayType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_emi__AlertSubscriptionPolicyIDArrayType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_emi__AlertSubscriptionPolicyIDArrayType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new emi__AlertSubscriptionPolicyIDArrayType;
		if (size)
			*size = sizeof(emi__AlertSubscriptionPolicyIDArrayType);
		((emi__AlertSubscriptionPolicyIDArrayType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new emi__AlertSubscriptionPolicyIDArrayType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(emi__AlertSubscriptionPolicyIDArrayType);
		for (int i = 0; i < n; i++)
			((emi__AlertSubscriptionPolicyIDArrayType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (emi__AlertSubscriptionPolicyIDArrayType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_emi__AlertSubscriptionPolicyIDArrayType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying emi__AlertSubscriptionPolicyIDArrayType %p -> %p\n", q, p));
	*(emi__AlertSubscriptionPolicyIDArrayType*)p = *(emi__AlertSubscriptionPolicyIDArrayType*)q;
}

void cmn__NodeAddressType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->cmn__NodeAddressType::__union_NodeAddressType = 0;
	/* transient soap skipped */
}

void cmn__NodeAddressType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize__cmn__union_NodeAddressType(soap, this->cmn__NodeAddressType::__union_NodeAddressType, &this->cmn__NodeAddressType::union_NodeAddressType);
	/* transient soap skipped */
}

int cmn__NodeAddressType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_cmn__NodeAddressType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int cmn__NodeAddressType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_cmn__NodeAddressType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__NodeAddressType(struct soap *soap, const char *tag, int id, const cmn__NodeAddressType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_cmn__NodeAddressType), type);
	soap_out__cmn__union_NodeAddressType(soap, a->cmn__NodeAddressType::__union_NodeAddressType, &a->cmn__NodeAddressType::union_NodeAddressType);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *cmn__NodeAddressType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_cmn__NodeAddressType(soap, this, tag, type);
}

SOAP_FMAC3 cmn__NodeAddressType * SOAP_FMAC4 soap_get_cmn__NodeAddressType(struct soap *soap, cmn__NodeAddressType *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__NodeAddressType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *cmn__NodeAddressType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_cmn__NodeAddressType(soap, tag, this, type);
}

SOAP_FMAC3 cmn__NodeAddressType * SOAP_FMAC4 soap_in_cmn__NodeAddressType(struct soap *soap, const char *tag, cmn__NodeAddressType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (cmn__NodeAddressType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_cmn__NodeAddressType, sizeof(cmn__NodeAddressType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_cmn__NodeAddressType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (cmn__NodeAddressType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_union_NodeAddressType1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_union_NodeAddressType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__cmn__union_NodeAddressType(soap, &a->cmn__NodeAddressType::__union_NodeAddressType, &a->cmn__NodeAddressType::union_NodeAddressType))
				{	soap_flag_union_NodeAddressType1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (cmn__NodeAddressType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_cmn__NodeAddressType, 0, sizeof(cmn__NodeAddressType), 0, soap_copy_cmn__NodeAddressType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_union_NodeAddressType1))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 cmn__NodeAddressType * SOAP_FMAC6 soap_new_cmn__NodeAddressType(struct soap *soap, int n)
{	return soap_instantiate_cmn__NodeAddressType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_cmn__NodeAddressType(struct soap *soap, cmn__NodeAddressType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 cmn__NodeAddressType * SOAP_FMAC4 soap_instantiate_cmn__NodeAddressType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_cmn__NodeAddressType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_cmn__NodeAddressType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new cmn__NodeAddressType;
		if (size)
			*size = sizeof(cmn__NodeAddressType);
		((cmn__NodeAddressType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new cmn__NodeAddressType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(cmn__NodeAddressType);
		for (int i = 0; i < n; i++)
			((cmn__NodeAddressType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (cmn__NodeAddressType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_cmn__NodeAddressType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying cmn__NodeAddressType %p -> %p\n", q, p));
	*(cmn__NodeAddressType*)p = *(cmn__NodeAddressType*)q;
}

void cmn__URLType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__anyURI(soap, &this->cmn__URLType::__item);
	this->cmn__URLType::__anyAttribute = NULL;
	/* transient soap skipped */
}

void cmn__URLType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &this->cmn__URLType::__item);
	/* transient soap skipped */
}

int cmn__URLType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_cmn__URLType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int cmn__URLType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_cmn__URLType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_cmn__URLType(struct soap *soap, const char *tag, int id, const cmn__URLType *a, const char *type)
{
	if (((cmn__URLType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((cmn__URLType *)a)->__anyAttribute);
	return soap_out_xsd__anyURI(soap, tag, id, &a->cmn__URLType::__item, "");
}

void *cmn__URLType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_cmn__URLType(soap, this, tag, type);
}

SOAP_FMAC3 cmn__URLType * SOAP_FMAC4 soap_get_cmn__URLType(struct soap *soap, cmn__URLType *p, const char *tag, const char *type)
{
	if ((p = soap_in_cmn__URLType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *cmn__URLType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_cmn__URLType(soap, tag, this, type);
}

SOAP_FMAC3 cmn__URLType * SOAP_FMAC4 soap_in_cmn__URLType(struct soap *soap, const char *tag, cmn__URLType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (cmn__URLType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_cmn__URLType, sizeof(cmn__URLType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_cmn__URLType)
			return (cmn__URLType *)a->soap_in(soap, tag, type);
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((cmn__URLType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_xsd__anyURI(soap, tag, &(a->cmn__URLType::__item), "cmn:URLType"))
		return NULL;
	return a;
}

SOAP_FMAC5 cmn__URLType * SOAP_FMAC6 soap_new_cmn__URLType(struct soap *soap, int n)
{	return soap_instantiate_cmn__URLType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_cmn__URLType(struct soap *soap, cmn__URLType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 cmn__URLType * SOAP_FMAC4 soap_instantiate_cmn__URLType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_cmn__URLType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_cmn__URLType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new cmn__URLType;
		if (size)
			*size = sizeof(cmn__URLType);
		((cmn__URLType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new cmn__URLType[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(cmn__URLType);
		for (int i = 0; i < n; i++)
			((cmn__URLType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (cmn__URLType*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_cmn__URLType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying cmn__URLType %p -> %p\n", q, p));
	*(cmn__URLType*)p = *(cmn__URLType*)q;
}

void xsd__base64Binary::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
	this->id = NULL;
	this->type = NULL;
	this->options = NULL;
}

void xsd__base64Binary::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_xsd__base64Binary))
		if (this->id || this->type)
			soap->mode |= SOAP_ENC_DIME;
}

int xsd__base64Binary::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_xsd__base64Binary);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int xsd__base64Binary::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_xsd__base64Binary(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const xsd__base64Binary *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE_xsd__base64Binary);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
#endif
	if (id < 0)
		return soap->error;
	soap_element_begin_out(soap, tag, id, type);
	soap_putbase64(soap, a->__ptr, a->__size);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *xsd__base64Binary::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xsd__base64Binary(soap, this, tag, type);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *xsd__base64Binary::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xsd__base64Binary(soap, tag, this, type);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, xsd__base64Binary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (xsd__base64Binary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(xsd__base64Binary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__base64Binary, 0, sizeof(xsd__base64Binary), 0, soap_copy_xsd__base64Binary);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 xsd__base64Binary * SOAP_FMAC6 soap_new_xsd__base64Binary(struct soap *soap, int n)
{	return soap_instantiate_xsd__base64Binary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__base64Binary(struct soap *soap, xsd__base64Binary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_instantiate_xsd__base64Binary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__base64Binary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__base64Binary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new xsd__base64Binary;
		if (size)
			*size = sizeof(xsd__base64Binary);
		((xsd__base64Binary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new xsd__base64Binary[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xsd__base64Binary);
		for (int i = 0; i < n; i++)
			((xsd__base64Binary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xsd__base64Binary*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__base64Binary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__base64Binary %p -> %p\n", q, p));
	*(xsd__base64Binary*)p = *(xsd__base64Binary*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__anyURI(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__anyURI), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_xsd__anyURI(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__anyURI, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__anyURI, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__anyURI, 0, sizeof(std::string), 0, soap_copy_xsd__anyURI);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_xsd__anyURI(struct soap *soap, int n)
{	return soap_instantiate_xsd__anyURI(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__anyURI(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_xsd__anyURI(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__anyURI(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__anyURI, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__anyURI(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{	(void)soap; /* appease -Wall -Werror */
	p->erase();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *p)
{	(void)soap; (void)p; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
	if (soap_out_std__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_std__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_std__string(struct soap *soap, int n)
{	return soap_instantiate_std__string(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__string(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___emc__SoapAlert(struct soap *soap, struct __emc__SoapAlert *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->emc__SoapAlertRequest = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___emc__SoapAlert(struct soap *soap, const struct __emc__SoapAlert *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_emc__SoapAlertRequest(soap, &a->emc__SoapAlertRequest);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___emc__SoapAlert(struct soap *soap, const struct __emc__SoapAlert *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___emc__SoapAlert(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___emc__SoapAlert(struct soap *soap, const char *tag, int id, const struct __emc__SoapAlert *a, const char *type)
{
	soap_out_PointerTo_emc__SoapAlertRequest(soap, "emc:SoapAlertRequest", -1, &a->emc__SoapAlertRequest, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __emc__SoapAlert * SOAP_FMAC4 soap_get___emc__SoapAlert(struct soap *soap, struct __emc__SoapAlert *p, const char *tag, const char *type)
{
	if ((p = soap_in___emc__SoapAlert(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __emc__SoapAlert * SOAP_FMAC4 soap_in___emc__SoapAlert(struct soap *soap, const char *tag, struct __emc__SoapAlert *a, const char *type)
{
	short soap_flag_emc__SoapAlertRequest = 1;
	short soap_flag;
	a = (struct __emc__SoapAlert *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___emc__SoapAlert, sizeof(struct __emc__SoapAlert), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___emc__SoapAlert(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_emc__SoapAlertRequest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_emc__SoapAlertRequest(soap, "emc:SoapAlertRequest", &a->emc__SoapAlertRequest, ""))
				{	soap_flag_emc__SoapAlertRequest--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC5 struct __emc__SoapAlert * SOAP_FMAC6 soap_new___emc__SoapAlert(struct soap *soap, int n)
{	return soap_instantiate___emc__SoapAlert(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete___emc__SoapAlert(struct soap *soap, struct __emc__SoapAlert *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct __emc__SoapAlert * SOAP_FMAC4 soap_instantiate___emc__SoapAlert(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___emc__SoapAlert(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___emc__SoapAlert, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct __emc__SoapAlert;
		if (size)
			*size = sizeof(struct __emc__SoapAlert);
	}
	else
	{	cp->ptr = (void*)new struct __emc__SoapAlert[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __emc__SoapAlert);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __emc__SoapAlert*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy___emc__SoapAlert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __emc__SoapAlert %p -> %p\n", q, p));
	*(struct __emc__SoapAlert*)p = *(struct __emc__SoapAlert*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__sai__union_EnvironmentDetectionType(struct soap *soap, int choice, const union _sai__union_EnvironmentDetectionType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	switch (choice)
	{
	case SOAP_UNION__sai__union_EnvironmentDetectionType_LocalDomains:
		soap_serialize_PointerTosai__EnvironmentDetectionDomainType(soap, &a->LocalDomains);
		break;
	case SOAP_UNION__sai__union_EnvironmentDetectionType_RemoteAddressHTTPS:
		soap_serialize_PointerTosai__EnvironmentDetectionHTTPSType(soap, &a->RemoteAddressHTTPS);
		break;
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__sai__union_EnvironmentDetectionType(struct soap *soap, int choice, const union _sai__union_EnvironmentDetectionType *a)
{
	switch (choice)
	{
	case SOAP_UNION__sai__union_EnvironmentDetectionType_LocalDomains:
		return soap_out_PointerTosai__EnvironmentDetectionDomainType(soap, "sai:LocalDomains", -1, &a->LocalDomains, "");
	case SOAP_UNION__sai__union_EnvironmentDetectionType_RemoteAddressHTTPS:
		return soap_out_PointerTosai__EnvironmentDetectionHTTPSType(soap, "sai:RemoteAddressHTTPS", -1, &a->RemoteAddressHTTPS, "");
	}
	return SOAP_OK;
}

SOAP_FMAC3 union _sai__union_EnvironmentDetectionType * SOAP_FMAC4 soap_in__sai__union_EnvironmentDetectionType(struct soap *soap, int *choice, union _sai__union_EnvironmentDetectionType *a)
{	soap->error = SOAP_TAG_MISMATCH;
	a->LocalDomains = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerTosai__EnvironmentDetectionDomainType(soap, "sai:LocalDomains", &a->LocalDomains, "sai:EnvironmentDetectionDomainType"))
	{	*choice = SOAP_UNION__sai__union_EnvironmentDetectionType_LocalDomains;
		return a;
	}
	a->RemoteAddressHTTPS = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerTosai__EnvironmentDetectionHTTPSType(soap, "sai:RemoteAddressHTTPS", &a->RemoteAddressHTTPS, "sai:EnvironmentDetectionHTTPSType"))
	{	*choice = SOAP_UNION__sai__union_EnvironmentDetectionType_RemoteAddressHTTPS;
		return a;
	}
	*choice = 0;
	if (!soap->error)
		soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__sai__union_UserAclEntryExType(struct soap *soap, int choice, const union _sai__union_UserAclEntryExType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	switch (choice)
	{
	case SOAP_UNION__sai__union_UserAclEntryExType_DigestUser:
		soap_serialize_PointerTosai__UserEntryDigestType(soap, &a->DigestUser);
		break;
	case SOAP_UNION__sai__union_UserAclEntryExType_KerberosUser:
		soap_serialize_PointerTosai__UserEntryKerberosType(soap, &a->KerberosUser);
		break;
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__sai__union_UserAclEntryExType(struct soap *soap, int choice, const union _sai__union_UserAclEntryExType *a)
{
	switch (choice)
	{
	case SOAP_UNION__sai__union_UserAclEntryExType_DigestUser:
		return soap_out_PointerTosai__UserEntryDigestType(soap, "sai:DigestUser", -1, &a->DigestUser, "");
	case SOAP_UNION__sai__union_UserAclEntryExType_KerberosUser:
		return soap_out_PointerTosai__UserEntryKerberosType(soap, "sai:KerberosUser", -1, &a->KerberosUser, "");
	}
	return SOAP_OK;
}

SOAP_FMAC3 union _sai__union_UserAclEntryExType * SOAP_FMAC4 soap_in__sai__union_UserAclEntryExType(struct soap *soap, int *choice, union _sai__union_UserAclEntryExType *a)
{	soap->error = SOAP_TAG_MISMATCH;
	a->DigestUser = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerTosai__UserEntryDigestType(soap, "sai:DigestUser", &a->DigestUser, "sai:UserEntryDigestType"))
	{	*choice = SOAP_UNION__sai__union_UserAclEntryExType_DigestUser;
		return a;
	}
	a->KerberosUser = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerTosai__UserEntryKerberosType(soap, "sai:KerberosUser", &a->KerberosUser, "sai:UserEntryKerberosType"))
	{	*choice = SOAP_UNION__sai__union_UserAclEntryExType_KerberosUser;
		return a;
	}
	*choice = 0;
	if (!soap->error)
		soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__emi__union_AlertSubscriptionGeneralType(struct soap *soap, int choice, const union _emi__union_AlertSubscriptionGeneralType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	switch (choice)
	{
	case SOAP_UNION__emi__union_AlertSubscriptionGeneralType_AlertSubscriptionSNMP:
		soap_serialize_PointerToemi__AlertSubscriptionSNMPType(soap, &a->AlertSubscriptionSNMP);
		break;
	case SOAP_UNION__emi__union_AlertSubscriptionGeneralType_AlertSubscriptionSoap:
		soap_serialize_PointerToemi__AlertSubscriptionSoapType(soap, &a->AlertSubscriptionSoap);
		break;
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__emi__union_AlertSubscriptionGeneralType(struct soap *soap, int choice, const union _emi__union_AlertSubscriptionGeneralType *a)
{
	switch (choice)
	{
	case SOAP_UNION__emi__union_AlertSubscriptionGeneralType_AlertSubscriptionSNMP:
		return soap_out_PointerToemi__AlertSubscriptionSNMPType(soap, "emi:AlertSubscriptionSNMP", -1, &a->AlertSubscriptionSNMP, "");
	case SOAP_UNION__emi__union_AlertSubscriptionGeneralType_AlertSubscriptionSoap:
		return soap_out_PointerToemi__AlertSubscriptionSoapType(soap, "emi:AlertSubscriptionSoap", -1, &a->AlertSubscriptionSoap, "");
	}
	return SOAP_OK;
}

SOAP_FMAC3 union _emi__union_AlertSubscriptionGeneralType * SOAP_FMAC4 soap_in__emi__union_AlertSubscriptionGeneralType(struct soap *soap, int *choice, union _emi__union_AlertSubscriptionGeneralType *a)
{	soap->error = SOAP_TAG_MISMATCH;
	a->AlertSubscriptionSNMP = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerToemi__AlertSubscriptionSNMPType(soap, "emi:AlertSubscriptionSNMP", &a->AlertSubscriptionSNMP, "emi:AlertSubscriptionSNMPType"))
	{	*choice = SOAP_UNION__emi__union_AlertSubscriptionGeneralType_AlertSubscriptionSNMP;
		return a;
	}
	a->AlertSubscriptionSoap = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerToemi__AlertSubscriptionSoapType(soap, "emi:AlertSubscriptionSoap", &a->AlertSubscriptionSoap, "emi:AlertSubscriptionSoapType"))
	{	*choice = SOAP_UNION__emi__union_AlertSubscriptionGeneralType_AlertSubscriptionSoap;
		return a;
	}
	*choice = 0;
	if (!soap->error)
		soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__cmn__union_NodeAddressType(struct soap *soap, int choice, const union _cmn__union_NodeAddressType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	switch (choice)
	{
	case SOAP_UNION__cmn__union_NodeAddressType_HostName:
		soap_serialize_PointerTocmn__HostNameType(soap, &a->HostName);
		break;
	case SOAP_UNION__cmn__union_NodeAddressType_IPv4Address:
		soap_serialize_PointerTocmn__IPv4AddressStringType(soap, &a->IPv4Address);
		break;
	case SOAP_UNION__cmn__union_NodeAddressType_IPv6Address:
		soap_serialize_PointerTocmn__IPv6AddressStringType(soap, &a->IPv6Address);
		break;
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__cmn__union_NodeAddressType(struct soap *soap, int choice, const union _cmn__union_NodeAddressType *a)
{
	switch (choice)
	{
	case SOAP_UNION__cmn__union_NodeAddressType_HostName:
		return soap_out_PointerTocmn__HostNameType(soap, "cmn:HostName", -1, &a->HostName, "");
	case SOAP_UNION__cmn__union_NodeAddressType_IPv4Address:
		return soap_out_PointerTocmn__IPv4AddressStringType(soap, "cmn:IPv4Address", -1, &a->IPv4Address, "");
	case SOAP_UNION__cmn__union_NodeAddressType_IPv6Address:
		return soap_out_PointerTocmn__IPv6AddressStringType(soap, "cmn:IPv6Address", -1, &a->IPv6Address, "");
	}
	return SOAP_OK;
}

SOAP_FMAC3 union _cmn__union_NodeAddressType * SOAP_FMAC4 soap_in__cmn__union_NodeAddressType(struct soap *soap, int *choice, union _cmn__union_NodeAddressType *a)
{	soap->error = SOAP_TAG_MISMATCH;
	a->HostName = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerTocmn__HostNameType(soap, "cmn:HostName", &a->HostName, "cmn:HostNameType"))
	{	*choice = SOAP_UNION__cmn__union_NodeAddressType_HostName;
		return a;
	}
	a->IPv4Address = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerTocmn__IPv4AddressStringType(soap, "cmn:IPv4Address", &a->IPv4Address, "cmn:IPv4AddressStringType"))
	{	*choice = SOAP_UNION__cmn__union_NodeAddressType_IPv4Address;
		return a;
	}
	a->IPv6Address = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerTocmn__IPv6AddressStringType(soap, "cmn:IPv6Address", &a->IPv6Address, "cmn:IPv6AddressStringType"))
	{	*choice = SOAP_UNION__cmn__union_NodeAddressType_IPv6Address;
		return a;
	}
	*choice = 0;
	if (!soap->error)
		soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_emc__SoapAlertResponse(struct soap *soap, _emc__SoapAlertResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__emc__SoapAlertResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_emc__SoapAlertResponse(struct soap *soap, _emc__SoapAlertResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_emc__SoapAlertResponse);
	if (soap_out_PointerTo_emc__SoapAlertResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_emc__SoapAlertResponse(struct soap *soap, const char *tag, int id, _emc__SoapAlertResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__emc__SoapAlertResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _emc__SoapAlertResponse ** SOAP_FMAC4 soap_get_PointerTo_emc__SoapAlertResponse(struct soap *soap, _emc__SoapAlertResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_emc__SoapAlertResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _emc__SoapAlertResponse ** SOAP_FMAC4 soap_in_PointerTo_emc__SoapAlertResponse(struct soap *soap, const char *tag, _emc__SoapAlertResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_emc__SoapAlertResponse **)soap_malloc(soap, sizeof(_emc__SoapAlertResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_emc__SoapAlertResponse *)soap_instantiate__emc__SoapAlertResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_emc__SoapAlertResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__emc__SoapAlertResponse, sizeof(_emc__SoapAlertResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_emc__SoapAlertRequest(struct soap *soap, _emc__SoapAlertRequest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__emc__SoapAlertRequest))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_emc__SoapAlertRequest(struct soap *soap, _emc__SoapAlertRequest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_emc__SoapAlertRequest);
	if (soap_out_PointerTo_emc__SoapAlertRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_emc__SoapAlertRequest(struct soap *soap, const char *tag, int id, _emc__SoapAlertRequest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__emc__SoapAlertRequest);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _emc__SoapAlertRequest ** SOAP_FMAC4 soap_get_PointerTo_emc__SoapAlertRequest(struct soap *soap, _emc__SoapAlertRequest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_emc__SoapAlertRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _emc__SoapAlertRequest ** SOAP_FMAC4 soap_in_PointerTo_emc__SoapAlertRequest(struct soap *soap, const char *tag, _emc__SoapAlertRequest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_emc__SoapAlertRequest **)soap_malloc(soap, sizeof(_emc__SoapAlertRequest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_emc__SoapAlertRequest *)soap_instantiate__emc__SoapAlertRequest(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_emc__SoapAlertRequest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__emc__SoapAlertRequest, sizeof(_emc__SoapAlertRequest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedInt(struct soap *soap, unsigned int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedInt(struct soap *soap, unsigned int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedInt);
	if (soap_out_PointerTounsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedInt(struct soap *soap, const char *tag, int id, unsigned int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedInt);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedInt(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned int ** SOAP_FMAC4 soap_get_PointerTounsignedInt(struct soap *soap, unsigned int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int ** SOAP_FMAC4 soap_in_PointerTounsignedInt(struct soap *soap, const char *tag, unsigned int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned int **)soap_malloc(soap, sizeof(unsigned int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedInt(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedInt, sizeof(unsigned int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosai__EnvironmentDetectionHTTPSType(struct soap *soap, sai__EnvironmentDetectionHTTPSType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sai__EnvironmentDetectionHTTPSType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosai__EnvironmentDetectionHTTPSType(struct soap *soap, sai__EnvironmentDetectionHTTPSType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosai__EnvironmentDetectionHTTPSType);
	if (soap_out_PointerTosai__EnvironmentDetectionHTTPSType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosai__EnvironmentDetectionHTTPSType(struct soap *soap, const char *tag, int id, sai__EnvironmentDetectionHTTPSType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sai__EnvironmentDetectionHTTPSType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sai__EnvironmentDetectionHTTPSType ** SOAP_FMAC4 soap_get_PointerTosai__EnvironmentDetectionHTTPSType(struct soap *soap, sai__EnvironmentDetectionHTTPSType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosai__EnvironmentDetectionHTTPSType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 sai__EnvironmentDetectionHTTPSType ** SOAP_FMAC4 soap_in_PointerTosai__EnvironmentDetectionHTTPSType(struct soap *soap, const char *tag, sai__EnvironmentDetectionHTTPSType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sai__EnvironmentDetectionHTTPSType **)soap_malloc(soap, sizeof(sai__EnvironmentDetectionHTTPSType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sai__EnvironmentDetectionHTTPSType *)soap_instantiate_sai__EnvironmentDetectionHTTPSType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (sai__EnvironmentDetectionHTTPSType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sai__EnvironmentDetectionHTTPSType, sizeof(sai__EnvironmentDetectionHTTPSType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosai__EnvironmentDetectionDomainType(struct soap *soap, sai__EnvironmentDetectionDomainType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sai__EnvironmentDetectionDomainType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosai__EnvironmentDetectionDomainType(struct soap *soap, sai__EnvironmentDetectionDomainType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosai__EnvironmentDetectionDomainType);
	if (soap_out_PointerTosai__EnvironmentDetectionDomainType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosai__EnvironmentDetectionDomainType(struct soap *soap, const char *tag, int id, sai__EnvironmentDetectionDomainType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sai__EnvironmentDetectionDomainType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sai__EnvironmentDetectionDomainType ** SOAP_FMAC4 soap_get_PointerTosai__EnvironmentDetectionDomainType(struct soap *soap, sai__EnvironmentDetectionDomainType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosai__EnvironmentDetectionDomainType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 sai__EnvironmentDetectionDomainType ** SOAP_FMAC4 soap_in_PointerTosai__EnvironmentDetectionDomainType(struct soap *soap, const char *tag, sai__EnvironmentDetectionDomainType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sai__EnvironmentDetectionDomainType **)soap_malloc(soap, sizeof(sai__EnvironmentDetectionDomainType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sai__EnvironmentDetectionDomainType *)soap_instantiate_sai__EnvironmentDetectionDomainType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (sai__EnvironmentDetectionDomainType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sai__EnvironmentDetectionDomainType, sizeof(sai__EnvironmentDetectionDomainType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTobool(struct soap *soap, bool *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_bool);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTobool(struct soap *soap, bool *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTobool);
	if (soap_out_PointerTobool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTobool(struct soap *soap, const char *tag, int id, bool *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_bool);
	if (id < 0)
		return soap->error;
	return soap_out_bool(soap, tag, id, *a, type);
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_get_PointerTobool(struct soap *soap, bool **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTobool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_in_PointerTobool(struct soap *soap, const char *tag, bool **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (bool **)soap_malloc(soap, sizeof(bool *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_bool(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (bool **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_bool, sizeof(bool), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__base64Binary(struct soap *soap, xsd__base64Binary *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__base64Binary(struct soap *soap, xsd__base64Binary *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__base64Binary);
	if (soap_out_PointerToxsd__base64Binary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__base64Binary(struct soap *soap, const char *tag, int id, xsd__base64Binary *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xsd__base64Binary ** SOAP_FMAC4 soap_get_PointerToxsd__base64Binary(struct soap *soap, xsd__base64Binary **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__base64Binary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 xsd__base64Binary ** SOAP_FMAC4 soap_in_PointerToxsd__base64Binary(struct soap *soap, const char *tag, xsd__base64Binary **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xsd__base64Binary **)soap_malloc(soap, sizeof(xsd__base64Binary *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xsd__base64Binary *)soap_instantiate_xsd__base64Binary(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (xsd__base64Binary **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__base64Binary, sizeof(xsd__base64Binary), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostd__string(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_std__string))
		soap_serialize_std__string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostd__string(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostd__string);
	if (soap_out_PointerTostd__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostd__string(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_std__string);
	if (id < 0)
		return soap->error;
	return soap_out_std__string(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTostd__string(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostd__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTostd__string(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_std__string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_std__string, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosai__KerberosSpnType(struct soap *soap, sai__KerberosSpnType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sai__KerberosSpnType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosai__KerberosSpnType(struct soap *soap, sai__KerberosSpnType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosai__KerberosSpnType);
	if (soap_out_PointerTosai__KerberosSpnType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosai__KerberosSpnType(struct soap *soap, const char *tag, int id, sai__KerberosSpnType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sai__KerberosSpnType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sai__KerberosSpnType ** SOAP_FMAC4 soap_get_PointerTosai__KerberosSpnType(struct soap *soap, sai__KerberosSpnType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosai__KerberosSpnType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 sai__KerberosSpnType ** SOAP_FMAC4 soap_in_PointerTosai__KerberosSpnType(struct soap *soap, const char *tag, sai__KerberosSpnType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sai__KerberosSpnType **)soap_malloc(soap, sizeof(sai__KerberosSpnType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sai__KerberosSpnType *)soap_instantiate_sai__KerberosSpnType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (sai__KerberosSpnType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sai__KerberosSpnType, sizeof(sai__KerberosSpnType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosai__UserEntryKerberosType(struct soap *soap, sai__UserEntryKerberosType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sai__UserEntryKerberosType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosai__UserEntryKerberosType(struct soap *soap, sai__UserEntryKerberosType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosai__UserEntryKerberosType);
	if (soap_out_PointerTosai__UserEntryKerberosType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosai__UserEntryKerberosType(struct soap *soap, const char *tag, int id, sai__UserEntryKerberosType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sai__UserEntryKerberosType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sai__UserEntryKerberosType ** SOAP_FMAC4 soap_get_PointerTosai__UserEntryKerberosType(struct soap *soap, sai__UserEntryKerberosType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosai__UserEntryKerberosType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 sai__UserEntryKerberosType ** SOAP_FMAC4 soap_in_PointerTosai__UserEntryKerberosType(struct soap *soap, const char *tag, sai__UserEntryKerberosType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sai__UserEntryKerberosType **)soap_malloc(soap, sizeof(sai__UserEntryKerberosType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sai__UserEntryKerberosType *)soap_instantiate_sai__UserEntryKerberosType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (sai__UserEntryKerberosType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sai__UserEntryKerberosType, sizeof(sai__UserEntryKerberosType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosai__UserEntryDigestType(struct soap *soap, sai__UserEntryDigestType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sai__UserEntryDigestType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosai__UserEntryDigestType(struct soap *soap, sai__UserEntryDigestType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosai__UserEntryDigestType);
	if (soap_out_PointerTosai__UserEntryDigestType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosai__UserEntryDigestType(struct soap *soap, const char *tag, int id, sai__UserEntryDigestType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sai__UserEntryDigestType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sai__UserEntryDigestType ** SOAP_FMAC4 soap_get_PointerTosai__UserEntryDigestType(struct soap *soap, sai__UserEntryDigestType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosai__UserEntryDigestType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 sai__UserEntryDigestType ** SOAP_FMAC4 soap_in_PointerTosai__UserEntryDigestType(struct soap *soap, const char *tag, sai__UserEntryDigestType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sai__UserEntryDigestType **)soap_malloc(soap, sizeof(sai__UserEntryDigestType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sai__UserEntryDigestType *)soap_instantiate_sai__UserEntryDigestType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (sai__UserEntryDigestType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sai__UserEntryDigestType, sizeof(sai__UserEntryDigestType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosai__UserAclRealmListType(struct soap *soap, sai__UserAclRealmListType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sai__UserAclRealmListType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosai__UserAclRealmListType(struct soap *soap, sai__UserAclRealmListType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosai__UserAclRealmListType);
	if (soap_out_PointerTosai__UserAclRealmListType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosai__UserAclRealmListType(struct soap *soap, const char *tag, int id, sai__UserAclRealmListType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sai__UserAclRealmListType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sai__UserAclRealmListType ** SOAP_FMAC4 soap_get_PointerTosai__UserAclRealmListType(struct soap *soap, sai__UserAclRealmListType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosai__UserAclRealmListType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 sai__UserAclRealmListType ** SOAP_FMAC4 soap_in_PointerTosai__UserAclRealmListType(struct soap *soap, const char *tag, sai__UserAclRealmListType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sai__UserAclRealmListType **)soap_malloc(soap, sizeof(sai__UserAclRealmListType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sai__UserAclRealmListType *)soap_instantiate_sai__UserAclRealmListType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (sai__UserAclRealmListType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sai__UserAclRealmListType, sizeof(sai__UserAclRealmListType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToemi__AlertSubscriptionPolicyIDType(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToemi__AlertSubscriptionPolicyIDType(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToemi__AlertSubscriptionPolicyIDType);
	if (soap_out_PointerToemi__AlertSubscriptionPolicyIDType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToemi__AlertSubscriptionPolicyIDType(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType);
	if (id < 0)
		return soap->error;
	return soap_out_emi__AlertSubscriptionPolicyIDType(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerToemi__AlertSubscriptionPolicyIDType(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToemi__AlertSubscriptionPolicyIDType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerToemi__AlertSubscriptionPolicyIDType(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_emi__AlertSubscriptionPolicyIDType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_emi__AlertSubscriptionPolicyIDType, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToemi__AlertSubscriptionGeneralType(struct soap *soap, emi__AlertSubscriptionGeneralType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_emi__AlertSubscriptionGeneralType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToemi__AlertSubscriptionGeneralType(struct soap *soap, emi__AlertSubscriptionGeneralType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToemi__AlertSubscriptionGeneralType);
	if (soap_out_PointerToemi__AlertSubscriptionGeneralType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToemi__AlertSubscriptionGeneralType(struct soap *soap, const char *tag, int id, emi__AlertSubscriptionGeneralType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_emi__AlertSubscriptionGeneralType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 emi__AlertSubscriptionGeneralType ** SOAP_FMAC4 soap_get_PointerToemi__AlertSubscriptionGeneralType(struct soap *soap, emi__AlertSubscriptionGeneralType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToemi__AlertSubscriptionGeneralType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 emi__AlertSubscriptionGeneralType ** SOAP_FMAC4 soap_in_PointerToemi__AlertSubscriptionGeneralType(struct soap *soap, const char *tag, emi__AlertSubscriptionGeneralType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (emi__AlertSubscriptionGeneralType **)soap_malloc(soap, sizeof(emi__AlertSubscriptionGeneralType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (emi__AlertSubscriptionGeneralType *)soap_instantiate_emi__AlertSubscriptionGeneralType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionGeneralType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_emi__AlertSubscriptionGeneralType, sizeof(emi__AlertSubscriptionGeneralType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToemi__AlertSubscriptionSoapType(struct soap *soap, emi__AlertSubscriptionSoapType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_emi__AlertSubscriptionSoapType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToemi__AlertSubscriptionSoapType(struct soap *soap, emi__AlertSubscriptionSoapType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToemi__AlertSubscriptionSoapType);
	if (soap_out_PointerToemi__AlertSubscriptionSoapType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToemi__AlertSubscriptionSoapType(struct soap *soap, const char *tag, int id, emi__AlertSubscriptionSoapType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_emi__AlertSubscriptionSoapType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 emi__AlertSubscriptionSoapType ** SOAP_FMAC4 soap_get_PointerToemi__AlertSubscriptionSoapType(struct soap *soap, emi__AlertSubscriptionSoapType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToemi__AlertSubscriptionSoapType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 emi__AlertSubscriptionSoapType ** SOAP_FMAC4 soap_in_PointerToemi__AlertSubscriptionSoapType(struct soap *soap, const char *tag, emi__AlertSubscriptionSoapType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (emi__AlertSubscriptionSoapType **)soap_malloc(soap, sizeof(emi__AlertSubscriptionSoapType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (emi__AlertSubscriptionSoapType *)soap_instantiate_emi__AlertSubscriptionSoapType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionSoapType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_emi__AlertSubscriptionSoapType, sizeof(emi__AlertSubscriptionSoapType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToemi__AlertSubscriptionSNMPType(struct soap *soap, emi__AlertSubscriptionSNMPType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_emi__AlertSubscriptionSNMPType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToemi__AlertSubscriptionSNMPType(struct soap *soap, emi__AlertSubscriptionSNMPType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToemi__AlertSubscriptionSNMPType);
	if (soap_out_PointerToemi__AlertSubscriptionSNMPType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToemi__AlertSubscriptionSNMPType(struct soap *soap, const char *tag, int id, emi__AlertSubscriptionSNMPType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_emi__AlertSubscriptionSNMPType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 emi__AlertSubscriptionSNMPType ** SOAP_FMAC4 soap_get_PointerToemi__AlertSubscriptionSNMPType(struct soap *soap, emi__AlertSubscriptionSNMPType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToemi__AlertSubscriptionSNMPType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 emi__AlertSubscriptionSNMPType ** SOAP_FMAC4 soap_in_PointerToemi__AlertSubscriptionSNMPType(struct soap *soap, const char *tag, emi__AlertSubscriptionSNMPType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (emi__AlertSubscriptionSNMPType **)soap_malloc(soap, sizeof(emi__AlertSubscriptionSNMPType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (emi__AlertSubscriptionSNMPType *)soap_instantiate_emi__AlertSubscriptionSNMPType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (emi__AlertSubscriptionSNMPType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_emi__AlertSubscriptionSNMPType, sizeof(emi__AlertSubscriptionSNMPType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToemi__AlertCredentialsType(struct soap *soap, emi__AlertCredentialsType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_emi__AlertCredentialsType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToemi__AlertCredentialsType(struct soap *soap, emi__AlertCredentialsType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToemi__AlertCredentialsType);
	if (soap_out_PointerToemi__AlertCredentialsType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToemi__AlertCredentialsType(struct soap *soap, const char *tag, int id, emi__AlertCredentialsType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_emi__AlertCredentialsType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 emi__AlertCredentialsType ** SOAP_FMAC4 soap_get_PointerToemi__AlertCredentialsType(struct soap *soap, emi__AlertCredentialsType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToemi__AlertCredentialsType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 emi__AlertCredentialsType ** SOAP_FMAC4 soap_in_PointerToemi__AlertCredentialsType(struct soap *soap, const char *tag, emi__AlertCredentialsType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (emi__AlertCredentialsType **)soap_malloc(soap, sizeof(emi__AlertCredentialsType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (emi__AlertCredentialsType *)soap_instantiate_emi__AlertCredentialsType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (emi__AlertCredentialsType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_emi__AlertCredentialsType, sizeof(emi__AlertCredentialsType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosai__CertificateHandleType(struct soap *soap, unsigned int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_sai__CertificateHandleType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosai__CertificateHandleType(struct soap *soap, unsigned int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosai__CertificateHandleType);
	if (soap_out_PointerTosai__CertificateHandleType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosai__CertificateHandleType(struct soap *soap, const char *tag, int id, unsigned int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sai__CertificateHandleType);
	if (id < 0)
		return soap->error;
	return soap_out_sai__CertificateHandleType(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned int ** SOAP_FMAC4 soap_get_PointerTosai__CertificateHandleType(struct soap *soap, unsigned int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosai__CertificateHandleType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int ** SOAP_FMAC4 soap_in_PointerTosai__CertificateHandleType(struct soap *soap, const char *tag, unsigned int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned int **)soap_malloc(soap, sizeof(unsigned int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_sai__CertificateHandleType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sai__CertificateHandleType, sizeof(unsigned int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTocmn__URLType(struct soap *soap, cmn__URLType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_cmn__URLType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTocmn__URLType(struct soap *soap, cmn__URLType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTocmn__URLType);
	if (soap_out_PointerTocmn__URLType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTocmn__URLType(struct soap *soap, const char *tag, int id, cmn__URLType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_cmn__URLType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 cmn__URLType ** SOAP_FMAC4 soap_get_PointerTocmn__URLType(struct soap *soap, cmn__URLType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTocmn__URLType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 cmn__URLType ** SOAP_FMAC4 soap_in_PointerTocmn__URLType(struct soap *soap, const char *tag, cmn__URLType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (cmn__URLType **)soap_malloc(soap, sizeof(cmn__URLType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (cmn__URLType *)soap_instantiate_cmn__URLType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (cmn__URLType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_cmn__URLType, sizeof(cmn__URLType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToemi__CommunityStringType(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_emi__CommunityStringType))
		soap_serialize_emi__CommunityStringType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToemi__CommunityStringType(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToemi__CommunityStringType);
	if (soap_out_PointerToemi__CommunityStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToemi__CommunityStringType(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_emi__CommunityStringType);
	if (id < 0)
		return soap->error;
	return soap_out_emi__CommunityStringType(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerToemi__CommunityStringType(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToemi__CommunityStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerToemi__CommunityStringType(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_emi__CommunityStringType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_emi__CommunityStringType, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTocmn__NodeAddressType(struct soap *soap, cmn__NodeAddressType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_cmn__NodeAddressType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTocmn__NodeAddressType(struct soap *soap, cmn__NodeAddressType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTocmn__NodeAddressType);
	if (soap_out_PointerTocmn__NodeAddressType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTocmn__NodeAddressType(struct soap *soap, const char *tag, int id, cmn__NodeAddressType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_cmn__NodeAddressType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 cmn__NodeAddressType ** SOAP_FMAC4 soap_get_PointerTocmn__NodeAddressType(struct soap *soap, cmn__NodeAddressType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTocmn__NodeAddressType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 cmn__NodeAddressType ** SOAP_FMAC4 soap_in_PointerTocmn__NodeAddressType(struct soap *soap, const char *tag, cmn__NodeAddressType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (cmn__NodeAddressType **)soap_malloc(soap, sizeof(cmn__NodeAddressType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (cmn__NodeAddressType *)soap_instantiate_cmn__NodeAddressType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (cmn__NodeAddressType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_cmn__NodeAddressType, sizeof(cmn__NodeAddressType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToemi__EventLogRecordType(struct soap *soap, emi__EventLogRecordType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_emi__EventLogRecordType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToemi__EventLogRecordType(struct soap *soap, emi__EventLogRecordType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToemi__EventLogRecordType);
	if (soap_out_PointerToemi__EventLogRecordType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToemi__EventLogRecordType(struct soap *soap, const char *tag, int id, emi__EventLogRecordType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_emi__EventLogRecordType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 emi__EventLogRecordType ** SOAP_FMAC4 soap_get_PointerToemi__EventLogRecordType(struct soap *soap, emi__EventLogRecordType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToemi__EventLogRecordType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 emi__EventLogRecordType ** SOAP_FMAC4 soap_in_PointerToemi__EventLogRecordType(struct soap *soap, const char *tag, emi__EventLogRecordType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (emi__EventLogRecordType **)soap_malloc(soap, sizeof(emi__EventLogRecordType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (emi__EventLogRecordType *)soap_instantiate_emi__EventLogRecordType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (emi__EventLogRecordType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_emi__EventLogRecordType, sizeof(emi__EventLogRecordType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToemi__ByteData(struct soap *soap, emi__ByteData *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_emi__ByteData))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToemi__ByteData(struct soap *soap, emi__ByteData *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToemi__ByteData);
	if (soap_out_PointerToemi__ByteData(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToemi__ByteData(struct soap *soap, const char *tag, int id, emi__ByteData *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_emi__ByteData);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 emi__ByteData ** SOAP_FMAC4 soap_get_PointerToemi__ByteData(struct soap *soap, emi__ByteData **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToemi__ByteData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 emi__ByteData ** SOAP_FMAC4 soap_in_PointerToemi__ByteData(struct soap *soap, const char *tag, emi__ByteData **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (emi__ByteData **)soap_malloc(soap, sizeof(emi__ByteData *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (emi__ByteData *)soap_instantiate_emi__ByteData(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (emi__ByteData **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_emi__ByteData, sizeof(emi__ByteData), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTocmn__IPv6AddressStringType(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_cmn__IPv6AddressStringType))
		soap_serialize_cmn__IPv6AddressStringType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTocmn__IPv6AddressStringType(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTocmn__IPv6AddressStringType);
	if (soap_out_PointerTocmn__IPv6AddressStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTocmn__IPv6AddressStringType(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_cmn__IPv6AddressStringType);
	if (id < 0)
		return soap->error;
	return soap_out_cmn__IPv6AddressStringType(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTocmn__IPv6AddressStringType(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTocmn__IPv6AddressStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTocmn__IPv6AddressStringType(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_cmn__IPv6AddressStringType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_cmn__IPv6AddressStringType, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTocmn__IPv4AddressStringType(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_cmn__IPv4AddressStringType))
		soap_serialize_cmn__IPv4AddressStringType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTocmn__IPv4AddressStringType(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTocmn__IPv4AddressStringType);
	if (soap_out_PointerTocmn__IPv4AddressStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTocmn__IPv4AddressStringType(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_cmn__IPv4AddressStringType);
	if (id < 0)
		return soap->error;
	return soap_out_cmn__IPv4AddressStringType(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTocmn__IPv4AddressStringType(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTocmn__IPv4AddressStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTocmn__IPv4AddressStringType(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_cmn__IPv4AddressStringType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_cmn__IPv4AddressStringType, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTocmn__HostNameType(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_cmn__HostNameType))
		soap_serialize_cmn__HostNameType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTocmn__HostNameType(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTocmn__HostNameType);
	if (soap_out_PointerTocmn__HostNameType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTocmn__HostNameType(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_cmn__HostNameType);
	if (id < 0)
		return soap->error;
	return soap_out_cmn__HostNameType(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTocmn__HostNameType(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTocmn__HostNameType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTocmn__HostNameType(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_cmn__HostNameType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_cmn__HostNameType, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
	if (soap_out_PointerTounsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfstd__string(struct soap *soap, std::vector<std::string >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfstd__string(struct soap *soap, const std::vector<std::string >*a)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_std__string(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfstd__string(struct soap *soap, const char *tag, int id, const std::vector<std::string >*a, const char *type)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_std__string(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<std::string >* SOAP_FMAC4 soap_in_std__vectorTemplateOfstd__string(struct soap *soap, const char *tag, std::vector<std::string >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfstd__string(soap, -1)))
		return NULL;
	std::string n;
	std::string *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_std__string, SOAP_TYPE_std__vectorTemplateOfstd__string, sizeof(std::string), 0))
				break;
			if (!(p = soap_in_std__string(soap, tag, NULL, "xsd:string")))
				break;
		}
		else
		{	soap_default_std__string(soap, &n);
			if (!soap_in_std__string(soap, tag, &n, "xsd:string"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<std::string > * SOAP_FMAC6 soap_new_std__vectorTemplateOfstd__string(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfstd__string(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfstd__string(struct soap *soap, std::vector<std::string >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<std::string > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfstd__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfstd__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfstd__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<std::string >;
		if (size)
			*size = sizeof(std::vector<std::string >);
	}
	else
	{	cp->ptr = (void*)new std::vector<std::string >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<std::string >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<std::string >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfstd__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<std::string > %p -> %p\n", q, p));
	*(std::vector<std::string >*)p = *(std::vector<std::string >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfxsd__anyURI(struct soap *soap, std::vector<std::string >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfxsd__anyURI(struct soap *soap, const std::vector<std::string >*a)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_xsd__anyURI(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfxsd__anyURI(struct soap *soap, const char *tag, int id, const std::vector<std::string >*a, const char *type)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_xsd__anyURI(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<std::string >* SOAP_FMAC4 soap_in_std__vectorTemplateOfxsd__anyURI(struct soap *soap, const char *tag, std::vector<std::string >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfxsd__anyURI(soap, -1)))
		return NULL;
	std::string n;
	std::string *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_xsd__anyURI, SOAP_TYPE_std__vectorTemplateOfxsd__anyURI, sizeof(std::string), 0))
				break;
			if (!(p = soap_in_xsd__anyURI(soap, tag, NULL, "xsd:anyURI")))
				break;
		}
		else
		{	soap_default_xsd__anyURI(soap, &n);
			if (!soap_in_xsd__anyURI(soap, tag, &n, "xsd:anyURI"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<std::string > * SOAP_FMAC6 soap_new_std__vectorTemplateOfxsd__anyURI(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfxsd__anyURI(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfxsd__anyURI(struct soap *soap, std::vector<std::string >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<std::string > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfxsd__anyURI(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfxsd__anyURI(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfxsd__anyURI, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<std::string >;
		if (size)
			*size = sizeof(std::vector<std::string >);
	}
	else
	{	cp->ptr = (void*)new std::vector<std::string >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<std::string >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<std::string >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfxsd__anyURI(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<std::string > %p -> %p\n", q, p));
	*(std::vector<std::string >*)p = *(std::vector<std::string >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfunsignedInt(struct soap *soap, std::vector<unsigned int >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfunsignedInt(struct soap *soap, const std::vector<unsigned int >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfunsignedInt(struct soap *soap, const char *tag, int id, const std::vector<unsigned int >*a, const char *type)
{
	for (std::vector<unsigned int >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_unsignedInt(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<unsigned int >* SOAP_FMAC4 soap_in_std__vectorTemplateOfunsignedInt(struct soap *soap, const char *tag, std::vector<unsigned int >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfunsignedInt(soap, -1)))
		return NULL;
	unsigned int n;
	unsigned int *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_unsignedInt, SOAP_TYPE_std__vectorTemplateOfunsignedInt, sizeof(unsigned int), 0))
				break;
			if (!(p = soap_in_unsignedInt(soap, tag, NULL, "xsd:unsignedInt")))
				break;
		}
		else
		{	soap_default_unsignedInt(soap, &n);
			if (!soap_in_unsignedInt(soap, tag, &n, "xsd:unsignedInt"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<unsigned int > * SOAP_FMAC6 soap_new_std__vectorTemplateOfunsignedInt(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfunsignedInt(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfunsignedInt(struct soap *soap, std::vector<unsigned int >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<unsigned int > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfunsignedInt(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfunsignedInt(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfunsignedInt, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<unsigned int >;
		if (size)
			*size = sizeof(std::vector<unsigned int >);
	}
	else
	{	cp->ptr = (void*)new std::vector<unsigned int >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<unsigned int >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<unsigned int >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfunsignedInt(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<unsigned int > %p -> %p\n", q, p));
	*(std::vector<unsigned int >*)p = *(std::vector<unsigned int >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfxsd__base64Binary(struct soap *soap, std::vector<xsd__base64Binary >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfxsd__base64Binary(struct soap *soap, const std::vector<xsd__base64Binary >*a)
{
	for (std::vector<xsd__base64Binary >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfxsd__base64Binary(struct soap *soap, const char *tag, int id, const std::vector<xsd__base64Binary >*a, const char *type)
{
	for (std::vector<xsd__base64Binary >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<xsd__base64Binary >* SOAP_FMAC4 soap_in_std__vectorTemplateOfxsd__base64Binary(struct soap *soap, const char *tag, std::vector<xsd__base64Binary >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfxsd__base64Binary(soap, -1)))
		return NULL;
	xsd__base64Binary n;
	xsd__base64Binary *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_xsd__base64Binary, SOAP_TYPE_std__vectorTemplateOfxsd__base64Binary, sizeof(xsd__base64Binary), 0))
				break;
			if (!(p = soap_in_xsd__base64Binary(soap, tag, NULL, "xsd:base64Binary")))
				break;
		}
		else
		{	n.soap_default(soap);
			if (!soap_in_xsd__base64Binary(soap, tag, &n, "xsd:base64Binary"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<xsd__base64Binary > * SOAP_FMAC6 soap_new_std__vectorTemplateOfxsd__base64Binary(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfxsd__base64Binary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfxsd__base64Binary(struct soap *soap, std::vector<xsd__base64Binary >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<xsd__base64Binary > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfxsd__base64Binary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfxsd__base64Binary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfxsd__base64Binary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<xsd__base64Binary >;
		if (size)
			*size = sizeof(std::vector<xsd__base64Binary >);
	}
	else
	{	cp->ptr = (void*)new std::vector<xsd__base64Binary >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<xsd__base64Binary >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<xsd__base64Binary >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfxsd__base64Binary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<xsd__base64Binary > %p -> %p\n", q, p));
	*(std::vector<xsd__base64Binary >*)p = *(std::vector<xsd__base64Binary >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTosai__KerberosSpnType(struct soap *soap, std::vector<sai__KerberosSpnType * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTosai__KerberosSpnType(struct soap *soap, const std::vector<sai__KerberosSpnType * >*a)
{
	for (std::vector<sai__KerberosSpnType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTosai__KerberosSpnType(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTosai__KerberosSpnType(struct soap *soap, const char *tag, int id, const std::vector<sai__KerberosSpnType * >*a, const char *type)
{
	for (std::vector<sai__KerberosSpnType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTosai__KerberosSpnType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<sai__KerberosSpnType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTosai__KerberosSpnType(struct soap *soap, const char *tag, std::vector<sai__KerberosSpnType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTosai__KerberosSpnType(soap, -1)))
		return NULL;
	sai__KerberosSpnType *n;
	sai__KerberosSpnType **p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_sai__KerberosSpnType, SOAP_TYPE_std__vectorTemplateOfPointerTosai__KerberosSpnType, sizeof(sai__KerberosSpnType), 1))
				break;
			if (!(p = soap_in_PointerTosai__KerberosSpnType(soap, tag, NULL, "sai:KerberosSpnType")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTosai__KerberosSpnType(soap, tag, &n, "sai:KerberosSpnType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<sai__KerberosSpnType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTosai__KerberosSpnType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTosai__KerberosSpnType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTosai__KerberosSpnType(struct soap *soap, std::vector<sai__KerberosSpnType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<sai__KerberosSpnType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTosai__KerberosSpnType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTosai__KerberosSpnType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTosai__KerberosSpnType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<sai__KerberosSpnType * >;
		if (size)
			*size = sizeof(std::vector<sai__KerberosSpnType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<sai__KerberosSpnType * >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<sai__KerberosSpnType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<sai__KerberosSpnType * >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTosai__KerberosSpnType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<sai__KerberosSpnType * > %p -> %p\n", q, p));
	*(std::vector<sai__KerberosSpnType * >*)p = *(std::vector<sai__KerberosSpnType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfsai__UserAclRealmType(struct soap *soap, std::vector<enum sai__UserAclRealmType >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfsai__UserAclRealmType(struct soap *soap, const std::vector<enum sai__UserAclRealmType >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfsai__UserAclRealmType(struct soap *soap, const char *tag, int id, const std::vector<enum sai__UserAclRealmType >*a, const char *type)
{
	for (std::vector<enum sai__UserAclRealmType >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_sai__UserAclRealmType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<enum sai__UserAclRealmType >* SOAP_FMAC4 soap_in_std__vectorTemplateOfsai__UserAclRealmType(struct soap *soap, const char *tag, std::vector<enum sai__UserAclRealmType >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfsai__UserAclRealmType(soap, -1)))
		return NULL;
	enum sai__UserAclRealmType n;
	enum sai__UserAclRealmType *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_sai__UserAclRealmType, SOAP_TYPE_std__vectorTemplateOfsai__UserAclRealmType, sizeof(enum sai__UserAclRealmType), 0))
				break;
			if (!(p = soap_in_sai__UserAclRealmType(soap, tag, NULL, "sai:UserAclRealmType")))
				break;
		}
		else
		{	soap_default_sai__UserAclRealmType(soap, &n);
			if (!soap_in_sai__UserAclRealmType(soap, tag, &n, "sai:UserAclRealmType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<enum sai__UserAclRealmType > * SOAP_FMAC6 soap_new_std__vectorTemplateOfsai__UserAclRealmType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfsai__UserAclRealmType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfsai__UserAclRealmType(struct soap *soap, std::vector<enum sai__UserAclRealmType >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<enum sai__UserAclRealmType > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfsai__UserAclRealmType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfsai__UserAclRealmType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfsai__UserAclRealmType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<enum sai__UserAclRealmType >;
		if (size)
			*size = sizeof(std::vector<enum sai__UserAclRealmType >);
	}
	else
	{	cp->ptr = (void*)new std::vector<enum sai__UserAclRealmType >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<enum sai__UserAclRealmType >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<enum sai__UserAclRealmType >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfsai__UserAclRealmType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<enum sai__UserAclRealmType > %p -> %p\n", q, p));
	*(std::vector<enum sai__UserAclRealmType >*)p = *(std::vector<enum sai__UserAclRealmType >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfsai__UserAclEntryHandleType(struct soap *soap, std::vector<unsigned int >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfsai__UserAclEntryHandleType(struct soap *soap, const std::vector<unsigned int >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfsai__UserAclEntryHandleType(struct soap *soap, const char *tag, int id, const std::vector<unsigned int >*a, const char *type)
{
	for (std::vector<unsigned int >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_sai__UserAclEntryHandleType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<unsigned int >* SOAP_FMAC4 soap_in_std__vectorTemplateOfsai__UserAclEntryHandleType(struct soap *soap, const char *tag, std::vector<unsigned int >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfsai__UserAclEntryHandleType(soap, -1)))
		return NULL;
	unsigned int n;
	unsigned int *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_sai__UserAclEntryHandleType, SOAP_TYPE_std__vectorTemplateOfsai__UserAclEntryHandleType, sizeof(unsigned int), 0))
				break;
			if (!(p = soap_in_sai__UserAclEntryHandleType(soap, tag, NULL, "sai:UserAclEntryHandleType")))
				break;
		}
		else
		{	soap_default_sai__UserAclEntryHandleType(soap, &n);
			if (!soap_in_sai__UserAclEntryHandleType(soap, tag, &n, "sai:UserAclEntryHandleType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<unsigned int > * SOAP_FMAC6 soap_new_std__vectorTemplateOfsai__UserAclEntryHandleType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfsai__UserAclEntryHandleType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfsai__UserAclEntryHandleType(struct soap *soap, std::vector<unsigned int >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<unsigned int > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfsai__UserAclEntryHandleType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfsai__UserAclEntryHandleType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfsai__UserAclEntryHandleType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<unsigned int >;
		if (size)
			*size = sizeof(std::vector<unsigned int >);
	}
	else
	{	cp->ptr = (void*)new std::vector<unsigned int >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<unsigned int >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<unsigned int >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfsai__UserAclEntryHandleType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<unsigned int > %p -> %p\n", q, p));
	*(std::vector<unsigned int >*)p = *(std::vector<unsigned int >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfemi__AlertAuthOptionsType(struct soap *soap, std::vector<enum emi__AlertAuthOptionsType >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfemi__AlertAuthOptionsType(struct soap *soap, const std::vector<enum emi__AlertAuthOptionsType >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfemi__AlertAuthOptionsType(struct soap *soap, const char *tag, int id, const std::vector<enum emi__AlertAuthOptionsType >*a, const char *type)
{
	for (std::vector<enum emi__AlertAuthOptionsType >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_emi__AlertAuthOptionsType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<enum emi__AlertAuthOptionsType >* SOAP_FMAC4 soap_in_std__vectorTemplateOfemi__AlertAuthOptionsType(struct soap *soap, const char *tag, std::vector<enum emi__AlertAuthOptionsType >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfemi__AlertAuthOptionsType(soap, -1)))
		return NULL;
	enum emi__AlertAuthOptionsType n;
	enum emi__AlertAuthOptionsType *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_emi__AlertAuthOptionsType, SOAP_TYPE_std__vectorTemplateOfemi__AlertAuthOptionsType, sizeof(enum emi__AlertAuthOptionsType), 0))
				break;
			if (!(p = soap_in_emi__AlertAuthOptionsType(soap, tag, NULL, "emi:AlertAuthOptionsType")))
				break;
		}
		else
		{	soap_default_emi__AlertAuthOptionsType(soap, &n);
			if (!soap_in_emi__AlertAuthOptionsType(soap, tag, &n, "emi:AlertAuthOptionsType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<enum emi__AlertAuthOptionsType > * SOAP_FMAC6 soap_new_std__vectorTemplateOfemi__AlertAuthOptionsType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfemi__AlertAuthOptionsType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfemi__AlertAuthOptionsType(struct soap *soap, std::vector<enum emi__AlertAuthOptionsType >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<enum emi__AlertAuthOptionsType > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfemi__AlertAuthOptionsType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfemi__AlertAuthOptionsType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfemi__AlertAuthOptionsType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<enum emi__AlertAuthOptionsType >;
		if (size)
			*size = sizeof(std::vector<enum emi__AlertAuthOptionsType >);
	}
	else
	{	cp->ptr = (void*)new std::vector<enum emi__AlertAuthOptionsType >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<enum emi__AlertAuthOptionsType >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<enum emi__AlertAuthOptionsType >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfemi__AlertAuthOptionsType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<enum emi__AlertAuthOptionsType > %p -> %p\n", q, p));
	*(std::vector<enum emi__AlertAuthOptionsType >*)p = *(std::vector<enum emi__AlertAuthOptionsType >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfemi__SensorHandleType(struct soap *soap, std::vector<unsigned int >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfemi__SensorHandleType(struct soap *soap, const std::vector<unsigned int >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfemi__SensorHandleType(struct soap *soap, const char *tag, int id, const std::vector<unsigned int >*a, const char *type)
{
	for (std::vector<unsigned int >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_emi__SensorHandleType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<unsigned int >* SOAP_FMAC4 soap_in_std__vectorTemplateOfemi__SensorHandleType(struct soap *soap, const char *tag, std::vector<unsigned int >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfemi__SensorHandleType(soap, -1)))
		return NULL;
	unsigned int n;
	unsigned int *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_emi__SensorHandleType, SOAP_TYPE_std__vectorTemplateOfemi__SensorHandleType, sizeof(unsigned int), 0))
				break;
			if (!(p = soap_in_emi__SensorHandleType(soap, tag, NULL, "emi:SensorHandleType")))
				break;
		}
		else
		{	soap_default_emi__SensorHandleType(soap, &n);
			if (!soap_in_emi__SensorHandleType(soap, tag, &n, "emi:SensorHandleType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<unsigned int > * SOAP_FMAC6 soap_new_std__vectorTemplateOfemi__SensorHandleType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfemi__SensorHandleType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfemi__SensorHandleType(struct soap *soap, std::vector<unsigned int >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<unsigned int > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfemi__SensorHandleType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfemi__SensorHandleType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfemi__SensorHandleType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<unsigned int >;
		if (size)
			*size = sizeof(std::vector<unsigned int >);
	}
	else
	{	cp->ptr = (void*)new std::vector<unsigned int >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<unsigned int >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<unsigned int >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfemi__SensorHandleType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<unsigned int > %p -> %p\n", q, p));
	*(std::vector<unsigned int >*)p = *(std::vector<unsigned int >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerToemi__EventLogRecordType(struct soap *soap, std::vector<emi__EventLogRecordType * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerToemi__EventLogRecordType(struct soap *soap, const std::vector<emi__EventLogRecordType * >*a)
{
	for (std::vector<emi__EventLogRecordType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerToemi__EventLogRecordType(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerToemi__EventLogRecordType(struct soap *soap, const char *tag, int id, const std::vector<emi__EventLogRecordType * >*a, const char *type)
{
	for (std::vector<emi__EventLogRecordType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerToemi__EventLogRecordType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<emi__EventLogRecordType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerToemi__EventLogRecordType(struct soap *soap, const char *tag, std::vector<emi__EventLogRecordType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, -1)))
		return NULL;
	emi__EventLogRecordType *n;
	emi__EventLogRecordType **p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_emi__EventLogRecordType, SOAP_TYPE_std__vectorTemplateOfPointerToemi__EventLogRecordType, sizeof(emi__EventLogRecordType), 1))
				break;
			if (!(p = soap_in_PointerToemi__EventLogRecordType(soap, tag, NULL, "emi:EventLogRecordType")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerToemi__EventLogRecordType(soap, tag, &n, "emi:EventLogRecordType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<emi__EventLogRecordType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerToemi__EventLogRecordType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerToemi__EventLogRecordType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerToemi__EventLogRecordType(struct soap *soap, std::vector<emi__EventLogRecordType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<emi__EventLogRecordType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerToemi__EventLogRecordType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerToemi__EventLogRecordType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerToemi__EventLogRecordType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<emi__EventLogRecordType * >;
		if (size)
			*size = sizeof(std::vector<emi__EventLogRecordType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<emi__EventLogRecordType * >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<emi__EventLogRecordType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<emi__EventLogRecordType * >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerToemi__EventLogRecordType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<emi__EventLogRecordType * > %p -> %p\n", q, p));
	*(std::vector<emi__EventLogRecordType * >*)p = *(std::vector<emi__EventLogRecordType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfemi__EventFilterHandleType(struct soap *soap, std::vector<unsigned int >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfemi__EventFilterHandleType(struct soap *soap, const std::vector<unsigned int >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfemi__EventFilterHandleType(struct soap *soap, const char *tag, int id, const std::vector<unsigned int >*a, const char *type)
{
	for (std::vector<unsigned int >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_emi__EventFilterHandleType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<unsigned int >* SOAP_FMAC4 soap_in_std__vectorTemplateOfemi__EventFilterHandleType(struct soap *soap, const char *tag, std::vector<unsigned int >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfemi__EventFilterHandleType(soap, -1)))
		return NULL;
	unsigned int n;
	unsigned int *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_emi__EventFilterHandleType, SOAP_TYPE_std__vectorTemplateOfemi__EventFilterHandleType, sizeof(unsigned int), 0))
				break;
			if (!(p = soap_in_emi__EventFilterHandleType(soap, tag, NULL, "emi:EventFilterHandleType")))
				break;
		}
		else
		{	soap_default_emi__EventFilterHandleType(soap, &n);
			if (!soap_in_emi__EventFilterHandleType(soap, tag, &n, "emi:EventFilterHandleType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<unsigned int > * SOAP_FMAC6 soap_new_std__vectorTemplateOfemi__EventFilterHandleType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfemi__EventFilterHandleType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfemi__EventFilterHandleType(struct soap *soap, std::vector<unsigned int >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<unsigned int > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfemi__EventFilterHandleType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfemi__EventFilterHandleType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfemi__EventFilterHandleType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<unsigned int >;
		if (size)
			*size = sizeof(std::vector<unsigned int >);
	}
	else
	{	cp->ptr = (void*)new std::vector<unsigned int >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<unsigned int >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<unsigned int >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfemi__EventFilterHandleType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<unsigned int > %p -> %p\n", q, p));
	*(std::vector<unsigned int >*)p = *(std::vector<unsigned int >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfemi__AlertSubscriptionHandleType(struct soap *soap, std::vector<unsigned int >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfemi__AlertSubscriptionHandleType(struct soap *soap, const std::vector<unsigned int >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfemi__AlertSubscriptionHandleType(struct soap *soap, const char *tag, int id, const std::vector<unsigned int >*a, const char *type)
{
	for (std::vector<unsigned int >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_emi__AlertSubscriptionHandleType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<unsigned int >* SOAP_FMAC4 soap_in_std__vectorTemplateOfemi__AlertSubscriptionHandleType(struct soap *soap, const char *tag, std::vector<unsigned int >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, -1)))
		return NULL;
	unsigned int n;
	unsigned int *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_emi__AlertSubscriptionHandleType, SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionHandleType, sizeof(unsigned int), 0))
				break;
			if (!(p = soap_in_emi__AlertSubscriptionHandleType(soap, tag, NULL, "emi:AlertSubscriptionHandleType")))
				break;
		}
		else
		{	soap_default_emi__AlertSubscriptionHandleType(soap, &n);
			if (!soap_in_emi__AlertSubscriptionHandleType(soap, tag, &n, "emi:AlertSubscriptionHandleType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<unsigned int > * SOAP_FMAC6 soap_new_std__vectorTemplateOfemi__AlertSubscriptionHandleType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfemi__AlertSubscriptionHandleType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfemi__AlertSubscriptionHandleType(struct soap *soap, std::vector<unsigned int >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<unsigned int > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfemi__AlertSubscriptionHandleType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfemi__AlertSubscriptionHandleType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionHandleType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<unsigned int >;
		if (size)
			*size = sizeof(std::vector<unsigned int >);
	}
	else
	{	cp->ptr = (void*)new std::vector<unsigned int >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<unsigned int >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<unsigned int >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfemi__AlertSubscriptionHandleType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<unsigned int > %p -> %p\n", q, p));
	*(std::vector<unsigned int >*)p = *(std::vector<unsigned int >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfunsignedByte(struct soap *soap, std::vector<unsigned char >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfunsignedByte(struct soap *soap, const std::vector<unsigned char >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfunsignedByte(struct soap *soap, const char *tag, int id, const std::vector<unsigned char >*a, const char *type)
{
	for (std::vector<unsigned char >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_unsignedByte(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<unsigned char >* SOAP_FMAC4 soap_in_std__vectorTemplateOfunsignedByte(struct soap *soap, const char *tag, std::vector<unsigned char >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfunsignedByte(soap, -1)))
		return NULL;
	unsigned char n;
	unsigned char *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_unsignedByte, SOAP_TYPE_std__vectorTemplateOfunsignedByte, sizeof(unsigned char), 0))
				break;
			if (!(p = soap_in_unsignedByte(soap, tag, NULL, "xsd:unsignedByte")))
				break;
		}
		else
		{	soap_default_unsignedByte(soap, &n);
			if (!soap_in_unsignedByte(soap, tag, &n, "xsd:unsignedByte"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<unsigned char > * SOAP_FMAC6 soap_new_std__vectorTemplateOfunsignedByte(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfunsignedByte(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfunsignedByte(struct soap *soap, std::vector<unsigned char >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<unsigned char > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfunsignedByte(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfunsignedByte(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfunsignedByte, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<unsigned char >;
		if (size)
			*size = sizeof(std::vector<unsigned char >);
	}
	else
	{	cp->ptr = (void*)new std::vector<unsigned char >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<unsigned char >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<unsigned char >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfunsignedByte(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<unsigned char > %p -> %p\n", q, p));
	*(std::vector<unsigned char >*)p = *(std::vector<unsigned char >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(struct soap *soap, std::vector<unsigned char >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(struct soap *soap, const std::vector<unsigned char >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(struct soap *soap, const char *tag, int id, const std::vector<unsigned char >*a, const char *type)
{
	for (std::vector<unsigned char >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_emi__AlertSubscriptionPolicyIDType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<unsigned char >* SOAP_FMAC4 soap_in_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(struct soap *soap, const char *tag, std::vector<unsigned char >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(soap, -1)))
		return NULL;
	unsigned char n;
	unsigned char *p;
	short soap_flag = 0;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_emi__AlertSubscriptionPolicyIDType, SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType, sizeof(unsigned char), 0))
				break;
			if (!(p = soap_in_emi__AlertSubscriptionPolicyIDType(soap, tag, NULL, "emi:AlertSubscriptionPolicyIDType")))
				break;
		}
		else
		{	soap_default_emi__AlertSubscriptionPolicyIDType(soap, &n);
			if (!soap_in_emi__AlertSubscriptionPolicyIDType(soap, tag, &n, "emi:AlertSubscriptionPolicyIDType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (!soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<unsigned char > * SOAP_FMAC6 soap_new_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(struct soap *soap, std::vector<unsigned char >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<unsigned char > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<unsigned char >;
		if (size)
			*size = sizeof(std::vector<unsigned char >);
	}
	else
	{	cp->ptr = (void*)new std::vector<unsigned char >[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<unsigned char >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<unsigned char >*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfemi__AlertSubscriptionPolicyIDType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<unsigned char > %p -> %p\n", q, p));
	*(std::vector<unsigned char >*)p = *(std::vector<unsigned char >*)q;
}

/* End of soapC.cpp */
