# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#-------------------------------------------------------------------------------------------------------------
# Reste à faire :
#-------------------------------------------------------------------------------------------------------------

#Standards Modules
import subprocess
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp     # use by windows version for mplayer -wid parameter

#Modules from Videoporama project
from main_winDLG import *
from GlobalDefines import *
from Transitions import *

class RenderDlgMovie() :
    def __init__(self,VideoporamaInstance,RenderDlg,StartRenderSequence=0):
      self.VideoporamaInstance = VideoporamaInstance  # Instance of the Application
      self.RenderDlg           = RenderDlg            # Instance of the Render Dialog Box
      self.StartRenderSequence = StartRenderSequence  # Number of the first sequence to render

    def RenderMovie(self):
      lumask =lumaList()[0]                               # Define lumalist for transition ??????
      
      #------------------------------------------------------------
      # Start self.RenderDlg.Commande : Open PIPE
      #------------------------------------------------------------
      #Change path for log generation
      CurPath=unicode(QDir().toNativeSeparators(QDir().current().absolutePath()))
      QDir.setCurrent(self.VideoporamaInstance.T) # change to temp dir
      self.RenderDlg.Commande=unicode(self.RenderDlg.Commande)
      if isWindows() : 
        #self.RenderDlg.Commande=u"\""+self.RenderDlg.Commande+"\""
        print "commande rendu = ", self.RenderDlg.Commande
        #Redirect unused pipe to nul => see : http://www.py2exe.org/index.cgi/Py2ExeSubprocessInteractions
        Process = subprocess.Popen(self.RenderDlg.Commande.encode('iso-8859-1'),shell=True,stdin=subprocess.PIPE,stderr=file('nul','a'),stdout=file('nul','a'))
      else:
        Process = subprocess.Popen(self.RenderDlg.Commande.encode('utf-8'),shell=True,stdin=subprocess.PIPE)
        
      # Standard input to convert process
      encodedv_stdin = Process.stdin
      QDir.setCurrent(CurPath) # return to previous current path
      #--------------------------------------------------------------------------------
      # Prepare black frame use for (first and last) transition
      #--------------------------------------------------------------------------------
      BlackFrame=QImage(QSize(self.RenderDlg.widthpict,self.RenderDlg.heightpict),QImage.Format_ARGB32_Premultiplied)
      p=QPainter(BlackFrame)
      p.fillRect(QRect(0,0,self.RenderDlg.widthpict,self.RenderDlg.heightpict),Qt.black)
      p.end()
      #BlackFrame=QImageToPil(BlackFrame)
      
      #------------------------------------------------------------
      # Render process
      #------------------------------------------------------------
      transitype = 1              # First transition : Always fondu from black image as first transition
      optTr      = 0              # First transition : No option
      z          = 0              # z = current frame
      SeqNum     = 0              # Start à first sequence
      PrevIm     = None

      self.RenderDlg.ProcessWorking = True
      self.RenderDlg.StopProcessBT.setEnabled(True)
      self.RenderDlg.ProgressBTClose.setEnabled(self.RenderDlg.ProcessWorking==False)
      
      IsMovieProcessCurrent   = False  # If True, current sequence is a movie
      IsMovieProcessPrevious  = False  # If True, previous sequence is a movie
      CurSeqVideoProcess      = None   # QProcess for movie conversion
      PrevSeqVideoProcess     = None   # Previous QProcess for movie conversion
      NeedRecalculateCurrent  = -1     # Flag for render optimisation of current image for transition
      NeedRecalculatePrevious = -1     # Flag for render optimisation of previous image for transition
      NbrFrameEqual           = 0      # Render optimisation or static shot
      NbrFrameMobile          = 0      # Render optimisation or mobile shot
      PreviousNbrFrameMobile  = 0      # Render optimisation or mobile shot (previous image for transition)
      CurrentSeqFrame         = 0      # current frame of current image 
      RenderMobileOptimisation= None   # Class cRenderMobileOptimisation for caching xml part of current image (mobile shot)
      RenderMobilePrevOptimis = None   # Class cRenderMobileOptimisation for caching xml part of previous image(mobile shot)
      IsMovieProcessCurrent   = False  # If True, current sequence is a movie (for the start sequence : we don't know)
      for im in self.RenderDlg.img :
        # Prepare variable use for this sequence
        SeqTime,SeqFramNbr,InTrTime,InTrFramNbr,OutTrTime,OutTrFramNbr=self.RenderDlg.ImgTime[SeqNum]
        if SeqNum>=self.StartRenderSequence:
          self.RenderDlg.DoRenderDisplayImg(im)
          #Render optimisation - Recalculation flags : -1=Unknown - 0=Yes, 1=No
          NeedRecalculateCurrent  = -1     # Flag for render optimisation of current image for transition
          NeedRecalculatePrevious = -1     # Flag for render optimisation of previous image for transition
          NbrFrameEqual           = 0      # Render optimisation or static shot
          NbrFrameMobile          = 0      # Render optimisation or mobile shot
          PreviousNbrFrameMobile  = 0      # Render optimisation or mobile shot (previous image for transition)
          CurrentSeqFrame         = 0      # current frame of current image 
          RenderMobileOptimisation= None   # Class cRenderMobileOptimisation for caching xml part of current image (mobile shot)
          RenderMobilePrevOptimis = None   # Class cRenderMobileOptimisation for caching xml part of previous image(mobile shot)
          IsMovieProcessCurrent   = False  # If True, current sequence is a movie (for the start sequence : we don't know)

          while self.RenderDlg.ForceClose==False and CurrentSeqFrame<int(SeqFramNbr-OutTrFramNbr) : # Process current sequence
            QCoreApplication.processEvents()

            #print "NbrFrameEqual="+str(NbrFrameEqual)
            if NbrFrameEqual<=0 or CurrentSeqFrame==0: NeedRecalculateCurrent  = -1
            if NbrFrameMobile<=0:                      RenderMobileOptimisation= None
            if PreviousNbrFrameMobile<=0:              RenderMobilePrevOptimis = None

            # Calculate image
            if NeedRecalculateCurrent==-1 : # if First frame of the sequence
              if im.ObjectType==2:  # It's a movie, then start movie process
                IsMovieProcessCurrent=True
                CurSeqVideoProcess=QProcess()
                # Note : for ffmpeg seek faster it's necessary -ss was place before -i for it seek at the container level rather than the decoder level
                if im.MovieSeekAtCodecLevel==False:
                  if self.RenderDlg.IsPreview==True : Commande = "\""+self.VideoporamaInstance.I+"ffmpeg\" -y -ss "+im.StartVideo.toString("HH:mm:ss.zzz")+" -i \""+im.urlim+"\" -r "+str(self.RenderDlg.imgpsec)+" -vframes "+str(SeqFramNbr+1)+" -t "+im.DurationVideo.toString("HH:mm:ss.zzz")+" -f image2pipe -vcodec ppm -"
                  else :                              Commande = "\""+self.VideoporamaInstance.I+"ffmpeg\" -y -ss "+im.StartVideo.toString("HH:mm:ss.zzz")+" -i \""+im.urlim+"\" -qscale 2 -r "+str(self.RenderDlg.imgpsec)+" -vframes "+str(SeqFramNbr+1)+" -t "+im.DurationVideo.toString("HH:mm:ss.zzz")+" -f image2pipe -vcodec ppm -"
                else:
                  if self.RenderDlg.IsPreview==True : Commande = "\""+self.VideoporamaInstance.I+"ffmpeg\" -y -i \""+im.urlim+"\" -r "+str(self.RenderDlg.imgpsec)+" -vframes "+str(SeqFramNbr+1)+" -t "+im.DurationVideo.toString("HH:mm:ss.zzz")+" -ss "+im.StartVideo.toString("HH:mm:ss.zzz")+" -f image2pipe -vcodec ppm -"
                  else :                              Commande = "\""+self.VideoporamaInstance.I+"ffmpeg\" -y -i \""+im.urlim+"\" -qscale 2 -r "+str(self.RenderDlg.imgpsec)+" -vframes "+str(SeqFramNbr+1)+" -t "+im.DurationVideo.toString("HH:mm:ss.zzz")+" -ss "+im.StartVideo.toString("HH:mm:ss.zzz")+" -f image2pipe -vcodec ppm -"
                self.RenderDlg.DoRenderInfoFrame(self.VideoporamaInstance.qtapp.translate("Render","Starting a new ffmpeg thread for movie conversion ..."),z)
                CurSeqVideoProcess.setProcessChannelMode(QProcess.SeparateChannels)
                CurSeqVideoProcess.setReadChannel(QProcess.StandardOutput)
                CurSeqVideoProcess.start(Commande)
                CurSeqVideoProcess.waitForStarted()
                CurSeqVideoProcess.waitForReadyRead()

                # Wait for an image is ready to read
                while self.RenderDlg.ForceClose==False and CurSeqVideoProcess.state()==QProcess.Running and CurSeqVideoProcess.bytesAvailable()<im.MoviePPMSize:
                  QCoreApplication.processEvents()

                if self.RenderDlg.ForceClose==True :
                  if CurSeqVideoProcess.state()==QProcess.Running: CurSeqVideoProcess.kill()
                else:
                  # Read Image from pipe
                  CurImageRendered=QImage()
                  if CurImageRendered.load(CurSeqVideoProcess,"PPM")==True:
                    # if MovieGeometry is 16/9, verify image is 16/9 and scale image if it's not correct
                    if im.MovieGeometry=="16:9":
                      XS=CurImageRendered.width()
                      YS=CurImageRendered.height()
                      if YS=="1088": YS="1080"  #Special case : same camera use 1920x1088 instead of 1920x1080
                      if ((int(XS)/16)*9)!=int(YS): CurImageRendered=CurImageRendered.scaled(int(16*(float(YS)/9)),YS,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
                    CurImageRendered,tempxmax,tempymax=LoadAndPrepareImage("PIPE",self.VideoporamaInstance.ConfAutoRotate,im.bgfile,im.bgcolor,self.VideoporamaInstance.imgformat,im.EXIF_Orientation,CurImageRendered)
                    QCoreApplication.processEvents()
                    # Apply image text item
                    if im.XMLText!=None : CurImageRendered=ApplyTextToQImage(CurImageRendered,im.XMLText.getElementsByTagName(u"SaveXML")[0])
                    # Scale image to correct size (aspect ratio must be correct !)
                    CurImageRendered=CurImageRendered.scaled(self.RenderDlg.widthpict,self.RenderDlg.heightpict,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
                    QCoreApplication.processEvents()
                  else :
                    #Error reading from PIPE : Make an empty frame
                    CurImageRendered,tempxmax,tempymax=LoadAndPrepareImage("",self.VideoporamaInstance.ConfAutoRotate,im.bgfile,im.bgcolor,self.VideoporamaInstance.imgformat,im.EXIF_Orientation)
                    # Apply image text item
                    if im.XMLText!=None : CurImageRendered=ApplyTextToQImage(CurImageRendered,im.XMLText.getElementsByTagName(u"SaveXML")[0])
                    # Scale image to correct size (aspect ratio must be correct !)
                    CurImageRendered=CurImageRendered.scaled(self.RenderDlg.widthpict,self.RenderDlg.heightpict,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
                    QCoreApplication.processEvents()

                  NbrFrameEqual=SeqFramNbr
                  NbrFrameMobile=0
                  RenderMobileOptimisation=None
                  # Next time, do not start process
                  NeedRecalculateCurrent=0
              else :
                CurImageRendered,NbrFrameEqual,NbrFrameMobile,RenderMobileOptimisation=im.getFrameImage(self.RenderDlg.imgpsec,CurrentSeqFrame,self.RenderDlg.widthpict,self.RenderDlg.heightpict,self.RenderDlg.IsPreview,RenderMobileOptimisation)
                # If it's a static shot then set No Need for Recalculate Current
                if NbrFrameEqual>0 :
                  NeedRecalculateCurrent=1
                else : NeedRecalculateCurrent=0
            elif NeedRecalculateCurrent==0 :
              if im.ObjectType==2:  # It's a movie, then continu movie process
                # Wait for an image is ready to read
                while CurSeqVideoProcess.state()==QProcess.Running and CurSeqVideoProcess.bytesAvailable()<im.MoviePPMSize: QCoreApplication.processEvents()
                NewCurImageRendered=QImage()
                # Read Image from pipe
                if NewCurImageRendered.load(CurSeqVideoProcess,"PPM")==True:
                  CurImageRendered=NewCurImageRendered
                  # if MovieGeometry is 16/9, verify image is 16/9 and scale image if it's not correct
                  if im.MovieGeometry=="16:9":
                    XS=CurImageRendered.width()
                    YS=CurImageRendered.height()
                    if YS=="1088": YS="1080"  #Special case : same camera use 1920x1088 instead of 1920x1080
                    if ((int(XS)/16)*9)!=int(YS): CurImageRendered=CurImageRendered.scaled(int(16*(float(YS)/9)),YS,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
                  CurImageRendered,tempxmax,tempymax=LoadAndPrepareImage("PIPE",self.VideoporamaInstance.ConfAutoRotate,im.bgfile,im.bgcolor,self.VideoporamaInstance.imgformat,im.EXIF_Orientation,CurImageRendered)
                  QCoreApplication.processEvents()
                  # Apply image text item
                  if im.XMLText!=None : CurImageRendered=ApplyTextToQImage(CurImageRendered,im.XMLText.getElementsByTagName(u"SaveXML")[0])
                  # Scale image to correct size (aspect ratio must be correct !)
                  CurImageRendered=CurImageRendered.scaled(self.RenderDlg.widthpict,self.RenderDlg.heightpict,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
                  QCoreApplication.processEvents()
                # No else : use last CurImageRendered if error
              else :
                CurImageRendered,NbrFrameEqual,NbrFrameMobile,RenderMobileOptimisation=im.getFrameImage(self.RenderDlg.imgpsec,CurrentSeqFrame,self.RenderDlg.widthpict,self.RenderDlg.heightpict,self.RenderDlg.IsPreview,RenderMobileOptimisation)
                QCoreApplication.processEvents()
            #else : None # Do nothing if no Need of Recalculate Current (only static shot)
            
            if self.RenderDlg.ForceClose==False :
              # Process transition with previous image : Transforme ImageRendered with transition
              if CurrentSeqFrame<InTrFramNbr:
                if PrevIm!=None : 
                  if PrevIm.ObjectType==2 and PrevSeqVideoProcess!=None:  # It's a movie, then continu movie process (if it exist)
                    # Wait for an image is ready to read
                    while PrevSeqVideoProcess.state()==QProcess.Running and PrevSeqVideoProcess.bytesAvailable()<PrevIm.MoviePPMSize: QCoreApplication.processEvents()
                    NewPreviousImageRendered=QImage()
                    # Read Image from pipe
                    if NewPreviousImageRendered.load(PrevSeqVideoProcess,"PPM")==True:
                      PreviousImageRendered=NewPreviousImageRendered
                      QCoreApplication.processEvents()
                      # if MovieGeometry is 16/9, verify image is 16/9 and scale image if it's not correct
                      if PrevIm.MovieGeometry=="16:9":
                        XS=PreviousImageRendered.width()
                        YS=PreviousImageRendered.height()
                        if YS=="1088": YS="1080"  #Special case : same camera use 1920x1088 instead of 1920x1080
                        if ((int(XS)/16)*9)!=int(YS): PreviousImageRendered=PreviousImageRendered.scaled(int(16*(float(YS)/9)),YS,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
                      PreviousImageRendered,tempxmax,tempymax=LoadAndPrepareImage("PIPE",self.VideoporamaInstance.ConfAutoRotate,PrevIm.bgfile,PrevIm.bgcolor,self.VideoporamaInstance.imgformat,PrevIm.EXIF_Orientation,PreviousImageRendered)
                      QCoreApplication.processEvents()
                      # Apply image text item
                      if PrevIm.XMLText!=None : PreviousImageRendered=ApplyTextToQImage(PreviousImageRendered,PrevIm.XMLText.getElementsByTagName(u"SaveXML")[0])
                      # Scale image to correct size (aspect ratio must be correct !)
                      PreviousImageRendered=PreviousImageRendered.scaled(self.RenderDlg.widthpict,self.RenderDlg.heightpict,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
                    # No else : use last PreviousImageRendered if error
                  elif NeedRecalculatePrevious==-1 : # if First frame of the transition
                    # Calculate image
                    if PrevIm.ObjectType==2 : # If previous is movie then it's a preview from process and user select just after a movie
                      PreviousImageRendered=BlackFrame
                      PreviousNbrFrameEqual=InTrFramNbr
                      PreviousNbrFrameMobile=0
                      RenderMobilePrevOptimis=None
                    else:
                      PreviousImageRendered,PreviousNbrFrameEqual,PreviousNbrFrameMobile,RenderMobilePrevOptimis=PrevIm.getFrameImage(self.RenderDlg.imgpsec,CurrentSeqFrame+(self.RenderDlg.ImgTime[SeqNum-1][1]-self.RenderDlg.ImgTime[SeqNum-1][5]),self.RenderDlg.widthpict,self.RenderDlg.heightpict,self.RenderDlg.IsPreview,RenderMobilePrevOptimis)
                      QCoreApplication.processEvents()
                    # If it's a static shot then set No Need for Recalculate Previous
                    if PreviousNbrFrameEqual>0 : NeedRecalculatePrevious=1
                    else : NeedRecalculatePrevious=0
                  elif NeedRecalculatePrevious==0 :
                    PreviousImageRendered,PreviousNbrFrameEqual,PreviousNbrFrameMobile,RenderMobilePrevOptimis=PrevIm.getFrameImage(self.RenderDlg.imgpsec,CurrentSeqFrame+(self.RenderDlg.ImgTime[SeqNum-1][1]-self.RenderDlg.ImgTime[SeqNum-1][5]),self.RenderDlg.widthpict,self.RenderDlg.heightpict,self.RenderDlg.IsPreview,RenderMobilePrevOptimis)
                    QCoreApplication.processEvents()
                  #else : None # Do nothing if no Need of Recalculate Previous
                else :
                  PreviousImageRendered=BlackFrame
                ImageRendered=choiceTransition(self.RenderDlg.widthpict,self.RenderDlg.heightpict,lumask,transitype,PreviousImageRendered,CurImageRendered,(float(CurrentSeqFrame)/InTrFramNbr)*100,optTr)
                QCoreApplication.processEvents()
              else :
                ImageRendered=CurImageRendered
                if PrevIm!=None :
                  if PrevIm.ImageCacheMovie!=None :
                    PrevIm.ImageCacheMovie=None             # free ImageCacheMovie

              # Add overlaid text if needed
              if self.RenderDlg.XMLText!=None: ImageRendered=ApplyTextToQImage(ImageRendered,self.RenderDlg.XMLText)

              # Save the QImage to a ByteArray and then write the ByteArray to the pipe
              BAr=QByteArray()
              Buf=QBuffer(BAr)
              Buf.open(QIODevice.WriteOnly)
              ImageRendered.save(Buf,"PPM")
              Buf.close()
              #print "BAr is empty ? length : ", BAr.length()
              encodedv_stdin.write(BAr.data())

              CurrentSeqFrame+=1      # frame suivante pour l'image en cours
              z              +=1      # frame suivante pour la séquence
              NbrFrameEqual  -=1      # one frame written
              NbrFrameMobile -=1      # one frame written

            #Display user information
            if self.RenderDlg.ForceClose==True:
              self.RenderDlg.DoRenderInfoFrame("Process stopped by user",z)
            elif (z % 5)==1:
              if CurrentSeqFrame<=InTrFramNbr:   self.RenderDlg.DoRenderInfoFrame(self.VideoporamaInstance.qtapp.translate("Render","Transition render (calculation)"),z)
              elif IsMovieProcessCurrent==True:  self.RenderDlg.DoRenderInfoFrame(self.VideoporamaInstance.qtapp.translate("Render","Movie render (conversion)"),z)
              elif NbrFrameEqual>0:              self.RenderDlg.DoRenderInfoFrame(self.VideoporamaInstance.qtapp.translate("Render","Static shot render (booster)"),z)
              else :                             self.RenderDlg.DoRenderInfoFrame(self.VideoporamaInstance.qtapp.translate("Render","Mobile shot render (calculation)"),z)

            #Render optimisation : if NbrFrameEqual>0 then we can write many identical frame at this point
            if im.ObjectType!=2:
              while self.RenderDlg.ForceClose==False and NbrFrameEqual>0 and CurrentSeqFrame<int(SeqFramNbr-OutTrFramNbr) and (CurrentSeqFrame>InTrFramNbr):
                # Re-use previous ByteArray
                encodedv_stdin.write(BAr.data())
                CurrentSeqFrame+=1    # frame suivante pour l'image en cours
                z              +=1    # frame suivante pour la séquence
                NbrFrameEqual  -=1    # one frame writtent

                #Display user information each 10 frame
                if (z % 10)==2: self.RenderDlg.DoRenderInfoFrame(self.VideoporamaInstance.qtapp.translate("Render","Static shot render (booster)"),z)
        else :
          z+=SeqFramNbr-OutTrFramNbr  # We skeep this sequence if preview from ...

        SeqNum                 = SeqNum+1         # Next sequence
        transitype             = int(im.typet)    # Get transition for next sequence
        optTr                  = im.opttransi     # Get Option Transition for next sequence
        PrevIm                 = im               # Current image become previous image
        IsMovieProcessPrevious = IsMovieProcessCurrent
        PrevSeqVideoProcess    = CurSeqVideoProcess
        PrevSeqFrame           = CurrentSeqFrame

      #---------------------------------------------------- Last Transition process
      SeqFramNbr   =OutTrFramNbr+CurrentSeqFrame # Calculate last frame number
      StartSeqFrame=CurrentSeqFrame              # Keep current frame number for % translation calculation
      #Render optimisation - Previous recalculation flag : -1=Unknown - 0=Yes, 1=No
      NeedRecalculatePrevious  = -1
      RenderMobileOptimisation = None
      while self.RenderDlg.ForceClose==False and CurrentSeqFrame<int(SeqFramNbr) :
        if im.ObjectType==2:  # It's a movie, then continu movie process
          # Wait for an image is ready to read
          while CurSeqVideoProcess.state()==QProcess.Running and CurSeqVideoProcess.bytesAvailable()<im.MoviePPMSize: QCoreApplication.processEvents()
          NewCurImageRendered=QImage()
          # Read Image from pipe
          if NewCurImageRendered.load(CurSeqVideoProcess,"PPM")==True:
            CurImageRendered=NewCurImageRendered
            # if MovieGeometry is 16/9, verify image is 16/9 and scale image if it's not correct
            if im.MovieGeometry=="16:9":
              XS=CurImageRendered.width()
              YS=CurImageRendered.height()
              if YS=="1088": YS="1080"  #Special case : same camera use 1920x1088 instead of 1920x1080
              if ((int(XS)/16)*9)!=int(YS): CurImageRendered=CurImageRendered.scaled(int(16*(float(YS)/9)),YS,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
            CurImageRendered,tempxmax,tempymax=LoadAndPrepareImage("PIPE",self.VideoporamaInstance.ConfAutoRotate,im.bgfile,im.bgcolor,self.VideoporamaInstance.imgformat,im.EXIF_Orientation,CurImageRendered)
            QCoreApplication.processEvents()
            # Apply image text item
            if im.XMLText!=None : CurImageRendered=ApplyTextToQImage(CurImageRendered,im.XMLText.getElementsByTagName(u"SaveXML")[0])
            # Scale image to correct size (aspect ratio must be correct !)
            #ImageRendered=QImageToPil(CurImageRendered.scaled(self.RenderDlg.widthpict,self.RenderDlg.heightpict,Qt.IgnoreAspectRatio,Qt.SmoothTransformation))
            ImageRendered=CurImageRendered.scaled(self.RenderDlg.widthpict,self.RenderDlg.heightpict,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
        elif NeedRecalculatePrevious==-1 : # if First frame of the transition
          # Calculate image
          CalcImageRendered,NbrFrameEqual,NbrFrameMobile,RenderMobileOptimisation=im.getFrameImage(self.RenderDlg.imgpsec,CurrentSeqFrame,self.RenderDlg.widthpict,self.RenderDlg.heightpict,self.RenderDlg.IsPreview,RenderMobileOptimisation)
          ImageRendered=CalcImageRendered
          # If it's a static shot then set No Need for Recalculate Previous
          if NbrFrameEqual>0 : 
            NeedRecalculatePrevious=1
          else : NeedRecalculatePrevious=0
        elif NeedRecalculatePrevious==0 :
          ImageRendered,NbrFrameEqual,NbrFrameMobile,RenderMobileOptimisation=im.getFrameImage(self.RenderDlg.imgpsec,CurrentSeqFrame,self.RenderDlg.widthpict,self.RenderDlg.heightpict,self.RenderDlg.IsPreview,RenderMobileOptimisation)
        else : 
          ImageRendered=CalcImageRendered # Do nothing if no Need of Recalculate Previous
        ImageRendered=choiceTransition(self.RenderDlg.widthpict,self.RenderDlg.heightpict,lumask,transitype,ImageRendered,BlackFrame,(float(CurrentSeqFrame-StartSeqFrame)/OutTrFramNbr)*100,optTr)
        # Add overlaid text if needed
        #if self.RenderDlg.XMLText!=None: ImageRendered=QImageToPil(ApplyTextToQImage(PilToQImage(ImageRendered),self.RenderDlg.XMLText))
        if self.RenderDlg.XMLText!=None: ImageRendered=ApplyTextToQImage(ImageRendered,self.RenderDlg.XMLText)

        # Save the QImage to a ByteArray and then write the ByteArray to the pipe
        BAr=QByteArray()
        Buf=QBuffer(BAr)
        Buf.open(QIODevice.WriteOnly)
        ImageRendered.save(Buf,"PPM")
        Buf.close()
        #print "BAr is empty ? length : ", BAr.length()
        encodedv_stdin.write(BAr.data())
        QCoreApplication.processEvents()

        CurrentSeqFrame+=1
        z              +=1  #frame suivante pour la séquence
        if (z % 5)==1: self.RenderDlg.DoRenderInfoFrame(self.VideoporamaInstance.qtapp.translate("Render","Last transition render (calculation)"),z)
      im.ImageCacheMovie=None             # free ImageCacheMovie
      self.RenderDlg.DoRenderInfoFrame(self.VideoporamaInstance.qtapp.translate("Render","Process terminated"),z)
      #---------------------------------------------------- Transition process End
      encodedv_stdin.close()  # Send signal End of file to encoding process
      if self.RenderDlg.IsPreview!=True: Process.wait()    # Wait until encoding is finished

      if self.RenderDlg.ForceClose==True:
        if PrevSeqVideoProcess!=None:
          if PrevSeqVideoProcess.state()==QProcess.Running:
            PrevSeqVideoProcess.kill()
        if CurSeqVideoProcess!=None:
          if CurSeqVideoProcess.state()==QProcess.Running:
            CurSeqVideoProcess.kill()
        self.RenderDlg.DoRenderInfoFrame("Process stopped by user",-1)
      else:
        if self.RenderDlg.IsPreview!=True: self.RenderDlg.ViewResultProcess()

      # Disabled StopProcessBT
      self.RenderDlg.ProcessWorking = False
      self.RenderDlg.StopProcessBT.setEnabled(False)
      self.RenderDlg.ProgressBTClose.setEnabled(self.RenderDlg.ProcessWorking==False)
      # Activate ReplayBT if IsPreview is True
      self.RenderDlg.ReplayBT.setEnabled(self.RenderDlg.IsPreview)
      # Activate Render TAB if IsPreview is False
      self.RenderDlg.Tab.setTabEnabled(0,self.RenderDlg.IsPreview==False)
