// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMULL_2D_2S_S_TRACE_AARCH64_H_
#define VIXL_SIM_SMULL_2D_2S_S_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_smull_2D_2S_S[] = {
  0x000000003e040000, 0x000000003e820000,
  0x000000003e820000, 0x000000003f010000,
  0x0000003efe860000, 0x0000003f7e830000,
  0x0000000000000000, 0x0000000000000000,
  0x000000003e820000, 0x000000003f010000,
  0x0000003efe860000, 0x0000003f7e830000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007e00, 0x0000000000007f00,
  0x0000003efe860000, 0x0000003f7e830000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007e00, 0x0000000000007f00,
  0x000000000000fc00, 0x000000000000fe00,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007e00, 0x0000000000007f00,
  0x000000000000fc00, 0x000000000000fe00,
  0x00000000000fc000, 0x00000000000fe000,
  0x0000000000007e00, 0x0000000000007f00,
  0x000000000000fc00, 0x000000000000fe00,
  0x00000000000fc000, 0x00000000000fe000,
  0x00000000003d8600, 0x00000000003e0300,
  0x000000000000fc00, 0x000000000000fe00,
  0x00000000000fc000, 0x00000000000fe000,
  0x00000000003d8600, 0x00000000003e0300,
  0x00000000003e0400, 0x00000000003e8200,
  0x00000000000fc000, 0x00000000000fe000,
  0x00000000003d8600, 0x00000000003e0300,
  0x00000000003e0400, 0x00000000003e8200,
  0x00000000003e8200, 0x00000000003f0100,
  0x00000000003d8600, 0x00000000003e0300,
  0x00000000003e0400, 0x00000000003e8200,
  0x00000000003e8200, 0x00000000003f0100,
  0x000000003efe8600, 0x000000003f7e8300,
  0x00000000003e0400, 0x00000000003e8200,
  0x00000000003e8200, 0x00000000003f0100,
  0x000000003efe8600, 0x000000003f7e8300,
  0x000000003eff0400, 0x000000003f7f0200,
  0x00000000003e8200, 0x00000000003f0100,
  0x000000003efe8600, 0x000000003f7e8300,
  0x000000003eff0400, 0x000000003f7f0200,
  0x000000003eff8200, 0x000000003f7f8100,
  0x000000003efe8600, 0x000000003f7e8300,
  0x000000003eff0400, 0x000000003f7f0200,
  0x000000003eff8200, 0x000000003f7f8100,
  0x0000193333331a00, 0x0000196666664d00,
  0x000000003eff0400, 0x000000003f7f0200,
  0x000000003eff8200, 0x000000003f7f8100,
  0x0000193333331a00, 0x0000196666664d00,
  0x000029ffffffd600, 0x00002a5555552b00,
  0x000000003eff8200, 0x000000003f7f8100,
  0x0000193333331a00, 0x0000196666664d00,
  0x000029ffffffd600, 0x00002a5555552b00,
  0x00003efffffe8600, 0x00003f7ffffe8300,
  0x0000193333331a00, 0x0000196666664d00,
  0x000029ffffffd600, 0x00002a5555552b00,
  0x00003efffffe8600, 0x00003f7ffffe8300,
  0x00003effffff0400, 0x00003f7fffff0200,
  0x000029ffffffd600, 0x00002a5555552b00,
  0x00003efffffe8600, 0x00003f7ffffe8300,
  0x00003effffff0400, 0x00003f7fffff0200,
  0x00003effffff8200, 0x00003f7fffff8100,
  0x00003efffffe8600, 0x00003f7ffffe8300,
  0x00003effffff0400, 0x00003f7fffff0200,
  0x00003effffff8200, 0x00003f7fffff8100,
  0xffffc10000000000, 0xffffc08000000000,
  0x00003effffff0400, 0x00003f7fffff0200,
  0x00003effffff8200, 0x00003f7fffff8100,
  0xffffc10000000000, 0xffffc08000000000,
  0xffffc10000007e00, 0xffffc08000007f00,
  0x00003effffff8200, 0x00003f7fffff8100,
  0xffffc10000000000, 0xffffc08000000000,
  0xffffc10000007e00, 0xffffc08000007f00,
  0xffffd5ffffffac00, 0xffffd5aaaaaa5600,
  0xffffc10000000000, 0xffffc08000000000,
  0xffffc10000007e00, 0xffffc08000007f00,
  0xffffd5ffffffac00, 0xffffd5aaaaaa5600,
  0xffffe6cccccc6800, 0xffffe69999993400,
  0xffffc10000007e00, 0xffffc08000007f00,
  0xffffd5ffffffac00, 0xffffd5aaaaaa5600,
  0xffffe6cccccc6800, 0xffffe69999993400,
  0xffffffffc1000000, 0xffffffffc0800000,
  0xffffd5ffffffac00, 0xffffd5aaaaaa5600,
  0xffffe6cccccc6800, 0xffffe69999993400,
  0xffffffffc1000000, 0xffffffffc0800000,
  0xffffffffc1007e00, 0xffffffffc0807f00,
  0xffffe6cccccc6800, 0xffffe69999993400,
  0xffffffffc1000000, 0xffffffffc0800000,
  0xffffffffc1007e00, 0xffffffffc0807f00,
  0xffffffffc100fc00, 0xffffffffc080fe00,
  0xffffffffc1000000, 0xffffffffc0800000,
  0xffffffffc1007e00, 0xffffffffc0807f00,
  0xffffffffc100fc00, 0xffffffffc080fe00,
  0xffffffffc1017a00, 0xffffffffc0817d00,
  0xffffffffc1007e00, 0xffffffffc0807f00,
  0xffffffffc100fc00, 0xffffffffc080fe00,
  0xffffffffc1017a00, 0xffffffffc0817d00,
  0xffffffffffc10000, 0xffffffffffc08000,
  0xffffffffc100fc00, 0xffffffffc080fe00,
  0xffffffffc1017a00, 0xffffffffc0817d00,
  0xffffffffffc10000, 0xffffffffffc08000,
  0xffffffffffc17e00, 0xffffffffffc0ff00,
  0xffffffffc1017a00, 0xffffffffc0817d00,
  0xffffffffffc10000, 0xffffffffffc08000,
  0xffffffffffc17e00, 0xffffffffffc0ff00,
  0xffffffffffc1fc00, 0xffffffffffc17e00,
  0xffffffffffc10000, 0xffffffffffc08000,
  0xffffffffffc17e00, 0xffffffffffc0ff00,
  0xffffffffffc1fc00, 0xffffffffffc17e00,
  0xffffffffffc27a00, 0xffffffffffc1fd00,
  0xffffffffffc17e00, 0xffffffffffc0ff00,
  0xffffffffffc1fc00, 0xffffffffffc17e00,
  0xffffffffffc27a00, 0xffffffffffc1fd00,
  0xfffffffffff04000, 0xfffffffffff02000,
  0xffffffffffc1fc00, 0xffffffffffc17e00,
  0xffffffffffc27a00, 0xffffffffffc1fd00,
  0xfffffffffff04000, 0xfffffffffff02000,
  0xfffffffffffe8600, 0xfffffffffffe8300,
  0xffffffffffc27a00, 0xffffffffffc1fd00,
  0xfffffffffff04000, 0xfffffffffff02000,
  0xfffffffffffe8600, 0xfffffffffffe8300,
  0xffffffffffff0400, 0xffffffffffff0200,
  0xfffffffffff04000, 0xfffffffffff02000,
  0xfffffffffffe8600, 0xfffffffffffe8300,
  0xffffffffffff0400, 0xffffffffffff0200,
  0xffffffffffff8200, 0xffffffffffff8100,
  0xfffffffffffe8300, 0xfffffffffe800900,
  0xffffffffffff0200, 0xffffffffff000600,
  0xffffffffffff8100, 0xffffffffff800300,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0200, 0xffffffffff000600,
  0xffffffffffff8100, 0xffffffffff800300,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f00, 0x00000000007ffd00,
  0xffffffffffff8100, 0xffffffffff800300,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f00, 0x00000000007ffd00,
  0x000000000000fe00, 0x0000000000fffa00,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f00, 0x00000000007ffd00,
  0x000000000000fe00, 0x0000000000fffa00,
  0x00000000000fe000, 0x000000000fffa000,
  0x0000000000007f00, 0x00000000007ffd00,
  0x000000000000fe00, 0x0000000000fffa00,
  0x00000000000fe000, 0x000000000fffa000,
  0x00000000003e0300, 0x000000003e7e8900,
  0x000000000000fe00, 0x0000000000fffa00,
  0x00000000000fe000, 0x000000000fffa000,
  0x00000000003e0300, 0x000000003e7e8900,
  0x00000000003e8200, 0x000000003efe8600,
  0x00000000000fe000, 0x000000000fffa000,
  0x00000000003e0300, 0x000000003e7e8900,
  0x00000000003e8200, 0x000000003efe8600,
  0x00000000003f0100, 0x000000003f7e8300,
  0x00000000003e0300, 0x000000003e7e8900,
  0x00000000003e8200, 0x000000003efe8600,
  0x00000000003f0100, 0x000000003f7e8300,
  0x000000003f7e8300, 0x0000003ffd000900,
  0x00000000003e8200, 0x000000003efe8600,
  0x00000000003f0100, 0x000000003f7e8300,
  0x000000003f7e8300, 0x0000003ffd000900,
  0x000000003f7f0200, 0x0000003ffd800600,
  0x00000000003f0100, 0x000000003f7e8300,
  0x000000003f7e8300, 0x0000003ffd000900,
  0x000000003f7f0200, 0x0000003ffd800600,
  0x000000003f7f8100, 0x0000003ffe000300,
  0x000000003f7e8300, 0x0000003ffd000900,
  0x000000003f7f0200, 0x0000003ffd800600,
  0x000000003f7f8100, 0x0000003ffe000300,
  0x0000196666664d00, 0x001998ffffe66700,
  0x000000003f7f0200, 0x0000003ffd800600,
  0x000000003f7f8100, 0x0000003ffe000300,
  0x0000196666664d00, 0x001998ffffe66700,
  0x00002a5555552b00, 0x002aa9aaaa800100,
  0x000000003f7f8100, 0x0000003ffe000300,
  0x0000196666664d00, 0x001998ffffe66700,
  0x00002a5555552b00, 0x002aa9aaaa800100,
  0x00003f7ffffe8300, 0x003ffe7ffe800900,
  0x0000196666664d00, 0x001998ffffe66700,
  0x00002a5555552b00, 0x002aa9aaaa800100,
  0x00003f7ffffe8300, 0x003ffe7ffe800900,
  0x00003f7fffff0200, 0x003ffe7fff000600,
  0x00002a5555552b00, 0x002aa9aaaa800100,
  0x00003f7ffffe8300, 0x003ffe7ffe800900,
  0x00003f7fffff0200, 0x003ffe7fff000600,
  0x00003f7fffff8100, 0x003ffe7fff800300,
  0x00003f7ffffe8300, 0x003ffe7ffe800900,
  0x00003f7fffff0200, 0x003ffe7fff000600,
  0x00003f7fffff8100, 0x003ffe7fff800300,
  0xffffc08000000000, 0xffc0018000000000,
  0x00003f7fffff0200, 0x003ffe7fff000600,
  0x00003f7fffff8100, 0x003ffe7fff800300,
  0xffffc08000000000, 0xffc0018000000000,
  0xffffc08000007f00, 0xffc00180007ffd00,
  0x00003f7fffff8100, 0x003ffe7fff800300,
  0xffffc08000000000, 0xffc0018000000000,
  0xffffc08000007f00, 0xffc00180007ffd00,
  0xffffd5aaaaaa5600, 0xffd5565555000200,
  0xffffc08000000000, 0xffc0018000000000,
  0xffffc08000007f00, 0xffc00180007ffd00,
  0xffffd5aaaaaa5600, 0xffd5565555000200,
  0xffffe69999993400, 0xffe666ffff999c00,
  0xffffc08000007f00, 0xffc00180007ffd00,
  0xffffd5aaaaaa5600, 0xffd5565555000200,
  0xffffe69999993400, 0xffe666ffff999c00,
  0xffffffffc0800000, 0xffffffc001800000,
  0xffffd5aaaaaa5600, 0xffd5565555000200,
  0xffffe69999993400, 0xffe666ffff999c00,
  0xffffffffc0800000, 0xffffffc001800000,
  0xffffffffc0807f00, 0xffffffc001fffd00,
  0xffffe69999993400, 0xffe666ffff999c00,
  0xffffffffc0800000, 0xffffffc001800000,
  0xffffffffc0807f00, 0xffffffc001fffd00,
  0xffffffffc080fe00, 0xffffffc0027ffa00,
  0xffffffffc0800000, 0xffffffc001800000,
  0xffffffffc0807f00, 0xffffffc001fffd00,
  0xffffffffc080fe00, 0xffffffc0027ffa00,
  0xffffffffc0817d00, 0xffffffc002fff700,
  0xffffffffc0807f00, 0xffffffc001fffd00,
  0xffffffffc080fe00, 0xffffffc0027ffa00,
  0xffffffffc0817d00, 0xffffffc002fff700,
  0xffffffffffc08000, 0xffffffffc0018000,
  0xffffffffc080fe00, 0xffffffc0027ffa00,
  0xffffffffc0817d00, 0xffffffc002fff700,
  0xffffffffffc08000, 0xffffffffc0018000,
  0xffffffffffc0ff00, 0xffffffffc0817d00,
  0xffffffffc0817d00, 0xffffffc002fff700,
  0xffffffffffc08000, 0xffffffffc0018000,
  0xffffffffffc0ff00, 0xffffffffc0817d00,
  0xffffffffffc17e00, 0xffffffffc1017a00,
  0xffffffffffc08000, 0xffffffffc0018000,
  0xffffffffffc0ff00, 0xffffffffc0817d00,
  0xffffffffffc17e00, 0xffffffffc1017a00,
  0xffffffffffc1fd00, 0xffffffffc1817700,
  0xffffffffffc0ff00, 0xffffffffc0817d00,
  0xffffffffffc17e00, 0xffffffffc1017a00,
  0xffffffffffc1fd00, 0xffffffffc1817700,
  0xfffffffffff02000, 0xfffffffff0006000,
  0xffffffffffc17e00, 0xffffffffc1017a00,
  0xffffffffffc1fd00, 0xffffffffc1817700,
  0xfffffffffff02000, 0xfffffffff0006000,
  0xfffffffffffe8300, 0xfffffffffe800900,
  0xffffffffffc1fd00, 0xffffffffc1817700,
  0xfffffffffff02000, 0xfffffffff0006000,
  0xfffffffffffe8300, 0xfffffffffe800900,
  0xffffffffffff0200, 0xffffffffff000600,
  0xfffffffffff02000, 0xfffffffff0006000,
  0xfffffffffffe8300, 0xfffffffffe800900,
  0xffffffffffff0200, 0xffffffffff000600,
  0xffffffffffff8100, 0xffffffffff800300,
  0xfffffffffe800900, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0xffffffffff800300, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0xffffffffff800300, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000000,
  0xffffffffff800300, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000000,
  0x0000000000fffa00, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000000,
  0x0000000000fffa00, 0x0000000000000000,
  0x000000000fffa000, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000000,
  0x0000000000fffa00, 0x0000000000000000,
  0x000000000fffa000, 0x0000000000000000,
  0x000000003e7e8900, 0x0000000000000000,
  0x0000000000fffa00, 0x0000000000000000,
  0x000000000fffa000, 0x0000000000000000,
  0x000000003e7e8900, 0x0000000000000000,
  0x000000003efe8600, 0x0000000000000000,
  0x000000000fffa000, 0x0000000000000000,
  0x000000003e7e8900, 0x0000000000000000,
  0x000000003efe8600, 0x0000000000000000,
  0x000000003f7e8300, 0x0000000000000000,
  0x000000003e7e8900, 0x0000000000000000,
  0x000000003efe8600, 0x0000000000000000,
  0x000000003f7e8300, 0x0000000000000000,
  0x0000003ffd000900, 0x0000000000000000,
  0x000000003efe8600, 0x0000000000000000,
  0x000000003f7e8300, 0x0000000000000000,
  0x0000003ffd000900, 0x0000000000000000,
  0x0000003ffd800600, 0x0000000000000000,
  0x000000003f7e8300, 0x0000000000000000,
  0x0000003ffd000900, 0x0000000000000000,
  0x0000003ffd800600, 0x0000000000000000,
  0x0000003ffe000300, 0x0000000000000000,
  0x0000003ffd000900, 0x0000000000000000,
  0x0000003ffd800600, 0x0000000000000000,
  0x0000003ffe000300, 0x0000000000000000,
  0x001998ffffe66700, 0x0000000000000000,
  0x0000003ffd800600, 0x0000000000000000,
  0x0000003ffe000300, 0x0000000000000000,
  0x001998ffffe66700, 0x0000000000000000,
  0x002aa9aaaa800100, 0x0000000000000000,
  0x0000003ffe000300, 0x0000000000000000,
  0x001998ffffe66700, 0x0000000000000000,
  0x002aa9aaaa800100, 0x0000000000000000,
  0x003ffe7ffe800900, 0x0000000000000000,
  0x001998ffffe66700, 0x0000000000000000,
  0x002aa9aaaa800100, 0x0000000000000000,
  0x003ffe7ffe800900, 0x0000000000000000,
  0x003ffe7fff000600, 0x0000000000000000,
  0x002aa9aaaa800100, 0x0000000000000000,
  0x003ffe7ffe800900, 0x0000000000000000,
  0x003ffe7fff000600, 0x0000000000000000,
  0x003ffe7fff800300, 0x0000000000000000,
  0x003ffe7ffe800900, 0x0000000000000000,
  0x003ffe7fff000600, 0x0000000000000000,
  0x003ffe7fff800300, 0x0000000000000000,
  0xffc0018000000000, 0x0000000000000000,
  0x003ffe7fff000600, 0x0000000000000000,
  0x003ffe7fff800300, 0x0000000000000000,
  0xffc0018000000000, 0x0000000000000000,
  0xffc00180007ffd00, 0x0000000000000000,
  0x003ffe7fff800300, 0x0000000000000000,
  0xffc0018000000000, 0x0000000000000000,
  0xffc00180007ffd00, 0x0000000000000000,
  0xffd5565555000200, 0x0000000000000000,
  0xffc0018000000000, 0x0000000000000000,
  0xffc00180007ffd00, 0x0000000000000000,
  0xffd5565555000200, 0x0000000000000000,
  0xffe666ffff999c00, 0x0000000000000000,
  0xffc00180007ffd00, 0x0000000000000000,
  0xffd5565555000200, 0x0000000000000000,
  0xffe666ffff999c00, 0x0000000000000000,
  0xffffffc001800000, 0x0000000000000000,
  0xffd5565555000200, 0x0000000000000000,
  0xffe666ffff999c00, 0x0000000000000000,
  0xffffffc001800000, 0x0000000000000000,
  0xffffffc001fffd00, 0x0000000000000000,
  0xffe666ffff999c00, 0x0000000000000000,
  0xffffffc001800000, 0x0000000000000000,
  0xffffffc001fffd00, 0x0000000000000000,
  0xffffffc0027ffa00, 0x0000000000000000,
  0xffffffc001800000, 0x0000000000000000,
  0xffffffc001fffd00, 0x0000000000000000,
  0xffffffc0027ffa00, 0x0000000000000000,
  0xffffffc002fff700, 0x0000000000000000,
  0xffffffc001fffd00, 0x0000000000000000,
  0xffffffc0027ffa00, 0x0000000000000000,
  0xffffffc002fff700, 0x0000000000000000,
  0xffffffffc0018000, 0x0000000000000000,
  0xffffffc0027ffa00, 0x0000000000000000,
  0xffffffc002fff700, 0x0000000000000000,
  0xffffffffc0018000, 0x0000000000000000,
  0xffffffffc0817d00, 0x0000000000000000,
  0xffffffc002fff700, 0x0000000000000000,
  0xffffffffc0018000, 0x0000000000000000,
  0xffffffffc0817d00, 0x0000000000000000,
  0xffffffffc1017a00, 0x0000000000000000,
  0xffffffffc0018000, 0x0000000000000000,
  0xffffffffc0817d00, 0x0000000000000000,
  0xffffffffc1017a00, 0x0000000000000000,
  0xffffffffc1817700, 0x0000000000000000,
  0xffffffffc0817d00, 0x0000000000000000,
  0xffffffffc1017a00, 0x0000000000000000,
  0xffffffffc1817700, 0x0000000000000000,
  0xfffffffff0006000, 0x0000000000000000,
  0xffffffffc1017a00, 0x0000000000000000,
  0xffffffffc1817700, 0x0000000000000000,
  0xfffffffff0006000, 0x0000000000000000,
  0xfffffffffe800900, 0x0000000000000000,
  0xffffffffc1817700, 0x0000000000000000,
  0xfffffffff0006000, 0x0000000000000000,
  0xfffffffffe800900, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0xfffffffff0006000, 0x0000000000000000,
  0xfffffffffe800900, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0xffffffffff800300, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000000, 0x000000000000007d,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000000, 0x000000000000007d,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000000, 0x000000000000007d,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x000000000000007d,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x0000000000007ffd,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x0000000000007ffd,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x0000000000007ffd,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000000007ffd,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000033333333,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000033333333,
  0x0000000000000000, 0x0000000055555555,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000033333333,
  0x0000000000000000, 0x0000000055555555,
  0x0000000000000000, 0x000000007ffffffd,
  0x0000000000000000, 0x0000000033333333,
  0x0000000000000000, 0x0000000055555555,
  0x0000000000000000, 0x000000007ffffffd,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000000000000, 0x0000000055555555,
  0x0000000000000000, 0x000000007ffffffd,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000000000000, 0x000000007fffffff,
  0x0000000000000000, 0x000000007ffffffd,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000000000000, 0x000000007fffffff,
  0x0000000000000000, 0xffffffff80000000,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000000000000, 0x000000007fffffff,
  0x0000000000000000, 0xffffffff80000000,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0x000000007fffffff,
  0x0000000000000000, 0xffffffff80000000,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0xffffffffaaaaaaaa,
  0x0000000000000000, 0xffffffff80000000,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0xffffffffaaaaaaaa,
  0x0000000000000000, 0xffffffffcccccccc,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0xffffffffaaaaaaaa,
  0x0000000000000000, 0xffffffffcccccccc,
  0x0000000000000000, 0xffffffffffff8000,
  0x0000000000000000, 0xffffffffaaaaaaaa,
  0x0000000000000000, 0xffffffffcccccccc,
  0x0000000000000000, 0xffffffffffff8000,
  0x0000000000000000, 0xffffffffffff8001,
  0x0000000000000000, 0xffffffffcccccccc,
  0x0000000000000000, 0xffffffffffff8000,
  0x0000000000000000, 0xffffffffffff8001,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffffff8000,
  0x0000000000000000, 0xffffffffffff8001,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffff8001,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffffff80,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffffff80,
  0x0000000000000000, 0xffffffffffffff81,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffffff80,
  0x0000000000000000, 0xffffffffffffff81,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffffff80,
  0x0000000000000000, 0xffffffffffffff81,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffff81,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffffe0,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffffe0,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffffe0,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffe0,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffff,
  0xfffffffffffffffd, 0xfffffffffffffffa,
  0xfffffffffffffffe, 0xfffffffffffffffc,
  0xffffffffffffffff, 0xfffffffffffffffe,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffffe, 0xfffffffffffffffc,
  0xffffffffffffffff, 0xfffffffffffffffe,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000002,
  0xffffffffffffffff, 0xfffffffffffffffe,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000020, 0x0000000000000040,
  0x0000000000000001, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000020, 0x0000000000000040,
  0x000000000000007d, 0x00000000000000fa,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000020, 0x0000000000000040,
  0x000000000000007d, 0x00000000000000fa,
  0x000000000000007e, 0x00000000000000fc,
  0x0000000000000020, 0x0000000000000040,
  0x000000000000007d, 0x00000000000000fa,
  0x000000000000007e, 0x00000000000000fc,
  0x000000000000007f, 0x00000000000000fe,
  0x000000000000007d, 0x00000000000000fa,
  0x000000000000007e, 0x00000000000000fc,
  0x000000000000007f, 0x00000000000000fe,
  0x0000000000007ffd, 0x000000000000fffa,
  0x000000000000007e, 0x00000000000000fc,
  0x000000000000007f, 0x00000000000000fe,
  0x0000000000007ffd, 0x000000000000fffa,
  0x0000000000007ffe, 0x000000000000fffc,
  0x000000000000007f, 0x00000000000000fe,
  0x0000000000007ffd, 0x000000000000fffa,
  0x0000000000007ffe, 0x000000000000fffc,
  0x0000000000007fff, 0x000000000000fffe,
  0x0000000000007ffd, 0x000000000000fffa,
  0x0000000000007ffe, 0x000000000000fffc,
  0x0000000000007fff, 0x000000000000fffe,
  0x0000000033333333, 0x0000000066666666,
  0x0000000000007ffe, 0x000000000000fffc,
  0x0000000000007fff, 0x000000000000fffe,
  0x0000000033333333, 0x0000000066666666,
  0x0000000055555555, 0x00000000aaaaaaaa,
  0x0000000000007fff, 0x000000000000fffe,
  0x0000000033333333, 0x0000000066666666,
  0x0000000055555555, 0x00000000aaaaaaaa,
  0x000000007ffffffd, 0x00000000fffffffa,
  0x0000000033333333, 0x0000000066666666,
  0x0000000055555555, 0x00000000aaaaaaaa,
  0x000000007ffffffd, 0x00000000fffffffa,
  0x000000007ffffffe, 0x00000000fffffffc,
  0x0000000055555555, 0x00000000aaaaaaaa,
  0x000000007ffffffd, 0x00000000fffffffa,
  0x000000007ffffffe, 0x00000000fffffffc,
  0x000000007fffffff, 0x00000000fffffffe,
  0x000000007ffffffd, 0x00000000fffffffa,
  0x000000007ffffffe, 0x00000000fffffffc,
  0x000000007fffffff, 0x00000000fffffffe,
  0xffffffff80000000, 0xffffffff00000000,
  0x000000007ffffffe, 0x00000000fffffffc,
  0x000000007fffffff, 0x00000000fffffffe,
  0xffffffff80000000, 0xffffffff00000000,
  0xffffffff80000001, 0xffffffff00000002,
  0x000000007fffffff, 0x00000000fffffffe,
  0xffffffff80000000, 0xffffffff00000000,
  0xffffffff80000001, 0xffffffff00000002,
  0xffffffffaaaaaaaa, 0xffffffff55555554,
  0xffffffff80000000, 0xffffffff00000000,
  0xffffffff80000001, 0xffffffff00000002,
  0xffffffffaaaaaaaa, 0xffffffff55555554,
  0xffffffffcccccccc, 0xffffffff99999998,
  0xffffffff80000001, 0xffffffff00000002,
  0xffffffffaaaaaaaa, 0xffffffff55555554,
  0xffffffffcccccccc, 0xffffffff99999998,
  0xffffffffffff8000, 0xffffffffffff0000,
  0xffffffffaaaaaaaa, 0xffffffff55555554,
  0xffffffffcccccccc, 0xffffffff99999998,
  0xffffffffffff8000, 0xffffffffffff0000,
  0xffffffffffff8001, 0xffffffffffff0002,
  0xffffffffcccccccc, 0xffffffff99999998,
  0xffffffffffff8000, 0xffffffffffff0000,
  0xffffffffffff8001, 0xffffffffffff0002,
  0xffffffffffff8002, 0xffffffffffff0004,
  0xffffffffffff8000, 0xffffffffffff0000,
  0xffffffffffff8001, 0xffffffffffff0002,
  0xffffffffffff8002, 0xffffffffffff0004,
  0xffffffffffff8003, 0xffffffffffff0006,
  0xffffffffffff8001, 0xffffffffffff0002,
  0xffffffffffff8002, 0xffffffffffff0004,
  0xffffffffffff8003, 0xffffffffffff0006,
  0xffffffffffffff80, 0xffffffffffffff00,
  0xffffffffffff8002, 0xffffffffffff0004,
  0xffffffffffff8003, 0xffffffffffff0006,
  0xffffffffffffff80, 0xffffffffffffff00,
  0xffffffffffffff81, 0xffffffffffffff02,
  0xffffffffffff8003, 0xffffffffffff0006,
  0xffffffffffffff80, 0xffffffffffffff00,
  0xffffffffffffff81, 0xffffffffffffff02,
  0xffffffffffffff82, 0xffffffffffffff04,
  0xffffffffffffff80, 0xffffffffffffff00,
  0xffffffffffffff81, 0xffffffffffffff02,
  0xffffffffffffff82, 0xffffffffffffff04,
  0xffffffffffffff83, 0xffffffffffffff06,
  0xffffffffffffff81, 0xffffffffffffff02,
  0xffffffffffffff82, 0xffffffffffffff04,
  0xffffffffffffff83, 0xffffffffffffff06,
  0xffffffffffffffe0, 0xffffffffffffffc0,
  0xffffffffffffff82, 0xffffffffffffff04,
  0xffffffffffffff83, 0xffffffffffffff06,
  0xffffffffffffffe0, 0xffffffffffffffc0,
  0xfffffffffffffffd, 0xfffffffffffffffa,
  0xffffffffffffff83, 0xffffffffffffff06,
  0xffffffffffffffe0, 0xffffffffffffffc0,
  0xfffffffffffffffd, 0xfffffffffffffffa,
  0xfffffffffffffffe, 0xfffffffffffffffc,
  0xffffffffffffffe0, 0xffffffffffffffc0,
  0xfffffffffffffffd, 0xfffffffffffffffa,
  0xfffffffffffffffe, 0xfffffffffffffffc,
  0xffffffffffffffff, 0xfffffffffffffffe,
  0xfffffffffffffffa, 0xffffffffffffffa0,
  0xfffffffffffffffc, 0xffffffffffffffc0,
  0xfffffffffffffffe, 0xffffffffffffffe0,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffffc, 0xffffffffffffffc0,
  0xfffffffffffffffe, 0xffffffffffffffe0,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000020,
  0xfffffffffffffffe, 0xffffffffffffffe0,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000020,
  0x0000000000000004, 0x0000000000000040,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000020,
  0x0000000000000004, 0x0000000000000040,
  0x0000000000000040, 0x0000000000000400,
  0x0000000000000002, 0x0000000000000020,
  0x0000000000000004, 0x0000000000000040,
  0x0000000000000040, 0x0000000000000400,
  0x00000000000000fa, 0x0000000000000fa0,
  0x0000000000000004, 0x0000000000000040,
  0x0000000000000040, 0x0000000000000400,
  0x00000000000000fa, 0x0000000000000fa0,
  0x00000000000000fc, 0x0000000000000fc0,
  0x0000000000000040, 0x0000000000000400,
  0x00000000000000fa, 0x0000000000000fa0,
  0x00000000000000fc, 0x0000000000000fc0,
  0x00000000000000fe, 0x0000000000000fe0,
  0x00000000000000fa, 0x0000000000000fa0,
  0x00000000000000fc, 0x0000000000000fc0,
  0x00000000000000fe, 0x0000000000000fe0,
  0x000000000000fffa, 0x00000000000fffa0,
  0x00000000000000fc, 0x0000000000000fc0,
  0x00000000000000fe, 0x0000000000000fe0,
  0x000000000000fffa, 0x00000000000fffa0,
  0x000000000000fffc, 0x00000000000fffc0,
  0x00000000000000fe, 0x0000000000000fe0,
  0x000000000000fffa, 0x00000000000fffa0,
  0x000000000000fffc, 0x00000000000fffc0,
  0x000000000000fffe, 0x00000000000fffe0,
  0x000000000000fffa, 0x00000000000fffa0,
  0x000000000000fffc, 0x00000000000fffc0,
  0x000000000000fffe, 0x00000000000fffe0,
  0x0000000066666666, 0x0000000666666660,
  0x000000000000fffc, 0x00000000000fffc0,
  0x000000000000fffe, 0x00000000000fffe0,
  0x0000000066666666, 0x0000000666666660,
  0x00000000aaaaaaaa, 0x0000000aaaaaaaa0,
  0x000000000000fffe, 0x00000000000fffe0,
  0x0000000066666666, 0x0000000666666660,
  0x00000000aaaaaaaa, 0x0000000aaaaaaaa0,
  0x00000000fffffffa, 0x0000000fffffffa0,
  0x0000000066666666, 0x0000000666666660,
  0x00000000aaaaaaaa, 0x0000000aaaaaaaa0,
  0x00000000fffffffa, 0x0000000fffffffa0,
  0x00000000fffffffc, 0x0000000fffffffc0,
  0x00000000aaaaaaaa, 0x0000000aaaaaaaa0,
  0x00000000fffffffa, 0x0000000fffffffa0,
  0x00000000fffffffc, 0x0000000fffffffc0,
  0x00000000fffffffe, 0x0000000fffffffe0,
  0x00000000fffffffa, 0x0000000fffffffa0,
  0x00000000fffffffc, 0x0000000fffffffc0,
  0x00000000fffffffe, 0x0000000fffffffe0,
  0xffffffff00000000, 0xfffffff000000000,
  0x00000000fffffffc, 0x0000000fffffffc0,
  0x00000000fffffffe, 0x0000000fffffffe0,
  0xffffffff00000000, 0xfffffff000000000,
  0xffffffff00000002, 0xfffffff000000020,
  0x00000000fffffffe, 0x0000000fffffffe0,
  0xffffffff00000000, 0xfffffff000000000,
  0xffffffff00000002, 0xfffffff000000020,
  0xffffffff55555554, 0xfffffff555555540,
  0xffffffff00000000, 0xfffffff000000000,
  0xffffffff00000002, 0xfffffff000000020,
  0xffffffff55555554, 0xfffffff555555540,
  0xffffffff99999998, 0xfffffff999999980,
  0xffffffff00000002, 0xfffffff000000020,
  0xffffffff55555554, 0xfffffff555555540,
  0xffffffff99999998, 0xfffffff999999980,
  0xffffffffffff0000, 0xfffffffffff00000,
  0xffffffff55555554, 0xfffffff555555540,
  0xffffffff99999998, 0xfffffff999999980,
  0xffffffffffff0000, 0xfffffffffff00000,
  0xffffffffffff0002, 0xfffffffffff00020,
  0xffffffff99999998, 0xfffffff999999980,
  0xffffffffffff0000, 0xfffffffffff00000,
  0xffffffffffff0002, 0xfffffffffff00020,
  0xffffffffffff0004, 0xfffffffffff00040,
  0xffffffffffff0000, 0xfffffffffff00000,
  0xffffffffffff0002, 0xfffffffffff00020,
  0xffffffffffff0004, 0xfffffffffff00040,
  0xffffffffffff0006, 0xfffffffffff00060,
  0xffffffffffff0002, 0xfffffffffff00020,
  0xffffffffffff0004, 0xfffffffffff00040,
  0xffffffffffff0006, 0xfffffffffff00060,
  0xffffffffffffff00, 0xfffffffffffff000,
  0xffffffffffff0004, 0xfffffffffff00040,
  0xffffffffffff0006, 0xfffffffffff00060,
  0xffffffffffffff00, 0xfffffffffffff000,
  0xffffffffffffff02, 0xfffffffffffff020,
  0xffffffffffff0006, 0xfffffffffff00060,
  0xffffffffffffff00, 0xfffffffffffff000,
  0xffffffffffffff02, 0xfffffffffffff020,
  0xffffffffffffff04, 0xfffffffffffff040,
  0xffffffffffffff00, 0xfffffffffffff000,
  0xffffffffffffff02, 0xfffffffffffff020,
  0xffffffffffffff04, 0xfffffffffffff040,
  0xffffffffffffff06, 0xfffffffffffff060,
  0xffffffffffffff02, 0xfffffffffffff020,
  0xffffffffffffff04, 0xfffffffffffff040,
  0xffffffffffffff06, 0xfffffffffffff060,
  0xffffffffffffffc0, 0xfffffffffffffc00,
  0xffffffffffffff04, 0xfffffffffffff040,
  0xffffffffffffff06, 0xfffffffffffff060,
  0xffffffffffffffc0, 0xfffffffffffffc00,
  0xfffffffffffffffa, 0xffffffffffffffa0,
  0xffffffffffffff06, 0xfffffffffffff060,
  0xffffffffffffffc0, 0xfffffffffffffc00,
  0xfffffffffffffffa, 0xffffffffffffffa0,
  0xfffffffffffffffc, 0xffffffffffffffc0,
  0xffffffffffffffc0, 0xfffffffffffffc00,
  0xfffffffffffffffa, 0xffffffffffffffa0,
  0xfffffffffffffffc, 0xffffffffffffffc0,
  0xfffffffffffffffe, 0xffffffffffffffe0,
  0xffffffffffffffa0, 0xfffffffffffffe89,
  0xffffffffffffffc0, 0xffffffffffffff06,
  0xffffffffffffffe0, 0xffffffffffffff83,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffc0, 0xffffffffffffff06,
  0xffffffffffffffe0, 0xffffffffffffff83,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000020, 0x000000000000007d,
  0xffffffffffffffe0, 0xffffffffffffff83,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000020, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000020, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000400, 0x0000000000000fa0,
  0x0000000000000020, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000400, 0x0000000000000fa0,
  0x0000000000000fa0, 0x0000000000003d09,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000400, 0x0000000000000fa0,
  0x0000000000000fa0, 0x0000000000003d09,
  0x0000000000000fc0, 0x0000000000003d86,
  0x0000000000000400, 0x0000000000000fa0,
  0x0000000000000fa0, 0x0000000000003d09,
  0x0000000000000fc0, 0x0000000000003d86,
  0x0000000000000fe0, 0x0000000000003e03,
  0x0000000000000fa0, 0x0000000000003d09,
  0x0000000000000fc0, 0x0000000000003d86,
  0x0000000000000fe0, 0x0000000000003e03,
  0x00000000000fffa0, 0x00000000003e7e89,
  0x0000000000000fc0, 0x0000000000003d86,
  0x0000000000000fe0, 0x0000000000003e03,
  0x00000000000fffa0, 0x00000000003e7e89,
  0x00000000000fffc0, 0x00000000003e7f06,
  0x0000000000000fe0, 0x0000000000003e03,
  0x00000000000fffa0, 0x00000000003e7e89,
  0x00000000000fffc0, 0x00000000003e7f06,
  0x00000000000fffe0, 0x00000000003e7f83,
  0x00000000000fffa0, 0x00000000003e7e89,
  0x00000000000fffc0, 0x00000000003e7f06,
  0x00000000000fffe0, 0x00000000003e7f83,
  0x0000000666666660, 0x00000018ffffffe7,
  0x00000000000fffc0, 0x00000000003e7f06,
  0x00000000000fffe0, 0x00000000003e7f83,
  0x0000000666666660, 0x00000018ffffffe7,
  0x0000000aaaaaaaa0, 0x00000029aaaaaa81,
  0x00000000000fffe0, 0x00000000003e7f83,
  0x0000000666666660, 0x00000018ffffffe7,
  0x0000000aaaaaaaa0, 0x00000029aaaaaa81,
  0x0000000fffffffa0, 0x0000003e7ffffe89,
  0x0000000666666660, 0x00000018ffffffe7,
  0x0000000aaaaaaaa0, 0x00000029aaaaaa81,
  0x0000000fffffffa0, 0x0000003e7ffffe89,
  0x0000000fffffffc0, 0x0000003e7fffff06,
  0x0000000aaaaaaaa0, 0x00000029aaaaaa81,
  0x0000000fffffffa0, 0x0000003e7ffffe89,
  0x0000000fffffffc0, 0x0000003e7fffff06,
  0x0000000fffffffe0, 0x0000003e7fffff83,
  0x0000000fffffffa0, 0x0000003e7ffffe89,
  0x0000000fffffffc0, 0x0000003e7fffff06,
  0x0000000fffffffe0, 0x0000003e7fffff83,
  0xfffffff000000000, 0xffffffc180000000,
  0x0000000fffffffc0, 0x0000003e7fffff06,
  0x0000000fffffffe0, 0x0000003e7fffff83,
  0xfffffff000000000, 0xffffffc180000000,
  0xfffffff000000020, 0xffffffc18000007d,
  0x0000000fffffffe0, 0x0000003e7fffff83,
  0xfffffff000000000, 0xffffffc180000000,
  0xfffffff000000020, 0xffffffc18000007d,
  0xfffffff555555540, 0xffffffd655555502,
  0xfffffff000000000, 0xffffffc180000000,
  0xfffffff000000020, 0xffffffc18000007d,
  0xfffffff555555540, 0xffffffd655555502,
  0xfffffff999999980, 0xffffffe6ffffff9c,
  0xfffffff000000020, 0xffffffc18000007d,
  0xfffffff555555540, 0xffffffd655555502,
  0xfffffff999999980, 0xffffffe6ffffff9c,
  0xfffffffffff00000, 0xffffffffffc18000,
  0xfffffff555555540, 0xffffffd655555502,
  0xfffffff999999980, 0xffffffe6ffffff9c,
  0xfffffffffff00000, 0xffffffffffc18000,
  0xfffffffffff00020, 0xffffffffffc1807d,
  0xfffffff999999980, 0xffffffe6ffffff9c,
  0xfffffffffff00000, 0xffffffffffc18000,
  0xfffffffffff00020, 0xffffffffffc1807d,
  0xfffffffffff00040, 0xffffffffffc180fa,
  0xfffffffffff00000, 0xffffffffffc18000,
  0xfffffffffff00020, 0xffffffffffc1807d,
  0xfffffffffff00040, 0xffffffffffc180fa,
  0xfffffffffff00060, 0xffffffffffc18177,
  0xfffffffffff00020, 0xffffffffffc1807d,
  0xfffffffffff00040, 0xffffffffffc180fa,
  0xfffffffffff00060, 0xffffffffffc18177,
  0xfffffffffffff000, 0xffffffffffffc180,
  0xfffffffffff00040, 0xffffffffffc180fa,
  0xfffffffffff00060, 0xffffffffffc18177,
  0xfffffffffffff000, 0xffffffffffffc180,
  0xfffffffffffff020, 0xffffffffffffc1fd,
  0xfffffffffff00060, 0xffffffffffc18177,
  0xfffffffffffff000, 0xffffffffffffc180,
  0xfffffffffffff020, 0xffffffffffffc1fd,
  0xfffffffffffff040, 0xffffffffffffc27a,
  0xfffffffffffff000, 0xffffffffffffc180,
  0xfffffffffffff020, 0xffffffffffffc1fd,
  0xfffffffffffff040, 0xffffffffffffc27a,
  0xfffffffffffff060, 0xffffffffffffc2f7,
  0xfffffffffffff020, 0xffffffffffffc1fd,
  0xfffffffffffff040, 0xffffffffffffc27a,
  0xfffffffffffff060, 0xffffffffffffc2f7,
  0xfffffffffffffc00, 0xfffffffffffff060,
  0xfffffffffffff040, 0xffffffffffffc27a,
  0xfffffffffffff060, 0xffffffffffffc2f7,
  0xfffffffffffffc00, 0xfffffffffffff060,
  0xffffffffffffffa0, 0xfffffffffffffe89,
  0xfffffffffffff060, 0xffffffffffffc2f7,
  0xfffffffffffffc00, 0xfffffffffffff060,
  0xffffffffffffffa0, 0xfffffffffffffe89,
  0xffffffffffffffc0, 0xffffffffffffff06,
  0xfffffffffffffc00, 0xfffffffffffff060,
  0xffffffffffffffa0, 0xfffffffffffffe89,
  0xffffffffffffffc0, 0xffffffffffffff06,
  0xffffffffffffffe0, 0xffffffffffffff83,
  0xfffffffffffffe89, 0xfffffffffffffe86,
  0xffffffffffffff06, 0xffffffffffffff04,
  0xffffffffffffff83, 0xffffffffffffff82,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff06, 0xffffffffffffff04,
  0xffffffffffffff83, 0xffffffffffffff82,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007d, 0x000000000000007e,
  0xffffffffffffff83, 0xffffffffffffff82,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007d, 0x000000000000007e,
  0x00000000000000fa, 0x00000000000000fc,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007d, 0x000000000000007e,
  0x00000000000000fa, 0x00000000000000fc,
  0x0000000000000fa0, 0x0000000000000fc0,
  0x000000000000007d, 0x000000000000007e,
  0x00000000000000fa, 0x00000000000000fc,
  0x0000000000000fa0, 0x0000000000000fc0,
  0x0000000000003d09, 0x0000000000003d86,
  0x00000000000000fa, 0x00000000000000fc,
  0x0000000000000fa0, 0x0000000000000fc0,
  0x0000000000003d09, 0x0000000000003d86,
  0x0000000000003d86, 0x0000000000003e04,
  0x0000000000000fa0, 0x0000000000000fc0,
  0x0000000000003d09, 0x0000000000003d86,
  0x0000000000003d86, 0x0000000000003e04,
  0x0000000000003e03, 0x0000000000003e82,
  0x0000000000003d09, 0x0000000000003d86,
  0x0000000000003d86, 0x0000000000003e04,
  0x0000000000003e03, 0x0000000000003e82,
  0x00000000003e7e89, 0x00000000003efe86,
  0x0000000000003d86, 0x0000000000003e04,
  0x0000000000003e03, 0x0000000000003e82,
  0x00000000003e7e89, 0x00000000003efe86,
  0x00000000003e7f06, 0x00000000003eff04,
  0x0000000000003e03, 0x0000000000003e82,
  0x00000000003e7e89, 0x00000000003efe86,
  0x00000000003e7f06, 0x00000000003eff04,
  0x00000000003e7f83, 0x00000000003eff82,
  0x00000000003e7e89, 0x00000000003efe86,
  0x00000000003e7f06, 0x00000000003eff04,
  0x00000000003e7f83, 0x00000000003eff82,
  0x00000018ffffffe7, 0x000000193333331a,
  0x00000000003e7f06, 0x00000000003eff04,
  0x00000000003e7f83, 0x00000000003eff82,
  0x00000018ffffffe7, 0x000000193333331a,
  0x00000029aaaaaa81, 0x00000029ffffffd6,
  0x00000000003e7f83, 0x00000000003eff82,
  0x00000018ffffffe7, 0x000000193333331a,
  0x00000029aaaaaa81, 0x00000029ffffffd6,
  0x0000003e7ffffe89, 0x0000003efffffe86,
  0x00000018ffffffe7, 0x000000193333331a,
  0x00000029aaaaaa81, 0x00000029ffffffd6,
  0x0000003e7ffffe89, 0x0000003efffffe86,
  0x0000003e7fffff06, 0x0000003effffff04,
  0x00000029aaaaaa81, 0x00000029ffffffd6,
  0x0000003e7ffffe89, 0x0000003efffffe86,
  0x0000003e7fffff06, 0x0000003effffff04,
  0x0000003e7fffff83, 0x0000003effffff82,
  0x0000003e7ffffe89, 0x0000003efffffe86,
  0x0000003e7fffff06, 0x0000003effffff04,
  0x0000003e7fffff83, 0x0000003effffff82,
  0xffffffc180000000, 0xffffffc100000000,
  0x0000003e7fffff06, 0x0000003effffff04,
  0x0000003e7fffff83, 0x0000003effffff82,
  0xffffffc180000000, 0xffffffc100000000,
  0xffffffc18000007d, 0xffffffc10000007e,
  0x0000003e7fffff83, 0x0000003effffff82,
  0xffffffc180000000, 0xffffffc100000000,
  0xffffffc18000007d, 0xffffffc10000007e,
  0xffffffd655555502, 0xffffffd5ffffffac,
  0xffffffc180000000, 0xffffffc100000000,
  0xffffffc18000007d, 0xffffffc10000007e,
  0xffffffd655555502, 0xffffffd5ffffffac,
  0xffffffe6ffffff9c, 0xffffffe6cccccc68,
  0xffffffc18000007d, 0xffffffc10000007e,
  0xffffffd655555502, 0xffffffd5ffffffac,
  0xffffffe6ffffff9c, 0xffffffe6cccccc68,
  0xffffffffffc18000, 0xffffffffffc10000,
  0xffffffd655555502, 0xffffffd5ffffffac,
  0xffffffe6ffffff9c, 0xffffffe6cccccc68,
  0xffffffffffc18000, 0xffffffffffc10000,
  0xffffffffffc1807d, 0xffffffffffc1007e,
  0xffffffe6ffffff9c, 0xffffffe6cccccc68,
  0xffffffffffc18000, 0xffffffffffc10000,
  0xffffffffffc1807d, 0xffffffffffc1007e,
  0xffffffffffc180fa, 0xffffffffffc100fc,
  0xffffffffffc18000, 0xffffffffffc10000,
  0xffffffffffc1807d, 0xffffffffffc1007e,
  0xffffffffffc180fa, 0xffffffffffc100fc,
  0xffffffffffc18177, 0xffffffffffc1017a,
  0xffffffffffc1807d, 0xffffffffffc1007e,
  0xffffffffffc180fa, 0xffffffffffc100fc,
  0xffffffffffc18177, 0xffffffffffc1017a,
  0xffffffffffffc180, 0xffffffffffffc100,
  0xffffffffffc180fa, 0xffffffffffc100fc,
  0xffffffffffc18177, 0xffffffffffc1017a,
  0xffffffffffffc180, 0xffffffffffffc100,
  0xffffffffffffc1fd, 0xffffffffffffc17e,
  0xffffffffffc18177, 0xffffffffffc1017a,
  0xffffffffffffc180, 0xffffffffffffc100,
  0xffffffffffffc1fd, 0xffffffffffffc17e,
  0xffffffffffffc27a, 0xffffffffffffc1fc,
  0xffffffffffffc180, 0xffffffffffffc100,
  0xffffffffffffc1fd, 0xffffffffffffc17e,
  0xffffffffffffc27a, 0xffffffffffffc1fc,
  0xffffffffffffc2f7, 0xffffffffffffc27a,
  0xffffffffffffc1fd, 0xffffffffffffc17e,
  0xffffffffffffc27a, 0xffffffffffffc1fc,
  0xffffffffffffc2f7, 0xffffffffffffc27a,
  0xfffffffffffff060, 0xfffffffffffff040,
  0xffffffffffffc27a, 0xffffffffffffc1fc,
  0xffffffffffffc2f7, 0xffffffffffffc27a,
  0xfffffffffffff060, 0xfffffffffffff040,
  0xfffffffffffffe89, 0xfffffffffffffe86,
  0xffffffffffffc2f7, 0xffffffffffffc27a,
  0xfffffffffffff060, 0xfffffffffffff040,
  0xfffffffffffffe89, 0xfffffffffffffe86,
  0xffffffffffffff06, 0xffffffffffffff04,
  0xfffffffffffff060, 0xfffffffffffff040,
  0xfffffffffffffe89, 0xfffffffffffffe86,
  0xffffffffffffff06, 0xffffffffffffff04,
  0xffffffffffffff83, 0xffffffffffffff82,
  0xfffffffffffffe86, 0xfffffffffffffe83,
  0xffffffffffffff04, 0xffffffffffffff02,
  0xffffffffffffff82, 0xffffffffffffff81,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff04, 0xffffffffffffff02,
  0xffffffffffffff82, 0xffffffffffffff81,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007e, 0x000000000000007f,
  0xffffffffffffff82, 0xffffffffffffff81,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007e, 0x000000000000007f,
  0x00000000000000fc, 0x00000000000000fe,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007e, 0x000000000000007f,
  0x00000000000000fc, 0x00000000000000fe,
  0x0000000000000fc0, 0x0000000000000fe0,
  0x000000000000007e, 0x000000000000007f,
  0x00000000000000fc, 0x00000000000000fe,
  0x0000000000000fc0, 0x0000000000000fe0,
  0x0000000000003d86, 0x0000000000003e03,
  0x00000000000000fc, 0x00000000000000fe,
  0x0000000000000fc0, 0x0000000000000fe0,
  0x0000000000003d86, 0x0000000000003e03,
  0x0000000000003e04, 0x0000000000003e82,
  0x0000000000000fc0, 0x0000000000000fe0,
  0x0000000000003d86, 0x0000000000003e03,
  0x0000000000003e04, 0x0000000000003e82,
  0x0000000000003e82, 0x0000000000003f01,
  0x0000000000003d86, 0x0000000000003e03,
  0x0000000000003e04, 0x0000000000003e82,
  0x0000000000003e82, 0x0000000000003f01,
  0x00000000003efe86, 0x00000000003f7e83,
  0x0000000000003e04, 0x0000000000003e82,
  0x0000000000003e82, 0x0000000000003f01,
  0x00000000003efe86, 0x00000000003f7e83,
  0x00000000003eff04, 0x00000000003f7f02,
  0x0000000000003e82, 0x0000000000003f01,
  0x00000000003efe86, 0x00000000003f7e83,
  0x00000000003eff04, 0x00000000003f7f02,
  0x00000000003eff82, 0x00000000003f7f81,
  0x00000000003efe86, 0x00000000003f7e83,
  0x00000000003eff04, 0x00000000003f7f02,
  0x00000000003eff82, 0x00000000003f7f81,
  0x000000193333331a, 0x000000196666664d,
  0x00000000003eff04, 0x00000000003f7f02,
  0x00000000003eff82, 0x00000000003f7f81,
  0x000000193333331a, 0x000000196666664d,
  0x00000029ffffffd6, 0x0000002a5555552b,
  0x00000000003eff82, 0x00000000003f7f81,
  0x000000193333331a, 0x000000196666664d,
  0x00000029ffffffd6, 0x0000002a5555552b,
  0x0000003efffffe86, 0x0000003f7ffffe83,
  0x000000193333331a, 0x000000196666664d,
  0x00000029ffffffd6, 0x0000002a5555552b,
  0x0000003efffffe86, 0x0000003f7ffffe83,
  0x0000003effffff04, 0x0000003f7fffff02,
  0x00000029ffffffd6, 0x0000002a5555552b,
  0x0000003efffffe86, 0x0000003f7ffffe83,
  0x0000003effffff04, 0x0000003f7fffff02,
  0x0000003effffff82, 0x0000003f7fffff81,
  0x0000003efffffe86, 0x0000003f7ffffe83,
  0x0000003effffff04, 0x0000003f7fffff02,
  0x0000003effffff82, 0x0000003f7fffff81,
  0xffffffc100000000, 0xffffffc080000000,
  0x0000003effffff04, 0x0000003f7fffff02,
  0x0000003effffff82, 0x0000003f7fffff81,
  0xffffffc100000000, 0xffffffc080000000,
  0xffffffc10000007e, 0xffffffc08000007f,
  0x0000003effffff82, 0x0000003f7fffff81,
  0xffffffc100000000, 0xffffffc080000000,
  0xffffffc10000007e, 0xffffffc08000007f,
  0xffffffd5ffffffac, 0xffffffd5aaaaaa56,
  0xffffffc100000000, 0xffffffc080000000,
  0xffffffc10000007e, 0xffffffc08000007f,
  0xffffffd5ffffffac, 0xffffffd5aaaaaa56,
  0xffffffe6cccccc68, 0xffffffe699999934,
  0xffffffc10000007e, 0xffffffc08000007f,
  0xffffffd5ffffffac, 0xffffffd5aaaaaa56,
  0xffffffe6cccccc68, 0xffffffe699999934,
  0xffffffffffc10000, 0xffffffffffc08000,
  0xffffffd5ffffffac, 0xffffffd5aaaaaa56,
  0xffffffe6cccccc68, 0xffffffe699999934,
  0xffffffffffc10000, 0xffffffffffc08000,
  0xffffffffffc1007e, 0xffffffffffc0807f,
  0xffffffe6cccccc68, 0xffffffe699999934,
  0xffffffffffc10000, 0xffffffffffc08000,
  0xffffffffffc1007e, 0xffffffffffc0807f,
  0xffffffffffc100fc, 0xffffffffffc080fe,
  0xffffffffffc10000, 0xffffffffffc08000,
  0xffffffffffc1007e, 0xffffffffffc0807f,
  0xffffffffffc100fc, 0xffffffffffc080fe,
  0xffffffffffc1017a, 0xffffffffffc0817d,
  0xffffffffffc1007e, 0xffffffffffc0807f,
  0xffffffffffc100fc, 0xffffffffffc080fe,
  0xffffffffffc1017a, 0xffffffffffc0817d,
  0xffffffffffffc100, 0xffffffffffffc080,
  0xffffffffffc100fc, 0xffffffffffc080fe,
  0xffffffffffc1017a, 0xffffffffffc0817d,
  0xffffffffffffc100, 0xffffffffffffc080,
  0xffffffffffffc17e, 0xffffffffffffc0ff,
  0xffffffffffc1017a, 0xffffffffffc0817d,
  0xffffffffffffc100, 0xffffffffffffc080,
  0xffffffffffffc17e, 0xffffffffffffc0ff,
  0xffffffffffffc1fc, 0xffffffffffffc17e,
  0xffffffffffffc100, 0xffffffffffffc080,
  0xffffffffffffc17e, 0xffffffffffffc0ff,
  0xffffffffffffc1fc, 0xffffffffffffc17e,
  0xffffffffffffc27a, 0xffffffffffffc1fd,
  0xffffffffffffc17e, 0xffffffffffffc0ff,
  0xffffffffffffc1fc, 0xffffffffffffc17e,
  0xffffffffffffc27a, 0xffffffffffffc1fd,
  0xfffffffffffff040, 0xfffffffffffff020,
  0xffffffffffffc1fc, 0xffffffffffffc17e,
  0xffffffffffffc27a, 0xffffffffffffc1fd,
  0xfffffffffffff040, 0xfffffffffffff020,
  0xfffffffffffffe86, 0xfffffffffffffe83,
  0xffffffffffffc27a, 0xffffffffffffc1fd,
  0xfffffffffffff040, 0xfffffffffffff020,
  0xfffffffffffffe86, 0xfffffffffffffe83,
  0xffffffffffffff04, 0xffffffffffffff02,
  0xfffffffffffff040, 0xfffffffffffff020,
  0xfffffffffffffe86, 0xfffffffffffffe83,
  0xffffffffffffff04, 0xffffffffffffff02,
  0xffffffffffffff82, 0xffffffffffffff81,
  0xfffffffffffffe83, 0xfffffffffffe8009,
  0xffffffffffffff02, 0xffffffffffff0006,
  0xffffffffffffff81, 0xffffffffffff8003,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff02, 0xffffffffffff0006,
  0xffffffffffffff81, 0xffffffffffff8003,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007f, 0x0000000000007ffd,
  0xffffffffffffff81, 0xffffffffffff8003,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007f, 0x0000000000007ffd,
  0x00000000000000fe, 0x000000000000fffa,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007f, 0x0000000000007ffd,
  0x00000000000000fe, 0x000000000000fffa,
  0x0000000000000fe0, 0x00000000000fffa0,
  0x000000000000007f, 0x0000000000007ffd,
  0x00000000000000fe, 0x000000000000fffa,
  0x0000000000000fe0, 0x00000000000fffa0,
  0x0000000000003e03, 0x00000000003e7e89,
  0x00000000000000fe, 0x000000000000fffa,
  0x0000000000000fe0, 0x00000000000fffa0,
  0x0000000000003e03, 0x00000000003e7e89,
  0x0000000000003e82, 0x00000000003efe86,
  0x0000000000000fe0, 0x00000000000fffa0,
  0x0000000000003e03, 0x00000000003e7e89,
  0x0000000000003e82, 0x00000000003efe86,
  0x0000000000003f01, 0x00000000003f7e83,
  0x0000000000003e03, 0x00000000003e7e89,
  0x0000000000003e82, 0x00000000003efe86,
  0x0000000000003f01, 0x00000000003f7e83,
  0x00000000003f7e83, 0x000000003ffd0009,
  0x0000000000003e82, 0x00000000003efe86,
  0x0000000000003f01, 0x00000000003f7e83,
  0x00000000003f7e83, 0x000000003ffd0009,
  0x00000000003f7f02, 0x000000003ffd8006,
  0x0000000000003f01, 0x00000000003f7e83,
  0x00000000003f7e83, 0x000000003ffd0009,
  0x00000000003f7f02, 0x000000003ffd8006,
  0x00000000003f7f81, 0x000000003ffe0003,
  0x00000000003f7e83, 0x000000003ffd0009,
  0x00000000003f7f02, 0x000000003ffd8006,
  0x00000000003f7f81, 0x000000003ffe0003,
  0x000000196666664d, 0x00001998ffffe667,
  0x00000000003f7f02, 0x000000003ffd8006,
  0x00000000003f7f81, 0x000000003ffe0003,
  0x000000196666664d, 0x00001998ffffe667,
  0x0000002a5555552b, 0x00002aa9aaaa8001,
  0x00000000003f7f81, 0x000000003ffe0003,
  0x000000196666664d, 0x00001998ffffe667,
  0x0000002a5555552b, 0x00002aa9aaaa8001,
  0x0000003f7ffffe83, 0x00003ffe7ffe8009,
  0x000000196666664d, 0x00001998ffffe667,
  0x0000002a5555552b, 0x00002aa9aaaa8001,
  0x0000003f7ffffe83, 0x00003ffe7ffe8009,
  0x0000003f7fffff02, 0x00003ffe7fff0006,
  0x0000002a5555552b, 0x00002aa9aaaa8001,
  0x0000003f7ffffe83, 0x00003ffe7ffe8009,
  0x0000003f7fffff02, 0x00003ffe7fff0006,
  0x0000003f7fffff81, 0x00003ffe7fff8003,
  0x0000003f7ffffe83, 0x00003ffe7ffe8009,
  0x0000003f7fffff02, 0x00003ffe7fff0006,
  0x0000003f7fffff81, 0x00003ffe7fff8003,
  0xffffffc080000000, 0xffffc00180000000,
  0x0000003f7fffff02, 0x00003ffe7fff0006,
  0x0000003f7fffff81, 0x00003ffe7fff8003,
  0xffffffc080000000, 0xffffc00180000000,
  0xffffffc08000007f, 0xffffc00180007ffd,
  0x0000003f7fffff81, 0x00003ffe7fff8003,
  0xffffffc080000000, 0xffffc00180000000,
  0xffffffc08000007f, 0xffffc00180007ffd,
  0xffffffd5aaaaaa56, 0xffffd55655550002,
  0xffffffc080000000, 0xffffc00180000000,
  0xffffffc08000007f, 0xffffc00180007ffd,
  0xffffffd5aaaaaa56, 0xffffd55655550002,
  0xffffffe699999934, 0xffffe666ffff999c,
  0xffffffc08000007f, 0xffffc00180007ffd,
  0xffffffd5aaaaaa56, 0xffffd55655550002,
  0xffffffe699999934, 0xffffe666ffff999c,
  0xffffffffffc08000, 0xffffffffc0018000,
  0xffffffd5aaaaaa56, 0xffffd55655550002,
  0xffffffe699999934, 0xffffe666ffff999c,
  0xffffffffffc08000, 0xffffffffc0018000,
  0xffffffffffc0807f, 0xffffffffc001fffd,
  0xffffffe699999934, 0xffffe666ffff999c,
  0xffffffffffc08000, 0xffffffffc0018000,
  0xffffffffffc0807f, 0xffffffffc001fffd,
  0xffffffffffc080fe, 0xffffffffc0027ffa,
  0xffffffffffc08000, 0xffffffffc0018000,
  0xffffffffffc0807f, 0xffffffffc001fffd,
  0xffffffffffc080fe, 0xffffffffc0027ffa,
  0xffffffffffc0817d, 0xffffffffc002fff7,
  0xffffffffffc0807f, 0xffffffffc001fffd,
  0xffffffffffc080fe, 0xffffffffc0027ffa,
  0xffffffffffc0817d, 0xffffffffc002fff7,
  0xffffffffffffc080, 0xffffffffffc00180,
  0xffffffffffc080fe, 0xffffffffc0027ffa,
  0xffffffffffc0817d, 0xffffffffc002fff7,
  0xffffffffffffc080, 0xffffffffffc00180,
  0xffffffffffffc0ff, 0xffffffffffc0817d,
  0xffffffffffc0817d, 0xffffffffc002fff7,
  0xffffffffffffc080, 0xffffffffffc00180,
  0xffffffffffffc0ff, 0xffffffffffc0817d,
  0xffffffffffffc17e, 0xffffffffffc1017a,
  0xffffffffffffc080, 0xffffffffffc00180,
  0xffffffffffffc0ff, 0xffffffffffc0817d,
  0xffffffffffffc17e, 0xffffffffffc1017a,
  0xffffffffffffc1fd, 0xffffffffffc18177,
  0xffffffffffffc0ff, 0xffffffffffc0817d,
  0xffffffffffffc17e, 0xffffffffffc1017a,
  0xffffffffffffc1fd, 0xffffffffffc18177,
  0xfffffffffffff020, 0xfffffffffff00060,
  0xffffffffffffc17e, 0xffffffffffc1017a,
  0xffffffffffffc1fd, 0xffffffffffc18177,
  0xfffffffffffff020, 0xfffffffffff00060,
  0xfffffffffffffe83, 0xfffffffffffe8009,
  0xffffffffffffc1fd, 0xffffffffffc18177,
  0xfffffffffffff020, 0xfffffffffff00060,
  0xfffffffffffffe83, 0xfffffffffffe8009,
  0xffffffffffffff02, 0xffffffffffff0006,
  0xfffffffffffff020, 0xfffffffffff00060,
  0xfffffffffffffe83, 0xfffffffffffe8009,
  0xffffffffffffff02, 0xffffffffffff0006,
  0xffffffffffffff81, 0xffffffffffff8003,
  0xfffffffffffe8009, 0xfffffffffffe8006,
  0xffffffffffff0006, 0xffffffffffff0004,
  0xffffffffffff8003, 0xffffffffffff8002,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0006, 0xffffffffffff0004,
  0xffffffffffff8003, 0xffffffffffff8002,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000007ffe,
  0xffffffffffff8003, 0xffffffffffff8002,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000007ffe,
  0x000000000000fffa, 0x000000000000fffc,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000007ffe,
  0x000000000000fffa, 0x000000000000fffc,
  0x00000000000fffa0, 0x00000000000fffc0,
  0x0000000000007ffd, 0x0000000000007ffe,
  0x000000000000fffa, 0x000000000000fffc,
  0x00000000000fffa0, 0x00000000000fffc0,
  0x00000000003e7e89, 0x00000000003e7f06,
  0x000000000000fffa, 0x000000000000fffc,
  0x00000000000fffa0, 0x00000000000fffc0,
  0x00000000003e7e89, 0x00000000003e7f06,
  0x00000000003efe86, 0x00000000003eff04,
  0x00000000000fffa0, 0x00000000000fffc0,
  0x00000000003e7e89, 0x00000000003e7f06,
  0x00000000003efe86, 0x00000000003eff04,
  0x00000000003f7e83, 0x00000000003f7f02,
  0x00000000003e7e89, 0x00000000003e7f06,
  0x00000000003efe86, 0x00000000003eff04,
  0x00000000003f7e83, 0x00000000003f7f02,
  0x000000003ffd0009, 0x000000003ffd8006,
  0x00000000003efe86, 0x00000000003eff04,
  0x00000000003f7e83, 0x00000000003f7f02,
  0x000000003ffd0009, 0x000000003ffd8006,
  0x000000003ffd8006, 0x000000003ffe0004,
  0x00000000003f7e83, 0x00000000003f7f02,
  0x000000003ffd0009, 0x000000003ffd8006,
  0x000000003ffd8006, 0x000000003ffe0004,
  0x000000003ffe0003, 0x000000003ffe8002,
  0x000000003ffd0009, 0x000000003ffd8006,
  0x000000003ffd8006, 0x000000003ffe0004,
  0x000000003ffe0003, 0x000000003ffe8002,
  0x00001998ffffe667, 0x000019993333199a,
  0x000000003ffd8006, 0x000000003ffe0004,
  0x000000003ffe0003, 0x000000003ffe8002,
  0x00001998ffffe667, 0x000019993333199a,
  0x00002aa9aaaa8001, 0x00002aa9ffffd556,
  0x000000003ffe0003, 0x000000003ffe8002,
  0x00001998ffffe667, 0x000019993333199a,
  0x00002aa9aaaa8001, 0x00002aa9ffffd556,
  0x00003ffe7ffe8009, 0x00003ffefffe8006,
  0x00001998ffffe667, 0x000019993333199a,
  0x00002aa9aaaa8001, 0x00002aa9ffffd556,
  0x00003ffe7ffe8009, 0x00003ffefffe8006,
  0x00003ffe7fff0006, 0x00003ffeffff0004,
  0x00002aa9aaaa8001, 0x00002aa9ffffd556,
  0x00003ffe7ffe8009, 0x00003ffefffe8006,
  0x00003ffe7fff0006, 0x00003ffeffff0004,
  0x00003ffe7fff8003, 0x00003ffeffff8002,
  0x00003ffe7ffe8009, 0x00003ffefffe8006,
  0x00003ffe7fff0006, 0x00003ffeffff0004,
  0x00003ffe7fff8003, 0x00003ffeffff8002,
  0xffffc00180000000, 0xffffc00100000000,
  0x00003ffe7fff0006, 0x00003ffeffff0004,
  0x00003ffe7fff8003, 0x00003ffeffff8002,
  0xffffc00180000000, 0xffffc00100000000,
  0xffffc00180007ffd, 0xffffc00100007ffe,
  0x00003ffe7fff8003, 0x00003ffeffff8002,
  0xffffc00180000000, 0xffffc00100000000,
  0xffffc00180007ffd, 0xffffc00100007ffe,
  0xffffd55655550002, 0xffffd555ffffaaac,
  0xffffc00180000000, 0xffffc00100000000,
  0xffffc00180007ffd, 0xffffc00100007ffe,
  0xffffd55655550002, 0xffffd555ffffaaac,
  0xffffe666ffff999c, 0xffffe666cccc6668,
  0xffffc00180007ffd, 0xffffc00100007ffe,
  0xffffd55655550002, 0xffffd555ffffaaac,
  0xffffe666ffff999c, 0xffffe666cccc6668,
  0xffffffffc0018000, 0xffffffffc0010000,
  0xffffd55655550002, 0xffffd555ffffaaac,
  0xffffe666ffff999c, 0xffffe666cccc6668,
  0xffffffffc0018000, 0xffffffffc0010000,
  0xffffffffc001fffd, 0xffffffffc0017ffe,
  0xffffe666ffff999c, 0xffffe666cccc6668,
  0xffffffffc0018000, 0xffffffffc0010000,
  0xffffffffc001fffd, 0xffffffffc0017ffe,
  0xffffffffc0027ffa, 0xffffffffc001fffc,
  0xffffffffc0018000, 0xffffffffc0010000,
  0xffffffffc001fffd, 0xffffffffc0017ffe,
  0xffffffffc0027ffa, 0xffffffffc001fffc,
  0xffffffffc002fff7, 0xffffffffc0027ffa,
  0xffffffffc001fffd, 0xffffffffc0017ffe,
  0xffffffffc0027ffa, 0xffffffffc001fffc,
  0xffffffffc002fff7, 0xffffffffc0027ffa,
  0xffffffffffc00180, 0xffffffffffc00100,
  0xffffffffc0027ffa, 0xffffffffc001fffc,
  0xffffffffc002fff7, 0xffffffffc0027ffa,
  0xffffffffffc00180, 0xffffffffffc00100,
  0xffffffffffc0817d, 0xffffffffffc080fe,
  0xffffffffc002fff7, 0xffffffffc0027ffa,
  0xffffffffffc00180, 0xffffffffffc00100,
  0xffffffffffc0817d, 0xffffffffffc080fe,
  0xffffffffffc1017a, 0xffffffffffc100fc,
  0xffffffffffc00180, 0xffffffffffc00100,
  0xffffffffffc0817d, 0xffffffffffc080fe,
  0xffffffffffc1017a, 0xffffffffffc100fc,
  0xffffffffffc18177, 0xffffffffffc180fa,
  0xffffffffffc0817d, 0xffffffffffc080fe,
  0xffffffffffc1017a, 0xffffffffffc100fc,
  0xffffffffffc18177, 0xffffffffffc180fa,
  0xfffffffffff00060, 0xfffffffffff00040,
  0xffffffffffc1017a, 0xffffffffffc100fc,
  0xffffffffffc18177, 0xffffffffffc180fa,
  0xfffffffffff00060, 0xfffffffffff00040,
  0xfffffffffffe8009, 0xfffffffffffe8006,
  0xffffffffffc18177, 0xffffffffffc180fa,
  0xfffffffffff00060, 0xfffffffffff00040,
  0xfffffffffffe8009, 0xfffffffffffe8006,
  0xffffffffffff0006, 0xffffffffffff0004,
  0xfffffffffff00060, 0xfffffffffff00040,
  0xfffffffffffe8009, 0xfffffffffffe8006,
  0xffffffffffff0006, 0xffffffffffff0004,
  0xffffffffffff8003, 0xffffffffffff8002,
  0xfffffffffffe8006, 0xfffffffffffe8003,
  0xffffffffffff0004, 0xffffffffffff0002,
  0xffffffffffff8002, 0xffffffffffff8001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0004, 0xffffffffffff0002,
  0xffffffffffff8002, 0xffffffffffff8001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000007fff,
  0xffffffffffff8002, 0xffffffffffff8001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000007fff,
  0x000000000000fffc, 0x000000000000fffe,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000007fff,
  0x000000000000fffc, 0x000000000000fffe,
  0x00000000000fffc0, 0x00000000000fffe0,
  0x0000000000007ffe, 0x0000000000007fff,
  0x000000000000fffc, 0x000000000000fffe,
  0x00000000000fffc0, 0x00000000000fffe0,
  0x00000000003e7f06, 0x00000000003e7f83,
  0x000000000000fffc, 0x000000000000fffe,
  0x00000000000fffc0, 0x00000000000fffe0,
  0x00000000003e7f06, 0x00000000003e7f83,
  0x00000000003eff04, 0x00000000003eff82,
  0x00000000000fffc0, 0x00000000000fffe0,
  0x00000000003e7f06, 0x00000000003e7f83,
  0x00000000003eff04, 0x00000000003eff82,
  0x00000000003f7f02, 0x00000000003f7f81,
  0x00000000003e7f06, 0x00000000003e7f83,
  0x00000000003eff04, 0x00000000003eff82,
  0x00000000003f7f02, 0x00000000003f7f81,
  0x000000003ffd8006, 0x000000003ffe0003,
  0x00000000003eff04, 0x00000000003eff82,
  0x00000000003f7f02, 0x00000000003f7f81,
  0x000000003ffd8006, 0x000000003ffe0003,
  0x000000003ffe0004, 0x000000003ffe8002,
  0x00000000003f7f02, 0x00000000003f7f81,
  0x000000003ffd8006, 0x000000003ffe0003,
  0x000000003ffe0004, 0x000000003ffe8002,
  0x000000003ffe8002, 0x000000003fff0001,
  0x000000003ffd8006, 0x000000003ffe0003,
  0x000000003ffe0004, 0x000000003ffe8002,
  0x000000003ffe8002, 0x000000003fff0001,
  0x000019993333199a, 0x0000199966664ccd,
  0x000000003ffe0004, 0x000000003ffe8002,
  0x000000003ffe8002, 0x000000003fff0001,
  0x000019993333199a, 0x0000199966664ccd,
  0x00002aa9ffffd556, 0x00002aaa55552aab,
  0x000000003ffe8002, 0x000000003fff0001,
  0x000019993333199a, 0x0000199966664ccd,
  0x00002aa9ffffd556, 0x00002aaa55552aab,
  0x00003ffefffe8006, 0x00003fff7ffe8003,
  0x000019993333199a, 0x0000199966664ccd,
  0x00002aa9ffffd556, 0x00002aaa55552aab,
  0x00003ffefffe8006, 0x00003fff7ffe8003,
  0x00003ffeffff0004, 0x00003fff7fff0002,
  0x00002aa9ffffd556, 0x00002aaa55552aab,
  0x00003ffefffe8006, 0x00003fff7ffe8003,
  0x00003ffeffff0004, 0x00003fff7fff0002,
  0x00003ffeffff8002, 0x00003fff7fff8001,
  0x00003ffefffe8006, 0x00003fff7ffe8003,
  0x00003ffeffff0004, 0x00003fff7fff0002,
  0x00003ffeffff8002, 0x00003fff7fff8001,
  0xffffc00100000000, 0xffffc00080000000,
  0x00003ffeffff0004, 0x00003fff7fff0002,
  0x00003ffeffff8002, 0x00003fff7fff8001,
  0xffffc00100000000, 0xffffc00080000000,
  0xffffc00100007ffe, 0xffffc00080007fff,
  0x00003ffeffff8002, 0x00003fff7fff8001,
  0xffffc00100000000, 0xffffc00080000000,
  0xffffc00100007ffe, 0xffffc00080007fff,
  0xffffd555ffffaaac, 0xffffd555aaaa5556,
  0xffffc00100000000, 0xffffc00080000000,
  0xffffc00100007ffe, 0xffffc00080007fff,
  0xffffd555ffffaaac, 0xffffd555aaaa5556,
  0xffffe666cccc6668, 0xffffe66699993334,
  0xffffc00100007ffe, 0xffffc00080007fff,
  0xffffd555ffffaaac, 0xffffd555aaaa5556,
  0xffffe666cccc6668, 0xffffe66699993334,
  0xffffffffc0010000, 0xffffffffc0008000,
  0xffffd555ffffaaac, 0xffffd555aaaa5556,
  0xffffe666cccc6668, 0xffffe66699993334,
  0xffffffffc0010000, 0xffffffffc0008000,
  0xffffffffc0017ffe, 0xffffffffc000ffff,
  0xffffe666cccc6668, 0xffffe66699993334,
  0xffffffffc0010000, 0xffffffffc0008000,
  0xffffffffc0017ffe, 0xffffffffc000ffff,
  0xffffffffc001fffc, 0xffffffffc0017ffe,
  0xffffffffc0010000, 0xffffffffc0008000,
  0xffffffffc0017ffe, 0xffffffffc000ffff,
  0xffffffffc001fffc, 0xffffffffc0017ffe,
  0xffffffffc0027ffa, 0xffffffffc001fffd,
  0xffffffffc0017ffe, 0xffffffffc000ffff,
  0xffffffffc001fffc, 0xffffffffc0017ffe,
  0xffffffffc0027ffa, 0xffffffffc001fffd,
  0xffffffffffc00100, 0xffffffffffc00080,
  0xffffffffc001fffc, 0xffffffffc0017ffe,
  0xffffffffc0027ffa, 0xffffffffc001fffd,
  0xffffffffffc00100, 0xffffffffffc00080,
  0xffffffffffc080fe, 0xffffffffffc0807f,
  0xffffffffc0027ffa, 0xffffffffc001fffd,
  0xffffffffffc00100, 0xffffffffffc00080,
  0xffffffffffc080fe, 0xffffffffffc0807f,
  0xffffffffffc100fc, 0xffffffffffc1007e,
  0xffffffffffc00100, 0xffffffffffc00080,
  0xffffffffffc080fe, 0xffffffffffc0807f,
  0xffffffffffc100fc, 0xffffffffffc1007e,
  0xffffffffffc180fa, 0xffffffffffc1807d,
  0xffffffffffc080fe, 0xffffffffffc0807f,
  0xffffffffffc100fc, 0xffffffffffc1007e,
  0xffffffffffc180fa, 0xffffffffffc1807d,
  0xfffffffffff00040, 0xfffffffffff00020,
  0xffffffffffc100fc, 0xffffffffffc1007e,
  0xffffffffffc180fa, 0xffffffffffc1807d,
  0xfffffffffff00040, 0xfffffffffff00020,
  0xfffffffffffe8006, 0xfffffffffffe8003,
  0xffffffffffc180fa, 0xffffffffffc1807d,
  0xfffffffffff00040, 0xfffffffffff00020,
  0xfffffffffffe8006, 0xfffffffffffe8003,
  0xffffffffffff0004, 0xffffffffffff0002,
  0xfffffffffff00040, 0xfffffffffff00020,
  0xfffffffffffe8006, 0xfffffffffffe8003,
  0xffffffffffff0004, 0xffffffffffff0002,
  0xffffffffffff8002, 0xffffffffffff8001,
  0xfffffffffffe8003, 0xffffffff66666667,
  0xffffffffffff0002, 0xffffffff9999999a,
  0xffffffffffff8001, 0xffffffffcccccccd,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0002, 0xffffffff9999999a,
  0xffffffffffff8001, 0xffffffffcccccccd,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007fff, 0x0000000033333333,
  0xffffffffffff8001, 0xffffffffcccccccd,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007fff, 0x0000000033333333,
  0x000000000000fffe, 0x0000000066666666,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007fff, 0x0000000033333333,
  0x000000000000fffe, 0x0000000066666666,
  0x00000000000fffe0, 0x0000000666666660,
  0x0000000000007fff, 0x0000000033333333,
  0x000000000000fffe, 0x0000000066666666,
  0x00000000000fffe0, 0x0000000666666660,
  0x00000000003e7f83, 0x00000018ffffffe7,
  0x000000000000fffe, 0x0000000066666666,
  0x00000000000fffe0, 0x0000000666666660,
  0x00000000003e7f83, 0x00000018ffffffe7,
  0x00000000003eff82, 0x000000193333331a,
  0x00000000000fffe0, 0x0000000666666660,
  0x00000000003e7f83, 0x00000018ffffffe7,
  0x00000000003eff82, 0x000000193333331a,
  0x00000000003f7f81, 0x000000196666664d,
  0x00000000003e7f83, 0x00000018ffffffe7,
  0x00000000003eff82, 0x000000193333331a,
  0x00000000003f7f81, 0x000000196666664d,
  0x000000003ffe0003, 0x00001998ffffe667,
  0x00000000003eff82, 0x000000193333331a,
  0x00000000003f7f81, 0x000000196666664d,
  0x000000003ffe0003, 0x00001998ffffe667,
  0x000000003ffe8002, 0x000019993333199a,
  0x00000000003f7f81, 0x000000196666664d,
  0x000000003ffe0003, 0x00001998ffffe667,
  0x000000003ffe8002, 0x000019993333199a,
  0x000000003fff0001, 0x0000199966664ccd,
  0x000000003ffe0003, 0x00001998ffffe667,
  0x000000003ffe8002, 0x000019993333199a,
  0x000000003fff0001, 0x0000199966664ccd,
  0x0000199966664ccd, 0x0a3d70a3c28f5c29,
  0x000000003ffe8002, 0x000019993333199a,
  0x000000003fff0001, 0x0000199966664ccd,
  0x0000199966664ccd, 0x0a3d70a3c28f5c29,
  0x00002aaa55552aab, 0x11111110eeeeeeef,
  0x000000003fff0001, 0x0000199966664ccd,
  0x0000199966664ccd, 0x0a3d70a3c28f5c29,
  0x00002aaa55552aab, 0x11111110eeeeeeef,
  0x00003fff7ffe8003, 0x19999998e6666667,
  0x0000199966664ccd, 0x0a3d70a3c28f5c29,
  0x00002aaa55552aab, 0x11111110eeeeeeef,
  0x00003fff7ffe8003, 0x19999998e6666667,
  0x00003fff7fff0002, 0x199999991999999a,
  0x00002aaa55552aab, 0x11111110eeeeeeef,
  0x00003fff7ffe8003, 0x19999998e6666667,
  0x00003fff7fff0002, 0x199999991999999a,
  0x00003fff7fff8001, 0x199999994ccccccd,
  0x00003fff7ffe8003, 0x19999998e6666667,
  0x00003fff7fff0002, 0x199999991999999a,
  0x00003fff7fff8001, 0x199999994ccccccd,
  0xffffc00080000000, 0xe666666680000000,
  0x00003fff7fff0002, 0x199999991999999a,
  0x00003fff7fff8001, 0x199999994ccccccd,
  0xffffc00080000000, 0xe666666680000000,
  0xffffc00080007fff, 0xe6666666b3333333,
  0x00003fff7fff8001, 0x199999994ccccccd,
  0xffffc00080000000, 0xe666666680000000,
  0xffffc00080007fff, 0xe6666666b3333333,
  0xffffd555aaaa5556, 0xeeeeeeeeddddddde,
  0xffffc00080000000, 0xe666666680000000,
  0xffffc00080007fff, 0xe6666666b3333333,
  0xffffd555aaaa5556, 0xeeeeeeeeddddddde,
  0xffffe66699993334, 0xf5c28f5c0a3d70a4,
  0xffffc00080007fff, 0xe6666666b3333333,
  0xffffd555aaaa5556, 0xeeeeeeeeddddddde,
  0xffffe66699993334, 0xf5c28f5c0a3d70a4,
  0xffffffffc0008000, 0xffffe66666668000,
  0xffffd555aaaa5556, 0xeeeeeeeeddddddde,
  0xffffe66699993334, 0xf5c28f5c0a3d70a4,
  0xffffffffc0008000, 0xffffe66666668000,
  0xffffffffc000ffff, 0xffffe6669999b333,
  0xffffe66699993334, 0xf5c28f5c0a3d70a4,
  0xffffffffc0008000, 0xffffe66666668000,
  0xffffffffc000ffff, 0xffffe6669999b333,
  0xffffffffc0017ffe, 0xffffe666cccce666,
  0xffffffffc0008000, 0xffffe66666668000,
  0xffffffffc000ffff, 0xffffe6669999b333,
  0xffffffffc0017ffe, 0xffffe666cccce666,
  0xffffffffc001fffd, 0xffffe66700001999,
  0xffffffffc000ffff, 0xffffe6669999b333,
  0xffffffffc0017ffe, 0xffffe666cccce666,
  0xffffffffc001fffd, 0xffffe66700001999,
  0xffffffffffc00080, 0xffffffe666666680,
  0xffffffffc0017ffe, 0xffffe666cccce666,
  0xffffffffc001fffd, 0xffffe66700001999,
  0xffffffffffc00080, 0xffffffe666666680,
  0xffffffffffc0807f, 0xffffffe6999999b3,
  0xffffffffc001fffd, 0xffffe66700001999,
  0xffffffffffc00080, 0xffffffe666666680,
  0xffffffffffc0807f, 0xffffffe6999999b3,
  0xffffffffffc1007e, 0xffffffe6cccccce6,
  0xffffffffffc00080, 0xffffffe666666680,
  0xffffffffffc0807f, 0xffffffe6999999b3,
  0xffffffffffc1007e, 0xffffffe6cccccce6,
  0xffffffffffc1807d, 0xffffffe700000019,
  0xffffffffffc0807f, 0xffffffe6999999b3,
  0xffffffffffc1007e, 0xffffffe6cccccce6,
  0xffffffffffc1807d, 0xffffffe700000019,
  0xfffffffffff00020, 0xfffffff9999999a0,
  0xffffffffffc1007e, 0xffffffe6cccccce6,
  0xffffffffffc1807d, 0xffffffe700000019,
  0xfffffffffff00020, 0xfffffff9999999a0,
  0xfffffffffffe8003, 0xffffffff66666667,
  0xffffffffffc1807d, 0xffffffe700000019,
  0xfffffffffff00020, 0xfffffff9999999a0,
  0xfffffffffffe8003, 0xffffffff66666667,
  0xffffffffffff0002, 0xffffffff9999999a,
  0xfffffffffff00020, 0xfffffff9999999a0,
  0xfffffffffffe8003, 0xffffffff66666667,
  0xffffffffffff0002, 0xffffffff9999999a,
  0xffffffffffff8001, 0xffffffffcccccccd,
  0xffffffff66666667, 0xffffffff00000001,
  0xffffffff9999999a, 0xffffffff55555556,
  0xffffffffcccccccd, 0xffffffffaaaaaaab,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff9999999a, 0xffffffff55555556,
  0xffffffffcccccccd, 0xffffffffaaaaaaab,
  0x0000000000000000, 0x0000000000000000,
  0x0000000033333333, 0x0000000055555555,
  0xffffffffcccccccd, 0xffffffffaaaaaaab,
  0x0000000000000000, 0x0000000000000000,
  0x0000000033333333, 0x0000000055555555,
  0x0000000066666666, 0x00000000aaaaaaaa,
  0x0000000000000000, 0x0000000000000000,
  0x0000000033333333, 0x0000000055555555,
  0x0000000066666666, 0x00000000aaaaaaaa,
  0x0000000666666660, 0x0000000aaaaaaaa0,
  0x0000000033333333, 0x0000000055555555,
  0x0000000066666666, 0x00000000aaaaaaaa,
  0x0000000666666660, 0x0000000aaaaaaaa0,
  0x00000018ffffffe7, 0x00000029aaaaaa81,
  0x0000000066666666, 0x00000000aaaaaaaa,
  0x0000000666666660, 0x0000000aaaaaaaa0,
  0x00000018ffffffe7, 0x00000029aaaaaa81,
  0x000000193333331a, 0x00000029ffffffd6,
  0x0000000666666660, 0x0000000aaaaaaaa0,
  0x00000018ffffffe7, 0x00000029aaaaaa81,
  0x000000193333331a, 0x00000029ffffffd6,
  0x000000196666664d, 0x0000002a5555552b,
  0x00000018ffffffe7, 0x00000029aaaaaa81,
  0x000000193333331a, 0x00000029ffffffd6,
  0x000000196666664d, 0x0000002a5555552b,
  0x00001998ffffe667, 0x00002aa9aaaa8001,
  0x000000193333331a, 0x00000029ffffffd6,
  0x000000196666664d, 0x0000002a5555552b,
  0x00001998ffffe667, 0x00002aa9aaaa8001,
  0x000019993333199a, 0x00002aa9ffffd556,
  0x000000196666664d, 0x0000002a5555552b,
  0x00001998ffffe667, 0x00002aa9aaaa8001,
  0x000019993333199a, 0x00002aa9ffffd556,
  0x0000199966664ccd, 0x00002aaa55552aab,
  0x00001998ffffe667, 0x00002aa9aaaa8001,
  0x000019993333199a, 0x00002aa9ffffd556,
  0x0000199966664ccd, 0x00002aaa55552aab,
  0x0a3d70a3c28f5c29, 0x11111110eeeeeeef,
  0x000019993333199a, 0x00002aa9ffffd556,
  0x0000199966664ccd, 0x00002aaa55552aab,
  0x0a3d70a3c28f5c29, 0x11111110eeeeeeef,
  0x11111110eeeeeeef, 0x1c71c71c38e38e39,
  0x0000199966664ccd, 0x00002aaa55552aab,
  0x0a3d70a3c28f5c29, 0x11111110eeeeeeef,
  0x11111110eeeeeeef, 0x1c71c71c38e38e39,
  0x19999998e6666667, 0x2aaaaaa980000001,
  0x0a3d70a3c28f5c29, 0x11111110eeeeeeef,
  0x11111110eeeeeeef, 0x1c71c71c38e38e39,
  0x19999998e6666667, 0x2aaaaaa980000001,
  0x199999991999999a, 0x2aaaaaa9d5555556,
  0x11111110eeeeeeef, 0x1c71c71c38e38e39,
  0x19999998e6666667, 0x2aaaaaa980000001,
  0x199999991999999a, 0x2aaaaaa9d5555556,
  0x199999994ccccccd, 0x2aaaaaaa2aaaaaab,
  0x19999998e6666667, 0x2aaaaaa980000001,
  0x199999991999999a, 0x2aaaaaa9d5555556,
  0x199999994ccccccd, 0x2aaaaaaa2aaaaaab,
  0xe666666680000000, 0xd555555580000000,
  0x199999991999999a, 0x2aaaaaa9d5555556,
  0x199999994ccccccd, 0x2aaaaaaa2aaaaaab,
  0xe666666680000000, 0xd555555580000000,
  0xe6666666b3333333, 0xd5555555d5555555,
  0x199999994ccccccd, 0x2aaaaaaa2aaaaaab,
  0xe666666680000000, 0xd555555580000000,
  0xe6666666b3333333, 0xd5555555d5555555,
  0xeeeeeeeeddddddde, 0xe38e38e371c71c72,
  0xe666666680000000, 0xd555555580000000,
  0xe6666666b3333333, 0xd5555555d5555555,
  0xeeeeeeeeddddddde, 0xe38e38e371c71c72,
  0xf5c28f5c0a3d70a4, 0xeeeeeeeebbbbbbbc,
  0xe6666666b3333333, 0xd5555555d5555555,
  0xeeeeeeeeddddddde, 0xe38e38e371c71c72,
  0xf5c28f5c0a3d70a4, 0xeeeeeeeebbbbbbbc,
  0xffffe66666668000, 0xffffd55555558000,
  0xeeeeeeeeddddddde, 0xe38e38e371c71c72,
  0xf5c28f5c0a3d70a4, 0xeeeeeeeebbbbbbbc,
  0xffffe66666668000, 0xffffd55555558000,
  0xffffe6669999b333, 0xffffd555aaaad555,
  0xf5c28f5c0a3d70a4, 0xeeeeeeeebbbbbbbc,
  0xffffe66666668000, 0xffffd55555558000,
  0xffffe6669999b333, 0xffffd555aaaad555,
  0xffffe666cccce666, 0xffffd55600002aaa,
  0xffffe66666668000, 0xffffd55555558000,
  0xffffe6669999b333, 0xffffd555aaaad555,
  0xffffe666cccce666, 0xffffd55600002aaa,
  0xffffe66700001999, 0xffffd55655557fff,
  0xffffe6669999b333, 0xffffd555aaaad555,
  0xffffe666cccce666, 0xffffd55600002aaa,
  0xffffe66700001999, 0xffffd55655557fff,
  0xffffffe666666680, 0xffffffd555555580,
  0xffffe666cccce666, 0xffffd55600002aaa,
  0xffffe66700001999, 0xffffd55655557fff,
  0xffffffe666666680, 0xffffffd555555580,
  0xffffffe6999999b3, 0xffffffd5aaaaaad5,
  0xffffe66700001999, 0xffffd55655557fff,
  0xffffffe666666680, 0xffffffd555555580,
  0xffffffe6999999b3, 0xffffffd5aaaaaad5,
  0xffffffe6cccccce6, 0xffffffd60000002a,
  0xffffffe666666680, 0xffffffd555555580,
  0xffffffe6999999b3, 0xffffffd5aaaaaad5,
  0xffffffe6cccccce6, 0xffffffd60000002a,
  0xffffffe700000019, 0xffffffd65555557f,
  0xffffffe6999999b3, 0xffffffd5aaaaaad5,
  0xffffffe6cccccce6, 0xffffffd60000002a,
  0xffffffe700000019, 0xffffffd65555557f,
  0xfffffff9999999a0, 0xfffffff555555560,
  0xffffffe6cccccce6, 0xffffffd60000002a,
  0xffffffe700000019, 0xffffffd65555557f,
  0xfffffff9999999a0, 0xfffffff555555560,
  0xffffffff66666667, 0xffffffff00000001,
  0xffffffe700000019, 0xffffffd65555557f,
  0xfffffff9999999a0, 0xfffffff555555560,
  0xffffffff66666667, 0xffffffff00000001,
  0xffffffff9999999a, 0xffffffff55555556,
  0xfffffff9999999a0, 0xfffffff555555560,
  0xffffffff66666667, 0xffffffff00000001,
  0xffffffff9999999a, 0xffffffff55555556,
  0xffffffffcccccccd, 0xffffffffaaaaaaab,
  0xffffffff00000001, 0xfffffffe80000009,
  0xffffffff55555556, 0xffffffff00000006,
  0xffffffffaaaaaaab, 0xffffffff80000003,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff55555556, 0xffffffff00000006,
  0xffffffffaaaaaaab, 0xffffffff80000003,
  0x0000000000000000, 0x0000000000000000,
  0x0000000055555555, 0x000000007ffffffd,
  0xffffffffaaaaaaab, 0xffffffff80000003,
  0x0000000000000000, 0x0000000000000000,
  0x0000000055555555, 0x000000007ffffffd,
  0x00000000aaaaaaaa, 0x00000000fffffffa,
  0x0000000000000000, 0x0000000000000000,
  0x0000000055555555, 0x000000007ffffffd,
  0x00000000aaaaaaaa, 0x00000000fffffffa,
  0x0000000aaaaaaaa0, 0x0000000fffffffa0,
  0x0000000055555555, 0x000000007ffffffd,
  0x00000000aaaaaaaa, 0x00000000fffffffa,
  0x0000000aaaaaaaa0, 0x0000000fffffffa0,
  0x00000029aaaaaa81, 0x0000003e7ffffe89,
  0x00000000aaaaaaaa, 0x00000000fffffffa,
  0x0000000aaaaaaaa0, 0x0000000fffffffa0,
  0x00000029aaaaaa81, 0x0000003e7ffffe89,
  0x00000029ffffffd6, 0x0000003efffffe86,
  0x0000000aaaaaaaa0, 0x0000000fffffffa0,
  0x00000029aaaaaa81, 0x0000003e7ffffe89,
  0x00000029ffffffd6, 0x0000003efffffe86,
  0x0000002a5555552b, 0x0000003f7ffffe83,
  0x00000029aaaaaa81, 0x0000003e7ffffe89,
  0x00000029ffffffd6, 0x0000003efffffe86,
  0x0000002a5555552b, 0x0000003f7ffffe83,
  0x00002aa9aaaa8001, 0x00003ffe7ffe8009,
  0x00000029ffffffd6, 0x0000003efffffe86,
  0x0000002a5555552b, 0x0000003f7ffffe83,
  0x00002aa9aaaa8001, 0x00003ffe7ffe8009,
  0x00002aa9ffffd556, 0x00003ffefffe8006,
  0x0000002a5555552b, 0x0000003f7ffffe83,
  0x00002aa9aaaa8001, 0x00003ffe7ffe8009,
  0x00002aa9ffffd556, 0x00003ffefffe8006,
  0x00002aaa55552aab, 0x00003fff7ffe8003,
  0x00002aa9aaaa8001, 0x00003ffe7ffe8009,
  0x00002aa9ffffd556, 0x00003ffefffe8006,
  0x00002aaa55552aab, 0x00003fff7ffe8003,
  0x11111110eeeeeeef, 0x19999998e6666667,
  0x00002aa9ffffd556, 0x00003ffefffe8006,
  0x00002aaa55552aab, 0x00003fff7ffe8003,
  0x11111110eeeeeeef, 0x19999998e6666667,
  0x1c71c71c38e38e39, 0x2aaaaaa980000001,
  0x00002aaa55552aab, 0x00003fff7ffe8003,
  0x11111110eeeeeeef, 0x19999998e6666667,
  0x1c71c71c38e38e39, 0x2aaaaaa980000001,
  0x2aaaaaa980000001, 0x3ffffffd00000009,
  0x11111110eeeeeeef, 0x19999998e6666667,
  0x1c71c71c38e38e39, 0x2aaaaaa980000001,
  0x2aaaaaa980000001, 0x3ffffffd00000009,
  0x2aaaaaa9d5555556, 0x3ffffffd80000006,
  0x1c71c71c38e38e39, 0x2aaaaaa980000001,
  0x2aaaaaa980000001, 0x3ffffffd00000009,
  0x2aaaaaa9d5555556, 0x3ffffffd80000006,
  0x2aaaaaaa2aaaaaab, 0x3ffffffe00000003,
  0x2aaaaaa980000001, 0x3ffffffd00000009,
  0x2aaaaaa9d5555556, 0x3ffffffd80000006,
  0x2aaaaaaa2aaaaaab, 0x3ffffffe00000003,
  0xd555555580000000, 0xc000000180000000,
  0x2aaaaaa9d5555556, 0x3ffffffd80000006,
  0x2aaaaaaa2aaaaaab, 0x3ffffffe00000003,
  0xd555555580000000, 0xc000000180000000,
  0xd5555555d5555555, 0xc0000001fffffffd,
  0x2aaaaaaa2aaaaaab, 0x3ffffffe00000003,
  0xd555555580000000, 0xc000000180000000,
  0xd5555555d5555555, 0xc0000001fffffffd,
  0xe38e38e371c71c72, 0xd555555600000002,
  0xd555555580000000, 0xc000000180000000,
  0xd5555555d5555555, 0xc0000001fffffffd,
  0xe38e38e371c71c72, 0xd555555600000002,
  0xeeeeeeeebbbbbbbc, 0xe66666669999999c,
  0xd5555555d5555555, 0xc0000001fffffffd,
  0xe38e38e371c71c72, 0xd555555600000002,
  0xeeeeeeeebbbbbbbc, 0xe66666669999999c,
  0xffffd55555558000, 0xffffc00000018000,
  0xe38e38e371c71c72, 0xd555555600000002,
  0xeeeeeeeebbbbbbbc, 0xe66666669999999c,
  0xffffd55555558000, 0xffffc00000018000,
  0xffffd555aaaad555, 0xffffc00080017ffd,
  0xeeeeeeeebbbbbbbc, 0xe66666669999999c,
  0xffffd55555558000, 0xffffc00000018000,
  0xffffd555aaaad555, 0xffffc00080017ffd,
  0xffffd55600002aaa, 0xffffc00100017ffa,
  0xffffd55555558000, 0xffffc00000018000,
  0xffffd555aaaad555, 0xffffc00080017ffd,
  0xffffd55600002aaa, 0xffffc00100017ffa,
  0xffffd55655557fff, 0xffffc00180017ff7,
  0xffffd555aaaad555, 0xffffc00080017ffd,
  0xffffd55600002aaa, 0xffffc00100017ffa,
  0xffffd55655557fff, 0xffffc00180017ff7,
  0xffffffd555555580, 0xffffffc000000180,
  0xffffd55600002aaa, 0xffffc00100017ffa,
  0xffffd55655557fff, 0xffffc00180017ff7,
  0xffffffd555555580, 0xffffffc000000180,
  0xffffffd5aaaaaad5, 0xffffffc08000017d,
  0xffffd55655557fff, 0xffffc00180017ff7,
  0xffffffd555555580, 0xffffffc000000180,
  0xffffffd5aaaaaad5, 0xffffffc08000017d,
  0xffffffd60000002a, 0xffffffc10000017a,
  0xffffffd555555580, 0xffffffc000000180,
  0xffffffd5aaaaaad5, 0xffffffc08000017d,
  0xffffffd60000002a, 0xffffffc10000017a,
  0xffffffd65555557f, 0xffffffc180000177,
  0xffffffd5aaaaaad5, 0xffffffc08000017d,
  0xffffffd60000002a, 0xffffffc10000017a,
  0xffffffd65555557f, 0xffffffc180000177,
  0xfffffff555555560, 0xfffffff000000060,
  0xffffffd60000002a, 0xffffffc10000017a,
  0xffffffd65555557f, 0xffffffc180000177,
  0xfffffff555555560, 0xfffffff000000060,
  0xffffffff00000001, 0xfffffffe80000009,
  0xffffffd65555557f, 0xffffffc180000177,
  0xfffffff555555560, 0xfffffff000000060,
  0xffffffff00000001, 0xfffffffe80000009,
  0xffffffff55555556, 0xffffffff00000006,
  0xfffffff555555560, 0xfffffff000000060,
  0xffffffff00000001, 0xfffffffe80000009,
  0xffffffff55555556, 0xffffffff00000006,
  0xffffffffaaaaaaab, 0xffffffff80000003,
  0xfffffffe80000009, 0xfffffffe80000006,
  0xffffffff00000006, 0xffffffff00000004,
  0xffffffff80000003, 0xffffffff80000002,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff00000006, 0xffffffff00000004,
  0xffffffff80000003, 0xffffffff80000002,
  0x0000000000000000, 0x0000000000000000,
  0x000000007ffffffd, 0x000000007ffffffe,
  0xffffffff80000003, 0xffffffff80000002,
  0x0000000000000000, 0x0000000000000000,
  0x000000007ffffffd, 0x000000007ffffffe,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x0000000000000000, 0x0000000000000000,
  0x000000007ffffffd, 0x000000007ffffffe,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x0000000fffffffa0, 0x0000000fffffffc0,
  0x000000007ffffffd, 0x000000007ffffffe,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x0000000fffffffa0, 0x0000000fffffffc0,
  0x0000003e7ffffe89, 0x0000003e7fffff06,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x0000000fffffffa0, 0x0000000fffffffc0,
  0x0000003e7ffffe89, 0x0000003e7fffff06,
  0x0000003efffffe86, 0x0000003effffff04,
  0x0000000fffffffa0, 0x0000000fffffffc0,
  0x0000003e7ffffe89, 0x0000003e7fffff06,
  0x0000003efffffe86, 0x0000003effffff04,
  0x0000003f7ffffe83, 0x0000003f7fffff02,
  0x0000003e7ffffe89, 0x0000003e7fffff06,
  0x0000003efffffe86, 0x0000003effffff04,
  0x0000003f7ffffe83, 0x0000003f7fffff02,
  0x00003ffe7ffe8009, 0x00003ffe7fff0006,
  0x0000003efffffe86, 0x0000003effffff04,
  0x0000003f7ffffe83, 0x0000003f7fffff02,
  0x00003ffe7ffe8009, 0x00003ffe7fff0006,
  0x00003ffefffe8006, 0x00003ffeffff0004,
  0x0000003f7ffffe83, 0x0000003f7fffff02,
  0x00003ffe7ffe8009, 0x00003ffe7fff0006,
  0x00003ffefffe8006, 0x00003ffeffff0004,
  0x00003fff7ffe8003, 0x00003fff7fff0002,
  0x00003ffe7ffe8009, 0x00003ffe7fff0006,
  0x00003ffefffe8006, 0x00003ffeffff0004,
  0x00003fff7ffe8003, 0x00003fff7fff0002,
  0x19999998e6666667, 0x199999991999999a,
  0x00003ffefffe8006, 0x00003ffeffff0004,
  0x00003fff7ffe8003, 0x00003fff7fff0002,
  0x19999998e6666667, 0x199999991999999a,
  0x2aaaaaa980000001, 0x2aaaaaa9d5555556,
  0x00003fff7ffe8003, 0x00003fff7fff0002,
  0x19999998e6666667, 0x199999991999999a,
  0x2aaaaaa980000001, 0x2aaaaaa9d5555556,
  0x3ffffffd00000009, 0x3ffffffd80000006,
  0x19999998e6666667, 0x199999991999999a,
  0x2aaaaaa980000001, 0x2aaaaaa9d5555556,
  0x3ffffffd00000009, 0x3ffffffd80000006,
  0x3ffffffd80000006, 0x3ffffffe00000004,
  0x2aaaaaa980000001, 0x2aaaaaa9d5555556,
  0x3ffffffd00000009, 0x3ffffffd80000006,
  0x3ffffffd80000006, 0x3ffffffe00000004,
  0x3ffffffe00000003, 0x3ffffffe80000002,
  0x3ffffffd00000009, 0x3ffffffd80000006,
  0x3ffffffd80000006, 0x3ffffffe00000004,
  0x3ffffffe00000003, 0x3ffffffe80000002,
  0xc000000180000000, 0xc000000100000000,
  0x3ffffffd80000006, 0x3ffffffe00000004,
  0x3ffffffe00000003, 0x3ffffffe80000002,
  0xc000000180000000, 0xc000000100000000,
  0xc0000001fffffffd, 0xc00000017ffffffe,
  0x3ffffffe00000003, 0x3ffffffe80000002,
  0xc000000180000000, 0xc000000100000000,
  0xc0000001fffffffd, 0xc00000017ffffffe,
  0xd555555600000002, 0xd5555555aaaaaaac,
  0xc000000180000000, 0xc000000100000000,
  0xc0000001fffffffd, 0xc00000017ffffffe,
  0xd555555600000002, 0xd5555555aaaaaaac,
  0xe66666669999999c, 0xe666666666666668,
  0xc0000001fffffffd, 0xc00000017ffffffe,
  0xd555555600000002, 0xd5555555aaaaaaac,
  0xe66666669999999c, 0xe666666666666668,
  0xffffc00000018000, 0xffffc00000010000,
  0xd555555600000002, 0xd5555555aaaaaaac,
  0xe66666669999999c, 0xe666666666666668,
  0xffffc00000018000, 0xffffc00000010000,
  0xffffc00080017ffd, 0xffffc0008000fffe,
  0xe66666669999999c, 0xe666666666666668,
  0xffffc00000018000, 0xffffc00000010000,
  0xffffc00080017ffd, 0xffffc0008000fffe,
  0xffffc00100017ffa, 0xffffc0010000fffc,
  0xffffc00000018000, 0xffffc00000010000,
  0xffffc00080017ffd, 0xffffc0008000fffe,
  0xffffc00100017ffa, 0xffffc0010000fffc,
  0xffffc00180017ff7, 0xffffc0018000fffa,
  0xffffc00080017ffd, 0xffffc0008000fffe,
  0xffffc00100017ffa, 0xffffc0010000fffc,
  0xffffc00180017ff7, 0xffffc0018000fffa,
  0xffffffc000000180, 0xffffffc000000100,
  0xffffc00100017ffa, 0xffffc0010000fffc,
  0xffffc00180017ff7, 0xffffc0018000fffa,
  0xffffffc000000180, 0xffffffc000000100,
  0xffffffc08000017d, 0xffffffc0800000fe,
  0xffffc00180017ff7, 0xffffc0018000fffa,
  0xffffffc000000180, 0xffffffc000000100,
  0xffffffc08000017d, 0xffffffc0800000fe,
  0xffffffc10000017a, 0xffffffc1000000fc,
  0xffffffc000000180, 0xffffffc000000100,
  0xffffffc08000017d, 0xffffffc0800000fe,
  0xffffffc10000017a, 0xffffffc1000000fc,
  0xffffffc180000177, 0xffffffc1800000fa,
  0xffffffc08000017d, 0xffffffc0800000fe,
  0xffffffc10000017a, 0xffffffc1000000fc,
  0xffffffc180000177, 0xffffffc1800000fa,
  0xfffffff000000060, 0xfffffff000000040,
  0xffffffc10000017a, 0xffffffc1000000fc,
  0xffffffc180000177, 0xffffffc1800000fa,
  0xfffffff000000060, 0xfffffff000000040,
  0xfffffffe80000009, 0xfffffffe80000006,
  0xffffffc180000177, 0xffffffc1800000fa,
  0xfffffff000000060, 0xfffffff000000040,
  0xfffffffe80000009, 0xfffffffe80000006,
  0xffffffff00000006, 0xffffffff00000004,
  0xfffffff000000060, 0xfffffff000000040,
  0xfffffffe80000009, 0xfffffffe80000006,
  0xffffffff00000006, 0xffffffff00000004,
  0xffffffff80000003, 0xffffffff80000002,
  0xfffffffe80000006, 0xfffffffe80000003,
  0xffffffff00000004, 0xffffffff00000002,
  0xffffffff80000002, 0xffffffff80000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff00000004, 0xffffffff00000002,
  0xffffffff80000002, 0xffffffff80000001,
  0x0000000000000000, 0x0000000000000000,
  0x000000007ffffffe, 0x000000007fffffff,
  0xffffffff80000002, 0xffffffff80000001,
  0x0000000000000000, 0x0000000000000000,
  0x000000007ffffffe, 0x000000007fffffff,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x0000000000000000, 0x0000000000000000,
  0x000000007ffffffe, 0x000000007fffffff,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x0000000fffffffc0, 0x0000000fffffffe0,
  0x000000007ffffffe, 0x000000007fffffff,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x0000000fffffffc0, 0x0000000fffffffe0,
  0x0000003e7fffff06, 0x0000003e7fffff83,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x0000000fffffffc0, 0x0000000fffffffe0,
  0x0000003e7fffff06, 0x0000003e7fffff83,
  0x0000003effffff04, 0x0000003effffff82,
  0x0000000fffffffc0, 0x0000000fffffffe0,
  0x0000003e7fffff06, 0x0000003e7fffff83,
  0x0000003effffff04, 0x0000003effffff82,
  0x0000003f7fffff02, 0x0000003f7fffff81,
  0x0000003e7fffff06, 0x0000003e7fffff83,
  0x0000003effffff04, 0x0000003effffff82,
  0x0000003f7fffff02, 0x0000003f7fffff81,
  0x00003ffe7fff0006, 0x00003ffe7fff8003,
  0x0000003effffff04, 0x0000003effffff82,
  0x0000003f7fffff02, 0x0000003f7fffff81,
  0x00003ffe7fff0006, 0x00003ffe7fff8003,
  0x00003ffeffff0004, 0x00003ffeffff8002,
  0x0000003f7fffff02, 0x0000003f7fffff81,
  0x00003ffe7fff0006, 0x00003ffe7fff8003,
  0x00003ffeffff0004, 0x00003ffeffff8002,
  0x00003fff7fff0002, 0x00003fff7fff8001,
  0x00003ffe7fff0006, 0x00003ffe7fff8003,
  0x00003ffeffff0004, 0x00003ffeffff8002,
  0x00003fff7fff0002, 0x00003fff7fff8001,
  0x199999991999999a, 0x199999994ccccccd,
  0x00003ffeffff0004, 0x00003ffeffff8002,
  0x00003fff7fff0002, 0x00003fff7fff8001,
  0x199999991999999a, 0x199999994ccccccd,
  0x2aaaaaa9d5555556, 0x2aaaaaaa2aaaaaab,
  0x00003fff7fff0002, 0x00003fff7fff8001,
  0x199999991999999a, 0x199999994ccccccd,
  0x2aaaaaa9d5555556, 0x2aaaaaaa2aaaaaab,
  0x3ffffffd80000006, 0x3ffffffe00000003,
  0x199999991999999a, 0x199999994ccccccd,
  0x2aaaaaa9d5555556, 0x2aaaaaaa2aaaaaab,
  0x3ffffffd80000006, 0x3ffffffe00000003,
  0x3ffffffe00000004, 0x3ffffffe80000002,
  0x2aaaaaa9d5555556, 0x2aaaaaaa2aaaaaab,
  0x3ffffffd80000006, 0x3ffffffe00000003,
  0x3ffffffe00000004, 0x3ffffffe80000002,
  0x3ffffffe80000002, 0x3fffffff00000001,
  0x3ffffffd80000006, 0x3ffffffe00000003,
  0x3ffffffe00000004, 0x3ffffffe80000002,
  0x3ffffffe80000002, 0x3fffffff00000001,
  0xc000000100000000, 0xc000000080000000,
  0x3ffffffe00000004, 0x3ffffffe80000002,
  0x3ffffffe80000002, 0x3fffffff00000001,
  0xc000000100000000, 0xc000000080000000,
  0xc00000017ffffffe, 0xc0000000ffffffff,
  0x3ffffffe80000002, 0x3fffffff00000001,
  0xc000000100000000, 0xc000000080000000,
  0xc00000017ffffffe, 0xc0000000ffffffff,
  0xd5555555aaaaaaac, 0xd555555555555556,
  0xc000000100000000, 0xc000000080000000,
  0xc00000017ffffffe, 0xc0000000ffffffff,
  0xd5555555aaaaaaac, 0xd555555555555556,
  0xe666666666666668, 0xe666666633333334,
  0xc00000017ffffffe, 0xc0000000ffffffff,
  0xd5555555aaaaaaac, 0xd555555555555556,
  0xe666666666666668, 0xe666666633333334,
  0xffffc00000010000, 0xffffc00000008000,
  0xd5555555aaaaaaac, 0xd555555555555556,
  0xe666666666666668, 0xe666666633333334,
  0xffffc00000010000, 0xffffc00000008000,
  0xffffc0008000fffe, 0xffffc00080007fff,
  0xe666666666666668, 0xe666666633333334,
  0xffffc00000010000, 0xffffc00000008000,
  0xffffc0008000fffe, 0xffffc00080007fff,
  0xffffc0010000fffc, 0xffffc00100007ffe,
  0xffffc00000010000, 0xffffc00000008000,
  0xffffc0008000fffe, 0xffffc00080007fff,
  0xffffc0010000fffc, 0xffffc00100007ffe,
  0xffffc0018000fffa, 0xffffc00180007ffd,
  0xffffc0008000fffe, 0xffffc00080007fff,
  0xffffc0010000fffc, 0xffffc00100007ffe,
  0xffffc0018000fffa, 0xffffc00180007ffd,
  0xffffffc000000100, 0xffffffc000000080,
  0xffffc0010000fffc, 0xffffc00100007ffe,
  0xffffc0018000fffa, 0xffffc00180007ffd,
  0xffffffc000000100, 0xffffffc000000080,
  0xffffffc0800000fe, 0xffffffc08000007f,
  0xffffc0018000fffa, 0xffffc00180007ffd,
  0xffffffc000000100, 0xffffffc000000080,
  0xffffffc0800000fe, 0xffffffc08000007f,
  0xffffffc1000000fc, 0xffffffc10000007e,
  0xffffffc000000100, 0xffffffc000000080,
  0xffffffc0800000fe, 0xffffffc08000007f,
  0xffffffc1000000fc, 0xffffffc10000007e,
  0xffffffc1800000fa, 0xffffffc18000007d,
  0xffffffc0800000fe, 0xffffffc08000007f,
  0xffffffc1000000fc, 0xffffffc10000007e,
  0xffffffc1800000fa, 0xffffffc18000007d,
  0xfffffff000000040, 0xfffffff000000020,
  0xffffffc1000000fc, 0xffffffc10000007e,
  0xffffffc1800000fa, 0xffffffc18000007d,
  0xfffffff000000040, 0xfffffff000000020,
  0xfffffffe80000006, 0xfffffffe80000003,
  0xffffffc1800000fa, 0xffffffc18000007d,
  0xfffffff000000040, 0xfffffff000000020,
  0xfffffffe80000006, 0xfffffffe80000003,
  0xffffffff00000004, 0xffffffff00000002,
  0xfffffff000000040, 0xfffffff000000020,
  0xfffffffe80000006, 0xfffffffe80000003,
  0xffffffff00000004, 0xffffffff00000002,
  0xffffffff80000002, 0xffffffff80000001,
  0xfffffffe80000003, 0x0000000180000000,
  0xffffffff00000002, 0x0000000100000000,
  0xffffffff80000001, 0x0000000080000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff00000002, 0x0000000100000000,
  0xffffffff80000001, 0x0000000080000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000007fffffff, 0xffffffff80000000,
  0xffffffff80000001, 0x0000000080000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000007fffffff, 0xffffffff80000000,
  0x00000000fffffffe, 0xffffffff00000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000007fffffff, 0xffffffff80000000,
  0x00000000fffffffe, 0xffffffff00000000,
  0x0000000fffffffe0, 0xfffffff000000000,
  0x000000007fffffff, 0xffffffff80000000,
  0x00000000fffffffe, 0xffffffff00000000,
  0x0000000fffffffe0, 0xfffffff000000000,
  0x0000003e7fffff83, 0xffffffc180000000,
  0x00000000fffffffe, 0xffffffff00000000,
  0x0000000fffffffe0, 0xfffffff000000000,
  0x0000003e7fffff83, 0xffffffc180000000,
  0x0000003effffff82, 0xffffffc100000000,
  0x0000000fffffffe0, 0xfffffff000000000,
  0x0000003e7fffff83, 0xffffffc180000000,
  0x0000003effffff82, 0xffffffc100000000,
  0x0000003f7fffff81, 0xffffffc080000000,
  0x0000003e7fffff83, 0xffffffc180000000,
  0x0000003effffff82, 0xffffffc100000000,
  0x0000003f7fffff81, 0xffffffc080000000,
  0x00003ffe7fff8003, 0xffffc00180000000,
  0x0000003effffff82, 0xffffffc100000000,
  0x0000003f7fffff81, 0xffffffc080000000,
  0x00003ffe7fff8003, 0xffffc00180000000,
  0x00003ffeffff8002, 0xffffc00100000000,
  0x0000003f7fffff81, 0xffffffc080000000,
  0x00003ffe7fff8003, 0xffffc00180000000,
  0x00003ffeffff8002, 0xffffc00100000000,
  0x00003fff7fff8001, 0xffffc00080000000,
  0x00003ffe7fff8003, 0xffffc00180000000,
  0x00003ffeffff8002, 0xffffc00100000000,
  0x00003fff7fff8001, 0xffffc00080000000,
  0x199999994ccccccd, 0xe666666680000000,
  0x00003ffeffff8002, 0xffffc00100000000,
  0x00003fff7fff8001, 0xffffc00080000000,
  0x199999994ccccccd, 0xe666666680000000,
  0x2aaaaaaa2aaaaaab, 0xd555555580000000,
  0x00003fff7fff8001, 0xffffc00080000000,
  0x199999994ccccccd, 0xe666666680000000,
  0x2aaaaaaa2aaaaaab, 0xd555555580000000,
  0x3ffffffe00000003, 0xc000000180000000,
  0x199999994ccccccd, 0xe666666680000000,
  0x2aaaaaaa2aaaaaab, 0xd555555580000000,
  0x3ffffffe00000003, 0xc000000180000000,
  0x3ffffffe80000002, 0xc000000100000000,
  0x2aaaaaaa2aaaaaab, 0xd555555580000000,
  0x3ffffffe00000003, 0xc000000180000000,
  0x3ffffffe80000002, 0xc000000100000000,
  0x3fffffff00000001, 0xc000000080000000,
  0x3ffffffe00000003, 0xc000000180000000,
  0x3ffffffe80000002, 0xc000000100000000,
  0x3fffffff00000001, 0xc000000080000000,
  0xc000000080000000, 0x4000000000000000,
  0x3ffffffe80000002, 0xc000000100000000,
  0x3fffffff00000001, 0xc000000080000000,
  0xc000000080000000, 0x4000000000000000,
  0xc0000000ffffffff, 0x3fffffff80000000,
  0x3fffffff00000001, 0xc000000080000000,
  0xc000000080000000, 0x4000000000000000,
  0xc0000000ffffffff, 0x3fffffff80000000,
  0xd555555555555556, 0x2aaaaaab00000000,
  0xc000000080000000, 0x4000000000000000,
  0xc0000000ffffffff, 0x3fffffff80000000,
  0xd555555555555556, 0x2aaaaaab00000000,
  0xe666666633333334, 0x1999999a00000000,
  0xc0000000ffffffff, 0x3fffffff80000000,
  0xd555555555555556, 0x2aaaaaab00000000,
  0xe666666633333334, 0x1999999a00000000,
  0xffffc00000008000, 0x0000400000000000,
  0xd555555555555556, 0x2aaaaaab00000000,
  0xe666666633333334, 0x1999999a00000000,
  0xffffc00000008000, 0x0000400000000000,
  0xffffc00080007fff, 0x00003fff80000000,
  0xe666666633333334, 0x1999999a00000000,
  0xffffc00000008000, 0x0000400000000000,
  0xffffc00080007fff, 0x00003fff80000000,
  0xffffc00100007ffe, 0x00003fff00000000,
  0xffffc00000008000, 0x0000400000000000,
  0xffffc00080007fff, 0x00003fff80000000,
  0xffffc00100007ffe, 0x00003fff00000000,
  0xffffc00180007ffd, 0x00003ffe80000000,
  0xffffc00080007fff, 0x00003fff80000000,
  0xffffc00100007ffe, 0x00003fff00000000,
  0xffffc00180007ffd, 0x00003ffe80000000,
  0xffffffc000000080, 0x0000004000000000,
  0xffffc00100007ffe, 0x00003fff00000000,
  0xffffc00180007ffd, 0x00003ffe80000000,
  0xffffffc000000080, 0x0000004000000000,
  0xffffffc08000007f, 0x0000003f80000000,
  0xffffc00180007ffd, 0x00003ffe80000000,
  0xffffffc000000080, 0x0000004000000000,
  0xffffffc08000007f, 0x0000003f80000000,
  0xffffffc10000007e, 0x0000003f00000000,
  0xffffffc000000080, 0x0000004000000000,
  0xffffffc08000007f, 0x0000003f80000000,
  0xffffffc10000007e, 0x0000003f00000000,
  0xffffffc18000007d, 0x0000003e80000000,
  0xffffffc08000007f, 0x0000003f80000000,
  0xffffffc10000007e, 0x0000003f00000000,
  0xffffffc18000007d, 0x0000003e80000000,
  0xfffffff000000020, 0x0000001000000000,
  0xffffffc10000007e, 0x0000003f00000000,
  0xffffffc18000007d, 0x0000003e80000000,
  0xfffffff000000020, 0x0000001000000000,
  0xfffffffe80000003, 0x0000000180000000,
  0xffffffc18000007d, 0x0000003e80000000,
  0xfffffff000000020, 0x0000001000000000,
  0xfffffffe80000003, 0x0000000180000000,
  0xffffffff00000002, 0x0000000100000000,
  0xfffffff000000020, 0x0000001000000000,
  0xfffffffe80000003, 0x0000000180000000,
  0xffffffff00000002, 0x0000000100000000,
  0xffffffff80000001, 0x0000000080000000,
  0x0000000180000000, 0x000000017ffffffd,
  0x0000000100000000, 0x00000000fffffffe,
  0x0000000080000000, 0x000000007fffffff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000100000000, 0x00000000fffffffe,
  0x0000000080000000, 0x000000007fffffff,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff80000000, 0xffffffff80000001,
  0x0000000080000000, 0x000000007fffffff,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff80000000, 0xffffffff80000001,
  0xffffffff00000000, 0xffffffff00000002,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff80000000, 0xffffffff80000001,
  0xffffffff00000000, 0xffffffff00000002,
  0xfffffff000000000, 0xfffffff000000020,
  0xffffffff80000000, 0xffffffff80000001,
  0xffffffff00000000, 0xffffffff00000002,
  0xfffffff000000000, 0xfffffff000000020,
  0xffffffc180000000, 0xffffffc18000007d,
  0xffffffff00000000, 0xffffffff00000002,
  0xfffffff000000000, 0xfffffff000000020,
  0xffffffc180000000, 0xffffffc18000007d,
  0xffffffc100000000, 0xffffffc10000007e,
  0xfffffff000000000, 0xfffffff000000020,
  0xffffffc180000000, 0xffffffc18000007d,
  0xffffffc100000000, 0xffffffc10000007e,
  0xffffffc080000000, 0xffffffc08000007f,
  0xffffffc180000000, 0xffffffc18000007d,
  0xffffffc100000000, 0xffffffc10000007e,
  0xffffffc080000000, 0xffffffc08000007f,
  0xffffc00180000000, 0xffffc00180007ffd,
  0xffffffc100000000, 0xffffffc10000007e,
  0xffffffc080000000, 0xffffffc08000007f,
  0xffffc00180000000, 0xffffc00180007ffd,
  0xffffc00100000000, 0xffffc00100007ffe,
  0xffffffc080000000, 0xffffffc08000007f,
  0xffffc00180000000, 0xffffc00180007ffd,
  0xffffc00100000000, 0xffffc00100007ffe,
  0xffffc00080000000, 0xffffc00080007fff,
  0xffffc00180000000, 0xffffc00180007ffd,
  0xffffc00100000000, 0xffffc00100007ffe,
  0xffffc00080000000, 0xffffc00080007fff,
  0xe666666680000000, 0xe6666666b3333333,
  0xffffc00100000000, 0xffffc00100007ffe,
  0xffffc00080000000, 0xffffc00080007fff,
  0xe666666680000000, 0xe6666666b3333333,
  0xd555555580000000, 0xd5555555d5555555,
  0xffffc00080000000, 0xffffc00080007fff,
  0xe666666680000000, 0xe6666666b3333333,
  0xd555555580000000, 0xd5555555d5555555,
  0xc000000180000000, 0xc0000001fffffffd,
  0xe666666680000000, 0xe6666666b3333333,
  0xd555555580000000, 0xd5555555d5555555,
  0xc000000180000000, 0xc0000001fffffffd,
  0xc000000100000000, 0xc00000017ffffffe,
  0xd555555580000000, 0xd5555555d5555555,
  0xc000000180000000, 0xc0000001fffffffd,
  0xc000000100000000, 0xc00000017ffffffe,
  0xc000000080000000, 0xc0000000ffffffff,
  0xc000000180000000, 0xc0000001fffffffd,
  0xc000000100000000, 0xc00000017ffffffe,
  0xc000000080000000, 0xc0000000ffffffff,
  0x4000000000000000, 0x3fffffff80000000,
  0xc000000100000000, 0xc00000017ffffffe,
  0xc000000080000000, 0xc0000000ffffffff,
  0x4000000000000000, 0x3fffffff80000000,
  0x3fffffff80000000, 0x3fffffff00000001,
  0xc000000080000000, 0xc0000000ffffffff,
  0x4000000000000000, 0x3fffffff80000000,
  0x3fffffff80000000, 0x3fffffff00000001,
  0x2aaaaaab00000000, 0x2aaaaaaaaaaaaaaa,
  0x4000000000000000, 0x3fffffff80000000,
  0x3fffffff80000000, 0x3fffffff00000001,
  0x2aaaaaab00000000, 0x2aaaaaaaaaaaaaaa,
  0x1999999a00000000, 0x19999999cccccccc,
  0x3fffffff80000000, 0x3fffffff00000001,
  0x2aaaaaab00000000, 0x2aaaaaaaaaaaaaaa,
  0x1999999a00000000, 0x19999999cccccccc,
  0x0000400000000000, 0x00003fffffff8000,
  0x2aaaaaab00000000, 0x2aaaaaaaaaaaaaaa,
  0x1999999a00000000, 0x19999999cccccccc,
  0x0000400000000000, 0x00003fffffff8000,
  0x00003fff80000000, 0x00003fff7fff8001,
  0x1999999a00000000, 0x19999999cccccccc,
  0x0000400000000000, 0x00003fffffff8000,
  0x00003fff80000000, 0x00003fff7fff8001,
  0x00003fff00000000, 0x00003ffeffff8002,
  0x0000400000000000, 0x00003fffffff8000,
  0x00003fff80000000, 0x00003fff7fff8001,
  0x00003fff00000000, 0x00003ffeffff8002,
  0x00003ffe80000000, 0x00003ffe7fff8003,
  0x00003fff80000000, 0x00003fff7fff8001,
  0x00003fff00000000, 0x00003ffeffff8002,
  0x00003ffe80000000, 0x00003ffe7fff8003,
  0x0000004000000000, 0x0000003fffffff80,
  0x00003fff00000000, 0x00003ffeffff8002,
  0x00003ffe80000000, 0x00003ffe7fff8003,
  0x0000004000000000, 0x0000003fffffff80,
  0x0000003f80000000, 0x0000003f7fffff81,
  0x00003ffe80000000, 0x00003ffe7fff8003,
  0x0000004000000000, 0x0000003fffffff80,
  0x0000003f80000000, 0x0000003f7fffff81,
  0x0000003f00000000, 0x0000003effffff82,
  0x0000004000000000, 0x0000003fffffff80,
  0x0000003f80000000, 0x0000003f7fffff81,
  0x0000003f00000000, 0x0000003effffff82,
  0x0000003e80000000, 0x0000003e7fffff83,
  0x0000003f80000000, 0x0000003f7fffff81,
  0x0000003f00000000, 0x0000003effffff82,
  0x0000003e80000000, 0x0000003e7fffff83,
  0x0000001000000000, 0x0000000fffffffe0,
  0x0000003f00000000, 0x0000003effffff82,
  0x0000003e80000000, 0x0000003e7fffff83,
  0x0000001000000000, 0x0000000fffffffe0,
  0x0000000180000000, 0x000000017ffffffd,
  0x0000003e80000000, 0x0000003e7fffff83,
  0x0000001000000000, 0x0000000fffffffe0,
  0x0000000180000000, 0x000000017ffffffd,
  0x0000000100000000, 0x00000000fffffffe,
  0x0000001000000000, 0x0000000fffffffe0,
  0x0000000180000000, 0x000000017ffffffd,
  0x0000000100000000, 0x00000000fffffffe,
  0x0000000080000000, 0x000000007fffffff,
  0x000000017ffffffd, 0x0000000100000002,
  0x00000000fffffffe, 0x00000000aaaaaaac,
  0x000000007fffffff, 0x0000000055555556,
  0x0000000000000000, 0x0000000000000000,
  0x00000000fffffffe, 0x00000000aaaaaaac,
  0x000000007fffffff, 0x0000000055555556,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff80000001, 0xffffffffaaaaaaaa,
  0x000000007fffffff, 0x0000000055555556,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff80000001, 0xffffffffaaaaaaaa,
  0xffffffff00000002, 0xffffffff55555554,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff80000001, 0xffffffffaaaaaaaa,
  0xffffffff00000002, 0xffffffff55555554,
  0xfffffff000000020, 0xfffffff555555540,
  0xffffffff80000001, 0xffffffffaaaaaaaa,
  0xffffffff00000002, 0xffffffff55555554,
  0xfffffff000000020, 0xfffffff555555540,
  0xffffffc18000007d, 0xffffffd655555502,
  0xffffffff00000002, 0xffffffff55555554,
  0xfffffff000000020, 0xfffffff555555540,
  0xffffffc18000007d, 0xffffffd655555502,
  0xffffffc10000007e, 0xffffffd5ffffffac,
  0xfffffff000000020, 0xfffffff555555540,
  0xffffffc18000007d, 0xffffffd655555502,
  0xffffffc10000007e, 0xffffffd5ffffffac,
  0xffffffc08000007f, 0xffffffd5aaaaaa56,
  0xffffffc18000007d, 0xffffffd655555502,
  0xffffffc10000007e, 0xffffffd5ffffffac,
  0xffffffc08000007f, 0xffffffd5aaaaaa56,
  0xffffc00180007ffd, 0xffffd55655550002,
  0xffffffc10000007e, 0xffffffd5ffffffac,
  0xffffffc08000007f, 0xffffffd5aaaaaa56,
  0xffffc00180007ffd, 0xffffd55655550002,
  0xffffc00100007ffe, 0xffffd555ffffaaac,
  0xffffffc08000007f, 0xffffffd5aaaaaa56,
  0xffffc00180007ffd, 0xffffd55655550002,
  0xffffc00100007ffe, 0xffffd555ffffaaac,
  0xffffc00080007fff, 0xffffd555aaaa5556,
  0xffffc00180007ffd, 0xffffd55655550002,
  0xffffc00100007ffe, 0xffffd555ffffaaac,
  0xffffc00080007fff, 0xffffd555aaaa5556,
  0xe6666666b3333333, 0xeeeeeeeeddddddde,
  0xffffc00100007ffe, 0xffffd555ffffaaac,
  0xffffc00080007fff, 0xffffd555aaaa5556,
  0xe6666666b3333333, 0xeeeeeeeeddddddde,
  0xd5555555d5555555, 0xe38e38e371c71c72,
  0xffffc00080007fff, 0xffffd555aaaa5556,
  0xe6666666b3333333, 0xeeeeeeeeddddddde,
  0xd5555555d5555555, 0xe38e38e371c71c72,
  0xc0000001fffffffd, 0xd555555600000002,
  0xe6666666b3333333, 0xeeeeeeeeddddddde,
  0xd5555555d5555555, 0xe38e38e371c71c72,
  0xc0000001fffffffd, 0xd555555600000002,
  0xc00000017ffffffe, 0xd5555555aaaaaaac,
  0xd5555555d5555555, 0xe38e38e371c71c72,
  0xc0000001fffffffd, 0xd555555600000002,
  0xc00000017ffffffe, 0xd5555555aaaaaaac,
  0xc0000000ffffffff, 0xd555555555555556,
  0xc0000001fffffffd, 0xd555555600000002,
  0xc00000017ffffffe, 0xd5555555aaaaaaac,
  0xc0000000ffffffff, 0xd555555555555556,
  0x3fffffff80000000, 0x2aaaaaab00000000,
  0xc00000017ffffffe, 0xd5555555aaaaaaac,
  0xc0000000ffffffff, 0xd555555555555556,
  0x3fffffff80000000, 0x2aaaaaab00000000,
  0x3fffffff00000001, 0x2aaaaaaaaaaaaaaa,
  0xc0000000ffffffff, 0xd555555555555556,
  0x3fffffff80000000, 0x2aaaaaab00000000,
  0x3fffffff00000001, 0x2aaaaaaaaaaaaaaa,
  0x2aaaaaaaaaaaaaaa, 0x1c71c71ce38e38e4,
  0x3fffffff80000000, 0x2aaaaaab00000000,
  0x3fffffff00000001, 0x2aaaaaaaaaaaaaaa,
  0x2aaaaaaaaaaaaaaa, 0x1c71c71ce38e38e4,
  0x19999999cccccccc, 0x1111111177777778,
  0x3fffffff00000001, 0x2aaaaaaaaaaaaaaa,
  0x2aaaaaaaaaaaaaaa, 0x1c71c71ce38e38e4,
  0x19999999cccccccc, 0x1111111177777778,
  0x00003fffffff8000, 0x00002aaaaaab0000,
  0x2aaaaaaaaaaaaaaa, 0x1c71c71ce38e38e4,
  0x19999999cccccccc, 0x1111111177777778,
  0x00003fffffff8000, 0x00002aaaaaab0000,
  0x00003fff7fff8001, 0x00002aaa5555aaaa,
  0x19999999cccccccc, 0x1111111177777778,
  0x00003fffffff8000, 0x00002aaaaaab0000,
  0x00003fff7fff8001, 0x00002aaa5555aaaa,
  0x00003ffeffff8002, 0x00002aaa00005554,
  0x00003fffffff8000, 0x00002aaaaaab0000,
  0x00003fff7fff8001, 0x00002aaa5555aaaa,
  0x00003ffeffff8002, 0x00002aaa00005554,
  0x00003ffe7fff8003, 0x00002aa9aaaafffe,
  0x00003fff7fff8001, 0x00002aaa5555aaaa,
  0x00003ffeffff8002, 0x00002aaa00005554,
  0x00003ffe7fff8003, 0x00002aa9aaaafffe,
  0x0000003fffffff80, 0x0000002aaaaaab00,
  0x00003ffeffff8002, 0x00002aaa00005554,
  0x00003ffe7fff8003, 0x00002aa9aaaafffe,
  0x0000003fffffff80, 0x0000002aaaaaab00,
  0x0000003f7fffff81, 0x0000002a555555aa,
  0x00003ffe7fff8003, 0x00002aa9aaaafffe,
  0x0000003fffffff80, 0x0000002aaaaaab00,
  0x0000003f7fffff81, 0x0000002a555555aa,
  0x0000003effffff82, 0x0000002a00000054,
  0x0000003fffffff80, 0x0000002aaaaaab00,
  0x0000003f7fffff81, 0x0000002a555555aa,
  0x0000003effffff82, 0x0000002a00000054,
  0x0000003e7fffff83, 0x00000029aaaaaafe,
  0x0000003f7fffff81, 0x0000002a555555aa,
  0x0000003effffff82, 0x0000002a00000054,
  0x0000003e7fffff83, 0x00000029aaaaaafe,
  0x0000000fffffffe0, 0x0000000aaaaaaac0,
  0x0000003effffff82, 0x0000002a00000054,
  0x0000003e7fffff83, 0x00000029aaaaaafe,
  0x0000000fffffffe0, 0x0000000aaaaaaac0,
  0x000000017ffffffd, 0x0000000100000002,
  0x0000003e7fffff83, 0x00000029aaaaaafe,
  0x0000000fffffffe0, 0x0000000aaaaaaac0,
  0x000000017ffffffd, 0x0000000100000002,
  0x00000000fffffffe, 0x00000000aaaaaaac,
  0x0000000fffffffe0, 0x0000000aaaaaaac0,
  0x000000017ffffffd, 0x0000000100000002,
  0x00000000fffffffe, 0x00000000aaaaaaac,
  0x000000007fffffff, 0x0000000055555556,
  0x0000000100000002, 0x000000009999999c,
  0x00000000aaaaaaac, 0x0000000066666668,
  0x0000000055555556, 0x0000000033333334,
  0x0000000000000000, 0x0000000000000000,
  0x00000000aaaaaaac, 0x0000000066666668,
  0x0000000055555556, 0x0000000033333334,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffaaaaaaaa, 0xffffffffcccccccc,
  0x0000000055555556, 0x0000000033333334,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffaaaaaaaa, 0xffffffffcccccccc,
  0xffffffff55555554, 0xffffffff99999998,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffaaaaaaaa, 0xffffffffcccccccc,
  0xffffffff55555554, 0xffffffff99999998,
  0xfffffff555555540, 0xfffffff999999980,
  0xffffffffaaaaaaaa, 0xffffffffcccccccc,
  0xffffffff55555554, 0xffffffff99999998,
  0xfffffff555555540, 0xfffffff999999980,
  0xffffffd655555502, 0xffffffe6ffffff9c,
  0xffffffff55555554, 0xffffffff99999998,
  0xfffffff555555540, 0xfffffff999999980,
  0xffffffd655555502, 0xffffffe6ffffff9c,
  0xffffffd5ffffffac, 0xffffffe6cccccc68,
  0xfffffff555555540, 0xfffffff999999980,
  0xffffffd655555502, 0xffffffe6ffffff9c,
  0xffffffd5ffffffac, 0xffffffe6cccccc68,
  0xffffffd5aaaaaa56, 0xffffffe699999934,
  0xffffffd655555502, 0xffffffe6ffffff9c,
  0xffffffd5ffffffac, 0xffffffe6cccccc68,
  0xffffffd5aaaaaa56, 0xffffffe699999934,
  0xffffd55655550002, 0xffffe666ffff999c,
  0xffffffd5ffffffac, 0xffffffe6cccccc68,
  0xffffffd5aaaaaa56, 0xffffffe699999934,
  0xffffd55655550002, 0xffffe666ffff999c,
  0xffffd555ffffaaac, 0xffffe666cccc6668,
  0xffffffd5aaaaaa56, 0xffffffe699999934,
  0xffffd55655550002, 0xffffe666ffff999c,
  0xffffd555ffffaaac, 0xffffe666cccc6668,
  0xffffd555aaaa5556, 0xffffe66699993334,
  0xffffd55655550002, 0xffffe666ffff999c,
  0xffffd555ffffaaac, 0xffffe666cccc6668,
  0xffffd555aaaa5556, 0xffffe66699993334,
  0xeeeeeeeeddddddde, 0xf5c28f5c0a3d70a4,
  0xffffd555ffffaaac, 0xffffe666cccc6668,
  0xffffd555aaaa5556, 0xffffe66699993334,
  0xeeeeeeeeddddddde, 0xf5c28f5c0a3d70a4,
  0xe38e38e371c71c72, 0xeeeeeeeebbbbbbbc,
  0xffffd555aaaa5556, 0xffffe66699993334,
  0xeeeeeeeeddddddde, 0xf5c28f5c0a3d70a4,
  0xe38e38e371c71c72, 0xeeeeeeeebbbbbbbc,
  0xd555555600000002, 0xe66666669999999c,
  0xeeeeeeeeddddddde, 0xf5c28f5c0a3d70a4,
  0xe38e38e371c71c72, 0xeeeeeeeebbbbbbbc,
  0xd555555600000002, 0xe66666669999999c,
  0xd5555555aaaaaaac, 0xe666666666666668,
  0xe38e38e371c71c72, 0xeeeeeeeebbbbbbbc,
  0xd555555600000002, 0xe66666669999999c,
  0xd5555555aaaaaaac, 0xe666666666666668,
  0xd555555555555556, 0xe666666633333334,
  0xd555555600000002, 0xe66666669999999c,
  0xd5555555aaaaaaac, 0xe666666666666668,
  0xd555555555555556, 0xe666666633333334,
  0x2aaaaaab00000000, 0x1999999a00000000,
  0xd5555555aaaaaaac, 0xe666666666666668,
  0xd555555555555556, 0xe666666633333334,
  0x2aaaaaab00000000, 0x1999999a00000000,
  0x2aaaaaaaaaaaaaaa, 0x19999999cccccccc,
  0xd555555555555556, 0xe666666633333334,
  0x2aaaaaab00000000, 0x1999999a00000000,
  0x2aaaaaaaaaaaaaaa, 0x19999999cccccccc,
  0x1c71c71ce38e38e4, 0x1111111177777778,
  0x2aaaaaab00000000, 0x1999999a00000000,
  0x2aaaaaaaaaaaaaaa, 0x19999999cccccccc,
  0x1c71c71ce38e38e4, 0x1111111177777778,
  0x1111111177777778, 0x0a3d70a428f5c290,
  0x2aaaaaaaaaaaaaaa, 0x19999999cccccccc,
  0x1c71c71ce38e38e4, 0x1111111177777778,
  0x1111111177777778, 0x0a3d70a428f5c290,
  0x00002aaaaaab0000, 0x00001999999a0000,
  0x1c71c71ce38e38e4, 0x1111111177777778,
  0x1111111177777778, 0x0a3d70a428f5c290,
  0x00002aaaaaab0000, 0x00001999999a0000,
  0x00002aaa5555aaaa, 0x000019996666cccc,
  0x1111111177777778, 0x0a3d70a428f5c290,
  0x00002aaaaaab0000, 0x00001999999a0000,
  0x00002aaa5555aaaa, 0x000019996666cccc,
  0x00002aaa00005554, 0x0000199933339998,
  0x00002aaaaaab0000, 0x00001999999a0000,
  0x00002aaa5555aaaa, 0x000019996666cccc,
  0x00002aaa00005554, 0x0000199933339998,
  0x00002aa9aaaafffe, 0x0000199900006664,
  0x00002aaa5555aaaa, 0x000019996666cccc,
  0x00002aaa00005554, 0x0000199933339998,
  0x00002aa9aaaafffe, 0x0000199900006664,
  0x0000002aaaaaab00, 0x0000001999999a00,
  0x00002aaa00005554, 0x0000199933339998,
  0x00002aa9aaaafffe, 0x0000199900006664,
  0x0000002aaaaaab00, 0x0000001999999a00,
  0x0000002a555555aa, 0x00000019666666cc,
  0x00002aa9aaaafffe, 0x0000199900006664,
  0x0000002aaaaaab00, 0x0000001999999a00,
  0x0000002a555555aa, 0x00000019666666cc,
  0x0000002a00000054, 0x0000001933333398,
  0x0000002aaaaaab00, 0x0000001999999a00,
  0x0000002a555555aa, 0x00000019666666cc,
  0x0000002a00000054, 0x0000001933333398,
  0x00000029aaaaaafe, 0x0000001900000064,
  0x0000002a555555aa, 0x00000019666666cc,
  0x0000002a00000054, 0x0000001933333398,
  0x00000029aaaaaafe, 0x0000001900000064,
  0x0000000aaaaaaac0, 0x0000000666666680,
  0x0000002a00000054, 0x0000001933333398,
  0x00000029aaaaaafe, 0x0000001900000064,
  0x0000000aaaaaaac0, 0x0000000666666680,
  0x0000000100000002, 0x000000009999999c,
  0x00000029aaaaaafe, 0x0000001900000064,
  0x0000000aaaaaaac0, 0x0000000666666680,
  0x0000000100000002, 0x000000009999999c,
  0x00000000aaaaaaac, 0x0000000066666668,
  0x0000000aaaaaaac0, 0x0000000666666680,
  0x0000000100000002, 0x000000009999999c,
  0x00000000aaaaaaac, 0x0000000066666668,
  0x0000000055555556, 0x0000000033333334,
  0x000000009999999c, 0x0000000000018000,
  0x0000000066666668, 0x0000000000010000,
  0x0000000033333334, 0x0000000000008000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000066666668, 0x0000000000010000,
  0x0000000033333334, 0x0000000000008000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffcccccccc, 0xffffffffffff8000,
  0x0000000033333334, 0x0000000000008000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffcccccccc, 0xffffffffffff8000,
  0xffffffff99999998, 0xffffffffffff0000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffcccccccc, 0xffffffffffff8000,
  0xffffffff99999998, 0xffffffffffff0000,
  0xfffffff999999980, 0xfffffffffff00000,
  0xffffffffcccccccc, 0xffffffffffff8000,
  0xffffffff99999998, 0xffffffffffff0000,
  0xfffffff999999980, 0xfffffffffff00000,
  0xffffffe6ffffff9c, 0xffffffffffc18000,
  0xffffffff99999998, 0xffffffffffff0000,
  0xfffffff999999980, 0xfffffffffff00000,
  0xffffffe6ffffff9c, 0xffffffffffc18000,
  0xffffffe6cccccc68, 0xffffffffffc10000,
  0xfffffff999999980, 0xfffffffffff00000,
  0xffffffe6ffffff9c, 0xffffffffffc18000,
  0xffffffe6cccccc68, 0xffffffffffc10000,
  0xffffffe699999934, 0xffffffffffc08000,
  0xffffffe6ffffff9c, 0xffffffffffc18000,
  0xffffffe6cccccc68, 0xffffffffffc10000,
  0xffffffe699999934, 0xffffffffffc08000,
  0xffffe666ffff999c, 0xffffffffc0018000,
  0xffffffe6cccccc68, 0xffffffffffc10000,
  0xffffffe699999934, 0xffffffffffc08000,
  0xffffe666ffff999c, 0xffffffffc0018000,
  0xffffe666cccc6668, 0xffffffffc0010000,
  0xffffffe699999934, 0xffffffffffc08000,
  0xffffe666ffff999c, 0xffffffffc0018000,
  0xffffe666cccc6668, 0xffffffffc0010000,
  0xffffe66699993334, 0xffffffffc0008000,
  0xffffe666ffff999c, 0xffffffffc0018000,
  0xffffe666cccc6668, 0xffffffffc0010000,
  0xffffe66699993334, 0xffffffffc0008000,
  0xf5c28f5c0a3d70a4, 0xffffe66666668000,
  0xffffe666cccc6668, 0xffffffffc0010000,
  0xffffe66699993334, 0xffffffffc0008000,
  0xf5c28f5c0a3d70a4, 0xffffe66666668000,
  0xeeeeeeeebbbbbbbc, 0xffffd55555558000,
  0xffffe66699993334, 0xffffffffc0008000,
  0xf5c28f5c0a3d70a4, 0xffffe66666668000,
  0xeeeeeeeebbbbbbbc, 0xffffd55555558000,
  0xe66666669999999c, 0xffffc00000018000,
  0xf5c28f5c0a3d70a4, 0xffffe66666668000,
  0xeeeeeeeebbbbbbbc, 0xffffd55555558000,
  0xe66666669999999c, 0xffffc00000018000,
  0xe666666666666668, 0xffffc00000010000,
  0xeeeeeeeebbbbbbbc, 0xffffd55555558000,
  0xe66666669999999c, 0xffffc00000018000,
  0xe666666666666668, 0xffffc00000010000,
  0xe666666633333334, 0xffffc00000008000,
  0xe66666669999999c, 0xffffc00000018000,
  0xe666666666666668, 0xffffc00000010000,
  0xe666666633333334, 0xffffc00000008000,
  0x1999999a00000000, 0x0000400000000000,
  0xe666666666666668, 0xffffc00000010000,
  0xe666666633333334, 0xffffc00000008000,
  0x1999999a00000000, 0x0000400000000000,
  0x19999999cccccccc, 0x00003fffffff8000,
  0xe666666633333334, 0xffffc00000008000,
  0x1999999a00000000, 0x0000400000000000,
  0x19999999cccccccc, 0x00003fffffff8000,
  0x1111111177777778, 0x00002aaaaaab0000,
  0x1999999a00000000, 0x0000400000000000,
  0x19999999cccccccc, 0x00003fffffff8000,
  0x1111111177777778, 0x00002aaaaaab0000,
  0x0a3d70a428f5c290, 0x00001999999a0000,
  0x19999999cccccccc, 0x00003fffffff8000,
  0x1111111177777778, 0x00002aaaaaab0000,
  0x0a3d70a428f5c290, 0x00001999999a0000,
  0x00001999999a0000, 0x0000000040000000,
  0x1111111177777778, 0x00002aaaaaab0000,
  0x0a3d70a428f5c290, 0x00001999999a0000,
  0x00001999999a0000, 0x0000000040000000,
  0x000019996666cccc, 0x000000003fff8000,
  0x0a3d70a428f5c290, 0x00001999999a0000,
  0x00001999999a0000, 0x0000000040000000,
  0x000019996666cccc, 0x000000003fff8000,
  0x0000199933339998, 0x000000003fff0000,
  0x00001999999a0000, 0x0000000040000000,
  0x000019996666cccc, 0x000000003fff8000,
  0x0000199933339998, 0x000000003fff0000,
  0x0000199900006664, 0x000000003ffe8000,
  0x000019996666cccc, 0x000000003fff8000,
  0x0000199933339998, 0x000000003fff0000,
  0x0000199900006664, 0x000000003ffe8000,
  0x0000001999999a00, 0x0000000000400000,
  0x0000199933339998, 0x000000003fff0000,
  0x0000199900006664, 0x000000003ffe8000,
  0x0000001999999a00, 0x0000000000400000,
  0x00000019666666cc, 0x00000000003f8000,
  0x0000199900006664, 0x000000003ffe8000,
  0x0000001999999a00, 0x0000000000400000,
  0x00000019666666cc, 0x00000000003f8000,
  0x0000001933333398, 0x00000000003f0000,
  0x0000001999999a00, 0x0000000000400000,
  0x00000019666666cc, 0x00000000003f8000,
  0x0000001933333398, 0x00000000003f0000,
  0x0000001900000064, 0x00000000003e8000,
  0x00000019666666cc, 0x00000000003f8000,
  0x0000001933333398, 0x00000000003f0000,
  0x0000001900000064, 0x00000000003e8000,
  0x0000000666666680, 0x0000000000100000,
  0x0000001933333398, 0x00000000003f0000,
  0x0000001900000064, 0x00000000003e8000,
  0x0000000666666680, 0x0000000000100000,
  0x000000009999999c, 0x0000000000018000,
  0x0000001900000064, 0x00000000003e8000,
  0x0000000666666680, 0x0000000000100000,
  0x000000009999999c, 0x0000000000018000,
  0x0000000066666668, 0x0000000000010000,
  0x0000000666666680, 0x0000000000100000,
  0x000000009999999c, 0x0000000000018000,
  0x0000000066666668, 0x0000000000010000,
  0x0000000033333334, 0x0000000000008000,
  0x0000000000018000, 0x0000000000017ffd,
  0x0000000000010000, 0x000000000000fffe,
  0x0000000000008000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000010000, 0x000000000000fffe,
  0x0000000000008000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8000, 0xffffffffffff8001,
  0x0000000000008000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8000, 0xffffffffffff8001,
  0xffffffffffff0000, 0xffffffffffff0002,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8000, 0xffffffffffff8001,
  0xffffffffffff0000, 0xffffffffffff0002,
  0xfffffffffff00000, 0xfffffffffff00020,
  0xffffffffffff8000, 0xffffffffffff8001,
  0xffffffffffff0000, 0xffffffffffff0002,
  0xfffffffffff00000, 0xfffffffffff00020,
  0xffffffffffc18000, 0xffffffffffc1807d,
  0xffffffffffff0000, 0xffffffffffff0002,
  0xfffffffffff00000, 0xfffffffffff00020,
  0xffffffffffc18000, 0xffffffffffc1807d,
  0xffffffffffc10000, 0xffffffffffc1007e,
  0xfffffffffff00000, 0xfffffffffff00020,
  0xffffffffffc18000, 0xffffffffffc1807d,
  0xffffffffffc10000, 0xffffffffffc1007e,
  0xffffffffffc08000, 0xffffffffffc0807f,
  0xffffffffffc18000, 0xffffffffffc1807d,
  0xffffffffffc10000, 0xffffffffffc1007e,
  0xffffffffffc08000, 0xffffffffffc0807f,
  0xffffffffc0018000, 0xffffffffc001fffd,
  0xffffffffffc10000, 0xffffffffffc1007e,
  0xffffffffffc08000, 0xffffffffffc0807f,
  0xffffffffc0018000, 0xffffffffc001fffd,
  0xffffffffc0010000, 0xffffffffc0017ffe,
  0xffffffffffc08000, 0xffffffffffc0807f,
  0xffffffffc0018000, 0xffffffffc001fffd,
  0xffffffffc0010000, 0xffffffffc0017ffe,
  0xffffffffc0008000, 0xffffffffc000ffff,
  0xffffffffc0018000, 0xffffffffc001fffd,
  0xffffffffc0010000, 0xffffffffc0017ffe,
  0xffffffffc0008000, 0xffffffffc000ffff,
  0xffffe66666668000, 0xffffe6669999b333,
  0xffffffffc0010000, 0xffffffffc0017ffe,
  0xffffffffc0008000, 0xffffffffc000ffff,
  0xffffe66666668000, 0xffffe6669999b333,
  0xffffd55555558000, 0xffffd555aaaad555,
  0xffffffffc0008000, 0xffffffffc000ffff,
  0xffffe66666668000, 0xffffe6669999b333,
  0xffffd55555558000, 0xffffd555aaaad555,
  0xffffc00000018000, 0xffffc00080017ffd,
  0xffffe66666668000, 0xffffe6669999b333,
  0xffffd55555558000, 0xffffd555aaaad555,
  0xffffc00000018000, 0xffffc00080017ffd,
  0xffffc00000010000, 0xffffc0008000fffe,
  0xffffd55555558000, 0xffffd555aaaad555,
  0xffffc00000018000, 0xffffc00080017ffd,
  0xffffc00000010000, 0xffffc0008000fffe,
  0xffffc00000008000, 0xffffc00080007fff,
  0xffffc00000018000, 0xffffc00080017ffd,
  0xffffc00000010000, 0xffffc0008000fffe,
  0xffffc00000008000, 0xffffc00080007fff,
  0x0000400000000000, 0x00003fff80000000,
  0xffffc00000010000, 0xffffc0008000fffe,
  0xffffc00000008000, 0xffffc00080007fff,
  0x0000400000000000, 0x00003fff80000000,
  0x00003fffffff8000, 0x00003fff7fff8001,
  0xffffc00000008000, 0xffffc00080007fff,
  0x0000400000000000, 0x00003fff80000000,
  0x00003fffffff8000, 0x00003fff7fff8001,
  0x00002aaaaaab0000, 0x00002aaa5555aaaa,
  0x0000400000000000, 0x00003fff80000000,
  0x00003fffffff8000, 0x00003fff7fff8001,
  0x00002aaaaaab0000, 0x00002aaa5555aaaa,
  0x00001999999a0000, 0x000019996666cccc,
  0x00003fffffff8000, 0x00003fff7fff8001,
  0x00002aaaaaab0000, 0x00002aaa5555aaaa,
  0x00001999999a0000, 0x000019996666cccc,
  0x0000000040000000, 0x000000003fff8000,
  0x00002aaaaaab0000, 0x00002aaa5555aaaa,
  0x00001999999a0000, 0x000019996666cccc,
  0x0000000040000000, 0x000000003fff8000,
  0x000000003fff8000, 0x000000003fff0001,
  0x00001999999a0000, 0x000019996666cccc,
  0x0000000040000000, 0x000000003fff8000,
  0x000000003fff8000, 0x000000003fff0001,
  0x000000003fff0000, 0x000000003ffe8002,
  0x0000000040000000, 0x000000003fff8000,
  0x000000003fff8000, 0x000000003fff0001,
  0x000000003fff0000, 0x000000003ffe8002,
  0x000000003ffe8000, 0x000000003ffe0003,
  0x000000003fff8000, 0x000000003fff0001,
  0x000000003fff0000, 0x000000003ffe8002,
  0x000000003ffe8000, 0x000000003ffe0003,
  0x0000000000400000, 0x00000000003fff80,
  0x000000003fff0000, 0x000000003ffe8002,
  0x000000003ffe8000, 0x000000003ffe0003,
  0x0000000000400000, 0x00000000003fff80,
  0x00000000003f8000, 0x00000000003f7f81,
  0x000000003ffe8000, 0x000000003ffe0003,
  0x0000000000400000, 0x00000000003fff80,
  0x00000000003f8000, 0x00000000003f7f81,
  0x00000000003f0000, 0x00000000003eff82,
  0x0000000000400000, 0x00000000003fff80,
  0x00000000003f8000, 0x00000000003f7f81,
  0x00000000003f0000, 0x00000000003eff82,
  0x00000000003e8000, 0x00000000003e7f83,
  0x00000000003f8000, 0x00000000003f7f81,
  0x00000000003f0000, 0x00000000003eff82,
  0x00000000003e8000, 0x00000000003e7f83,
  0x0000000000100000, 0x00000000000fffe0,
  0x00000000003f0000, 0x00000000003eff82,
  0x00000000003e8000, 0x00000000003e7f83,
  0x0000000000100000, 0x00000000000fffe0,
  0x0000000000018000, 0x0000000000017ffd,
  0x00000000003e8000, 0x00000000003e7f83,
  0x0000000000100000, 0x00000000000fffe0,
  0x0000000000018000, 0x0000000000017ffd,
  0x0000000000010000, 0x000000000000fffe,
  0x0000000000100000, 0x00000000000fffe0,
  0x0000000000018000, 0x0000000000017ffd,
  0x0000000000010000, 0x000000000000fffe,
  0x0000000000008000, 0x0000000000007fff,
  0x0000000000017ffd, 0x0000000000017ffa,
  0x000000000000fffe, 0x000000000000fffc,
  0x0000000000007fff, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffe, 0x000000000000fffc,
  0x0000000000007fff, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8001, 0xffffffffffff8002,
  0x0000000000007fff, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8001, 0xffffffffffff8002,
  0xffffffffffff0002, 0xffffffffffff0004,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8001, 0xffffffffffff8002,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xfffffffffff00020, 0xfffffffffff00040,
  0xffffffffffff8001, 0xffffffffffff8002,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xfffffffffff00020, 0xfffffffffff00040,
  0xffffffffffc1807d, 0xffffffffffc180fa,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xfffffffffff00020, 0xfffffffffff00040,
  0xffffffffffc1807d, 0xffffffffffc180fa,
  0xffffffffffc1007e, 0xffffffffffc100fc,
  0xfffffffffff00020, 0xfffffffffff00040,
  0xffffffffffc1807d, 0xffffffffffc180fa,
  0xffffffffffc1007e, 0xffffffffffc100fc,
  0xffffffffffc0807f, 0xffffffffffc080fe,
  0xffffffffffc1807d, 0xffffffffffc180fa,
  0xffffffffffc1007e, 0xffffffffffc100fc,
  0xffffffffffc0807f, 0xffffffffffc080fe,
  0xffffffffc001fffd, 0xffffffffc0027ffa,
  0xffffffffffc1007e, 0xffffffffffc100fc,
  0xffffffffffc0807f, 0xffffffffffc080fe,
  0xffffffffc001fffd, 0xffffffffc0027ffa,
  0xffffffffc0017ffe, 0xffffffffc001fffc,
  0xffffffffffc0807f, 0xffffffffffc080fe,
  0xffffffffc001fffd, 0xffffffffc0027ffa,
  0xffffffffc0017ffe, 0xffffffffc001fffc,
  0xffffffffc000ffff, 0xffffffffc0017ffe,
  0xffffffffc001fffd, 0xffffffffc0027ffa,
  0xffffffffc0017ffe, 0xffffffffc001fffc,
  0xffffffffc000ffff, 0xffffffffc0017ffe,
  0xffffe6669999b333, 0xffffe666cccce666,
  0xffffffffc0017ffe, 0xffffffffc001fffc,
  0xffffffffc000ffff, 0xffffffffc0017ffe,
  0xffffe6669999b333, 0xffffe666cccce666,
  0xffffd555aaaad555, 0xffffd55600002aaa,
  0xffffffffc000ffff, 0xffffffffc0017ffe,
  0xffffe6669999b333, 0xffffe666cccce666,
  0xffffd555aaaad555, 0xffffd55600002aaa,
  0xffffc00080017ffd, 0xffffc00100017ffa,
  0xffffe6669999b333, 0xffffe666cccce666,
  0xffffd555aaaad555, 0xffffd55600002aaa,
  0xffffc00080017ffd, 0xffffc00100017ffa,
  0xffffc0008000fffe, 0xffffc0010000fffc,
  0xffffd555aaaad555, 0xffffd55600002aaa,
  0xffffc00080017ffd, 0xffffc00100017ffa,
  0xffffc0008000fffe, 0xffffc0010000fffc,
  0xffffc00080007fff, 0xffffc00100007ffe,
  0xffffc00080017ffd, 0xffffc00100017ffa,
  0xffffc0008000fffe, 0xffffc0010000fffc,
  0xffffc00080007fff, 0xffffc00100007ffe,
  0x00003fff80000000, 0x00003fff00000000,
  0xffffc0008000fffe, 0xffffc0010000fffc,
  0xffffc00080007fff, 0xffffc00100007ffe,
  0x00003fff80000000, 0x00003fff00000000,
  0x00003fff7fff8001, 0x00003ffeffff8002,
  0xffffc00080007fff, 0xffffc00100007ffe,
  0x00003fff80000000, 0x00003fff00000000,
  0x00003fff7fff8001, 0x00003ffeffff8002,
  0x00002aaa5555aaaa, 0x00002aaa00005554,
  0x00003fff80000000, 0x00003fff00000000,
  0x00003fff7fff8001, 0x00003ffeffff8002,
  0x00002aaa5555aaaa, 0x00002aaa00005554,
  0x000019996666cccc, 0x0000199933339998,
  0x00003fff7fff8001, 0x00003ffeffff8002,
  0x00002aaa5555aaaa, 0x00002aaa00005554,
  0x000019996666cccc, 0x0000199933339998,
  0x000000003fff8000, 0x000000003fff0000,
  0x00002aaa5555aaaa, 0x00002aaa00005554,
  0x000019996666cccc, 0x0000199933339998,
  0x000000003fff8000, 0x000000003fff0000,
  0x000000003fff0001, 0x000000003ffe8002,
  0x000019996666cccc, 0x0000199933339998,
  0x000000003fff8000, 0x000000003fff0000,
  0x000000003fff0001, 0x000000003ffe8002,
  0x000000003ffe8002, 0x000000003ffe0004,
  0x000000003fff8000, 0x000000003fff0000,
  0x000000003fff0001, 0x000000003ffe8002,
  0x000000003ffe8002, 0x000000003ffe0004,
  0x000000003ffe0003, 0x000000003ffd8006,
  0x000000003fff0001, 0x000000003ffe8002,
  0x000000003ffe8002, 0x000000003ffe0004,
  0x000000003ffe0003, 0x000000003ffd8006,
  0x00000000003fff80, 0x00000000003fff00,
  0x000000003ffe8002, 0x000000003ffe0004,
  0x000000003ffe0003, 0x000000003ffd8006,
  0x00000000003fff80, 0x00000000003fff00,
  0x00000000003f7f81, 0x00000000003f7f02,
  0x000000003ffe0003, 0x000000003ffd8006,
  0x00000000003fff80, 0x00000000003fff00,
  0x00000000003f7f81, 0x00000000003f7f02,
  0x00000000003eff82, 0x00000000003eff04,
  0x00000000003fff80, 0x00000000003fff00,
  0x00000000003f7f81, 0x00000000003f7f02,
  0x00000000003eff82, 0x00000000003eff04,
  0x00000000003e7f83, 0x00000000003e7f06,
  0x00000000003f7f81, 0x00000000003f7f02,
  0x00000000003eff82, 0x00000000003eff04,
  0x00000000003e7f83, 0x00000000003e7f06,
  0x00000000000fffe0, 0x00000000000fffc0,
  0x00000000003eff82, 0x00000000003eff04,
  0x00000000003e7f83, 0x00000000003e7f06,
  0x00000000000fffe0, 0x00000000000fffc0,
  0x0000000000017ffd, 0x0000000000017ffa,
  0x00000000003e7f83, 0x00000000003e7f06,
  0x00000000000fffe0, 0x00000000000fffc0,
  0x0000000000017ffd, 0x0000000000017ffa,
  0x000000000000fffe, 0x000000000000fffc,
  0x00000000000fffe0, 0x00000000000fffc0,
  0x0000000000017ffd, 0x0000000000017ffa,
  0x000000000000fffe, 0x000000000000fffc,
  0x0000000000007fff, 0x0000000000007ffe,
  0x0000000000017ffa, 0x0000000000017ff7,
  0x000000000000fffc, 0x000000000000fffa,
  0x0000000000007ffe, 0x0000000000007ffd,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffc, 0x000000000000fffa,
  0x0000000000007ffe, 0x0000000000007ffd,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8002, 0xffffffffffff8003,
  0x0000000000007ffe, 0x0000000000007ffd,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8002, 0xffffffffffff8003,
  0xffffffffffff0004, 0xffffffffffff0006,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8002, 0xffffffffffff8003,
  0xffffffffffff0004, 0xffffffffffff0006,
  0xfffffffffff00040, 0xfffffffffff00060,
  0xffffffffffff8002, 0xffffffffffff8003,
  0xffffffffffff0004, 0xffffffffffff0006,
  0xfffffffffff00040, 0xfffffffffff00060,
  0xffffffffffc180fa, 0xffffffffffc18177,
  0xffffffffffff0004, 0xffffffffffff0006,
  0xfffffffffff00040, 0xfffffffffff00060,
  0xffffffffffc180fa, 0xffffffffffc18177,
  0xffffffffffc100fc, 0xffffffffffc1017a,
  0xfffffffffff00040, 0xfffffffffff00060,
  0xffffffffffc180fa, 0xffffffffffc18177,
  0xffffffffffc100fc, 0xffffffffffc1017a,
  0xffffffffffc080fe, 0xffffffffffc0817d,
  0xffffffffffc180fa, 0xffffffffffc18177,
  0xffffffffffc100fc, 0xffffffffffc1017a,
  0xffffffffffc080fe, 0xffffffffffc0817d,
  0xffffffffc0027ffa, 0xffffffffc002fff7,
  0xffffffffffc100fc, 0xffffffffffc1017a,
  0xffffffffffc080fe, 0xffffffffffc0817d,
  0xffffffffc0027ffa, 0xffffffffc002fff7,
  0xffffffffc001fffc, 0xffffffffc0027ffa,
  0xffffffffffc080fe, 0xffffffffffc0817d,
  0xffffffffc0027ffa, 0xffffffffc002fff7,
  0xffffffffc001fffc, 0xffffffffc0027ffa,
  0xffffffffc0017ffe, 0xffffffffc001fffd,
  0xffffffffc0027ffa, 0xffffffffc002fff7,
  0xffffffffc001fffc, 0xffffffffc0027ffa,
  0xffffffffc0017ffe, 0xffffffffc001fffd,
  0xffffe666cccce666, 0xffffe66700001999,
  0xffffffffc001fffc, 0xffffffffc0027ffa,
  0xffffffffc0017ffe, 0xffffffffc001fffd,
  0xffffe666cccce666, 0xffffe66700001999,
  0xffffd55600002aaa, 0xffffd55655557fff,
  0xffffffffc0017ffe, 0xffffffffc001fffd,
  0xffffe666cccce666, 0xffffe66700001999,
  0xffffd55600002aaa, 0xffffd55655557fff,
  0xffffc00100017ffa, 0xffffc00180017ff7,
  0xffffe666cccce666, 0xffffe66700001999,
  0xffffd55600002aaa, 0xffffd55655557fff,
  0xffffc00100017ffa, 0xffffc00180017ff7,
  0xffffc0010000fffc, 0xffffc0018000fffa,
  0xffffd55600002aaa, 0xffffd55655557fff,
  0xffffc00100017ffa, 0xffffc00180017ff7,
  0xffffc0010000fffc, 0xffffc0018000fffa,
  0xffffc00100007ffe, 0xffffc00180007ffd,
  0xffffc00100017ffa, 0xffffc00180017ff7,
  0xffffc0010000fffc, 0xffffc0018000fffa,
  0xffffc00100007ffe, 0xffffc00180007ffd,
  0x00003fff00000000, 0x00003ffe80000000,
  0xffffc0010000fffc, 0xffffc0018000fffa,
  0xffffc00100007ffe, 0xffffc00180007ffd,
  0x00003fff00000000, 0x00003ffe80000000,
  0x00003ffeffff8002, 0x00003ffe7fff8003,
  0xffffc00100007ffe, 0xffffc00180007ffd,
  0x00003fff00000000, 0x00003ffe80000000,
  0x00003ffeffff8002, 0x00003ffe7fff8003,
  0x00002aaa00005554, 0x00002aa9aaaafffe,
  0x00003fff00000000, 0x00003ffe80000000,
  0x00003ffeffff8002, 0x00003ffe7fff8003,
  0x00002aaa00005554, 0x00002aa9aaaafffe,
  0x0000199933339998, 0x0000199900006664,
  0x00003ffeffff8002, 0x00003ffe7fff8003,
  0x00002aaa00005554, 0x00002aa9aaaafffe,
  0x0000199933339998, 0x0000199900006664,
  0x000000003fff0000, 0x000000003ffe8000,
  0x00002aaa00005554, 0x00002aa9aaaafffe,
  0x0000199933339998, 0x0000199900006664,
  0x000000003fff0000, 0x000000003ffe8000,
  0x000000003ffe8002, 0x000000003ffe0003,
  0x0000199933339998, 0x0000199900006664,
  0x000000003fff0000, 0x000000003ffe8000,
  0x000000003ffe8002, 0x000000003ffe0003,
  0x000000003ffe0004, 0x000000003ffd8006,
  0x000000003fff0000, 0x000000003ffe8000,
  0x000000003ffe8002, 0x000000003ffe0003,
  0x000000003ffe0004, 0x000000003ffd8006,
  0x000000003ffd8006, 0x000000003ffd0009,
  0x000000003ffe8002, 0x000000003ffe0003,
  0x000000003ffe0004, 0x000000003ffd8006,
  0x000000003ffd8006, 0x000000003ffd0009,
  0x00000000003fff00, 0x00000000003ffe80,
  0x000000003ffe0004, 0x000000003ffd8006,
  0x000000003ffd8006, 0x000000003ffd0009,
  0x00000000003fff00, 0x00000000003ffe80,
  0x00000000003f7f02, 0x00000000003f7e83,
  0x000000003ffd8006, 0x000000003ffd0009,
  0x00000000003fff00, 0x00000000003ffe80,
  0x00000000003f7f02, 0x00000000003f7e83,
  0x00000000003eff04, 0x00000000003efe86,
  0x00000000003fff00, 0x00000000003ffe80,
  0x00000000003f7f02, 0x00000000003f7e83,
  0x00000000003eff04, 0x00000000003efe86,
  0x00000000003e7f06, 0x00000000003e7e89,
  0x00000000003f7f02, 0x00000000003f7e83,
  0x00000000003eff04, 0x00000000003efe86,
  0x00000000003e7f06, 0x00000000003e7e89,
  0x00000000000fffc0, 0x00000000000fffa0,
  0x00000000003eff04, 0x00000000003efe86,
  0x00000000003e7f06, 0x00000000003e7e89,
  0x00000000000fffc0, 0x00000000000fffa0,
  0x0000000000017ffa, 0x0000000000017ff7,
  0x00000000003e7f06, 0x00000000003e7e89,
  0x00000000000fffc0, 0x00000000000fffa0,
  0x0000000000017ffa, 0x0000000000017ff7,
  0x000000000000fffc, 0x000000000000fffa,
  0x00000000000fffc0, 0x00000000000fffa0,
  0x0000000000017ffa, 0x0000000000017ff7,
  0x000000000000fffc, 0x000000000000fffa,
  0x0000000000007ffe, 0x0000000000007ffd,
  0x0000000000017ff7, 0x0000000000000180,
  0x000000000000fffa, 0x0000000000000100,
  0x0000000000007ffd, 0x0000000000000080,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000100,
  0x0000000000007ffd, 0x0000000000000080,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8003, 0xffffffffffffff80,
  0x0000000000007ffd, 0x0000000000000080,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8003, 0xffffffffffffff80,
  0xffffffffffff0006, 0xffffffffffffff00,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8003, 0xffffffffffffff80,
  0xffffffffffff0006, 0xffffffffffffff00,
  0xfffffffffff00060, 0xfffffffffffff000,
  0xffffffffffff8003, 0xffffffffffffff80,
  0xffffffffffff0006, 0xffffffffffffff00,
  0xfffffffffff00060, 0xfffffffffffff000,
  0xffffffffffc18177, 0xffffffffffffc180,
  0xffffffffffff0006, 0xffffffffffffff00,
  0xfffffffffff00060, 0xfffffffffffff000,
  0xffffffffffc18177, 0xffffffffffffc180,
  0xffffffffffc1017a, 0xffffffffffffc100,
  0xfffffffffff00060, 0xfffffffffffff000,
  0xffffffffffc18177, 0xffffffffffffc180,
  0xffffffffffc1017a, 0xffffffffffffc100,
  0xffffffffffc0817d, 0xffffffffffffc080,
  0xffffffffffc18177, 0xffffffffffffc180,
  0xffffffffffc1017a, 0xffffffffffffc100,
  0xffffffffffc0817d, 0xffffffffffffc080,
  0xffffffffc002fff7, 0xffffffffffc00180,
  0xffffffffffc1017a, 0xffffffffffffc100,
  0xffffffffffc0817d, 0xffffffffffffc080,
  0xffffffffc002fff7, 0xffffffffffc00180,
  0xffffffffc0027ffa, 0xffffffffffc00100,
  0xffffffffffc0817d, 0xffffffffffffc080,
  0xffffffffc002fff7, 0xffffffffffc00180,
  0xffffffffc0027ffa, 0xffffffffffc00100,
  0xffffffffc001fffd, 0xffffffffffc00080,
  0xffffffffc002fff7, 0xffffffffffc00180,
  0xffffffffc0027ffa, 0xffffffffffc00100,
  0xffffffffc001fffd, 0xffffffffffc00080,
  0xffffe66700001999, 0xffffffe666666680,
  0xffffffffc0027ffa, 0xffffffffffc00100,
  0xffffffffc001fffd, 0xffffffffffc00080,
  0xffffe66700001999, 0xffffffe666666680,
  0xffffd55655557fff, 0xffffffd555555580,
  0xffffffffc001fffd, 0xffffffffffc00080,
  0xffffe66700001999, 0xffffffe666666680,
  0xffffd55655557fff, 0xffffffd555555580,
  0xffffc00180017ff7, 0xffffffc000000180,
  0xffffe66700001999, 0xffffffe666666680,
  0xffffd55655557fff, 0xffffffd555555580,
  0xffffc00180017ff7, 0xffffffc000000180,
  0xffffc0018000fffa, 0xffffffc000000100,
  0xffffd55655557fff, 0xffffffd555555580,
  0xffffc00180017ff7, 0xffffffc000000180,
  0xffffc0018000fffa, 0xffffffc000000100,
  0xffffc00180007ffd, 0xffffffc000000080,
  0xffffc00180017ff7, 0xffffffc000000180,
  0xffffc0018000fffa, 0xffffffc000000100,
  0xffffc00180007ffd, 0xffffffc000000080,
  0x00003ffe80000000, 0x0000004000000000,
  0xffffc0018000fffa, 0xffffffc000000100,
  0xffffc00180007ffd, 0xffffffc000000080,
  0x00003ffe80000000, 0x0000004000000000,
  0x00003ffe7fff8003, 0x0000003fffffff80,
  0xffffc00180007ffd, 0xffffffc000000080,
  0x00003ffe80000000, 0x0000004000000000,
  0x00003ffe7fff8003, 0x0000003fffffff80,
  0x00002aa9aaaafffe, 0x0000002aaaaaab00,
  0x00003ffe80000000, 0x0000004000000000,
  0x00003ffe7fff8003, 0x0000003fffffff80,
  0x00002aa9aaaafffe, 0x0000002aaaaaab00,
  0x0000199900006664, 0x0000001999999a00,
  0x00003ffe7fff8003, 0x0000003fffffff80,
  0x00002aa9aaaafffe, 0x0000002aaaaaab00,
  0x0000199900006664, 0x0000001999999a00,
  0x000000003ffe8000, 0x0000000000400000,
  0x00002aa9aaaafffe, 0x0000002aaaaaab00,
  0x0000199900006664, 0x0000001999999a00,
  0x000000003ffe8000, 0x0000000000400000,
  0x000000003ffe0003, 0x00000000003fff80,
  0x0000199900006664, 0x0000001999999a00,
  0x000000003ffe8000, 0x0000000000400000,
  0x000000003ffe0003, 0x00000000003fff80,
  0x000000003ffd8006, 0x00000000003fff00,
  0x000000003ffe8000, 0x0000000000400000,
  0x000000003ffe0003, 0x00000000003fff80,
  0x000000003ffd8006, 0x00000000003fff00,
  0x000000003ffd0009, 0x00000000003ffe80,
  0x000000003ffe0003, 0x00000000003fff80,
  0x000000003ffd8006, 0x00000000003fff00,
  0x000000003ffd0009, 0x00000000003ffe80,
  0x00000000003ffe80, 0x0000000000004000,
  0x000000003ffd8006, 0x00000000003fff00,
  0x000000003ffd0009, 0x00000000003ffe80,
  0x00000000003ffe80, 0x0000000000004000,
  0x00000000003f7e83, 0x0000000000003f80,
  0x000000003ffd0009, 0x00000000003ffe80,
  0x00000000003ffe80, 0x0000000000004000,
  0x00000000003f7e83, 0x0000000000003f80,
  0x00000000003efe86, 0x0000000000003f00,
  0x00000000003ffe80, 0x0000000000004000,
  0x00000000003f7e83, 0x0000000000003f80,
  0x00000000003efe86, 0x0000000000003f00,
  0x00000000003e7e89, 0x0000000000003e80,
  0x00000000003f7e83, 0x0000000000003f80,
  0x00000000003efe86, 0x0000000000003f00,
  0x00000000003e7e89, 0x0000000000003e80,
  0x00000000000fffa0, 0x0000000000001000,
  0x00000000003efe86, 0x0000000000003f00,
  0x00000000003e7e89, 0x0000000000003e80,
  0x00000000000fffa0, 0x0000000000001000,
  0x0000000000017ff7, 0x0000000000000180,
  0x00000000003e7e89, 0x0000000000003e80,
  0x00000000000fffa0, 0x0000000000001000,
  0x0000000000017ff7, 0x0000000000000180,
  0x000000000000fffa, 0x0000000000000100,
  0x00000000000fffa0, 0x0000000000001000,
  0x0000000000017ff7, 0x0000000000000180,
  0x000000000000fffa, 0x0000000000000100,
  0x0000000000007ffd, 0x0000000000000080,
  0x0000000000000180, 0x000000000000017d,
  0x0000000000000100, 0x00000000000000fe,
  0x0000000000000080, 0x000000000000007f,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000100, 0x00000000000000fe,
  0x0000000000000080, 0x000000000000007f,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff80, 0xffffffffffffff81,
  0x0000000000000080, 0x000000000000007f,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff80, 0xffffffffffffff81,
  0xffffffffffffff00, 0xffffffffffffff02,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff80, 0xffffffffffffff81,
  0xffffffffffffff00, 0xffffffffffffff02,
  0xfffffffffffff000, 0xfffffffffffff020,
  0xffffffffffffff80, 0xffffffffffffff81,
  0xffffffffffffff00, 0xffffffffffffff02,
  0xfffffffffffff000, 0xfffffffffffff020,
  0xffffffffffffc180, 0xffffffffffffc1fd,
  0xffffffffffffff00, 0xffffffffffffff02,
  0xfffffffffffff000, 0xfffffffffffff020,
  0xffffffffffffc180, 0xffffffffffffc1fd,
  0xffffffffffffc100, 0xffffffffffffc17e,
  0xfffffffffffff000, 0xfffffffffffff020,
  0xffffffffffffc180, 0xffffffffffffc1fd,
  0xffffffffffffc100, 0xffffffffffffc17e,
  0xffffffffffffc080, 0xffffffffffffc0ff,
  0xffffffffffffc180, 0xffffffffffffc1fd,
  0xffffffffffffc100, 0xffffffffffffc17e,
  0xffffffffffffc080, 0xffffffffffffc0ff,
  0xffffffffffc00180, 0xffffffffffc0817d,
  0xffffffffffffc100, 0xffffffffffffc17e,
  0xffffffffffffc080, 0xffffffffffffc0ff,
  0xffffffffffc00180, 0xffffffffffc0817d,
  0xffffffffffc00100, 0xffffffffffc080fe,
  0xffffffffffffc080, 0xffffffffffffc0ff,
  0xffffffffffc00180, 0xffffffffffc0817d,
  0xffffffffffc00100, 0xffffffffffc080fe,
  0xffffffffffc00080, 0xffffffffffc0807f,
  0xffffffffffc00180, 0xffffffffffc0817d,
  0xffffffffffc00100, 0xffffffffffc080fe,
  0xffffffffffc00080, 0xffffffffffc0807f,
  0xffffffe666666680, 0xffffffe6999999b3,
  0xffffffffffc00100, 0xffffffffffc080fe,
  0xffffffffffc00080, 0xffffffffffc0807f,
  0xffffffe666666680, 0xffffffe6999999b3,
  0xffffffd555555580, 0xffffffd5aaaaaad5,
  0xffffffffffc00080, 0xffffffffffc0807f,
  0xffffffe666666680, 0xffffffe6999999b3,
  0xffffffd555555580, 0xffffffd5aaaaaad5,
  0xffffffc000000180, 0xffffffc08000017d,
  0xffffffe666666680, 0xffffffe6999999b3,
  0xffffffd555555580, 0xffffffd5aaaaaad5,
  0xffffffc000000180, 0xffffffc08000017d,
  0xffffffc000000100, 0xffffffc0800000fe,
  0xffffffd555555580, 0xffffffd5aaaaaad5,
  0xffffffc000000180, 0xffffffc08000017d,
  0xffffffc000000100, 0xffffffc0800000fe,
  0xffffffc000000080, 0xffffffc08000007f,
  0xffffffc000000180, 0xffffffc08000017d,
  0xffffffc000000100, 0xffffffc0800000fe,
  0xffffffc000000080, 0xffffffc08000007f,
  0x0000004000000000, 0x0000003f80000000,
  0xffffffc000000100, 0xffffffc0800000fe,
  0xffffffc000000080, 0xffffffc08000007f,
  0x0000004000000000, 0x0000003f80000000,
  0x0000003fffffff80, 0x0000003f7fffff81,
  0xffffffc000000080, 0xffffffc08000007f,
  0x0000004000000000, 0x0000003f80000000,
  0x0000003fffffff80, 0x0000003f7fffff81,
  0x0000002aaaaaab00, 0x0000002a555555aa,
  0x0000004000000000, 0x0000003f80000000,
  0x0000003fffffff80, 0x0000003f7fffff81,
  0x0000002aaaaaab00, 0x0000002a555555aa,
  0x0000001999999a00, 0x00000019666666cc,
  0x0000003fffffff80, 0x0000003f7fffff81,
  0x0000002aaaaaab00, 0x0000002a555555aa,
  0x0000001999999a00, 0x00000019666666cc,
  0x0000000000400000, 0x00000000003f8000,
  0x0000002aaaaaab00, 0x0000002a555555aa,
  0x0000001999999a00, 0x00000019666666cc,
  0x0000000000400000, 0x00000000003f8000,
  0x00000000003fff80, 0x00000000003f7f81,
  0x0000001999999a00, 0x00000019666666cc,
  0x0000000000400000, 0x00000000003f8000,
  0x00000000003fff80, 0x00000000003f7f81,
  0x00000000003fff00, 0x00000000003f7f02,
  0x0000000000400000, 0x00000000003f8000,
  0x00000000003fff80, 0x00000000003f7f81,
  0x00000000003fff00, 0x00000000003f7f02,
  0x00000000003ffe80, 0x00000000003f7e83,
  0x00000000003fff80, 0x00000000003f7f81,
  0x00000000003fff00, 0x00000000003f7f02,
  0x00000000003ffe80, 0x00000000003f7e83,
  0x0000000000004000, 0x0000000000003f80,
  0x00000000003fff00, 0x00000000003f7f02,
  0x00000000003ffe80, 0x00000000003f7e83,
  0x0000000000004000, 0x0000000000003f80,
  0x0000000000003f80, 0x0000000000003f01,
  0x00000000003ffe80, 0x00000000003f7e83,
  0x0000000000004000, 0x0000000000003f80,
  0x0000000000003f80, 0x0000000000003f01,
  0x0000000000003f00, 0x0000000000003e82,
  0x0000000000004000, 0x0000000000003f80,
  0x0000000000003f80, 0x0000000000003f01,
  0x0000000000003f00, 0x0000000000003e82,
  0x0000000000003e80, 0x0000000000003e03,
  0x0000000000003f80, 0x0000000000003f01,
  0x0000000000003f00, 0x0000000000003e82,
  0x0000000000003e80, 0x0000000000003e03,
  0x0000000000001000, 0x0000000000000fe0,
  0x0000000000003f00, 0x0000000000003e82,
  0x0000000000003e80, 0x0000000000003e03,
  0x0000000000001000, 0x0000000000000fe0,
  0x0000000000000180, 0x000000000000017d,
  0x0000000000003e80, 0x0000000000003e03,
  0x0000000000001000, 0x0000000000000fe0,
  0x0000000000000180, 0x000000000000017d,
  0x0000000000000100, 0x00000000000000fe,
  0x0000000000001000, 0x0000000000000fe0,
  0x0000000000000180, 0x000000000000017d,
  0x0000000000000100, 0x00000000000000fe,
  0x0000000000000080, 0x000000000000007f,
  0x000000000000017d, 0x000000000000017a,
  0x00000000000000fe, 0x00000000000000fc,
  0x000000000000007f, 0x000000000000007e,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fe, 0x00000000000000fc,
  0x000000000000007f, 0x000000000000007e,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff81, 0xffffffffffffff82,
  0x000000000000007f, 0x000000000000007e,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff81, 0xffffffffffffff82,
  0xffffffffffffff02, 0xffffffffffffff04,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff81, 0xffffffffffffff82,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xfffffffffffff020, 0xfffffffffffff040,
  0xffffffffffffff81, 0xffffffffffffff82,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xfffffffffffff020, 0xfffffffffffff040,
  0xffffffffffffc1fd, 0xffffffffffffc27a,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xfffffffffffff020, 0xfffffffffffff040,
  0xffffffffffffc1fd, 0xffffffffffffc27a,
  0xffffffffffffc17e, 0xffffffffffffc1fc,
  0xfffffffffffff020, 0xfffffffffffff040,
  0xffffffffffffc1fd, 0xffffffffffffc27a,
  0xffffffffffffc17e, 0xffffffffffffc1fc,
  0xffffffffffffc0ff, 0xffffffffffffc17e,
  0xffffffffffffc1fd, 0xffffffffffffc27a,
  0xffffffffffffc17e, 0xffffffffffffc1fc,
  0xffffffffffffc0ff, 0xffffffffffffc17e,
  0xffffffffffc0817d, 0xffffffffffc1017a,
  0xffffffffffffc17e, 0xffffffffffffc1fc,
  0xffffffffffffc0ff, 0xffffffffffffc17e,
  0xffffffffffc0817d, 0xffffffffffc1017a,
  0xffffffffffc080fe, 0xffffffffffc100fc,
  0xffffffffffffc0ff, 0xffffffffffffc17e,
  0xffffffffffc0817d, 0xffffffffffc1017a,
  0xffffffffffc080fe, 0xffffffffffc100fc,
  0xffffffffffc0807f, 0xffffffffffc1007e,
  0xffffffffffc0817d, 0xffffffffffc1017a,
  0xffffffffffc080fe, 0xffffffffffc100fc,
  0xffffffffffc0807f, 0xffffffffffc1007e,
  0xffffffe6999999b3, 0xffffffe6cccccce6,
  0xffffffffffc080fe, 0xffffffffffc100fc,
  0xffffffffffc0807f, 0xffffffffffc1007e,
  0xffffffe6999999b3, 0xffffffe6cccccce6,
  0xffffffd5aaaaaad5, 0xffffffd60000002a,
  0xffffffffffc0807f, 0xffffffffffc1007e,
  0xffffffe6999999b3, 0xffffffe6cccccce6,
  0xffffffd5aaaaaad5, 0xffffffd60000002a,
  0xffffffc08000017d, 0xffffffc10000017a,
  0xffffffe6999999b3, 0xffffffe6cccccce6,
  0xffffffd5aaaaaad5, 0xffffffd60000002a,
  0xffffffc08000017d, 0xffffffc10000017a,
  0xffffffc0800000fe, 0xffffffc1000000fc,
  0xffffffd5aaaaaad5, 0xffffffd60000002a,
  0xffffffc08000017d, 0xffffffc10000017a,
  0xffffffc0800000fe, 0xffffffc1000000fc,
  0xffffffc08000007f, 0xffffffc10000007e,
  0xffffffc08000017d, 0xffffffc10000017a,
  0xffffffc0800000fe, 0xffffffc1000000fc,
  0xffffffc08000007f, 0xffffffc10000007e,
  0x0000003f80000000, 0x0000003f00000000,
  0xffffffc0800000fe, 0xffffffc1000000fc,
  0xffffffc08000007f, 0xffffffc10000007e,
  0x0000003f80000000, 0x0000003f00000000,
  0x0000003f7fffff81, 0x0000003effffff82,
  0xffffffc08000007f, 0xffffffc10000007e,
  0x0000003f80000000, 0x0000003f00000000,
  0x0000003f7fffff81, 0x0000003effffff82,
  0x0000002a555555aa, 0x0000002a00000054,
  0x0000003f80000000, 0x0000003f00000000,
  0x0000003f7fffff81, 0x0000003effffff82,
  0x0000002a555555aa, 0x0000002a00000054,
  0x00000019666666cc, 0x0000001933333398,
  0x0000003f7fffff81, 0x0000003effffff82,
  0x0000002a555555aa, 0x0000002a00000054,
  0x00000019666666cc, 0x0000001933333398,
  0x00000000003f8000, 0x00000000003f0000,
  0x0000002a555555aa, 0x0000002a00000054,
  0x00000019666666cc, 0x0000001933333398,
  0x00000000003f8000, 0x00000000003f0000,
  0x00000000003f7f81, 0x00000000003eff82,
  0x00000019666666cc, 0x0000001933333398,
  0x00000000003f8000, 0x00000000003f0000,
  0x00000000003f7f81, 0x00000000003eff82,
  0x00000000003f7f02, 0x00000000003eff04,
  0x00000000003f8000, 0x00000000003f0000,
  0x00000000003f7f81, 0x00000000003eff82,
  0x00000000003f7f02, 0x00000000003eff04,
  0x00000000003f7e83, 0x00000000003efe86,
  0x00000000003f7f81, 0x00000000003eff82,
  0x00000000003f7f02, 0x00000000003eff04,
  0x00000000003f7e83, 0x00000000003efe86,
  0x0000000000003f80, 0x0000000000003f00,
  0x00000000003f7f02, 0x00000000003eff04,
  0x00000000003f7e83, 0x00000000003efe86,
  0x0000000000003f80, 0x0000000000003f00,
  0x0000000000003f01, 0x0000000000003e82,
  0x00000000003f7e83, 0x00000000003efe86,
  0x0000000000003f80, 0x0000000000003f00,
  0x0000000000003f01, 0x0000000000003e82,
  0x0000000000003e82, 0x0000000000003e04,
  0x0000000000003f80, 0x0000000000003f00,
  0x0000000000003f01, 0x0000000000003e82,
  0x0000000000003e82, 0x0000000000003e04,
  0x0000000000003e03, 0x0000000000003d86,
  0x0000000000003f01, 0x0000000000003e82,
  0x0000000000003e82, 0x0000000000003e04,
  0x0000000000003e03, 0x0000000000003d86,
  0x0000000000000fe0, 0x0000000000000fc0,
  0x0000000000003e82, 0x0000000000003e04,
  0x0000000000003e03, 0x0000000000003d86,
  0x0000000000000fe0, 0x0000000000000fc0,
  0x000000000000017d, 0x000000000000017a,
  0x0000000000003e03, 0x0000000000003d86,
  0x0000000000000fe0, 0x0000000000000fc0,
  0x000000000000017d, 0x000000000000017a,
  0x00000000000000fe, 0x00000000000000fc,
  0x0000000000000fe0, 0x0000000000000fc0,
  0x000000000000017d, 0x000000000000017a,
  0x00000000000000fe, 0x00000000000000fc,
  0x000000000000007f, 0x000000000000007e,
  0x000000000000017a, 0x0000000000000177,
  0x00000000000000fc, 0x00000000000000fa,
  0x000000000000007e, 0x000000000000007d,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fc, 0x00000000000000fa,
  0x000000000000007e, 0x000000000000007d,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff82, 0xffffffffffffff83,
  0x000000000000007e, 0x000000000000007d,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff82, 0xffffffffffffff83,
  0xffffffffffffff04, 0xffffffffffffff06,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff82, 0xffffffffffffff83,
  0xffffffffffffff04, 0xffffffffffffff06,
  0xfffffffffffff040, 0xfffffffffffff060,
  0xffffffffffffff82, 0xffffffffffffff83,
  0xffffffffffffff04, 0xffffffffffffff06,
  0xfffffffffffff040, 0xfffffffffffff060,
  0xffffffffffffc27a, 0xffffffffffffc2f7,
  0xffffffffffffff04, 0xffffffffffffff06,
  0xfffffffffffff040, 0xfffffffffffff060,
  0xffffffffffffc27a, 0xffffffffffffc2f7,
  0xffffffffffffc1fc, 0xffffffffffffc27a,
  0xfffffffffffff040, 0xfffffffffffff060,
  0xffffffffffffc27a, 0xffffffffffffc2f7,
  0xffffffffffffc1fc, 0xffffffffffffc27a,
  0xffffffffffffc17e, 0xffffffffffffc1fd,
  0xffffffffffffc27a, 0xffffffffffffc2f7,
  0xffffffffffffc1fc, 0xffffffffffffc27a,
  0xffffffffffffc17e, 0xffffffffffffc1fd,
  0xffffffffffc1017a, 0xffffffffffc18177,
  0xffffffffffffc1fc, 0xffffffffffffc27a,
  0xffffffffffffc17e, 0xffffffffffffc1fd,
  0xffffffffffc1017a, 0xffffffffffc18177,
  0xffffffffffc100fc, 0xffffffffffc180fa,
  0xffffffffffffc17e, 0xffffffffffffc1fd,
  0xffffffffffc1017a, 0xffffffffffc18177,
  0xffffffffffc100fc, 0xffffffffffc180fa,
  0xffffffffffc1007e, 0xffffffffffc1807d,
  0xffffffffffc1017a, 0xffffffffffc18177,
  0xffffffffffc100fc, 0xffffffffffc180fa,
  0xffffffffffc1007e, 0xffffffffffc1807d,
  0xffffffe6cccccce6, 0xffffffe700000019,
  0xffffffffffc100fc, 0xffffffffffc180fa,
  0xffffffffffc1007e, 0xffffffffffc1807d,
  0xffffffe6cccccce6, 0xffffffe700000019,
  0xffffffd60000002a, 0xffffffd65555557f,
  0xffffffffffc1007e, 0xffffffffffc1807d,
  0xffffffe6cccccce6, 0xffffffe700000019,
  0xffffffd60000002a, 0xffffffd65555557f,
  0xffffffc10000017a, 0xffffffc180000177,
  0xffffffe6cccccce6, 0xffffffe700000019,
  0xffffffd60000002a, 0xffffffd65555557f,
  0xffffffc10000017a, 0xffffffc180000177,
  0xffffffc1000000fc, 0xffffffc1800000fa,
  0xffffffd60000002a, 0xffffffd65555557f,
  0xffffffc10000017a, 0xffffffc180000177,
  0xffffffc1000000fc, 0xffffffc1800000fa,
  0xffffffc10000007e, 0xffffffc18000007d,
  0xffffffc10000017a, 0xffffffc180000177,
  0xffffffc1000000fc, 0xffffffc1800000fa,
  0xffffffc10000007e, 0xffffffc18000007d,
  0x0000003f00000000, 0x0000003e80000000,
  0xffffffc1000000fc, 0xffffffc1800000fa,
  0xffffffc10000007e, 0xffffffc18000007d,
  0x0000003f00000000, 0x0000003e80000000,
  0x0000003effffff82, 0x0000003e7fffff83,
  0xffffffc10000007e, 0xffffffc18000007d,
  0x0000003f00000000, 0x0000003e80000000,
  0x0000003effffff82, 0x0000003e7fffff83,
  0x0000002a00000054, 0x00000029aaaaaafe,
  0x0000003f00000000, 0x0000003e80000000,
  0x0000003effffff82, 0x0000003e7fffff83,
  0x0000002a00000054, 0x00000029aaaaaafe,
  0x0000001933333398, 0x0000001900000064,
  0x0000003effffff82, 0x0000003e7fffff83,
  0x0000002a00000054, 0x00000029aaaaaafe,
  0x0000001933333398, 0x0000001900000064,
  0x00000000003f0000, 0x00000000003e8000,
  0x0000002a00000054, 0x00000029aaaaaafe,
  0x0000001933333398, 0x0000001900000064,
  0x00000000003f0000, 0x00000000003e8000,
  0x00000000003eff82, 0x00000000003e7f83,
  0x0000001933333398, 0x0000001900000064,
  0x00000000003f0000, 0x00000000003e8000,
  0x00000000003eff82, 0x00000000003e7f83,
  0x00000000003eff04, 0x00000000003e7f06,
  0x00000000003f0000, 0x00000000003e8000,
  0x00000000003eff82, 0x00000000003e7f83,
  0x00000000003eff04, 0x00000000003e7f06,
  0x00000000003efe86, 0x00000000003e7e89,
  0x00000000003eff82, 0x00000000003e7f83,
  0x00000000003eff04, 0x00000000003e7f06,
  0x00000000003efe86, 0x00000000003e7e89,
  0x0000000000003f00, 0x0000000000003e80,
  0x00000000003eff04, 0x00000000003e7f06,
  0x00000000003efe86, 0x00000000003e7e89,
  0x0000000000003f00, 0x0000000000003e80,
  0x0000000000003e82, 0x0000000000003e03,
  0x00000000003efe86, 0x00000000003e7e89,
  0x0000000000003f00, 0x0000000000003e80,
  0x0000000000003e82, 0x0000000000003e03,
  0x0000000000003e04, 0x0000000000003d86,
  0x0000000000003f00, 0x0000000000003e80,
  0x0000000000003e82, 0x0000000000003e03,
  0x0000000000003e04, 0x0000000000003d86,
  0x0000000000003d86, 0x0000000000003d09,
  0x0000000000003e82, 0x0000000000003e03,
  0x0000000000003e04, 0x0000000000003d86,
  0x0000000000003d86, 0x0000000000003d09,
  0x0000000000000fc0, 0x0000000000000fa0,
  0x0000000000003e04, 0x0000000000003d86,
  0x0000000000003d86, 0x0000000000003d09,
  0x0000000000000fc0, 0x0000000000000fa0,
  0x000000000000017a, 0x0000000000000177,
  0x0000000000003d86, 0x0000000000003d09,
  0x0000000000000fc0, 0x0000000000000fa0,
  0x000000000000017a, 0x0000000000000177,
  0x00000000000000fc, 0x00000000000000fa,
  0x0000000000000fc0, 0x0000000000000fa0,
  0x000000000000017a, 0x0000000000000177,
  0x00000000000000fc, 0x00000000000000fa,
  0x000000000000007e, 0x000000000000007d,
  0x0000000000000177, 0x0000000000000060,
  0x00000000000000fa, 0x0000000000000040,
  0x000000000000007d, 0x0000000000000020,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000040,
  0x000000000000007d, 0x0000000000000020,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff83, 0xffffffffffffffe0,
  0x000000000000007d, 0x0000000000000020,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff83, 0xffffffffffffffe0,
  0xffffffffffffff06, 0xffffffffffffffc0,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff83, 0xffffffffffffffe0,
  0xffffffffffffff06, 0xffffffffffffffc0,
  0xfffffffffffff060, 0xfffffffffffffc00,
  0xffffffffffffff83, 0xffffffffffffffe0,
  0xffffffffffffff06, 0xffffffffffffffc0,
  0xfffffffffffff060, 0xfffffffffffffc00,
  0xffffffffffffc2f7, 0xfffffffffffff060,
  0xffffffffffffff06, 0xffffffffffffffc0,
  0xfffffffffffff060, 0xfffffffffffffc00,
  0xffffffffffffc2f7, 0xfffffffffffff060,
  0xffffffffffffc27a, 0xfffffffffffff040,
  0xfffffffffffff060, 0xfffffffffffffc00,
  0xffffffffffffc2f7, 0xfffffffffffff060,
  0xffffffffffffc27a, 0xfffffffffffff040,
  0xffffffffffffc1fd, 0xfffffffffffff020,
  0xffffffffffffc2f7, 0xfffffffffffff060,
  0xffffffffffffc27a, 0xfffffffffffff040,
  0xffffffffffffc1fd, 0xfffffffffffff020,
  0xffffffffffc18177, 0xfffffffffff00060,
  0xffffffffffffc27a, 0xfffffffffffff040,
  0xffffffffffffc1fd, 0xfffffffffffff020,
  0xffffffffffc18177, 0xfffffffffff00060,
  0xffffffffffc180fa, 0xfffffffffff00040,
  0xffffffffffffc1fd, 0xfffffffffffff020,
  0xffffffffffc18177, 0xfffffffffff00060,
  0xffffffffffc180fa, 0xfffffffffff00040,
  0xffffffffffc1807d, 0xfffffffffff00020,
  0xffffffffffc18177, 0xfffffffffff00060,
  0xffffffffffc180fa, 0xfffffffffff00040,
  0xffffffffffc1807d, 0xfffffffffff00020,
  0xffffffe700000019, 0xfffffff9999999a0,
  0xffffffffffc180fa, 0xfffffffffff00040,
  0xffffffffffc1807d, 0xfffffffffff00020,
  0xffffffe700000019, 0xfffffff9999999a0,
  0xffffffd65555557f, 0xfffffff555555560,
  0xffffffffffc1807d, 0xfffffffffff00020,
  0xffffffe700000019, 0xfffffff9999999a0,
  0xffffffd65555557f, 0xfffffff555555560,
  0xffffffc180000177, 0xfffffff000000060,
  0xffffffe700000019, 0xfffffff9999999a0,
  0xffffffd65555557f, 0xfffffff555555560,
  0xffffffc180000177, 0xfffffff000000060,
  0xffffffc1800000fa, 0xfffffff000000040,
  0xffffffd65555557f, 0xfffffff555555560,
  0xffffffc180000177, 0xfffffff000000060,
  0xffffffc1800000fa, 0xfffffff000000040,
  0xffffffc18000007d, 0xfffffff000000020,
  0xffffffc180000177, 0xfffffff000000060,
  0xffffffc1800000fa, 0xfffffff000000040,
  0xffffffc18000007d, 0xfffffff000000020,
  0x0000003e80000000, 0x0000001000000000,
  0xffffffc1800000fa, 0xfffffff000000040,
  0xffffffc18000007d, 0xfffffff000000020,
  0x0000003e80000000, 0x0000001000000000,
  0x0000003e7fffff83, 0x0000000fffffffe0,
  0xffffffc18000007d, 0xfffffff000000020,
  0x0000003e80000000, 0x0000001000000000,
  0x0000003e7fffff83, 0x0000000fffffffe0,
  0x00000029aaaaaafe, 0x0000000aaaaaaac0,
  0x0000003e80000000, 0x0000001000000000,
  0x0000003e7fffff83, 0x0000000fffffffe0,
  0x00000029aaaaaafe, 0x0000000aaaaaaac0,
  0x0000001900000064, 0x0000000666666680,
  0x0000003e7fffff83, 0x0000000fffffffe0,
  0x00000029aaaaaafe, 0x0000000aaaaaaac0,
  0x0000001900000064, 0x0000000666666680,
  0x00000000003e8000, 0x0000000000100000,
  0x00000029aaaaaafe, 0x0000000aaaaaaac0,
  0x0000001900000064, 0x0000000666666680,
  0x00000000003e8000, 0x0000000000100000,
  0x00000000003e7f83, 0x00000000000fffe0,
  0x0000001900000064, 0x0000000666666680,
  0x00000000003e8000, 0x0000000000100000,
  0x00000000003e7f83, 0x00000000000fffe0,
  0x00000000003e7f06, 0x00000000000fffc0,
  0x00000000003e8000, 0x0000000000100000,
  0x00000000003e7f83, 0x00000000000fffe0,
  0x00000000003e7f06, 0x00000000000fffc0,
  0x00000000003e7e89, 0x00000000000fffa0,
  0x00000000003e7f83, 0x00000000000fffe0,
  0x00000000003e7f06, 0x00000000000fffc0,
  0x00000000003e7e89, 0x00000000000fffa0,
  0x0000000000003e80, 0x0000000000001000,
  0x00000000003e7f06, 0x00000000000fffc0,
  0x00000000003e7e89, 0x00000000000fffa0,
  0x0000000000003e80, 0x0000000000001000,
  0x0000000000003e03, 0x0000000000000fe0,
  0x00000000003e7e89, 0x00000000000fffa0,
  0x0000000000003e80, 0x0000000000001000,
  0x0000000000003e03, 0x0000000000000fe0,
  0x0000000000003d86, 0x0000000000000fc0,
  0x0000000000003e80, 0x0000000000001000,
  0x0000000000003e03, 0x0000000000000fe0,
  0x0000000000003d86, 0x0000000000000fc0,
  0x0000000000003d09, 0x0000000000000fa0,
  0x0000000000003e03, 0x0000000000000fe0,
  0x0000000000003d86, 0x0000000000000fc0,
  0x0000000000003d09, 0x0000000000000fa0,
  0x0000000000000fa0, 0x0000000000000400,
  0x0000000000003d86, 0x0000000000000fc0,
  0x0000000000003d09, 0x0000000000000fa0,
  0x0000000000000fa0, 0x0000000000000400,
  0x0000000000000177, 0x0000000000000060,
  0x0000000000003d09, 0x0000000000000fa0,
  0x0000000000000fa0, 0x0000000000000400,
  0x0000000000000177, 0x0000000000000060,
  0x00000000000000fa, 0x0000000000000040,
  0x0000000000000fa0, 0x0000000000000400,
  0x0000000000000177, 0x0000000000000060,
  0x00000000000000fa, 0x0000000000000040,
  0x000000000000007d, 0x0000000000000020,
  0x0000000000000060, 0x0000000000000009,
  0x0000000000000040, 0x0000000000000006,
  0x0000000000000020, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000006,
  0x0000000000000020, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffe0, 0xfffffffffffffffd,
  0x0000000000000020, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffe0, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffe0, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0xfffffffffffffc00, 0xffffffffffffffa0,
  0xffffffffffffffe0, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0xfffffffffffffc00, 0xffffffffffffffa0,
  0xfffffffffffff060, 0xfffffffffffffe89,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0xfffffffffffffc00, 0xffffffffffffffa0,
  0xfffffffffffff060, 0xfffffffffffffe89,
  0xfffffffffffff040, 0xfffffffffffffe86,
  0xfffffffffffffc00, 0xffffffffffffffa0,
  0xfffffffffffff060, 0xfffffffffffffe89,
  0xfffffffffffff040, 0xfffffffffffffe86,
  0xfffffffffffff020, 0xfffffffffffffe83,
  0xfffffffffffff060, 0xfffffffffffffe89,
  0xfffffffffffff040, 0xfffffffffffffe86,
  0xfffffffffffff020, 0xfffffffffffffe83,
  0xfffffffffff00060, 0xfffffffffffe8009,
  0xfffffffffffff040, 0xfffffffffffffe86,
  0xfffffffffffff020, 0xfffffffffffffe83,
  0xfffffffffff00060, 0xfffffffffffe8009,
  0xfffffffffff00040, 0xfffffffffffe8006,
  0xfffffffffffff020, 0xfffffffffffffe83,
  0xfffffffffff00060, 0xfffffffffffe8009,
  0xfffffffffff00040, 0xfffffffffffe8006,
  0xfffffffffff00020, 0xfffffffffffe8003,
  0xfffffffffff00060, 0xfffffffffffe8009,
  0xfffffffffff00040, 0xfffffffffffe8006,
  0xfffffffffff00020, 0xfffffffffffe8003,
  0xfffffff9999999a0, 0xffffffff66666667,
  0xfffffffffff00040, 0xfffffffffffe8006,
  0xfffffffffff00020, 0xfffffffffffe8003,
  0xfffffff9999999a0, 0xffffffff66666667,
  0xfffffff555555560, 0xffffffff00000001,
  0xfffffffffff00020, 0xfffffffffffe8003,
  0xfffffff9999999a0, 0xffffffff66666667,
  0xfffffff555555560, 0xffffffff00000001,
  0xfffffff000000060, 0xfffffffe80000009,
  0xfffffff9999999a0, 0xffffffff66666667,
  0xfffffff555555560, 0xffffffff00000001,
  0xfffffff000000060, 0xfffffffe80000009,
  0xfffffff000000040, 0xfffffffe80000006,
  0xfffffff555555560, 0xffffffff00000001,
  0xfffffff000000060, 0xfffffffe80000009,
  0xfffffff000000040, 0xfffffffe80000006,
  0xfffffff000000020, 0xfffffffe80000003,
  0xfffffff000000060, 0xfffffffe80000009,
  0xfffffff000000040, 0xfffffffe80000006,
  0xfffffff000000020, 0xfffffffe80000003,
  0x0000001000000000, 0x0000000180000000,
  0xfffffff000000040, 0xfffffffe80000006,
  0xfffffff000000020, 0xfffffffe80000003,
  0x0000001000000000, 0x0000000180000000,
  0x0000000fffffffe0, 0x000000017ffffffd,
  0xfffffff000000020, 0xfffffffe80000003,
  0x0000001000000000, 0x0000000180000000,
  0x0000000fffffffe0, 0x000000017ffffffd,
  0x0000000aaaaaaac0, 0x0000000100000002,
  0x0000001000000000, 0x0000000180000000,
  0x0000000fffffffe0, 0x000000017ffffffd,
  0x0000000aaaaaaac0, 0x0000000100000002,
  0x0000000666666680, 0x000000009999999c,
  0x0000000fffffffe0, 0x000000017ffffffd,
  0x0000000aaaaaaac0, 0x0000000100000002,
  0x0000000666666680, 0x000000009999999c,
  0x0000000000100000, 0x0000000000018000,
  0x0000000aaaaaaac0, 0x0000000100000002,
  0x0000000666666680, 0x000000009999999c,
  0x0000000000100000, 0x0000000000018000,
  0x00000000000fffe0, 0x0000000000017ffd,
  0x0000000666666680, 0x000000009999999c,
  0x0000000000100000, 0x0000000000018000,
  0x00000000000fffe0, 0x0000000000017ffd,
  0x00000000000fffc0, 0x0000000000017ffa,
  0x0000000000100000, 0x0000000000018000,
  0x00000000000fffe0, 0x0000000000017ffd,
  0x00000000000fffc0, 0x0000000000017ffa,
  0x00000000000fffa0, 0x0000000000017ff7,
  0x00000000000fffe0, 0x0000000000017ffd,
  0x00000000000fffc0, 0x0000000000017ffa,
  0x00000000000fffa0, 0x0000000000017ff7,
  0x0000000000001000, 0x0000000000000180,
  0x00000000000fffc0, 0x0000000000017ffa,
  0x00000000000fffa0, 0x0000000000017ff7,
  0x0000000000001000, 0x0000000000000180,
  0x0000000000000fe0, 0x000000000000017d,
  0x00000000000fffa0, 0x0000000000017ff7,
  0x0000000000001000, 0x0000000000000180,
  0x0000000000000fe0, 0x000000000000017d,
  0x0000000000000fc0, 0x000000000000017a,
  0x0000000000001000, 0x0000000000000180,
  0x0000000000000fe0, 0x000000000000017d,
  0x0000000000000fc0, 0x000000000000017a,
  0x0000000000000fa0, 0x0000000000000177,
  0x0000000000000fe0, 0x000000000000017d,
  0x0000000000000fc0, 0x000000000000017a,
  0x0000000000000fa0, 0x0000000000000177,
  0x0000000000000400, 0x0000000000000060,
  0x0000000000000fc0, 0x000000000000017a,
  0x0000000000000fa0, 0x0000000000000177,
  0x0000000000000400, 0x0000000000000060,
  0x0000000000000060, 0x0000000000000009,
  0x0000000000000fa0, 0x0000000000000177,
  0x0000000000000400, 0x0000000000000060,
  0x0000000000000060, 0x0000000000000009,
  0x0000000000000040, 0x0000000000000006,
  0x0000000000000400, 0x0000000000000060,
  0x0000000000000060, 0x0000000000000009,
  0x0000000000000040, 0x0000000000000006,
  0x0000000000000020, 0x0000000000000003,
};
const unsigned kExpectedCount_NEON_smull_2D_2S_S = 3844;

#endif  // VIXL_SIM_SMULL_2D_2S_S_TRACE_AARCH64_H_
