.\" $XFree86: xc/programs/Xserver/hw/xfree86/drivers/sis/sis.man,v 1.10 2003/01/29 15:42:16 eich Exp $
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH SIS __drivermansuffix__ __vendorversion__
.SH NAME
sis \- SiS video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qsis\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B sis
is an XFree86 driver for SiS video chips. The driver is accelerated, and
provides support for 8, 16 and 24 colordepths. XVideo, Render and other
extensions are supported as well.
.SH SUPPORTED HARDWARE
The
.B sis
driver supports PCI and AGP video cards based on the following chipsets:
.PP
.B SiS5597/5598
.B SiS530/620
.B SiS6326/AGP/DVD
.B SiS300/305
.B SiS540
.B SiS630/730
.B SiS315/H/PRO
.B SiS550
.B SiS650/651/650M/740
.B SiS330 (Xabre)
.PP
In the following text, the following terms are used:
.PP
.B old series
for SiS5597/5598, 530/620 and 6326/AGP/DVD
.PP
.B 300 series
for SiS300/305, 540 and 630/730
.PP
.B 310/325/330 series
for SiS315/H/PRO, 550 and 650/651/650M/740, 330
.SH CONFIGURATION DETAILS
Please refer to XF86Config(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver. Please note that support for the SiS330 is new and there may be
some problems.
.PP
.I "1. For all supported chipsets"
.PP
The following driver
.B Options
are supported on all chipsets:
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable 2D acceleration. Please note: On chipsets with XVideo
support, this also disables XVideo. Default: acceleration is enabled.
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Enable or disable the HW cursor. Default: HWCursor is on.
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
The opposite of HWCursor. Default: SWCursor is off.
.TP
.BI "Option \*qRotate\*q \*qCW\*q"
Rotate the display clockwise. This mode is unaccelerated, and uses
the Shadow Frame Buffer layer.
Default: no rotation.
.TP
.BI "Option \*qRotate\*q \*qCCW\*q"
Rotate the display counterclockwise. This mode is unaccelerated, and
uses the Shadow Frame Buffer layer.
Default: no rotation.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable use of the shadow framebuffer layer.
Default: Shadow framebuffer is off.
.PP
.I "2. Old series specific information"
.PP
The driver will auto-detect the amount of video memory present for all
these chips, but in the 6326 case, it will limit the memory size to 4MB.
This is because the 6326's 2D engine can only address 4MB. The remaining
memory seems to be intended for 3D texture data, since only the 3D
engine can address RAM above 4MB. However, you can override this forced
limitation using the
.B \*qVideoRAM\*q
option in the device section if your board has more than
4MB and you need to use it. However, 2D acceleration, Xvideo and the
HWCursor will be disabled in this case.
.PP
The driver will also auto-detect the maximum dotclock and DAC speed.
If you have problems getting high resolutions because of dot clock
limitations, try using the
.B \*qDacSpeed\*q
option, also in the device section. However, this is not recommended
for the 6326. For this chipset, the driver has two built-in modes for
high resolutions which you should use instead. These are named
.B \*qSIS1280x1024-75\*q
and
.B \*qSIS1600x1200-60\*q
and they will be added to the list of default modes. To use these modes,
just place them in your Screen section. Example:
.PP
.BI "Modes \*qSIS1600x1200-60\*q \*qSIS1280x1024x75\*q \*q1024x768\*q ...
.PP
1280x1024 is only available at 8, 15 and 16bpp. 1600x1200 is available
at 8bpp only.
.PP
TV support for the 6326
.PP
TV output is supported on the 6326. The driver will auto detect a
TV connected, and in this case add the following modes to the list
of default modes: "PAL800x600", "PAL800x600U", "PAL720x540",
"PAL640x480", "NTSC640x480", "NTSC640x480U" and "NTSC640x400".
Use these modes like the hi-res modes described above.
.PP
The following driver
.B Options
are supported on the old series:
.TP
.BI "Option \*qTurboQueue\*q \*q" boolean \*q
Enable or disable TurboQueue mode.  Default: off for SIS530/620, on for
the others
.TP
.BI "Option \*qFastVram\*q \*q" boolean \*q
Enable or disable FastVram mode.  Enabling this sets the video RAM timing 
to only one cycle per read operation instead of two cycles. Disabling
this will set 2 cycles for read and write operations. Leaving this
option out uses the default.
Default: off for read, on for write.
.TP
.BI "Option \*qNoHostBus\*q \*q" boolean \*q
(SiS5597/5598 only). Disable CPU-to-VGA host bus support. This
speeds up CPU to video RAM transfers. Default: Host bus is enabled.
.TP
.BI "Option \*qNoXVideo\*q \*q" boolean \*q
Disable XV (XVideo) extension support. Default: XVideo is on.
.TP
.BI "Option \*qTVStandard\*q \*q" string \*q
(6326 only) Possible parameters are
.B PAL
or
.B NTSC.
The default is set by a jumper on the card.
.TP
.BI "Option \*qTVXPosOffset\*q \*q" integer \*q
(6326 only) This option allows horizontal relocation the TV output.
The range is from -16 to 16.
.TP
.BI "Option \*qTVYPosOffset\*q \*q" integer \*q
(6326 only) This option allows vertical relocation the TV output.
The range is from -16 to 16.
.TP
.BI "Option \*qSIS6326TVEnableYFilter\*q \*q" boolean \*q
(6326 only) This option allows enabling/disabling the Y filter for
TV output.
.TP
.BI "Option \*qSIS6326TVAntiFlicker\*q \*q" string \*q
(6326 only) This option allow enabling/disabling the anti flicker
facility for TV output. Possible parameters are
.B OFF, LOW, MED, HIGH
or
.B ADAPTIVE.
By experience,
.B ADAPTIVE
yields the best results.
.PP
.I "2. 300 and 310/325/330 series specific information"
.PP
The 300 and 310/325/330 series very often come with a video bridge for
controlling LCD and TV output. Hereinafter, the term
.B CRT1
refers to the VGA output of the chip, and
.B CRT2
refers to either LCD, TV or secondary VGA. Due to timing reasons,
only one CRT2 output can be active at the same time. But this
limitation does not apply to using CRT1 and CRT2 at the same time
which makes it possible to run the driver in dual head mode.
.PP
The driver supports the following video bridges:
.PP
.B SiS301
.B SiS301B
.B SiS301LV
.B SiS302B
.B SiS302LV
.PP
Instead of a video bridge, some machines have a
.B LVDS
transmitter to control LCD panels, and a
.B "Chrontel 7005"
or
.B "7019"
for TV output. All these are supported as well.
.PP
About TV output
.PP
On the SiS301 and the Chrontel 7005, only resolutions up to 800x600
are supported. On all others, resolutions up to 1024x768 are supported.
.PP
About XVideo support
.PP
XVideo is supported on all chipsets of both families. However, there
are some differences in hardware features which cause limitations.
The 300 series as well as the SiS550, 650M, 651 and 330 support two video
overlays. The SiS315/H/PRO and 650/740 support only one such overlay.
On chips with two overlays, one overlay is used for CRT1, the other
for CRT2. On the other chipsets, the option
.B \*qXvOnCRT2\*q
can be used to select the desired output channel.
.PP
About dual-head support
.PP
Dual head mode has some limitations as regards color depth and
resolution. Due to memory bandwidth limits, CRT1 might have a
reduced refresh rate if running on higher resolutions than
1280x1024.
.PP
Colordepth 8 is not supported when running in dual head mode.
.PP
The following driver
.B Options
are supported on the 300 and 310/325 series:
.TP
.BI "Option \*qNoXVideo\*q \*q" boolean \*q
Disable XV (XVideo) extension support.
Default: XVideo is on.
.TP
.BI "Option \*qXvOnCRT2\*q \*q" boolean \*q
On chipsets with only one video overlay, this option can
used to bind the overlay to CRT1 ( if a monitor is detected
and if this option is either unset or set to
.B false
) or CRT2 ( if a CRT2 device is detected or forced, and if this
option is set to
.B true
). If either only CRT1 or CRT2 is detected, the driver decides
automatically.
Default: overlay is used on CRT1
.TP
.BI "Option \*qForceCRT1\*q \*q" boolean \*q
The BIOS detects VGA monitors connected to CRT1 at boot time
and the X driver by default relies on the information passed
by the BIOS. However, some old monitors are not detected
correctly. If this is the case, or if you connected the VGA
monitor after you booted the machine, you may set this
option to
.B true
in order to make the X driver ignore the
information from the BIOS and initialize CRT1 anyway.
If this option is set to
.B false
, the driver will switch
off CRT1 and thus save memory bandwidth.
Default: auto detect CRT1
.TP
.BI "Option \*qForceCRT2Type\*q \*q" string \*q
Force display type to one of:
.B NONE
,
.B TV
,
.B SVIDEO
,
.B COMPOSITE
,
.B SCART,
,
.B LCD
,
.B VGA
;
.B NONE
will disable CRT2. The SVIDEO, COMPOSITE and SCART parameters
can be used to force the driver to use a specific TV output
connector (if present).
Default: auto detect.
.TP
.BI "Option \*qPanelDelayCompensation\*q \*q" integer \*q
This option is only for machines with a 300 series chipset
and either a SiS301B video bridge or a LVDS transmitter.
Different LCD panels require different delay compensation
values. In most cases, the driver can autodetect this value.
However, due to bad BIOS design this might fail in rare
cases. If your LCD shows small horizontal waves, set the
parameter of this option first to
.B 4
,
.B 32
or
.B 24
and if the problem persists, try using other values between
4 and 60 in steps of 4.
.TP
.BI "Option \*qUseROMData\*q \*q" boolean \*q
The driver reads some data from the BIOS ROM, especially
LCD dependent information. If the folks at SiS some day
decide to change the location of this data inside the
BIOS image, the display might not be initialized correctly.
In order to prevent this, set this option's parameter to
.B false.
Default: ROM data is used
.TP
.BI "Option \*qTVStandard\*q \*q" string \*q
Force the TV standard to either
.B PAL
or
.B NTSC.
On some machines with 630, 730 or 650/740,
.B PALM
and
.B PALN
are supported as well. Default: BIOS setting.
.TP
.BI "Option \*qTVXPosOffset\*q \*q" integer \*q
This option allows horizontal relocation the TV output.
The range is from -32 to 32. Not supported on the Chrontel
7019 yet.
.TP
.BI "Option \*qTVYPosOffset\*q \*q" integer \*q
This option allows vertical relocation the TV output.
The range is from -32 to 32. Not supported on the Chrontel
7019 yet.
.TP
.BI "Option \*qCHTVOverscan\*q \*q" boolean \*q
On machines with a Chrontel TV encoder, this can be used to
force the TV mode to overscan or underscan.
.B True
means overscan,
.B false
means underscan.
Default: BIOS setting.
.TP
.BI "Option \*qCHTVSuperOverscan\*q \*q" boolean \*q
On machines with a Chrontel 7005 TV encoder, this option
enables a super-overscan mode. This is only supported if
the TV standard is PAL. Super overscan will produce an
image on the TV which is larger than the viewable area.
.PP
.I "3. 300 series specific information"
.PP
DRI is supported on the 300 series only. DRI requires
the kernel's SiS framebuffer driver (
.B sisfb
) and some other modules
which come with either the kernel or XFree86.
.PP
Sisfb takes care of memory management for texture
data. In order to prevent the X driver and sisfb from
overwriting each others video memory, sisfb reserves
an amount of video memory for the X driver. This amount
can either be selected using sisfb's mem parameter, or
auto-selected depending on the amount of total video RAM
available. However, the X driver needs to know about the
amount of RAM sisfb reserved. For this purpose, the
.TP
.BI "Option \*qMaxXFBMem\*q \*q" integer \*q
.PP
exists.
.PP
At the moment (2002), the SiS DRI driver is not
maintained, lacks support for memory swapping and
has a few bugs. If you intend to use DRI, I recommend
setting the total video memory in the BIOS to 64MB
in order to at least overcome the lack of memory
swap functions.
.PP
Sisfb can be used for memory management only, or as
a complete framebuffer driver. If you start sisfb
with a valid mode (ie you gain a graphical console),
the X driver can communicate with sisfb and doesn't
require setting the
.B \*qMaxXFBMem\*q
option at all. The X driver will receive enough information
from sisfb in this case.
.PP
However, if you use sisfb for memory management only, ie
you started sisfb with mode=none and still have a text
mode console, there is no communication between sisfb
and the X driver. In this case, you need to set
.B \*qMaxXFBMem\*q
to the same value as you gave sisfb with its mem
parameter. If you didn't specify any mem parameter,
sisfb will reserve
.TP
12288KB if more than 16MB of total video RAM is available,
.TP
8192KB if between 12 and 16MB of video RAM is available,
.TP
4096KB in all other cases.
.PP
Then you need to specify any of these amounts as the
parameter for the
.B \*qMaxXFBMem\*q
option. The value is to be given without 'KB'.
.SH "KNOWN BUGS"
For some reason, PAL TV output on the SiS301LV bridge is
only black and white. NTSC is OK, though.
.PP
LCD panels with a resolution of 1280x1024 do not work
correctly.
.SH "SEE ALSO"
XFree86(1), XF86Config(__filemansuffix__), xf86config(1), Xserver(1), X(__miscmansuffix__)
.PP
.B "http://www.winischhofer.net"
for more information and updates
.SH AUTHORS
Authors include: Alan Hourihane, Mike Chapman, Juanjo Santamarta, Mitani
Hiroshi, David Thomas, Sung-Ching Lin, Ademar Reis, Thomas Winischhofer
