#!/usr/bin/env python
# Copyright 2012 Free Software Foundation, Inc.
#
# This file is part of VOLK
#
# SPDX-License-Identifier: LGPL-3.0-or-later
#

import os
import re
import sys
import argparse
import volk_arch_defs
import volk_machine_defs
import volk_kernel_defs
from mako.template import Template


def __parse_tmpl(_tmpl, **kwargs):
    defs = {
        'archs': volk_arch_defs.archs,
        'arch_dict': volk_arch_defs.arch_dict,
        'machines': volk_machine_defs.machines,
        'machine_dict': volk_machine_defs.machine_dict,
        'kernels': volk_kernel_defs.kernels,
    }
    defs.update(kwargs)
    _tmpl = """

/* this file was generated by volk template utils, do not edit! */

""" + _tmpl
    return str(Template(_tmpl).render(**defs))


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input', type=str)
    parser.add_argument('--output', type=str)
    args, extras = parser.parse_known_args()

    output = __parse_tmpl(open(args.input).read(), args=extras)
    if args.output: open(args.output, 'w').write(output)
    else: print(output)


if __name__ == '__main__': 
    main()
    
