/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CodeInputUnpacker {
    private byte[] bytes = null;
    private InputStream stream = null;
    private int ctr = 0;
    private int width = 12;
    private int accum = 0;
    private int acc_bits = 0;
    private int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};

    public CodeInputUnpacker(byte[] byArray) {
        this.bytes = byArray;
    }

    public CodeInputUnpacker(InputStream inputStream) {
        this.stream = inputStream;
    }

    public CodeInputUnpacker(byte[] byArray, int n) {
        this.bytes = byArray;
        this.width = n;
    }

    public CodeInputUnpacker(InputStream inputStream, int n) {
        this.stream = inputStream;
        this.width = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getN() throws IOException {
        int n;
        while (this.acc_bits < this.width) {
            this.accum = this.acc_bits == 0 ? 0 : this.accum << 8 & 0xFF00;
            n = 0;
            if (null != this.bytes) {
                n = this.bytes[this.ctr] & 0xFF;
            } else if (null != this.stream) {
                n = this.stream.read() & 0xFF;
            }
            this.accum |= n;
            this.acc_bits += 8;
            ++this.ctr;
        }
        n = this.accum >> this.acc_bits - this.width & this.masks[this.width];
        this.acc_bits -= this.width;
        return n;
    }

    public int[] getNArray(int n) throws IOException {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length && !this.atEnd()) {
            nArray[n2++] = this.getN();
        }
        if (n2 < nArray.length) {
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return nArray2;
        }
        return nArray;
    }

    public int fillNArray(int[] nArray) throws IOException {
        int n = 0;
        while (n < nArray.length && !this.atEnd()) {
            nArray[n++] = this.getN();
        }
        return n;
    }

    public void reset() {
        this.ctr = 0;
        this.acc_bits = 0;
        if (null != this.stream) {
            try {
                ((DataInputStream)this.stream).reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean atEnd() throws IOException {
        if (this.acc_bits < this.width) {
            int n = 0;
            for (int i = this.acc_bits; i < this.width; i += 8) {
                ++n;
            }
            if (null != this.bytes) {
                return this.ctr + n > this.bytes.length;
            }
            if (null != this.stream) {
                return n > this.stream.available();
            }
        }
        return true;
    }
}

