/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.particle;

import org.j3d.geom.particle.ParticleInitializer;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParticleEmitterNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseEmitter
extends AbstractNode
implements VRMLParticleEmitterNodeType {
    protected static final int FIELD_SPEED = 1;
    protected static final int FIELD_MASS = 2;
    protected static final int FIELD_SURFACE_AREA = 3;
    protected static final int FIELD_VARIATION = 4;
    protected static final int LAST_EMITTER_INDEX = 4;
    protected static final int NUM_FIELDS = 5;
    private static final String NEG_MASS_ERR = "Mass must be >= zero";
    private static final String NEG_AREA_ERR = "Surface area must be >= zero";
    protected float vfSpeed = 0.0f;
    protected float vfVariation = 0.25f;
    protected float vfMass = 0.0f;
    protected float vfSurfaceArea = 0.0f;
    protected ParticleInitializer initializer;

    protected BaseEmitter(String string) {
        super(string);
    }

    protected void copy(VRMLParticleEmitterNodeType vRMLParticleEmitterNodeType) {
        try {
            int n = vRMLParticleEmitterNodeType.getFieldIndex("speed");
            VRMLFieldData vRMLFieldData = vRMLParticleEmitterNodeType.getFieldValue(n);
            this.vfSpeed = vRMLFieldData.floatValue;
            n = vRMLParticleEmitterNodeType.getFieldIndex("mass");
            vRMLFieldData = vRMLParticleEmitterNodeType.getFieldValue(n);
            this.vfMass = vRMLFieldData.floatValue;
            n = vRMLParticleEmitterNodeType.getFieldIndex("surfaceArea");
            vRMLFieldData = vRMLParticleEmitterNodeType.getFieldValue(n);
            this.vfSurfaceArea = vRMLFieldData.floatValue;
            n = vRMLParticleEmitterNodeType.getFieldIndex("variation");
            vRMLFieldData = vRMLParticleEmitterNodeType.getFieldValue(n);
            this.vfVariation = vRMLFieldData.floatValue;
            this.initializer.setMass(this.vfMass);
            this.initializer.setSurfaceArea(this.vfSurfaceArea);
            this.initializer.setSpeed(this.vfSpeed);
            this.initializer.setParticleVariation(this.vfVariation);
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public ParticleInitializer getInitializer() {
        return this.initializer;
    }

    public float getSpeed() {
        return this.vfSpeed;
    }

    public void setSpeed(float f) throws InvalidFieldValueException {
        this.vfSpeed = f;
        this.initializer.setSpeed(this.vfSpeed);
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public float getMass() {
        return this.vfMass;
    }

    public void setMass(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_MASS_ERR);
        }
        this.vfMass = f;
        this.initializer.setMass(this.vfMass);
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public float getSurfaceArea() {
        return this.vfSurfaceArea;
    }

    public void setSurfaceArea(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_AREA_ERR);
        }
        this.vfSurfaceArea = f;
        this.initializer.setSurfaceArea(this.vfSurfaceArea);
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public float getVariation() {
        return this.vfVariation;
    }

    public void setVariation(float f) throws InvalidFieldValueException {
        this.vfVariation = f;
        this.initializer.setParticleVariation(this.vfVariation);
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public int getPrimaryType() {
        return 64;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSpeed;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMass;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSurfaceArea;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfVariation;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfSpeed);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfMass);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfSurfaceArea);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfVariation);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setSpeed(f);
                break;
            }
            case 2: {
                this.setMass(f);
                break;
            }
            case 3: {
                this.setSurfaceArea(f);
                break;
            }
            case 4: {
                this.setVariation(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }
}

