/*
  Copyright (C) 2000-2008

  Code contributed by Greg Collecutt, Joseph Hope and Paul Cochrane

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_segment.cc 1885 2008-03-18 15:24:56Z paultcochrane $
*/

/*! @file xmds_segment.cc
  @brief Segment element parsing classes and methods

  More detailed explanation...
*/

#include <xmds_common.h>
#include <xmds_segment.h>
#include <xmds_simulation.h>

// **************************************************************************
// **************************************************************************
//                              xmdsSegment public
// **************************************************************************
// **************************************************************************

extern bool debugFlag;

long nxmdsSegments=0;  //!< Number of xmds segment objects

// **************************************************************************
xmdsSegment::xmdsSegment(
                         const xmdsSimulation *const yourSimulation,
                         const bool& yourVerboseMode) :
  xmdsElement(yourSimulation, yourVerboseMode),
  segmentNumber(yourSimulation->nextSegmentNumber()) {
  if (debugFlag) {
    nxmdsSegments++;
    printf("xmdsSegment::xmdsSegment\n");
    printf("nxmdsSegments=%li\n", nxmdsSegments);
  }
}

// **************************************************************************
xmdsSegment::~xmdsSegment() {
  if (debugFlag) {
    nxmdsSegments--;
    printf("xmdsSegment::~xmdsSegment\n");
    printf("nxmdsSegments=%li\n", nxmdsSegments);
  }
}

// **************************************************************************
void xmdsSegment::outputSampleCount() const {
  if (debugFlag) {
    printf("xmdsSegment::outputSampleCount\n");
  }
}

// **************************************************************************
void xmdsSegment::writeInitialisationCalls(
                                           FILE *const outfile) const {
  if (debugFlag) {
    printf("xmdsSegment::writeInitialisationCalls\n");
  }
}

void xmdsSegment::writeDestructionCalls(FILE *const outfile) const
{
  if (debugFlag) {
    printf("xmdsSegment::writeDestructionCalls\n");
  }
}


/*
 * Local variables:
 * c-indentation-style: bsd
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 *
 * vim: tabstop=2 expandtab shiftwidth=2:
 */
