package ONVIF::Analytics::Types::FocusStatus20;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Position_of :ATTR(:get<Position>);
my %MoveStatus_of :ATTR(:get<MoveStatus>);
my %Error_of :ATTR(:get<Error>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Position
        MoveStatus
        Error
        Extension

    ) ],
    {
        'Position' => \%Position_of,
        'MoveStatus' => \%MoveStatus_of,
        'Error' => \%Error_of,
        'Extension' => \%Extension_of,
    },
    {
        'Position' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'MoveStatus' => 'ONVIF::Analytics::Types::MoveStatus',
        'Error' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Extension' => 'ONVIF::Analytics::Types::FocusStatus20Extension',
    },
    {

        'Position' => 'Position',
        'MoveStatus' => 'MoveStatus',
        'Error' => 'Error',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::FocusStatus20

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FocusStatus20 from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Position


=item * MoveStatus


=item * Error


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::FocusStatus20
   Position =>  $some_value, # float
   MoveStatus => $some_value, # MoveStatus
   Error =>  $some_value, # string
   Extension =>  { # ONVIF::Analytics::Types::FocusStatus20Extension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

