/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import org.videolan.BDJXletContext;
import org.videolan.Logger;
import org.videolan.PortingHelper;

class BDJThreadGroup
extends ThreadGroup {
    private boolean destroyed = false;
    private final BDJXletContext context;
    private static final Logger logger = Logger.getLogger(BDJThreadGroup.class.getName());

    protected static BDJThreadGroup create(String name, BDJXletContext context) {
        if (context == null) {
            logger.error("Missing context");
            throw new NullPointerException();
        }
        return new BDJThreadGroup(name, context);
    }

    private BDJThreadGroup(String name, BDJXletContext context) {
        super(name);
        this.context = context;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String stack = "";
        if (e != null) {
            stack = Logger.dumpStack(e);
        }
        if (e instanceof ThreadDeath) {
            logger.error("Thread " + t + " killed");
        } else {
            logger.error("Unhandled exception in thread " + t + ": " + e + stack);
        }
    }

    protected BDJXletContext getContext() {
        return this.context;
    }

    protected boolean waitForShutdown(int timeout, int maxThreads) {
        boolean result;
        if (this.parentOf(Thread.currentThread().getThreadGroup()) && maxThreads < 1) {
            logger.error("Current Thread is contained within ThreadGroup to be disposed.");
            throw new IllegalThreadStateException("Current Thread is contained within ThreadGroup to be disposed.");
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        while (this.activeCount() > maxThreads && System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean bl = result = this.activeCount() <= maxThreads;
        if (!result) {
            logger.error("waitForShutdown timeout (have " + this.activeCount() + " threads, expected " + maxThreads + ")");
        }
        return result;
    }

    protected void stopAll(int timeout) {
        this.interrupt();
        this.waitForShutdown(timeout, 0);
        if (this.activeCount() > 0) {
            logger.error("stopAll(): killing threads");
            this.dumpThreads();
            PortingHelper.stopThreadGroup(this);
            this.waitForShutdown(500, 0);
        }
        if (this.destroyed) {
            return;
        }
        try {
            this.destroy();
            this.destroyed = true;
        }
        catch (IllegalThreadStateException e) {
            logger.error("ThreadGroup destroy failed: " + e);
        }
    }

    public void dumpThreads() {
        logger.info("Active threads in " + this + ":");
        Thread[] threads = new Thread[this.activeCount() + 1];
        while (this.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null) continue;
            logger.info("    " + threads[i]);
            logger.info("    at " + PortingHelper.dumpStack(threads[i]));
        }
    }
}

